/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.gnu.pilotlink.DatebookRecord;
import org.gnu.pilotlink.PilotLink;
import org.gnu.pilotlink.PilotLinkException;
import org.gnu.pilotlink.Record;
import org.gnu.pilotlink.User;

public class datebooktst {
    public static void main(String[] stringArray) {
        test test2 = new test();
        JFrame jFrame = new JFrame("Progress");
        jFrame.getContentPane().setLayout(new BorderLayout());
        JLabel jLabel = new JLabel("Reading in");
        jFrame.getContentPane().add((Component)jLabel, "North");
        JProgressBar jProgressBar = new JProgressBar(0, 100);
        jFrame.getContentPane().add((Component)jProgressBar, "Center");
        jFrame.setSize(300, 50);
        jFrame.setVisible(true);
        String string = stringArray.length == 0 ? "/dev/usb/tts/1" : stringArray[0];
        File file = new File(string);
        System.out.println("looking for file " + string);
        if (!file.exists()) {
            System.out.println("File does not exist... USB? Waiting for port to appear");
            while (!file.exists()) {
                System.out.print(".");
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
        }
        PilotLink pilotLink = null;
        try {
            pilotLink = new PilotLink(string);
            if (!pilotLink.isConnected()) {
                System.out.println("Something went wrong. Check output!");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        try {
            User user = pilotLink.getUserInfo();
            System.out.println("User: " + user.getName());
            System.out.println("Last Synchronization Date: " + user.getLastSyncDate());
        }
        catch (PilotLinkException pilotLinkException) {
            pilotLinkException.printStackTrace();
        }
        try {
            DatebookRecord datebookRecord;
            Object object;
            int n;
            System.out.println("Opening catdb!");
            int n2 = pilotLink.openDB("DatebookDB");
            System.out.println("db opened!");
            System.out.println("Count: " + pilotLink.getRecordCount(n2));
            jProgressBar.setMaximum(pilotLink.getRecordCount(n2));
            Vector<Integer> vector = new Vector<Integer>();
            for (n = 0; n < pilotLink.getRecordCount(n2); ++n) {
                object = pilotLink.getRecordByIndex(n2, n);
                jProgressBar.setValue(n);
                jLabel.setText("Reading in " + n);
                if (object == null) break;
                if (((Record)object).getBuffer() == null || ((Record)object).getBuffer().length == 0) {
                    System.out.println("0-sized record? Deleting...");
                    pilotLink.deleteRecordById(n2, ((Record)object).getId());
                    continue;
                }
                if (!((Record)object).isDirty()) continue;
                datebookRecord = new DatebookRecord((Record)object);
                vector.add(new Integer(n));
                System.out.println("Read index " + n);
                System.out.println("  id: " + datebookRecord.getId());
                System.out.println("attr: " + Integer.toHexString(datebookRecord.getAttribs()));
                System.out.println(" dirty:" + datebookRecord.isDirty());
                System.out.println(" arch :" + datebookRecord.isArchived());
                System.out.println(" del  :" + datebookRecord.isDeleted());
                System.out.println("size: " + datebookRecord.getSize());
                System.out.println("cat : " + datebookRecord.getCategory());
                test.hexdump(datebookRecord.getBuffer());
                test.hexdump(((Record)object).getBuffer());
                System.out.println("Has alarm  : " + datebookRecord.hasAlarm());
                System.out.println("Description: " + datebookRecord.hasDescription());
                System.out.println("Note       : " + datebookRecord.hasNote());
                System.out.println("Reapeated  : " + datebookRecord.isRepeated());
                System.out.println("hasTime    : " + datebookRecord.hasTime());
                if (datebookRecord.hasDescription()) {
                    System.out.println("Descr: " + datebookRecord.getDescription());
                }
                if (datebookRecord.hasNote()) {
                    System.out.println("Note: " + datebookRecord.getNote());
                }
                System.out.println("Start: " + datebookRecord.getStartDate());
                System.out.println("End: " + datebookRecord.getEndDate());
            }
            for (n = 0; n < vector.size(); ++n) {
                System.out.println("updating..." + vector.get(n));
                object = pilotLink.getRecordByIndex(n2, (Integer)vector.get(n));
                ((Record)object).setDirty(false);
                test.hexdump(((Record)object).getBuffer());
                if (!((Record)object).isDirty()) continue;
                System.out.println("H\ufffd\ufffd\ufffd\ufffd?!");
            }
            System.out.println("\n\n\nNew Datebookentry:\n");
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(new Date());
            gregorianCalendar.set(13, 0);
            object = new GregorianCalendar();
            ((Calendar)object).setTime(new Date(System.currentTimeMillis() + 900000L));
            ((Calendar)object).set(13, 0);
            System.out.println("Instaciating...");
            datebookRecord = new DatebookRecord(gregorianCalendar.getTime(), ((Calendar)object).getTime(), "Test of pilot-links new java bindings", "");
            pilotLink.writeRecord(n2, datebookRecord);
            pilotLink.closeDB(n2);
            pilotLink.endSync();
            pilotLink.close();
        }
        catch (PilotLinkException pilotLinkException) {
            pilotLinkException.printStackTrace();
        }
        jFrame.dispose();
    }
}

