// RUN: %clang_cc1 -fsyntax-only -Wno-unused-value -Wno-conversion -ffreestanding -verify %s

//
// we use -Wno-unused-value because we generate some no-op expressions to yield errors
// without also putting them in a static assertion
//
// we use -Wno-conversion because many of the assignments result in precision loss
//

// non-standard: consider right-hand-side const as equivalent
//template<typename T>             struct is_same<T, const T> : public true_type{};
// non-standard: consider right-hand-side lvalue as equivalent
//template<typename T>             struct is_same<T, T&>      : public true_type{};

// __decltype is the GCC way of saying 'decltype', but doesn't require C++11
// _Static_assert is the C11 way of saying 'static_assert', but doesn't require C++11
#ifdef VERIFY_FXC
#define _Static_assert(a,b,c) ;
#endif

// To test with the classic compiler, run
// %sdxroot%\tools\x86\fxc.exe /T vs_5_1 scalar-operators-assign.hlsl
// with vs_2_0 (the default) min16float usage produces a complaint that it's not supported

float4 plain(float4 param4 /* : FOO */) /*: FOO */{
    bool        bools       = 0;
    int         ints        = 0;
    uint        uints       = 0;
    dword       dwords      = 0;
    half        halfs       = 0;
    float       floats      = 0;
    double      doubles     = 0;
    min16float  min16floats = 0;
    min10float  min10floats = 0;    min16int    min16ints   = 0;
    min12int    min12ints   = 0;    min16uint   min16uints  = 0;

  //
  // Some error messages were changed from the fxc version to ease generating test cases
  //
  // signed integer remainder is not supported on minimum-precision types; Cast to int to use 32-bit division
  // *and*
  // signed division remainder is not supported on minimum-precision types; Cast to int to use 32-bit division
  // are both mapped to
  // signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division
  //

  _Static_assert(std::is_same<bool, __decltype(bools = bools)>::value, "");
  _Static_assert(std::is_same<bool, __decltype(bools = ints)>::value, "");
  _Static_assert(std::is_same<bool, __decltype(bools = uints)>::value, "");
  _Static_assert(std::is_same<bool, __decltype(bools = halfs)>::value, "");
  _Static_assert(std::is_same<bool, __decltype(bools = floats)>::value, "");
  _Static_assert(std::is_same<bool, __decltype(bools = doubles)>::value, "");
  _Static_assert(std::is_same<bool, __decltype(bools = min16floats)>::value, "");
  _Static_assert(std::is_same<bool, __decltype(bools = min10floats)>::value, "");
  _Static_assert(std::is_same<bool, __decltype(bools = min16ints)>::value, "");
  _Static_assert(std::is_same<bool, __decltype(bools = min12ints)>::value, "");
  _Static_assert(std::is_same<bool, __decltype(bools = min16uints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints = bools)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints = ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints = uints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints = halfs)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints = floats)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints = doubles)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints = min16floats)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints = min10floats)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints = min16ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints = min12ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints = min16uints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints = bools)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints = ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints = uints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints = halfs)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints = floats)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints = doubles)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints = min16floats)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints = min10floats)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints = min16ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints = min12ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints = min16uints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs = bools)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs = ints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs = uints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs = halfs)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs = floats)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs = doubles)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs = min16floats)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs = min10floats)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs = min16ints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs = min12ints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs = min16uints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats = bools)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats = ints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats = uints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats = halfs)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats = floats)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats = doubles)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats = min16floats)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats = min10floats)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats = min16ints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats = min12ints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats = min16uints)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles = bools)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles = ints)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles = uints)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles = halfs)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles = floats)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles = doubles)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles = min16floats)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles = min10floats)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles = min16ints)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles = min12ints)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles = min16uints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats = bools)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats = ints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats = uints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats = halfs)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats = floats)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats = doubles)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats = min16floats)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats = min10floats)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats = min16ints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats = min12ints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats = min16uints)>::value, "");
  _Static_assert(std::is_same<min10float, __decltype(min10floats = bools)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats = ints)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats = uints)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats = halfs)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats = floats)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats = doubles)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats = min16floats)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats = min10floats)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats = min16ints)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats = min12ints)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats = min16uints)>::value, "");  _Static_assert(std::is_same<min16int, __decltype(min16ints = bools)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints = ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints = uints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints = halfs)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints = floats)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints = doubles)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints = min16floats)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints = min10floats)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints = min16ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints = min12ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints = min16uints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints = bools)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints = ints)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints = uints)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints = halfs)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints = floats)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints = doubles)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints = min16floats)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints = min10floats)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints = min16ints)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints = min12ints)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints = min16uints)>::value, "");  _Static_assert(std::is_same<min16uint, __decltype(min16uints = bools)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints = ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints = uints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints = halfs)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints = floats)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints = doubles)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints = min16floats)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints = min10floats)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints = min16ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints = min12ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints = min16uints)>::value, "");
  (bools += bools); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools += ints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools += uints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools += halfs); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools += floats); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools += doubles); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools += min16floats); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools += min10floats); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools += min16ints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools += min12ints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools += min16uints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  _Static_assert(std::is_same<int, __decltype(ints += bools)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints += ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints += uints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints += halfs)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints += floats)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints += doubles)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints += min16floats)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints += min10floats)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints += min16ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints += min12ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints += min16uints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints += bools)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints += ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints += uints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints += halfs)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints += floats)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints += doubles)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints += min16floats)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints += min10floats)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints += min16ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints += min12ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints += min16uints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs += bools)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs += ints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs += uints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs += halfs)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs += floats)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs += doubles)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs += min16floats)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs += min10floats)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs += min16ints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs += min12ints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs += min16uints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats += bools)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats += ints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats += uints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats += halfs)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats += floats)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats += doubles)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats += min16floats)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats += min10floats)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats += min16ints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats += min12ints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats += min16uints)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles += bools)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles += ints)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles += uints)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles += halfs)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles += floats)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles += doubles)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles += min16floats)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles += min10floats)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles += min16ints)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles += min12ints)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles += min16uints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats += bools)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats += ints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats += uints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats += halfs)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats += floats)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats += doubles)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats += min16floats)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats += min10floats)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats += min16ints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats += min12ints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats += min16uints)>::value, "");
  _Static_assert(std::is_same<min10float, __decltype(min10floats += bools)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats += ints)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats += uints)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats += halfs)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats += floats)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats += doubles)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats += min16floats)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats += min10floats)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats += min16ints)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats += min12ints)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats += min16uints)>::value, "");  _Static_assert(std::is_same<min16int, __decltype(min16ints += bools)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints += ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints += uints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints += halfs)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints += floats)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints += doubles)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints += min16floats)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints += min10floats)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints += min16ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints += min12ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints += min16uints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints += bools)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints += ints)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints += uints)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints += halfs)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints += floats)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints += doubles)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints += min16floats)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints += min10floats)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints += min16ints)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints += min12ints)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints += min16uints)>::value, "");  _Static_assert(std::is_same<min16uint, __decltype(min16uints += bools)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints += ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints += uints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints += halfs)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints += floats)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints += doubles)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints += min16floats)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints += min10floats)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints += min16ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints += min12ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints += min16uints)>::value, "");
  (bools -= bools); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools -= ints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools -= uints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools -= halfs); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools -= floats); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools -= doubles); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools -= min16floats); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools -= min10floats); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools -= min16ints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools -= min12ints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools -= min16uints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  _Static_assert(std::is_same<int, __decltype(ints -= bools)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints -= ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints -= uints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints -= halfs)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints -= floats)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints -= doubles)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints -= min16floats)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints -= min10floats)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints -= min16ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints -= min12ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints -= min16uints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints -= bools)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints -= ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints -= uints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints -= halfs)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints -= floats)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints -= doubles)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints -= min16floats)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints -= min10floats)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints -= min16ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints -= min12ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints -= min16uints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs -= bools)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs -= ints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs -= uints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs -= halfs)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs -= floats)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs -= doubles)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs -= min16floats)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs -= min10floats)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs -= min16ints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs -= min12ints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs -= min16uints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats -= bools)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats -= ints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats -= uints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats -= halfs)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats -= floats)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats -= doubles)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats -= min16floats)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats -= min10floats)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats -= min16ints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats -= min12ints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats -= min16uints)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles -= bools)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles -= ints)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles -= uints)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles -= halfs)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles -= floats)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles -= doubles)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles -= min16floats)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles -= min10floats)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles -= min16ints)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles -= min12ints)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles -= min16uints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats -= bools)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats -= ints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats -= uints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats -= halfs)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats -= floats)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats -= doubles)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats -= min16floats)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats -= min10floats)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats -= min16ints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats -= min12ints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats -= min16uints)>::value, "");
  _Static_assert(std::is_same<min10float, __decltype(min10floats -= bools)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats -= ints)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats -= uints)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats -= halfs)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats -= floats)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats -= doubles)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats -= min16floats)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats -= min10floats)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats -= min16ints)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats -= min12ints)>::value, "");  _Static_assert(std::is_same<min10float, __decltype(min10floats -= min16uints)>::value, "");  _Static_assert(std::is_same<min16int, __decltype(min16ints -= bools)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints -= ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints -= uints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints -= halfs)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints -= floats)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints -= doubles)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints -= min16floats)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints -= min10floats)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints -= min16ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints -= min12ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints -= min16uints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints -= bools)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints -= ints)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints -= uints)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints -= halfs)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints -= floats)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints -= doubles)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints -= min16floats)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints -= min10floats)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints -= min16ints)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints -= min12ints)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints -= min16uints)>::value, "");  _Static_assert(std::is_same<min16uint, __decltype(min16uints -= bools)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints -= ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints -= uints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints -= halfs)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints -= floats)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints -= doubles)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints -= min16floats)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints -= min10floats)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints -= min16ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints -= min12ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints -= min16uints)>::value, "");
  (bools /= bools); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools /= ints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools /= uints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools /= halfs); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools /= floats); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools /= doubles); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools /= min16floats); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools /= min10floats); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools /= min16ints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools /= min12ints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools /= min16uints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  _Static_assert(std::is_same<int, __decltype(ints /= bools)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints /= ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints /= uints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints /= halfs)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints /= floats)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints /= doubles)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints /= min16floats)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints /= min10floats)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints /= min16ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints /= min12ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints /= min16uints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints /= bools)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints /= ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints /= uints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints /= halfs)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints /= floats)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints /= doubles)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints /= min16floats)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints /= min10floats)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints /= min16ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints /= min12ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints /= min16uints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs /= bools)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs /= ints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs /= uints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs /= halfs)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs /= floats)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs /= doubles)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs /= min16floats)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs /= min10floats)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs /= min16ints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs /= min12ints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs /= min16uints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats /= bools)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats /= ints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats /= uints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats /= halfs)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats /= floats)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats /= doubles)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats /= min16floats)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats /= min10floats)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats /= min16ints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats /= min12ints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats /= min16uints)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles /= bools)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles /= ints)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles /= uints)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles /= halfs)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles /= floats)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles /= doubles)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles /= min16floats)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles /= min10floats)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles /= min16ints)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles /= min12ints)>::value, "");
  _Static_assert(std::is_same<double, __decltype(doubles /= min16uints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats /= bools)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats /= ints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats /= uints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats /= halfs)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats /= floats)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats /= doubles)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats /= min16floats)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats /= min10floats)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats /= min16ints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats /= min12ints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats /= min16uints)>::value, "");
  _Static_assert(std::is_same<min10float, __decltype(min10floats /= bools)>::value, "");
  _Static_assert(std::is_same<min10float, __decltype(min10floats /= ints)>::value, "");
  _Static_assert(std::is_same<min10float, __decltype(min10floats /= uints)>::value, "");
  _Static_assert(std::is_same<min10float, __decltype(min10floats /= halfs)>::value, "");
  _Static_assert(std::is_same<min10float, __decltype(min10floats /= floats)>::value, "");
  _Static_assert(std::is_same<min10float, __decltype(min10floats /= doubles)>::value, "");
  _Static_assert(std::is_same<min10float, __decltype(min10floats /= min16floats)>::value, "");
  _Static_assert(std::is_same<min10float, __decltype(min10floats /= min10floats)>::value, "");
  _Static_assert(std::is_same<min10float, __decltype(min10floats /= min16ints)>::value, "");
  _Static_assert(std::is_same<min10float, __decltype(min10floats /= min12ints)>::value, "");
  _Static_assert(std::is_same<min10float, __decltype(min10floats /= min16uints)>::value, "");  (min16ints /= bools); // expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} fxc-pass {{}}
  _Static_assert(std::is_same<min16int, __decltype(min16ints /= ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints /= uints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints /= halfs)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints /= floats)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints /= doubles)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints /= min16floats)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints /= min10floats)>::value, "");
  (min16ints /= min16ints); // expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} fxc-pass {{}}
  (min16ints /= min12ints); // expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} fxc-pass {{}}
  _Static_assert(std::is_same<min16int, __decltype(min16ints /= min16uints)>::value, "");
  (min12ints /= bools); // expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} fxc-pass {{}}
  _Static_assert(std::is_same<min12int, __decltype(min12ints /= ints)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints /= uints)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints /= halfs)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints /= floats)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints /= doubles)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints /= min16floats)>::value, "");  _Static_assert(std::is_same<min12int, __decltype(min12ints /= min10floats)>::value, "");  (min12ints /= min16ints); // expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} fxc-warning {{X3205: conversion from larger type to smaller, possible loss of data}}
  (min12ints /= min12ints); // expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} fxc-pass {{}}
  _Static_assert(std::is_same<min12int, __decltype(min12ints /= min16uints)>::value, "");  _Static_assert(std::is_same<min16uint, __decltype(min16uints /= bools)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints /= ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints /= uints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints /= halfs)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints /= floats)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints /= doubles)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints /= min16floats)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints /= min10floats)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints /= min16ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints /= min12ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints /= min16uints)>::value, "");
  (bools %= bools); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools %= ints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools %= uints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools %= halfs); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools %= floats); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools %= doubles); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools %= min16floats); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools %= min10floats); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools %= min16ints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools %= min12ints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools %= min16uints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  _Static_assert(std::is_same<int, __decltype(ints %= bools)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints %= ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints %= uints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints %= halfs)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints %= floats)>::value, "");
  (ints %= doubles); // expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-warning {{X3205: conversion from larger type to smaller, possible loss of data}}
  _Static_assert(std::is_same<int, __decltype(ints %= min16floats)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints %= min10floats)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints %= min16ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints %= min12ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints %= min16uints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints %= bools)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints %= ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints %= uints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints %= halfs)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints %= floats)>::value, "");
  (uints %= doubles); // expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-warning {{X3205: conversion from larger type to smaller, possible loss of data}}
  _Static_assert(std::is_same<uint, __decltype(uints %= min16floats)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints %= min10floats)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints %= min16ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints %= min12ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints %= min16uints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs %= bools)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs %= ints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs %= uints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs %= halfs)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs %= floats)>::value, "");
  (halfs %= doubles); // expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-warning {{X3205: conversion from larger type to smaller, possible loss of data}}
  _Static_assert(std::is_same<half, __decltype(halfs %= min16floats)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs %= min10floats)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs %= min16ints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs %= min12ints)>::value, "");
  _Static_assert(std::is_same<half, __decltype(halfs %= min16uints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats %= bools)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats %= ints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats %= uints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats %= halfs)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats %= floats)>::value, "");
  (floats %= doubles); // expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-warning {{X3205: conversion from larger type to smaller, possible loss of data}}
  _Static_assert(std::is_same<float, __decltype(floats %= min16floats)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats %= min10floats)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats %= min16ints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats %= min12ints)>::value, "");
  _Static_assert(std::is_same<float, __decltype(floats %= min16uints)>::value, "");
  (doubles %= bools); // expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-pass {{}}
  (doubles %= ints); // expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-pass {{}}
  (doubles %= uints); // expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-pass {{}}
  (doubles %= halfs); // expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-pass {{}}
  (doubles %= floats); // expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-pass {{}}
  (doubles %= doubles); // expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-pass {{}}
  (doubles %= min16floats); // expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-pass {{}}
  (doubles %= min10floats); // expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-pass {{}}
  (doubles %= min16ints); // expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-pass {{}}
  (doubles %= min12ints); // expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-pass {{}}
  (doubles %= min16uints); // expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-pass {{}}
  _Static_assert(std::is_same<min16float, __decltype(min16floats %= bools)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats %= ints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats %= uints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats %= halfs)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats %= floats)>::value, "");
  (min16floats %= doubles); // expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-warning {{X3205: conversion from larger type to smaller, possible loss of data}}
  _Static_assert(std::is_same<min16float, __decltype(min16floats %= min16floats)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats %= min10floats)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats %= min16ints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats %= min12ints)>::value, "");
  _Static_assert(std::is_same<min16float, __decltype(min16floats %= min16uints)>::value, "");
  _Static_assert(std::is_same<min10float, __decltype(min10floats %= bools)>::value, "");
  _Static_assert(std::is_same<min10float, __decltype(min10floats %= ints)>::value, "");
  _Static_assert(std::is_same<min10float, __decltype(min10floats %= uints)>::value, "");
  _Static_assert(std::is_same<min10float, __decltype(min10floats %= halfs)>::value, "");
  _Static_assert(std::is_same<min10float, __decltype(min10floats %= floats)>::value, "");  (min10floats %= doubles); // expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-warning {{X3205: conversion from larger type to smaller, possible loss of data}}
  _Static_assert(std::is_same<min10float, __decltype(min10floats %= min16floats)>::value, "");
  _Static_assert(std::is_same<min10float, __decltype(min10floats %= min10floats)>::value, "");
  _Static_assert(std::is_same<min10float, __decltype(min10floats %= min16ints)>::value, "");
  _Static_assert(std::is_same<min10float, __decltype(min10floats %= min12ints)>::value, "");
  _Static_assert(std::is_same<min10float, __decltype(min10floats %= min16uints)>::value, "");  (min16ints %= bools); // expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} fxc-pass {{}}
  _Static_assert(std::is_same<min16int, __decltype(min16ints %= ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints %= uints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints %= halfs)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints %= floats)>::value, "");
  (min16ints %= doubles); // expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-warning {{X3205: conversion from larger type to smaller, possible loss of data}}
  _Static_assert(std::is_same<min16int, __decltype(min16ints %= min16floats)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints %= min10floats)>::value, "");
  (min16ints %= min16ints); // expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} fxc-pass {{}}
  (min16ints %= min12ints); // expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} fxc-pass {{}}
  _Static_assert(std::is_same<min16int, __decltype(min16ints %= min16uints)>::value, "");
  (min12ints %= bools); // expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} fxc-pass {{}}
  _Static_assert(std::is_same<min12int, __decltype(min12ints %= ints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints %= uints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints %= halfs)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints %= floats)>::value, "");  (min12ints %= doubles); // expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-warning {{X3205: conversion from larger type to smaller, possible loss of data}}
  _Static_assert(std::is_same<min12int, __decltype(min12ints %= min16floats)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints %= min10floats)>::value, "");  (min12ints %= min16ints); // expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} fxc-warning {{X3205: conversion from larger type to smaller, possible loss of data}}
  (min12ints %= min12ints); // expected-error {{signed integer division is not supported on minimum-precision types, cast to int to use 32-bit division}} fxc-pass {{}}
  _Static_assert(std::is_same<min12int, __decltype(min12ints %= min16uints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints %= bools)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints %= ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints %= uints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints %= halfs)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints %= floats)>::value, "");
  (min16uints %= doubles); // expected-error {{modulo cannot be used with doubles, cast to float first}} fxc-warning {{X3205: conversion from larger type to smaller, possible loss of data}}
  _Static_assert(std::is_same<min16uint, __decltype(min16uints %= min16floats)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints %= min10floats)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints %= min16ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints %= min12ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints %= min16uints)>::value, "");
  (bools <<= bools); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools <<= ints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools <<= uints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools <<= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools <<= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools <<= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools <<= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools <<= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools <<= min16ints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools <<= min12ints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools <<= min16uints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  _Static_assert(std::is_same<int, __decltype(ints <<= bools)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints <<= ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints <<= uints)>::value, "");
  (ints <<= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (ints <<= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (ints <<= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (ints <<= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (ints <<= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<int, __decltype(ints <<= min16ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints <<= min12ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints <<= min16uints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints <<= bools)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints <<= ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints <<= uints)>::value, "");
  (uints <<= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (uints <<= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (uints <<= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (uints <<= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (uints <<= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<uint, __decltype(uints <<= min16ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints <<= min12ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints <<= min16uints)>::value, "");
  (halfs <<= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs <<= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs <<= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs <<= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs <<= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs <<= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs <<= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs <<= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs <<= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs <<= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs <<= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats <<= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats <<= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats <<= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats <<= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats <<= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats <<= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats <<= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats <<= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats <<= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats <<= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats <<= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles <<= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles <<= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles <<= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles <<= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles <<= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles <<= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles <<= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles <<= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles <<= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles <<= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles <<= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats <<= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats <<= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats <<= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats <<= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats <<= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats <<= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats <<= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats <<= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats <<= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats <<= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats <<= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats <<= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats <<= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats <<= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats <<= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats <<= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats <<= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats <<= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats <<= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats <<= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats <<= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats <<= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<min16int, __decltype(min16ints <<= bools)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints <<= ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints <<= uints)>::value, "");
  (min16ints <<= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16ints <<= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16ints <<= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16ints <<= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16ints <<= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<min16int, __decltype(min16ints <<= min16ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints <<= min12ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints <<= min16uints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints <<= bools)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints <<= ints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints <<= uints)>::value, "");  (min12ints <<= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min12ints <<= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min12ints <<= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min12ints <<= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min12ints <<= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<min12int, __decltype(min12ints <<= min16ints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints <<= min12ints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints <<= min16uints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints <<= bools)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints <<= ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints <<= uints)>::value, "");
  (min16uints <<= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16uints <<= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16uints <<= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16uints <<= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16uints <<= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<min16uint, __decltype(min16uints <<= min16ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints <<= min12ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints <<= min16uints)>::value, "");
  (bools >>= bools); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools >>= ints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools >>= uints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools >>= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools >>= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools >>= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools >>= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools >>= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools >>= min16ints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools >>= min12ints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools >>= min16uints); // expected-error {{operator cannot be used with a bool lvalue}} fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  _Static_assert(std::is_same<int, __decltype(ints >>= bools)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints >>= ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints >>= uints)>::value, "");
  (ints >>= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (ints >>= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (ints >>= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (ints >>= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (ints >>= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<int, __decltype(ints >>= min16ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints >>= min12ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints >>= min16uints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints >>= bools)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints >>= ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints >>= uints)>::value, "");
  (uints >>= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (uints >>= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (uints >>= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (uints >>= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (uints >>= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<uint, __decltype(uints >>= min16ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints >>= min12ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints >>= min16uints)>::value, "");
  (halfs >>= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs >>= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs >>= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs >>= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs >>= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs >>= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs >>= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs >>= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs >>= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs >>= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs >>= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats >>= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats >>= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats >>= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats >>= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats >>= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats >>= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats >>= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats >>= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats >>= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats >>= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats >>= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles >>= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles >>= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles >>= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles >>= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles >>= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles >>= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles >>= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles >>= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles >>= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles >>= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles >>= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats >>= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats >>= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats >>= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats >>= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats >>= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats >>= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats >>= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats >>= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats >>= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats >>= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats >>= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats >>= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats >>= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats >>= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats >>= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats >>= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats >>= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats >>= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats >>= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats >>= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats >>= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats >>= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<min16int, __decltype(min16ints >>= bools)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints >>= ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints >>= uints)>::value, "");
  (min16ints >>= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16ints >>= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16ints >>= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16ints >>= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16ints >>= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<min16int, __decltype(min16ints >>= min16ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints >>= min12ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints >>= min16uints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints >>= bools)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints >>= ints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints >>= uints)>::value, "");  (min12ints >>= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min12ints >>= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min12ints >>= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min12ints >>= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min12ints >>= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<min12int, __decltype(min12ints >>= min16ints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints >>= min12ints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints >>= min16uints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints >>= bools)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints >>= ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints >>= uints)>::value, "");
  (min16uints >>= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16uints >>= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16uints >>= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16uints >>= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16uints >>= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<min16uint, __decltype(min16uints >>= min16ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints >>= min12ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints >>= min16uints)>::value, "");
  (bools &= bools); // fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools &= ints); // fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools &= uints); // fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools &= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools &= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools &= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools &= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools &= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools &= min16ints); // fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools &= min12ints); // fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools &= min16uints); // fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  _Static_assert(std::is_same<int, __decltype(ints &= bools)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints &= ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints &= uints)>::value, "");
  (ints &= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (ints &= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (ints &= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (ints &= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (ints &= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<int, __decltype(ints &= min16ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints &= min12ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints &= min16uints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints &= bools)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints &= ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints &= uints)>::value, "");
  (uints &= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (uints &= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (uints &= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (uints &= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (uints &= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<uint, __decltype(uints &= min16ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints &= min12ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints &= min16uints)>::value, "");
  (halfs &= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs &= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs &= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs &= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs &= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs &= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs &= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs &= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs &= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs &= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs &= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats &= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats &= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats &= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats &= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats &= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats &= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats &= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats &= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats &= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats &= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats &= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles &= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles &= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles &= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles &= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles &= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles &= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles &= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles &= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles &= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles &= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles &= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats &= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats &= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats &= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats &= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats &= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats &= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats &= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats &= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats &= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats &= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats &= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats &= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats &= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats &= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats &= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats &= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats &= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats &= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats &= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats &= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats &= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats &= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<min16int, __decltype(min16ints &= bools)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints &= ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints &= uints)>::value, "");
  (min16ints &= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16ints &= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16ints &= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16ints &= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16ints &= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<min16int, __decltype(min16ints &= min16ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints &= min12ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints &= min16uints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints &= bools)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints &= ints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints &= uints)>::value, "");  (min12ints &= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min12ints &= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min12ints &= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min12ints &= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min12ints &= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<min12int, __decltype(min12ints &= min16ints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints &= min12ints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints &= min16uints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints &= bools)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints &= ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints &= uints)>::value, "");
  (min16uints &= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16uints &= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16uints &= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16uints &= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16uints &= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<min16uint, __decltype(min16uints &= min16ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints &= min12ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints &= min16uints)>::value, "");
  (bools |= bools); // fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools |= ints); // fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools |= uints); // fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools |= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools |= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools |= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools |= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools |= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools |= min16ints); // fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools |= min12ints); // fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools |= min16uints); // fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  _Static_assert(std::is_same<int, __decltype(ints |= bools)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints |= ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints |= uints)>::value, "");
  (ints |= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (ints |= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (ints |= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (ints |= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (ints |= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<int, __decltype(ints |= min16ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints |= min12ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints |= min16uints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints |= bools)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints |= ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints |= uints)>::value, "");
  (uints |= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (uints |= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (uints |= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (uints |= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (uints |= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<uint, __decltype(uints |= min16ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints |= min12ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints |= min16uints)>::value, "");
  (halfs |= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs |= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs |= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs |= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs |= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs |= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs |= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs |= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs |= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs |= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs |= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats |= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats |= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats |= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats |= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats |= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats |= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats |= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats |= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats |= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats |= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats |= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles |= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles |= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles |= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles |= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles |= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles |= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles |= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles |= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles |= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles |= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles |= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats |= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats |= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats |= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats |= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats |= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats |= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats |= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats |= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats |= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats |= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats |= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats |= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats |= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats |= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats |= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats |= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats |= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats |= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats |= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats |= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats |= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats |= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<min16int, __decltype(min16ints |= bools)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints |= ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints |= uints)>::value, "");
  (min16ints |= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16ints |= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16ints |= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16ints |= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16ints |= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<min16int, __decltype(min16ints |= min16ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints |= min12ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints |= min16uints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints |= bools)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints |= ints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints |= uints)>::value, "");  (min12ints |= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min12ints |= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min12ints |= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min12ints |= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min12ints |= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<min12int, __decltype(min12ints |= min16ints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints |= min12ints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints |= min16uints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints |= bools)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints |= ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints |= uints)>::value, "");
  (min16uints |= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16uints |= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16uints |= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16uints |= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16uints |= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<min16uint, __decltype(min16uints |= min16ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints |= min12ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints |= min16uints)>::value, "");
  (bools ^= bools); // fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools ^= ints); // fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools ^= uints); // fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools ^= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools ^= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools ^= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools ^= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools ^= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (bools ^= min16ints); // fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools ^= min12ints); // fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  (bools ^= min16uints); // fxc-error {{X3020: operator cannot be used with a bool lvalue}}
  _Static_assert(std::is_same<int, __decltype(ints ^= bools)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints ^= ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints ^= uints)>::value, "");
  (ints ^= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (ints ^= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (ints ^= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (ints ^= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (ints ^= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<int, __decltype(ints ^= min16ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints ^= min12ints)>::value, "");
  _Static_assert(std::is_same<int, __decltype(ints ^= min16uints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints ^= bools)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints ^= ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints ^= uints)>::value, "");
  (uints ^= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (uints ^= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (uints ^= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (uints ^= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (uints ^= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<uint, __decltype(uints ^= min16ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints ^= min12ints)>::value, "");
  _Static_assert(std::is_same<uint, __decltype(uints ^= min16uints)>::value, "");
  (halfs ^= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs ^= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs ^= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs ^= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs ^= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs ^= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs ^= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs ^= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs ^= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs ^= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (halfs ^= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats ^= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats ^= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats ^= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats ^= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats ^= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats ^= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats ^= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats ^= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats ^= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats ^= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (floats ^= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles ^= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles ^= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles ^= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles ^= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles ^= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles ^= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles ^= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles ^= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles ^= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles ^= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (doubles ^= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats ^= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats ^= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats ^= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats ^= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats ^= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats ^= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats ^= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats ^= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats ^= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats ^= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16floats ^= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats ^= bools); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats ^= ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats ^= uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats ^= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats ^= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats ^= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats ^= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats ^= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats ^= min16ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats ^= min12ints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min10floats ^= min16uints); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<min16int, __decltype(min16ints ^= bools)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints ^= ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints ^= uints)>::value, "");
  (min16ints ^= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16ints ^= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16ints ^= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16ints ^= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16ints ^= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<min16int, __decltype(min16ints ^= min16ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints ^= min12ints)>::value, "");
  _Static_assert(std::is_same<min16int, __decltype(min16ints ^= min16uints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints ^= bools)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints ^= ints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints ^= uints)>::value, "");  (min12ints ^= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min12ints ^= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min12ints ^= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min12ints ^= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min12ints ^= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<min12int, __decltype(min12ints ^= min16ints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints ^= min12ints)>::value, "");
  _Static_assert(std::is_same<min12int, __decltype(min12ints ^= min16uints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints ^= bools)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints ^= ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints ^= uints)>::value, "");
  (min16uints ^= halfs); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16uints ^= floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16uints ^= doubles); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16uints ^= min16floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  (min16uints ^= min10floats); // expected-error {{int or unsigned int type required}} fxc-error {{X3082: int or unsigned int type required}}
  _Static_assert(std::is_same<min16uint, __decltype(min16uints ^= min16ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints ^= min12ints)>::value, "");
  _Static_assert(std::is_same<min16uint, __decltype(min16uints ^= min16uints)>::value, "");

}
