/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
/* 
 * Connection component state transition event qualifiers
 */


#ifndef LLC_C_EV_H
#define LLC_C_EV_H

/* Types of events (possible values in 'event->type') */
#define CONN_EV_TYPE_SIMPLE        1
#define CONN_EV_TYPE_CONDITION     2
#define CONN_EV_TYPE_PRIM          3
#define CONN_EV_TYPE_PDU           4           /* command/response PDU */
#define CONN_EV_TYPE_ACK_TIMER     5
#define CONN_EV_TYPE_P_TIMER       6
#define CONN_EV_TYPE_REJ_TIMER     7
#define CONN_EV_TYPE_BUSY_TIMER    8
#define CONN_EV_TYPE_RPT_STATUS    9
#define CONN_EV_TYPE_SENDACK_TIMER     10

#define NBR_CONN_EV		   5 


/*
 * Connection events which cause state transitions when fully qualified 
 */

#define CONN_EV_CONNECT_REQUEST                    1
#define CONN_EV_CONNECT_RESPONSE                   2
#define CONN_EV_DATA_REQUEST                       3
#define CONN_EV_DISCONNECT_REQUEST                 4
#define CONN_EV_RESET_REQUEST                      5
#define CONN_EV_RESET_RESPONSE                     6
#define CONN_EV_LOCAL_BUSY_DETECTED                7
#define CONN_EV_LOCAL_BUSY_CLEARED                 8
#define CONN_EV_RX_BAD_PDU                         9
#define CONN_EV_RX_DISC_CMD_Pbit_SET_X             10
#define CONN_EV_RX_DM_RSP_Fbit_SET_X               11
#define CONN_EV_RX_FRMR_RSP_Fbit_SET_X             12
#define CONN_EV_RX_I_CMD_Pbit_SET_X                13
#define CONN_EV_RX_I_CMD_Pbit_SET_X_UNEXPD_Ns      14
#define CONN_EV_RX_I_CMD_Pbit_SET_X_INVAL_Ns       15
#define CONN_EV_RX_I_RSP_Fbit_SET_X                16
#define CONN_EV_RX_I_RSP_Fbit_SET_X_UNEXPD_Ns      17
#define CONN_EV_RX_I_RSP_Fbit_SET_X_INVAL_Ns       18
#define CONN_EV_RX_REJ_CMD_Pbit_SET_X              19
#define CONN_EV_RX_REJ_RSP_Fbit_SET_X              20
#define CONN_EV_RX_RNR_CMD_Pbit_SET_X              21
#define CONN_EV_RX_RNR_RSP_Fbit_SET_X              22
#define CONN_EV_RX_RR_CMD_Pbit_SET_X               23
#define CONN_EV_RX_RR_RSP_Fbit_SET_X               24
#define CONN_EV_RX_SABME_CMD_Pbit_SET_X            25
#define CONN_EV_RX_UA_RSP_Fbit_SET_X               26
#define CONN_EV_RX_XXX_CMD_Pbit_SET_X              27
#define CONN_EV_RX_XXX_RSP_Fbit_SET_X              28
#define CONN_EV_RX_XXX_YYY                         29
#define CONN_EV_RX_ZZZ_CMD_Pbit_SET_X_INVAL_Nr     30
#define CONN_EV_RX_ZZZ_RSP_Fbit_SET_X_INVAL_Nr     31
#define CONN_EV_P_TIMER_EXPIRED                    32
#define CONN_EV_ACK_TIMER_EXPIRED                  33
#define CONN_EV_REJ_TIMER_EXPIRED                  34
#define CONN_EV_BUSY_TIMER_EXPIRED                 35
#define CONN_EV_RX_XXX_CMD_Pbit_SET_1              36
#define CONN_EV_RX_XXX_CMD_Pbit_SET_0              37
#define CONN_EV_RX_I_CMD_Pbit_SET_0_UNEXPD_Ns      38
#define CONN_EV_RX_I_RSP_Fbit_SET_0_UNEXPD_Ns      39
#define CONN_EV_RX_I_RSP_Fbit_SET_1_UNEXPD_Ns      40
#define CONN_EV_RX_I_CMD_Pbit_SET_1_UNEXPD_Ns      41
#define CONN_EV_RX_I_CMD_Pbit_SET_0                42
#define CONN_EV_RX_I_RSP_Fbit_SET_0                43
#define CONN_EV_RX_I_CMD_Pbit_SET_1                44
#define CONN_EV_RX_RR_CMD_Pbit_SET_0               45
#define CONN_EV_RX_RR_RSP_Fbit_SET_0               46
#define CONN_EV_RX_RR_RSP_Fbit_SET_1               47
#define CONN_EV_RX_RR_CMD_Pbit_SET_1               48
#define CONN_EV_RX_RNR_CMD_Pbit_SET_0              49
#define CONN_EV_RX_RNR_RSP_Fbit_SET_0              50
#define CONN_EV_RX_RNR_RSP_Fbit_SET_1              51
#define CONN_EV_RX_RNR_CMD_Pbit_SET_1              52
#define CONN_EV_RX_REJ_CMD_Pbit_SET_0              53
#define CONN_EV_RX_REJ_RSP_Fbit_SET_0              54
#define CONN_EV_RX_REJ_CMD_Pbit_SET_1              55
#define CONN_EV_RX_I_RSP_Fbit_SET_1                56
#define CONN_EV_RX_REJ_RSP_Fbit_SET_1              57
#define CONN_EV_RX_XXX_RSP_Fbit_SET_1              58
#define CONN_EV_TX_BUFF_FULL                       59

#define CONN_EV_INIT_P_F_CYCLE                     100


/*
 * Connection event qualifiers; for some events a certain combination of
 * these qualifiers must be TRUE before event recognized valid for state;
 * these constants act as indexes into the Event Qualifier function 
 * table
 */
#define CONN_EV_QFY_DATA_FLAG_EQ_1         1
#define CONN_EV_QFY_DATA_FLAG_EQ_0         2
#define CONN_EV_QFY_DATA_FLAG_EQ_2         3
#define CONN_EV_QFY_P_FLAG_EQ_1            4
#define CONN_EV_QFY_P_FLAG_EQ_0            5
#define CONN_EV_QFY_P_FLAG_EQ_Fbit         6
#define CONN_EV_QFY_REMOTE_BUSY_EQ_0       7
#define CONN_EV_QFY_RETRY_COUNT_LT_N2      8
#define CONN_EV_QFY_RETRY_COUNT_GTE_N2     9
#define CONN_EV_QFY_S_FLAG_EQ_1            10
#define CONN_EV_QFY_S_FLAG_EQ_0            11
#define CONN_EV_QFY_INIT_P_F_CYCLE         12


/* Event data interface; what is sent in an event package */

/* Event CONN_EV_TYPE_SIMPLE interface */
typedef struct
{
   us8                     event;
} conn_event_simple_if_t;


/* Event CONN_EV_TYPE_PRIM interface */
typedef struct
{
   us8                     prim;       /* connect, disconnect, reset, ... */
   us8                     type;  /* request, indicate, response, confirm */
   void *                  data;          /* pointer to 'prim_if_block_t' */
} conn_event_prim_if_t;


/* Event CONN_EV_TYPE_PDU interface */
typedef struct
{                      
   us8                 event;
   us8                 reason;
   frame_t *           frame;
} conn_event_pdu_if_t;


/* Event interface for timer-generated events */
typedef struct
{
#ifdef LLC_MAIN_C
   connection_t *          conn;
#else
   void *                  conn;
#endif /* LLC_MAIN_C */
   us32                    component_handle;
   void *                  timer_specific;
} conn_event_timer_if_t;


typedef struct
{
   us8                     status;
} conn_event_rpt_sts_if_t;


typedef union
{
   conn_event_simple_if_t  a;          /* 'a' for simple, easy ... */
   conn_event_prim_if_t    prim;
   conn_event_pdu_if_t     pdu;
   conn_event_timer_if_t   tmr;
   conn_event_rpt_sts_if_t rsts;       /* report status */
} conn_event_if_t;


typedef struct
{
   us8                     type;
   us8                     status;
   us8                     flag;
   prim_if_block_t         *ind_prim;
   prim_if_block_t         *cfm_prim;
   conn_event_if_t         data;
} conn_state_event_t;


#ifndef LLC_MAIN_C


typedef us16       (*conn_event_t)(connection_t * conn,
                                                conn_state_event_t * event);

typedef us16       (*conn_event_qfyr_t)(connection_t * conn,
                                                conn_state_event_t * event);


#ifdef LLC_C_EV_C
#define EXTRN
#else
#define EXTRN extern
#endif /* LLC_C_EV_C */


EXTRN us16     conn_ev_connect_request (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_connect_response (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_data_request (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_disconnect_request (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_reset_request (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_reset_response (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_local_busy_detected (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_local_busy_cleared (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_bad_pdu (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_disc_cmd_pbit_set_x (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_dm_rsp_fbit_set_x (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_frmr_rsp_fbit_set_x (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_i_cmd_pbit_set_x_inval_ns (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_i_rsp_fbit_set_x (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_i_rsp_fbit_set_x_unexpd_ns (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_i_rsp_fbit_set_x_inval_ns (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_rej_rsp_fbit_set_x (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_sabme_cmd_pbit_set_x (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_ua_rsp_fbit_set_x (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_xxx_cmd_pbit_set_x (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_xxx_rsp_fbit_set_x (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_xxx_yyy (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_zzz_cmd_pbit_set_x_inval_nr (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_zzz_rsp_fbit_set_x_inval_nr (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_p_timer_expired (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_ack_timer_expired (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rej_timer_expired (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_busy_timer_expired (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_any_timer_expired (connection_t * conn,
                                                 conn_state_event_t *event);

EXTRN us16     conn_ev_sendack_timer_expired (connection_t * conn,
                                                 conn_state_event_t *event); 

/* NOT_USED functions and their variations */
EXTRN us16     conn_ev_rx_xxx_cmd_pbit_set_1 (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_xxx_cmd_pbit_set_0 (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_xxx_rsp_fbit_set_1 (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_i_cmd_pbit_set_0_unexpd_ns (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_i_cmd_pbit_set_1_unexpd_ns (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_i_cmd_pbit_set_0 (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_i_cmd_pbit_set_1 (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_i_rsp_fbit_set_0_unexpd_ns (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_i_rsp_fbit_set_1_unexpd_ns (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_i_rsp_fbit_set_0 (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_i_rsp_fbit_set_1 (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_rr_cmd_pbit_set_0 (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_rr_cmd_pbit_set_1 (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_rr_rsp_fbit_set_0 (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_rr_rsp_fbit_set_1 (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_rnr_cmd_pbit_set_0 (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_rnr_cmd_pbit_set_1 (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_rnr_rsp_fbit_set_0 (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_rnr_rsp_fbit_set_1 (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_rej_cmd_pbit_set_0 (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_rej_cmd_pbit_set_1 (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_rej_rsp_fbit_set_0 (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_rej_rsp_fbit_set_1 (connection_t * conn,
                                                 conn_state_event_t *event);
EXTRN us16     conn_ev_rx_any_frame (connection_t * conn,
                                                 conn_state_event_t *event);

EXTRN us16     conn_ev_tx_buffer_full (connection_t * conn,
                                                 conn_state_event_t *event);

EXTRN us16     conn_ev_init_p_f_cycle (connection_t * conn,
                                                 conn_state_event_t *event);


/* Available connection action qualifiers */

EXTRN us16     conn_ev_qlfy_data_flag_eq_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_data_flag_eq_0 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_data_flag_eq_2 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_p_flag_eq_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_last_frame_eq_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_last_frame_eq_0 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_p_flag_eq_0 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_p_flag_eq_f (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_remote_busy_eq_0 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_remote_busy_eq_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_retry_count_lt_n2 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_retry_count_gte_n2 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_s_flag_eq_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_s_flag_eq_0 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_cause_flag_eq_1 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_cause_flag_eq_0 (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_init_p_f_cycle (connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_set_status_connect(connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_set_status_disconnect(connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_set_status_failed(connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_set_status_impossible(connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_set_status_remote_busy(connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_set_status_received(connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_set_status_refuse(connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_set_status_conflict(connection_t * conn,
                                                conn_state_event_t * event);
EXTRN us16     conn_ev_qlfy_set_status_reset_done(connection_t * conn,
                                                conn_state_event_t * event);
#endif /* LLC_MAIN_C */


#undef EXTRN
#endif /* LLC_C_EV_H */
