/*
 * Copyright 2008 Sony Corporation of America
 *
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this Library and associated documentation files (the
 * "Library"), to deal in the Library without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Library, and to
 * permit persons to whom the Library is furnished to do so, subject to
 * the following conditions:
 *
 *  The above copyright notice and this permission notice shall be
 *  included in all copies or substantial portions of the Library.
 *
 *  If you modify the Library, you may copy and distribute your modified
 *  version of the Library in object code or as an executable provided
 *  that you also do one of the following:
 *
 *   Accompany the modified version of the Library with the complete
 *   corresponding machine-readable source code for the modified version
 *   of the Library; or,
 *
 *   Accompany the modified version of the Library with a written offer
 *   for a complete machine-readable copy of the corresponding source
 *   code of the modified version of the Library.
 *
 *
 * THE LIBRARY IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * LIBRARY OR THE USE OR OTHER DEALINGS IN THE LIBRARY.
 */

#ifndef MARS_TASK_QUEUE_TYPES_H
#define MARS_TASK_QUEUE_TYPES_H

/**
 * \file
 * \ingroup group_mars_task_queue
 * \brief <b>[host/MPU]</b> MARS Task Queue Types
 */

/**
 * \ingroup group_mars_task_queue
 * \brief Queue direction from PPU to SPU
 */
#define MARS_TASK_QUEUE_HOST_TO_MPU		0x10

/**
 * \ingroup group_mars_task_queue
 * \brief Queue direction from SPU to PPU
 */
#define MARS_TASK_QUEUE_MPU_TO_HOST		0x11

/**
 * \ingroup group_mars_task_queue
 * \brief Queue direction from SPU to SPU
 */
#define MARS_TASK_QUEUE_MPU_TO_MPU		0x12

/**
 * \ingroup group_mars_task_queue
 * \brief Maximum tasks allowed to wait on a queue
 */
#define MARS_TASK_QUEUE_WAIT_MAX		18

/**
 * \ingroup group_mars_task_queue
 * \brief Maximum size allowed for queue entry
 */
#define MARS_TASK_QUEUE_ENTRY_SIZE_MAX		16384

/**
 * \ingroup group_mars_task_queue
 * \brief MARS task queue structure
 *
 * An instance of this structure must be created when using any of the
 * MARS queue API.
 */
struct mars_task_queue;

#endif
