/*
 * Copyright (C) 2000 Jens Axboe <axboe@suse.de>
 *
 * May be copied or modified under the terms of the GNU General Public
 * License.  See linux/COPYING for more information.
 *
 * Packet writing layer for ATAPI and SCSI CD-R, CD-RW, DVD-R, and
 * DVD-RW devices.
 *
 */
#ifndef __PKTCDVD_H
#define __PKTCDVD_H

/*
 * 1 for normal debug messages, 2 is very verbose. 0 to turn it off.
 */
#define PACKET_DEBUG		1

#define	MAX_WRITERS		8

#define STACKED_BH_POOL_SIZE	64

/*
 * use drive write caching -- we need deferred error handling to be
 * able to sucessfully recover with this option (drive will return good
 * status as soon as the cdb is validated).
 */
#if defined(CONFIG_CDROM_PKTCDVD_WCACHE)
#warning Enabling write caching, use at your own risk
#define USE_WCACHING		1
#else
#define USE_WCACHING		0
#endif

/*
 * No user-servicable parts beyond this point ->
 */

#if PACKET_DEBUG
#define DPRINTK(fmt, args...) printk(KERN_NOTICE fmt, ##args)
#else
#define DPRINTK(fmt, args...)
#endif

#if PACKET_DEBUG > 1
#define VPRINTK(fmt, args...) printk(KERN_NOTICE fmt, ##args)
#else
#define VPRINTK(fmt, args...)
#endif

#define PKT_BUF_LIST		0x89

/*
 * device types
 */
#define PACKET_CDR		1
#define	PACKET_CDRW		2
#define PACKET_DVDR		3
#define PACKET_DVDRW		4

/*
 * flags
 */
#define PACKET_WRITEABLE	1	/* pd is writeable */
#define PACKET_NWA_VALID	2	/* next writeable address valid */
#define PACKET_LRA_VALID	3	/* last recorded address valid */
#define PACKET_READONLY		4	/* read only pd */
#define PACKET_RECOVERY		5	/* rq recovery in progress */
#define PACKET_RQ		6	/* current rq is set */
#define PACKET_BUSY		7	/* current rq is being processed */

/*
 * Disc status -- from READ_DISC_INFO
 */
#define PACKET_DISC_EMPTY	0
#define PACKET_DISC_INCOMPLETE	1
#define PACKET_DISC_COMPLETE	2
#define PACKET_DISC_OTHER	3

/*
 * write type, and corresponding data block type
 */
#define PACKET_MODE1		1
#define PACKET_MODE2		2
#define PACKET_BLOCK_MODE1	8
#define PACKET_BLOCK_MODE2	10

/*
 * Last session/border status
 */
#define PACKET_SESSION_EMPTY		0
#define PACKET_SESSION_INCOMPLETE	1
#define PACKET_SESSION_RESERVED		2
#define PACKET_SESSION_COMPLETE		3

#define PACKET_MCN			"4a656e734178626f65323030300000"

#undef PACKET_USE_LS

/*
 * special requests
 */
#define PKT_THROTTLE_SPEED	1

#define PKT_TRAY_UNLOCK		0
#define PKT_TRAY_LOCK		1

/*
 * Very crude stats for now
 */
struct packet_stats
{
	unsigned long		bh_s;
	unsigned long		bh_e;
	unsigned long		bh_cache_hits;
	unsigned long		page_cache_hits;
	unsigned long		secs_w;
	unsigned long		secs_r;
};

/*
 * packet ioctls
 */
#define PACKET_IOCTL_MAGIC	('X')
#define PACKET_GET_STATS	_IOR(PACKET_IOCTL_MAGIC, 0, struct packet_stats)
#define PACKET_SETUP_DEV	_IOW(PACKET_IOCTL_MAGIC, 1, unsigned int)
#define PACKET_TEARDOWN_DEV	_IOW(PACKET_IOCTL_MAGIC, 2, unsigned int)

#ifdef __KERNEL__
#include <linux/blkdev.h>
#include <linux/completion.h>

struct packet_settings
{
	__u8			size;		/* packet size (512 byte sectors) */
	__u8			fp;		/* fixed packets */
	__u8			link_loss;	/* the rest is specified
						 * as per Mt Fuji */
	__u8			write_type;
	__u8			track_mode;
	__u8			block_mode;
};

struct packet_cdrw
{
	struct buffer_head		*bhlist;	/* string of bhs */
	atomic_t			free_bh;
	merge_request_fn		*front_merge_fn;
	merge_request_fn		*back_merge_fn;
	merge_requests_fn		*merge_requests_fn;
	request_queue_t			r_queue;
	void				*queuedata;
	pid_t				pid;
	int				time_to_die;
	struct completion		thr_compl;
};

struct pktcdvd_device
{
	struct block_device		*bdev;
	kdev_t				dev;		/* dev attached */
	kdev_t				pkt_dev;	/* our dev */
	char				name[20];
	struct cdrom_device_info	*cdi;		/* cdrom matching dev */
	struct packet_settings		settings;
	struct packet_stats		stats;
	atomic_t			refcnt;
	__u8				write_speed;	/* current write speed */
	unsigned long			offset;		/* start offset */
	__u8				mode_offset;	/* 0 / 8 */
	__u8				type;
	unsigned long			flags;
	__u16				mmc3_profile;
	__u8				disc_status;
	__u8				track_status;	/* last one */
	__u32				nwa;	/* next writable address */
	__u32				lra;	/* last recorded address */
	spinlock_t			lock;
	struct packet_cdrw		cdrw;
	wait_queue_head_t		wqueue;
	struct request			*rq;
	atomic_t			wrqcnt;
	struct buffer_head		*stacked_bhlist;
	int				stacked_bhcnt;

	struct semaphore		cache_sync_mutex;
	int				unflushed_writes;

	make_request_fn			*make_request_fn;
};

/*
 * following possibly belongs in cdrom.h
 */

struct cdvd_capacity
{
	__u32 lba;
	__u32 block_length;
};

void pkt_elevator_merge_req(struct request *rq, struct request *nxt) {}

#define ELEVATOR_PKTCDVD					\
((elevator_t) {							\
	0,				/* not used */		\
	0,				/* not used */		\
								\
	pkt_elevator_merge,		/* elevator_merge_fn */ \
	pkt_elevator_merge_req,					\
	})

#endif /* __KERNEL__ */

#endif /* __PKTCDVD_H */
