/*
 * Atom-4 triboard celltype wrapper
 * Header file
 *
 * $Id$
 */

#ifndef COLOR4_H
#define COLOR4_H

#include "triboard.h"


class color4 {
  celltype val;
public:
  color4(celltype c=BAD_CELL) : val(c) {}
  operator celltype () { return val; }

  int colortype();		// -1 = invalid, 0 = propagator, 1 = additive,
				// 2 = subtractive
  color4 propagator() { return propagator(colortype()); }
  static color4 propagator(int type);

  color4 complement() { return color4(((val-'a')^7) + 'a'); }
  color4 mix(color4 c);

  color4 rotl();		// rotate left
  color4 rotr();		// rotate right
};

#endif // COLOR4_H
