"""Fixtures for different items from UniFi controller."""

LOGIN_UNIFIOS_JSON_RESPONSE = {
    "unique_id": "868d288b-a642-4209-a768-8425498fa928",
    "username": "Testing1",
    "first_name": "Testing",
    "last_name": "Testing",
    "full_name": "Testing Testing",
    "email": "",
    "email_status": "UNVERIFIED",
    "phone": "",
    "avatar": "",
    "avatar_relative_path": "",
    "status": "ACTIVE",
    "sso_account": "",
    "sso_uuid": "",
    "sso_username": "",
    "create_time": 1585163886,
    "local_account_exist": True,
    "uid_sso_id": "",
    "uid_sso_account": "",
    "password_revision": 1585163886,
    "extras": None,
    "nfc_token": "",
    "nfc_display_id": "",
    "update_time": 1585167486,
    "groups": [],
    "roles": [
        {
            "unique_id": "ddf31242-c4f1-4dbc-b362-d0b220cae124",
            "name": "Super Administrator",
            "system_role": True,
            "system_key": "super_administrator",
            "level": 2,
        }
    ],
    "permissions": {
        "access.management": ["admin"],
        "led.management": ["admin"],
        "network.management": ["admin"],
        "protect.management": ["admin"],
        "system.management.location": ["admin"],
        "system.management.user": ["admin"],
        "talk.management": ["admin"],
    },
    "scopes": [
        "view:user_timezone",
        "view:user",
        "view:systemlog",
        "view:settings",
        "view:role",
        "view:permission:viewer",
        "view:permission:admin",
        "view:notification",
        "view:location_policy",
        "view:location_device",
        "view:location_activity",
        "view:location",
        "view:holiday_timezone",
        "view:holiday",
        "view:group",
        "view:door_group",
        "view:controller:talk",
        "view:controller:protect",
        "view:controller:network",
        "view:controller:led",
        "view:controller:access",
        "view:cloud_access",
        "view:app:users",
        "view:app:settings",
        "view:app:locations",
        "view:access.visitor",
        "view:access.systemlog",
        "view:access.schedule",
        "view:access.policy",
        "view:access.nfc_card",
        "view:access.device",
        "view:access.dashboard",
        "update:access.device",
        "systemlog:user",
        "systemlog:system",
        "systemlog:location",
        "systemlog:access",
        "notify:user",
        "notify:location",
        "notify:access",
        "manage:controller:talk",
        "manage:controller:protect",
        "manage:controller:network",
        "manage:controller:led",
        "manage:controller:access",
        "edit:user_timezone",
        "edit:user",
        "edit:systemlog",
        "edit:settings",
        "edit:role",
        "edit:permission:viewer",
        "edit:permission:admin",
        "edit:notification",
        "edit:location_policy",
        "edit:location_device",
        "edit:location_activity",
        "edit:location",
        "edit:holiday_timezone",
        "edit:holiday",
        "edit:group",
        "edit:feedback",
        "edit:door_group",
        "edit:access.visitor",
        "edit:access.schedule",
        "edit:access.policy",
        "edit:access.nfc_card",
        "edit:access.device",
        "delete:access.device",
        "assign:role",
        "adopt:access.device",
    ],
    "cloud_access_granted": False,
    "id": "868d288b-a642-4209-a768-8425498fa928",
    "isOwner": False,
    "isSuperAdmin": True,
}


SITE_RESPONSE = {
    "meta": {"rc": "ok"},
    "data": [
        {
            "_id": "5e231c10931eb902acf25112",
            "name": "default",
            "desc": "Default",
            "attr_hidden_id": "default",
            "attr_no_delete": True,
            "role": "admin",
        }
    ],
}


ACCESS_POINT_AC_PRO = {
    "_id": "5a4c022",
    "_uptime": 3971849,
    "adoptable_when_upgraded": False,
    "adopted": True,
    "antenna_table": [
        {"default": True, "id": 4, "name": "Combined", "wifi0_gain": 3, "wifi1_gain": 3}
    ],
    "architecture": "mips",
    "board_rev": 21,
    "bytes": 202573081705,
    "bytes-d": 4275308,
    "bytes-r": 178137,
    "cfgversion": "97f3011a27fcfd5b",
    "config_network": {"ip": "192.168.1.7", "type": "dhcp"},
    "connect_request_ip": "192.168.0.11",
    "connect_request_port": "48591",
    "considered_lost_at": 1588175837,
    "country_code": 0,
    "countrycode_table": [],
    "device_id": "235678987654345678",
    "downlink_table": [],
    "element_peer_mac": "",
    "ethernet_table": [{"mac": "80:2a:a8:00:01:02", "name": "eth0", "num_port": 2}],
    "fw_caps": 25099583,
    "gateway_mac": "192.168.0.1",
    "guest-num_sta": 0,
    "guest-wlan-num_sta": 0,
    "guest_token": "dae23r4fdf565434567876543",
    "has_eth1": False,
    "has_fan": False,
    "has_speaker": False,
    "has_temperature": False,
    "hash_id": "4b0fd8ba2912345",
    "hide_ch_width": "none",
    "hw_caps": 0,
    "inform_ip": "192.168.0.5",
    "inform_url": "http://192.168.0.6:8080/inform",
    "ip": "192.168.0.4",
    "isolated": False,
    "kernel_version": "4.4.153",
    "known_cfgversion": "23434545676787654",
    "last_seen": 1588175726,
    "last_uplink": {"uplink_mac": "f0:9f:11:22:33:44", "uplink_remote_port": 6},
    "led_override": "on",
    "license_state": "registered",
    "locating": False,
    "mac": "80:2a:a8:00:01:02",
    "manufacturer_id": 4,
    "meshv3_peer_mac": "",
    "model": "U7PG2",
    "name": "ACCESS POINT AC PRO",
    "next_heartbeat_at": 1588175763,
    "next_interval": 27,
    "num_sta": 12,
    "outdoor_mode_override": "default",
    "port_table": [
        {
            "aggregated_by": False,
            "attr_no_edit": True,
            "autoneg": True,
            "bytes-r": 177399,
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": True,
            "is_uplink": False,
            "jumbo": False,
            "mac_table": [
                {
                    "age": 1,
                    "mac": "10:00:00:00:00:01",
                    "static": False,
                    "uptime": 3971792,
                    "vlan": 1,
                }
            ],
            "masked": False,
            "media": "GE",
            "name": "Main",
            "op_mode": "switch",
            "poe_caps": 0,
            "port_delta": {
                "rx_bytes": 4136705,
                "rx_packets": 2930,
                "time_delta": 24,
                "time_delta_activity": 24,
                "tx_bytes": 120873,
                "tx_packets": 824,
            },
            "port_idx": 1,
            "port_poe": False,
            "portconf_id": "5a32aa4",
            "rx_broadcast": 2323942,
            "rx_bytes": 2275836363755,
            "rx_bytes-r": 172362,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 5051177,
            "rx_packets": 1574257888,
            "speed": 1000,
            "stp_pathcost": 0,
            "stp_state": "forwarding",
            "tx_broadcast": 218413,
            "tx_bytes": 53516753422,
            "tx_bytes-r": 5036,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 2935588,
            "tx_packets": 333052121,
            "up": True,
        },
        {
            "aggregated_by": False,
            "autoneg": False,
            "bytes-r": 0,
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": False,
            "is_uplink": False,
            "jumbo": False,
            "mac_table": [],
            "masked": False,
            "media": "GE",
            "name": "Secondary",
            "op_mode": "switch",
            "poe_caps": 0,
            "port_delta": {"time_delta": 24, "time_delta_activity": 1588175726},
            "port_idx": 2,
            "port_poe": False,
            "portconf_id": "5a32aa4",
            "rx_broadcast": 0,
            "rx_bytes": 0,
            "rx_bytes-r": 0,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 0,
            "speed": 0,
            "stp_pathcost": 0,
            "stp_state": "forwarding",
            "tx_broadcast": 0,
            "tx_bytes": 0,
            "tx_bytes-r": 0,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 0,
            "tx_packets": 0,
            "up": False,
        },
    ],
    "radio_table": [
        {
            "antenna_gain": 6,
            "builtin_ant_gain": 3,
            "builtin_antenna": True,
            "channel": 1,
            "current_antenna_gain": 0,
            "ht": "20",
            "max_txpower": 22,
            "min_rssi_enabled": False,
            "min_txpower": 6,
            "name": "wifi0",
            "nss": 3,
            "radio": "ng",
            "radio_caps": 16420,
            "sens_level_enabled": False,
            "tx_power_mode": "low",
            "wlangroup_id": "5a32aa4ee4",
        },
        {
            "antenna_gain": 6,
            "builtin_ant_gain": 3,
            "builtin_antenna": True,
            "channel": "auto",
            "current_antenna_gain": 0,
            "hard_noise_floor_enabled": False,
            "has_dfs": True,
            "has_fccdfs": True,
            "ht": "40",
            "is_11ac": True,
            "max_txpower": 22,
            "min_rssi_enabled": False,
            "min_txpower": 6,
            "name": "wifi1",
            "nss": 3,
            "radio": "na",
            "radio_caps": 50479140,
            "sens_level_enabled": False,
            "tx_power_mode": "high",
            "wlangroup_id": "5a32aa4ee4",
        },
    ],
    "radio_table_stats": [
        {
            "ast_be_xmit": 239,
            "ast_cst": None,
            "ast_txto": None,
            "channel": 1,
            "cu_self_rx": 20,
            "cu_self_tx": 0,
            "cu_total": 21,
            "extchannel": 0,
            "gain": 3,
            "guest-num_sta": 0,
            "name": "wifi0",
            "num_sta": 3,
            "radio": "ng",
            "satisfaction": 99,
            "state": "RUN",
            "tx_packets": 30,
            "tx_power": 6,
            "tx_retries": 16,
            "user-num_sta": 3,
        },
        {
            "ast_be_xmit": 239,
            "ast_cst": None,
            "ast_txto": None,
            "channel": 44,
            "cu_self_rx": 1,
            "cu_self_tx": 1,
            "cu_total": 2,
            "extchannel": 1,
            "gain": 3,
            "guest-num_sta": 0,
            "name": "wifi1",
            "num_sta": 9,
            "radio": "na",
            "satisfaction": 97,
            "state": "RUN",
            "tx_packets": 2902,
            "tx_power": 17,
            "tx_retries": 121,
            "user-num_sta": 9,
        },
    ],
    "required_version": "3.4.1",
    "rx_bytes": 4049050176,
    "rx_bytes-d": 126600,
    "satisfaction": 97,
    "scan_radio_table": [],
    "scanning": False,
    "serial": "802AA8000102",
    "site_id": "5a32aa4ee4b0412345678910",
    "spectrum_scanning": False,
    "ssh_session_table": [],
    "start_connected_millis": 1587859252498,
    "start_disconnected_millis": 1587859249141,
    "stat": {
        "ap": {
            "ap": "80:2a:a8:00:01:02",
            "bytes": 202573081705.0,
            "datetime": "2020-04-26T00:00:00Z",
            "duration": 316470000.0,
            "guest-mac_filter_rejections": 0.0,
            "guest-rx_bytes": 0.0,
            "guest-rx_crypts": 0.0,
            "guest-rx_dropped": 0.0,
            "guest-rx_errors": 0.0,
            "guest-rx_frags": 0.0,
            "guest-rx_packets": 0.0,
            "guest-tx_bytes": 0.0,
            "guest-tx_dropped": 0.0,
            "guest-tx_errors": 0.0,
            "guest-tx_packets": 0.0,
            "guest-tx_retries": 0.0,
            "guest-wifi_tx_attempts": 0.0,
            "guest-wifi_tx_dropped": 0.0,
            "mac_filter_rejections": 0.0,
            "o": "ap",
            "oid": "80:2a:a8:00:01:02",
            "port_1-rx_broadcast": 172074.0,
            "port_1-rx_bytes": 216612809001.0,
            "port_1-rx_multicast": 403649.0,
            "port_1-rx_packets": 148071452.0,
            "port_1-tx_broadcast": 19948.0,
            "port_1-tx_bytes": 3988805922.0,
            "port_1-tx_multicast": 258376.0,
            "port_1-tx_packets": 26448260.0,
            "rx_bytes": 4049050176.0,
            "rx_crypts": 20074.0,
            "rx_dropped": 41540.0,
            "rx_errors": 20385.0,
            "rx_frags": 0.0,
            "rx_packets": 27062516.0,
            "site_id": "5a32aa4ee4b0412345678910",
            "time": 1587859200000,
            "tx_bytes": 198524031529.0,
            "tx_dropped": 0.0,
            "tx_errors": 233910.0,
            "tx_packets": 148794592.0,
            "tx_retries": 5259147.0,
            "user-mac_filter_rejections": 0.0,
            "user-rx_bytes": 4049050176.0,
            "user-rx_crypts": 20074.0,
            "user-rx_dropped": 41540.0,
            "user-rx_errors": 20385.0,
            "user-rx_frags": 0.0,
            "user-rx_packets": 27062516.0,
            "user-tx_bytes": 198524031529.0,
            "user-tx_dropped": 0.0,
            "user-tx_errors": 233910.0,
            "user-tx_packets": 148794592.0,
            "user-tx_retries": 5259147.0,
            "user-wifi0-ath0-3453453453453-rx_bytes": 543942635.0,
            "user-wifi0-ath0-3453453453453-rx_crypts": 8532.0,
            "user-wifi0-ath0-3453453453453-rx_dropped": 17899.0,
            "user-wifi0-ath0-3453453453453-rx_errors": 8843.0,
            "user-wifi0-ath0-3453453453453-rx_packets": 1286990.0,
            "user-wifi0-ath0-3453453453453-tx_bytes": 1631875402.0,
            "user-wifi0-ath0-3453453453453-tx_packets": 2143440.0,
            "user-wifi0-ath0-3453453453453-tx_retries": 815193.0,
            "user-wifi0-ath0-3453453453453-wifi_tx_attempts": 2251168.0,
            "user-wifi0-ath0-3453453453453-wifi_tx_dropped": 5689.0,
            "user-wifi0-mac_filter_rejections": 0.0,
            "user-wifi0-rx_bytes": 543942635.0,
            "user-wifi0-rx_crypts": 8532.0,
            "user-wifi0-rx_dropped": 17899.0,
            "user-wifi0-rx_errors": 8843.0,
            "user-wifi0-rx_frags": 0.0,
            "user-wifi0-rx_packets": 1286990.0,
            "user-wifi0-tx_bytes": 1631875402.0,
            "user-wifi0-tx_dropped": 0.0,
            "user-wifi0-tx_errors": 0.0,
            "user-wifi0-tx_packets": 2143440.0,
            "user-wifi0-tx_retries": 815193.0,
            "user-wifi0-wifi_tx_attempts": 2251168.0,
            "user-wifi0-wifi_tx_dropped": 5689.0,
            "user-wifi1-ath1-3453453453453-rx_bytes": 3505107541.0,
            "user-wifi1-ath1-3453453453453-rx_crypts": 11542.0,
            "user-wifi1-ath1-3453453453453-rx_dropped": 23641.0,
            "user-wifi1-ath1-3453453453453-rx_errors": 11542.0,
            "user-wifi1-ath1-3453453453453-rx_packets": 25775526.0,
            "user-wifi1-ath1-3453453453453-tx_bytes": 196892156127.0,
            "user-wifi1-ath1-3453453453453-tx_errors": 233910.0,
            "user-wifi1-ath1-3453453453453-tx_packets": 146651152.0,
            "user-wifi1-ath1-3453453453453-tx_retries": 4443954.0,
            "user-wifi1-ath1-3453453453453-wifi_tx_attempts": 79575052.0,
            "user-wifi1-ath1-3453453453453-wifi_tx_dropped": 512.0,
            "user-wifi1-mac_filter_rejections": 0.0,
            "user-wifi1-rx_bytes": 3505107541.0,
            "user-wifi1-rx_crypts": 11542.0,
            "user-wifi1-rx_dropped": 23641.0,
            "user-wifi1-rx_errors": 11542.0,
            "user-wifi1-rx_frags": 0.0,
            "user-wifi1-rx_packets": 25775526.0,
            "user-wifi1-tx_bytes": 196892156127.0,
            "user-wifi1-tx_dropped": 0.0,
            "user-wifi1-tx_errors": 233910.0,
            "user-wifi1-tx_packets": 146651152.0,
            "user-wifi1-tx_retries": 4443954.0,
            "user-wifi1-wifi_tx_attempts": 79575052.0,
            "user-wifi1-wifi_tx_dropped": 512.0,
            "user-wifi_tx_attempts": 81826220.0,
            "user-wifi_tx_dropped": 6201.0,
            "wifi0-mac_filter_rejections": 0.0,
            "wifi0-rx_bytes": 543942635.0,
            "wifi0-rx_crypts": 8532.0,
            "wifi0-rx_dropped": 17899.0,
            "wifi0-rx_errors": 8843.0,
            "wifi0-rx_frags": 0.0,
            "wifi0-rx_packets": 1286990.0,
            "wifi0-tx_bytes": 1631875402.0,
            "wifi0-tx_dropped": 0.0,
            "wifi0-tx_errors": 0.0,
            "wifi0-tx_packets": 2143440.0,
            "wifi0-tx_retries": 815193.0,
            "wifi0-wifi_tx_attempts": 2251168.0,
            "wifi0-wifi_tx_dropped": 5689.0,
            "wifi1-mac_filter_rejections": 0.0,
            "wifi1-rx_bytes": 3505107541.0,
            "wifi1-rx_crypts": 11542.0,
            "wifi1-rx_dropped": 23641.0,
            "wifi1-rx_errors": 11542.0,
            "wifi1-rx_frags": 0.0,
            "wifi1-rx_packets": 25775526.0,
            "wifi1-tx_bytes": 196892156127.0,
            "wifi1-tx_dropped": 0.0,
            "wifi1-tx_errors": 233910.0,
            "wifi1-tx_packets": 146651152.0,
            "wifi1-tx_retries": 4443954.0,
            "wifi1-wifi_tx_attempts": 79575052.0,
            "wifi1-wifi_tx_dropped": 512.0,
            "wifi_tx_attempts": 81826220.0,
            "wifi_tx_dropped": 6201.0,
        }
    },
    "state": 1,
    "switch_caps": {
        "feature_caps": 32,
        "max_aggregate_sessions": 0,
        "max_mirror_sessions": 0,
    },
    "sys_error_caps": 0,
    "sys_stats": {
        "loadavg_1": "0.15",
        "loadavg_15": "0.02",
        "loadavg_5": "0.08",
        "mem_buffer": 0,
        "mem_total": 128622592,
        "mem_used": 63606784,
    },
    "syslog_key": "3456789098098769876543",
    "system-stats": {"cpu": "3.1", "mem": "27.4", "uptime": "3971849"},
    "two_phase_adopt": False,
    "tx_bytes": 198524031529,
    "tx_bytes-d": 4148708,
    "type": "uap",
    "unsupported": False,
    "unsupported_reason": 0,
    "upgradable": True,
    "upgrade_state": 0,
    "upgrade_to_firmware": "4.0.80.10875",
    "uplink": {
        "full_duplex": True,
        "ip": "0.0.0.0",
        "mac": "80:2a:a8:00:01:02",
        "max_speed": 1000,
        "max_vlan": 96,
        "name": "eth0",
        "netmask": "0.0.0.0",
        "num_port": 2,
        "rx_bytes": 1755202154,
        "rx_bytes-r": 171857,
        "rx_dropped": 131000,
        "rx_errors": 0,
        "rx_multicast": 0,
        "rx_packets": 1574229881,
        "speed": 1000,
        "tx_bytes": 537697796,
        "tx_bytes-r": 4916,
        "tx_dropped": 0,
        "tx_errors": 0,
        "tx_packets": 333052303,
        "type": "wire",
        "up": True,
        "uplink_mac": "f0:9f:11:22:33:44",
        "uplink_remote_port": 6,
    },
    "uplink_table": [],
    "uptime": 3971849,
    "user-num_sta": 12,
    "user-wlan-num_sta": 12,
    "vap_table": [
        {
            "anomalies_bar_chart": {
                "high_dns_latency": 0,
                "high_tcp_latency": 0,
                "high_tcp_packet_loss": 0,
                "high_wifi_latency": 0,
                "high_wifi_retries": 0,
                "low_phy_rate": 0,
                "poor_stream_eff": 0,
                "sleepy_client": 0,
                "sta_arp_timeout": 0,
                "sta_dns_timeout": 0,
                "sta_ip_timeout": 0,
                "weak_signal": 0,
            },
            "anomalies_bar_chart_now": {
                "high_dns_latency": 0,
                "high_tcp_latency": 0,
                "high_tcp_packet_loss": 0,
                "high_wifi_latency": 0,
                "high_wifi_retries": 0,
                "low_phy_rate": 0,
                "poor_stream_eff": 0,
                "sleepy_client": 0,
                "sta_arp_timeout": 0,
                "sta_dns_timeout": 0,
                "sta_ip_timeout": 0,
                "weak_signal": 0,
            },
            "ap_mac": "80:2a:a8:00:01:02",
            "avg_client_signal": -75,
            "bssid": "80:2a:11:22:33:44",
            "ccq": 340,
            "channel": 44,
            "dns_avg_latency": 6,
            "essid": "PhG",
            "extchannel": 1,
            "id": "3453453453453",
            "is_guest": False,
            "is_wep": False,
            "mac_filter_rejections": 0,
            "map_id": None,
            "name": "ath1",
            "num_satisfaction_sta": 9,
            "num_sta": 9,
            "radio": "na",
            "radio_name": "wifi1",
            "reasons_bar_chart": {
                "phy_rate": 0,
                "signal": 3,
                "sleepy_client": 0,
                "sta_arp_timeout": 0,
                "sta_dns_latency": 0,
                "sta_dns_timeout": 0,
                "sta_ip_timeout": 0,
                "stream_eff": 0,
                "tcp_latency": 2,
                "tcp_packet_loss": 0,
                "wifi_latency": 2,
                "wifi_retries": 2,
            },
            "reasons_bar_chart_now": {
                "phy_rate": 0,
                "signal": 2,
                "sleepy_client": 0,
                "sta_arp_timeout": 0,
                "sta_dns_latency": 2,
                "sta_dns_timeout": 0,
                "sta_ip_timeout": 0,
                "stream_eff": 0,
                "tcp_latency": 1,
                "tcp_packet_loss": 0,
                "wifi_latency": 1,
                "wifi_retries": 1,
            },
            "rx_bytes": 2772787976,
            "rx_crypts": 193706,
            "rx_dropped": 377847,
            "rx_errors": 193706,
            "rx_frags": 0,
            "rx_nwids": 244037,
            "rx_packets": 253573604,
            "rx_tcp_stats": {
                "goodbytes": 16307156809,
                "lat_avg": 26,
                "lat_max": 180,
                "lat_min": 10,
                "stalls": 0,
            },
            "satisfaction": 97,
            "site_id": "5a32aa4ee4b0412345678910",
            "state": "RUN",
            "t": "vap",
            "tx_bytes": 2122358914,
            "tx_combined_retries": 3708330,
            "tx_data_mpdu_bytes": 181801507822,
            "tx_dropped": 0,
            "tx_errors": 1710454,
            "tx_packets": 1282805591,
            "tx_power": 17,
            "tx_retries": 3708330,
            "tx_rts_retries": 0,
            "tx_success": 64435416,
            "tx_tcp_stats": {
                "goodbytes": 298206899,
                "lat_avg": 21,
                "lat_max": 110,
                "lat_min": 10,
                "stalls": 0,
            },
            "tx_total": 64435427,
            "up": True,
            "usage": "user",
            "wifi_tx_attempts": 68143757,
            "wifi_tx_dropped": 11,
            "wifi_tx_latency_mov": {
                "avg": 968,
                "max": 3985,
                "min": 97,
                "total": 888421,
                "total_count": 917,
            },
            "wlanconf_id": "3453453453453",
        },
        {
            "anomalies_bar_chart": {
                "high_dns_latency": 0,
                "high_tcp_latency": 0,
                "high_tcp_packet_loss": 0,
                "high_wifi_latency": 0,
                "high_wifi_retries": 0,
                "low_phy_rate": 0,
                "poor_stream_eff": 0,
                "sleepy_client": 0,
                "sta_arp_timeout": 0,
                "sta_dns_timeout": 0,
                "sta_ip_timeout": 0,
                "weak_signal": 0,
            },
            "anomalies_bar_chart_now": {
                "high_dns_latency": 0,
                "high_tcp_latency": 0,
                "high_tcp_packet_loss": 0,
                "high_wifi_latency": 0,
                "high_wifi_retries": 0,
                "low_phy_rate": 0,
                "poor_stream_eff": 0,
                "sleepy_client": 0,
                "sta_arp_timeout": 0,
                "sta_dns_timeout": 0,
                "sta_ip_timeout": 0,
                "weak_signal": 0,
            },
            "ap_mac": "80:2a:a8:00:01:02",
            "avg_client_signal": -70,
            "bssid": "80:2a:22:33:44:55:66",
            "ccq": 633,
            "channel": 1,
            "dns_avg_latency": 5,
            "essid": "PhG",
            "id": "3453453453453",
            "is_guest": False,
            "is_wep": False,
            "mac_filter_rejections": 0,
            "map_id": None,
            "name": "ath0",
            "num_satisfaction_sta": 3,
            "num_sta": 3,
            "radio": "ng",
            "radio_name": "wifi0",
            "reasons_bar_chart": {
                "phy_rate": 0,
                "signal": 0,
                "sleepy_client": 0,
                "sta_arp_timeout": 0,
                "sta_dns_latency": 1,
                "sta_dns_timeout": 0,
                "sta_ip_timeout": 0,
                "stream_eff": 0,
                "tcp_latency": 0,
                "tcp_packet_loss": 0,
                "wifi_latency": 2,
                "wifi_retries": 0,
            },
            "reasons_bar_chart_now": {
                "phy_rate": 0,
                "signal": 0,
                "sleepy_client": 0,
                "sta_arp_timeout": 0,
                "sta_dns_latency": 1,
                "sta_dns_timeout": 0,
                "sta_ip_timeout": 0,
                "stream_eff": 0,
                "tcp_latency": 0,
                "tcp_packet_loss": 0,
                "wifi_latency": 2,
                "wifi_retries": 0,
            },
            "rx_bytes": 1680489730,
            "rx_crypts": 111491,
            "rx_dropped": 140008,
            "rx_errors": 112587,
            "rx_frags": 0,
            "rx_nwids": 3448793,
            "rx_packets": 23062297,
            "rx_tcp_stats": {
                "goodbytes": 22571928,
                "lat_avg": 3,
                "lat_max": 10,
                "lat_min": 10,
                "stalls": 0,
            },
            "satisfaction": 99,
            "site_id": "5a32aa4ee4b0412345678910",
            "state": "RUN",
            "t": "vap",
            "tx_bytes": 2405174619,
            "tx_combined_retries": 198754,
            "tx_data_mpdu_bytes": 65829188,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_packets": 59362177,
            "tx_power": 6,
            "tx_retries": 144922,
            "tx_rts_retries": 53832,
            "tx_success": 411226,
            "tx_tcp_stats": {
                "goodbytes": 51240971,
                "lat_avg": 3,
                "lat_max": 10,
                "lat_min": 10,
                "stalls": 0,
            },
            "tx_total": 411704,
            "up": True,
            "usage": "user",
            "wifi_tx_attempts": 556148,
            "wifi_tx_dropped": 478,
            "wifi_tx_latency_mov": {
                "avg": 516,
                "max": 12117,
                "min": 0,
                "total": 20141,
                "total_count": 39,
            },
            "wlanconf_id": "3453453453453",
        },
    ],
    "version": "4.0.69.10871",
    "vwireEnabled": False,
    "vwire_table": [],
    "vwire_vap_table": [],
    "wifi_caps": 573429,
    "wlan_overrides": [
        {
            "name": "My5GHzSSID1",
            "radio": "na",
            "radio_name": "wifi1",
            "wlan_id": "012345678910111213141516",
        },
    ],
    "wlangroup_id_na": "5a32aa4ee4123",
    "wlangroup_id_ng": "5a32aa4ee4123",
    "x_aes_gcm": True,
    "x_authkey": "345678976545678",
    "x_fingerprint": "1345678765345643567543",
    "x_has_ssh_hostkey": True,
    "x_inform_authkey": "34567657878987654323456",
    "x_ssh_hostkey_fingerprint": "3456787654567898765",
    "x_vwirekey": "2dabb7e23b048c88b60123456789",
}

GATEWAY_USG3 = {
    "_id": "5a4c0cc1e4b0f3665471969a",
    "_uptime": 3971869,
    "adoptable_when_upgraded": False,
    "adopted": True,
    "board_rev": 16,
    "bytes": 1204107284393,
    "cfgversion": "464ab1e08b5bd1a2",
    "config_network": {"ip": "192.168.0.1", "type": "dhcp"},
    "connect_request_ip": "192.168.0.1",
    "connect_request_port": "48714",
    "considered_lost_at": 1588175842,
    "device_id": "235678987654345678",
    "ethernet_overrides": [
        {"ifname": "eth1", "networkgroup": "LAN"},
        {"ifname": "eth0", "networkgroup": "WAN"},
    ],
    "ethernet_table": [
        {"mac": "78:8a:20:33:44:55", "name": "eth0", "num_port": 1},
        {"mac": "192.168.0.1", "name": "eth1", "num_port": 1},
        {"mac": "78:8a:20:33:44:56", "name": "eth2", "num_port": 1},
    ],
    "fw_caps": 184323,
    "guest-num_sta": 0,
    "guest_token": "dae23r4fdf565434567876543",
    "hw_caps": 0,
    "inform_ip": "192.168.0.5",
    "inform_url": "http://192.168.0.7:8080/inform",
    "ip": "1.2.3.4",
    "known_cfgversion": "23434545676787654",
    "last_seen": 1588175740,
    "led_override": "on",
    "license_state": "registered",
    "locating": False,
    "mac": "78:8a:20:33:44:55",
    "model": "UGW3",
    "name": "USG",
    "network_table": [
        {
            "_id": "5a32aa4ee4b3456542345678765",
            "attr_hidden_id": "LAN",
            "attr_no_delete": True,
            "dhcp_relay_enabled": False,
            "dhcpd_dns_1": "192.168.0.7",
            "dhcpd_dns_enabled": False,
            "dhcpd_enabled": True,
            "dhcpd_gateway_enabled": False,
            "dhcpd_leasetime": 86400,
            "dhcpd_start": "192.168.0.11",
            "dhcpd_stop": "192.168.0.254",
            "dhcpd_time_offset_enabled": False,
            "dhcpd_unifi_controller": "192.168.0.7",
            "domain_name": "localdomain",
            "enabled": True,
            "ip": "192.168.0.1",
            "ip_subnet": "192.168.0.1/24",
            "is_guest": False,
            "is_nat": True,
            "lte_lan_enabled": True,
            "mac": "192.168.0.1",
            "name": "LAN",
            "networkgroup": "LAN",
            "num_sta": 16,
            "purpose": "corporate",
            "rx_bytes": 1103117408747,
            "rx_packets": 805953276,
            "site_id": "5a32aa4ee4b0412345678910",
            "tx_bytes": 96022594996,
            "tx_packets": 341451260,
            "up": "true",
            "vlan_enabled": False,
        }
    ],
    "next_heartbeat_at": 1588175774,
    "next_interval": 24,
    "num_desktop": 4,
    "num_handheld": 1,
    "num_mobile": 0,
    "num_sta": 20,
    "outdoor_mode_override": "default",
    "port_table": [
        {
            "dns": ["127.0.0.1"],
            "enable": True,
            "full_duplex": True,
            "gateway": "2.3.4.5",
            "ifname": "eth0",
            "ip": "1.2.3.4",
            "mac": "78:8a:20:33:44:55",
            "name": "wan",
            "netmask": "255.255.254.0",
            "rx_bytes": 1107294012155,
            "rx_dropped": 3929,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 807555430,
            "speed": 1000,
            "tx_bytes": 96813272238,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_packets": 344559427,
            "up": True,
        },
        {
            "enable": True,
            "full_duplex": True,
            "ifname": "eth1",
            "ip": "192.168.0.1",
            "mac": "192.168.0.1",
            "name": "lan",
            "netmask": "255.255.255.0",
            "rx_bytes": 98681321728,
            "rx_dropped": 1379,
            "rx_errors": 0,
            "rx_multicast": 247602,
            "rx_packets": 349214866,
            "speed": 1000,
            "tx_bytes": 1105756381870,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_packets": 808015520,
            "up": True,
        },
        {
            "enable": False,
            "full_duplex": False,
            "ifname": "eth2",
            "ip": "0.0.0.0",
            "mac": "78:8a:20:33:44:56",
            "name": "lan2",
            "netmask": "0.0.0.0",
            "rx_bytes": 0,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 0,
            "speed": 0,
            "tx_bytes": 0,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_packets": 0,
            "up": False,
        },
    ],
    "required_version": "4.0.0",
    "rx_bytes": 96813272238,
    "serial": "788A20334455",
    "site_id": "5a32aa4ee4b0412345678910",
    "speedtest-status": {
        "latency": 0,
        "rundate": 0,
        "runtime": 0,
        "status_download": 0,
        "status_ping": 0,
        "status_summary": 0,
        "status_upload": 0,
        "xput_download": 0.0,
        "xput_upload": 0.0,
    },
    "speedtest-status-saved": True,
    "start_connected_millis": 1587859256101,
    "start_disconnected_millis": 1587859249149,
    "stat": {
        "gw": {
            "datetime": "2020-04-26T00:00:00Z",
            "duration": 316484000.0,
            "gw": "78:8a:20:33:44:55",
            "lan-rx_bytes": 5964025490.0,
            "lan-rx_dropped": 10.0,
            "lan-rx_packets": 24227687.0,
            "lan-tx_bytes": 76685302301.0,
            "lan-tx_packets": 56428312.0,
            "o": "gw",
            "oid": "78:8a:20:33:44:55",
            "site_id": "5a32aa4ee4b0412345678910",
            "time": 1587859200000,
            "wan-rx_bytes": 76769209870.0,
            "wan-rx_dropped": 231.0,
            "wan-rx_packets": 56473855.0,
            "wan-tx_bytes": 5836684857.0,
            "wan-tx_packets": 23887040.0,
        }
    },
    "state": 1,
    "storage": [
        {
            "mount_point": "/persistent",
            "name": "Backup",
            "size": 2040373248,
            "type": "eMMC",
            "used": 148353024,
        },
        {
            "mount_point": "/tmp",
            "name": "Temporary",
            "size": 1073741824,
            "type": "other",
            "used": 90112,
        },
    ],
    "sys_stats": {
        "loadavg_1": "0.03",
        "loadavg_15": "0.08",
        "loadavg_5": "0.07",
        "mem_buffer": 57561088,
        "mem_total": 507412480,
        "mem_used": 293453824,
    },
    "syslog_key": "3456789098098769876543",
    "system-stats": {"cpu": "0", "mem": "25", "uptime": "3971505"},
    "temperatures": [
        {"name": "CPU", "type": "cpu", "value": 66.0},
        {"name": "Local", "type": "board", "value": 48.75},
        {"name": "PHY", "type": "board", "value": 50.25},
    ],
    "two_phase_adopt": False,
    "tx_bytes": 1107294012155,
    "type": "ugw",
    "unsupported": False,
    "unsupported_reason": 0,
    "upgradable": True,
    "upgrade_state": 0,
    "upgrade_to_firmware": "4.4.50.5272448",
    "uplink": {
        "bytes-r": 242330,
        "drops": 4,
        "enable": True,
        "full_duplex": True,
        "gateways": ["2.3.4.5"],
        "ip": "1.2.3.4",
        "latency": 1,
        "mac": "78:8a:20:33:44:55",
        "max_speed": 1000,
        "name": "eth0",
        "nameservers": ["127.0.0.1"],
        "netmask": "255.255.254.0",
        "num_port": 1,
        "rx_bytes": 1107294012155,
        "rx_bytes-r": 239494,
        "rx_dropped": 3929,
        "rx_errors": 0,
        "rx_multicast": 0,
        "rx_packets": 807555430,
        "speed": 1000,
        "speedtest_lastrun": 0,
        "speedtest_ping": 0,
        "speedtest_status": "Idle",
        "tx_bytes": 96813272238,
        "tx_bytes-r": 2836,
        "tx_dropped": 0,
        "tx_errors": 0,
        "tx_packets": 344559427,
        "type": "wire",
        "up": True,
        "uptime": 855760,
        "xput_down": 0.0,
        "xput_up": 0.0,
    },
    "uptime": 3971869,
    "uptime_stats": {
        "WAN": {
            "monitors": [
                {
                    "availability": 100.0,
                    "latency_average": 5,
                    "target": "www.microsoft.com",
                    "type": "icmp",
                },
                {
                    "availability": 100.0,
                    "latency_average": 7,
                    "target": "google.com",
                    "type": "icmp",
                },
                {
                    "availability": 100.0,
                    "latency_average": 5,
                    "target": "1.1.1.1",
                    "type": "icmp",
                },
            ]
        },
        "WAN2": {
            "monitors": [
                {
                    "availability": 0.0,
                    "target": "www.microsoft.com",
                    "type": "icmp",
                },
                {"availability": 0.0, "target": "google.com", "type": "icmp"},
                {"availability": 0.0, "target": "1.1.1.1", "type": "icmp"},
            ]
        },
    },
    "user-num_sta": 20,
    "usg_caps": 786431,
    "version": "4.4.44.5213844",
    "wan1": {
        "bytes-r": 242330,
        "dns": ["127.0.0.1"],
        "enable": True,
        "full_duplex": True,
        "gateway": "2.3.4.5",
        "ifname": "eth0",
        "ip": "1.2.3.4",
        "mac": "78:8a:20:33:44:55",
        "max_speed": 1000,
        "name": "wan",
        "netmask": "255.255.254.0",
        "rx_bytes": 1107294012155,
        "rx_bytes-r": 239494,
        "rx_dropped": 3929,
        "rx_errors": 0,
        "rx_multicast": 0,
        "rx_packets": 807555430,
        "speed": 1000,
        "tx_bytes": 96813272238,
        "tx_bytes-r": 2836,
        "tx_dropped": 0,
        "tx_errors": 0,
        "tx_packets": 344559427,
        "type": "wire",
        "up": True,
    },
    "x_aes_gcm": True,
    "x_authkey": "345678976545678",
    "x_has_ssh_hostkey": True,
    "x_inform_authkey": "34567657878987654323456",
    "x_ssh_hostkey_fingerprint": "3456787654567898765",
}

SWITCH_16_PORT_POE = {
    "_id": "5b8457a9e4b01dd29e9f1578",
    "_uptime": 3971865,
    "adoptable_when_upgraded": False,
    "adopted": True,
    "architecture": "armv7l",
    "board_rev": 9,
    "bytes": 3859971623,
    "cfgversion": "6381f86fdd573e1e",
    "config_network": {"ip": "192.168.0.57", "type": "dhcp"},
    "connect_request_ip": "192.168.0.57",
    "connect_request_port": "58628",
    "considered_lost_at": 1588175821,
    "device_id": "235678987654345678",
    "dhcp_server_table": [],
    "dot1x_portctrl_enabled": False,
    "downlink_table": [],
    "ethernet_table": [
        {"mac": "fc:ec:da:11:22:33", "name": "eth0", "num_port": 18},
        {"mac": "fc:ec:da:11:22:34", "name": "srv0"},
    ],
    "fan_level": 0,
    "flowctrl_enabled": False,
    "fw_caps": 21683749,
    "gateway_mac": "192.168.0.1",
    "general_temperature": 56,
    "guest-num_sta": 0,
    "has_fan": True,
    "has_temperature": True,
    "hash_id": "1234567623454",
    "hw_caps": 0,
    "inform_ip": "192.168.0.5",
    "inform_url": "http://192.168.0.7:8080/inform",
    "internet": True,
    "ip": "192.168.0.57",
    "jumboframe_enabled": False,
    "kernel_version": "3.6.5",
    "known_cfgversion": "23434545676787654",
    "last_seen": 1588175722,
    "last_uplink": {"uplink_mac": "f0:9f:11:22:33:44"},
    "led_override": "on",
    "license_state": "registered",
    "locating": False,
    "mac": "fc:ec:da:11:22:33",
    "manufacturer_id": 2,
    "model": "US16P150",
    "name": "Switch 16",
    "next_heartbeat_at": 1588175755,
    "next_interval": 23,
    "num_sta": 4,
    "outdoor_mode_override": "default",
    "overheating": False,
    "port_overrides": [
        {
            "poe_mode": "auto",
            "portconf_id": "5e1b309714bd614afd3d11a7",
            "port_security_mac_address": [],
            "autoneg": True,
            "stp_port_mode": True,
        },
        {
            "poe_mode": "off",
            "port_idx": 3,
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
        },
        {
            "poe_mode": "auto",
            "port_idx": 4,
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
        },
        {
            "poe_mode": "auto",
            "port_idx": 16,
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
        },
    ],
    "port_table": [
        {
            "aggregated_by": False,
            "autoneg": True,
            "bytes-r": 1042,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": True,
            "is_uplink": True,
            "jumbo": False,
            "lldp_table": [
                {
                    "lldp_chassis_id": "F0:9F:C2:1A:2B:3C:4E",
                    "lldp_port_id": "0/5",
                    "lldp_system_name": "Switch8",
                }
            ],
            "masked": False,
            "media": "GE",
            "name": "Port 1",
            "op_mode": "switch",
            "poe_caps": 7,
            "poe_class": "Unknown",
            "poe_current": "0.00",
            "poe_enable": False,
            "poe_good": False,
            "poe_mode": "auto",
            "poe_power": "0.00",
            "poe_voltage": "0.00",
            "port_idx": 1,
            "port_poe": True,
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "rx_broadcast": 2422847,
            "rx_bytes": 2027844548,
            "rx_bytes-r": 712,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 7707714,
            "rx_packets": 12170261,
            "satisfaction": 100,
            "speed": 1000,
            "speed_caps": 1048623,
            "stp_pathcost": 20000,
            "stp_state": "forwarding",
            "tx_broadcast": 119481,
            "tx_bytes": 1832127075,
            "tx_bytes-r": 330,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 277595,
            "tx_packets": 4364049,
            "up": True,
        },
        {
            "aggregated_by": False,
            "autoneg": True,
            "bytes-r": 0,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": False,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [],
            "masked": False,
            "media": "GE",
            "name": "Port 2",
            "op_mode": "switch",
            "poe_caps": 7,
            "poe_class": "Unknown",
            "poe_current": "0.00",
            "poe_enable": False,
            "poe_good": False,
            "poe_mode": "auto",
            "poe_power": "0.00",
            "poe_voltage": "0.00",
            "port_idx": 2,
            "port_poe": True,
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "rx_broadcast": 0,
            "rx_bytes": 0,
            "rx_bytes-r": 0,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 0,
            "satisfaction": 100,
            "speed": 0,
            "speed_caps": 1048623,
            "stp_pathcost": 0,
            "stp_state": "disabled",
            "tx_broadcast": 0,
            "tx_bytes": 0,
            "tx_bytes-r": 0,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 0,
            "tx_packets": 0,
            "up": False,
        },
        {
            "aggregated_by": False,
            "autoneg": True,
            "bytes-r": 670,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": True,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [],
            "masked": False,
            "media": "GE",
            "name": "Port 3",
            "op_mode": "switch",
            "poe_caps": 7,
            "poe_class": "Class 3",
            "poe_current": "60.18",
            "poe_enable": True,
            "poe_good": True,
            "poe_mode": "auto",
            "poe_power": "3.24",
            "poe_voltage": "53.78",
            "port_idx": 3,
            "port_poe": True,
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "rx_broadcast": 218,
            "rx_bytes": 478468,
            "rx_bytes-r": 0,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 29,
            "rx_packets": 6014,
            "satisfaction": 100,
            "speed": 1000,
            "speed_caps": 1048623,
            "stp_pathcost": 20000,
            "stp_state": "forwarding",
            "tx_broadcast": 2542042,
            "tx_bytes": 1911509746,
            "tx_bytes-r": 670,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 7854039,
            "tx_packets": 10408988,
            "up": True,
        },
        {
            "aggregated_by": False,
            "autoneg": True,
            "bytes-r": 722,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": True,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [],
            "masked": False,
            "media": "GE",
            "name": "Port 4",
            "op_mode": "switch",
            "poe_caps": 7,
            "poe_class": "Class 2",
            "poe_current": "27.83",
            "poe_enable": True,
            "poe_good": True,
            "poe_mode": "auto",
            "poe_power": "1.50",
            "poe_voltage": "53.85",
            "port_idx": 4,
            "port_poe": True,
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "rx_broadcast": 30730,
            "rx_bytes": 288074224,
            "rx_bytes-r": 45,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 182131,
            "rx_packets": 819789,
            "satisfaction": 100,
            "speed": 100,
            "speed_caps": 1048623,
            "stp_pathcost": 200000,
            "stp_state": "forwarding",
            "tx_broadcast": 2542135,
            "tx_bytes": 1895681324,
            "tx_bytes-r": 677,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 7805864,
            "tx_packets": 10458150,
            "up": True,
        },
        {
            "aggregated_by": False,
            "autoneg": True,
            "bytes-r": 0,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": False,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [],
            "masked": False,
            "media": "GE",
            "name": "Port 5",
            "op_mode": "switch",
            "poe_caps": 7,
            "poe_class": "Unknown",
            "poe_current": "0.00",
            "poe_enable": False,
            "poe_good": False,
            "poe_mode": "auto",
            "poe_power": "0.00",
            "poe_voltage": "0.00",
            "port_idx": 5,
            "port_poe": True,
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "rx_broadcast": 0,
            "rx_bytes": 0,
            "rx_bytes-r": 0,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 0,
            "satisfaction": 100,
            "speed": 0,
            "speed_caps": 1048623,
            "stp_pathcost": 0,
            "stp_state": "disabled",
            "tx_broadcast": 0,
            "tx_bytes": 0,
            "tx_bytes-r": 0,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 0,
            "tx_packets": 0,
            "up": False,
        },
        {
            "aggregated_by": False,
            "autoneg": True,
            "bytes-r": 0,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": False,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [],
            "masked": False,
            "media": "GE",
            "name": "Port 6",
            "op_mode": "switch",
            "poe_caps": 7,
            "poe_class": "Unknown",
            "poe_current": "0.00",
            "poe_enable": False,
            "poe_good": False,
            "poe_mode": "auto",
            "poe_power": "0.00",
            "poe_voltage": "0.00",
            "port_idx": 6,
            "port_poe": True,
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "rx_broadcast": 0,
            "rx_bytes": 0,
            "rx_bytes-r": 0,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 0,
            "satisfaction": 100,
            "speed": 0,
            "speed_caps": 1048623,
            "stp_pathcost": 0,
            "stp_state": "disabled",
            "tx_broadcast": 0,
            "tx_bytes": 0,
            "tx_bytes-r": 0,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 0,
            "tx_packets": 0,
            "up": False,
        },
        {
            "aggregated_by": False,
            "autoneg": True,
            "bytes-r": 0,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": False,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [],
            "masked": False,
            "media": "GE",
            "name": "Port 7",
            "op_mode": "switch",
            "poe_caps": 7,
            "poe_class": "Unknown",
            "poe_current": "0.00",
            "poe_enable": False,
            "poe_good": False,
            "poe_mode": "auto",
            "poe_power": "0.00",
            "poe_voltage": "0.00",
            "port_idx": 7,
            "port_poe": True,
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "rx_broadcast": 0,
            "rx_bytes": 0,
            "rx_bytes-r": 0,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 0,
            "satisfaction": 100,
            "speed": 0,
            "speed_caps": 1048623,
            "stp_pathcost": 0,
            "stp_state": "disabled",
            "tx_broadcast": 0,
            "tx_bytes": 0,
            "tx_bytes-r": 0,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 0,
            "tx_packets": 0,
            "up": False,
        },
        {
            "aggregated_by": False,
            "autoneg": True,
            "bytes-r": 719,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": True,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [],
            "masked": False,
            "media": "GE",
            "name": "Port 8",
            "op_mode": "switch",
            "poe_caps": 7,
            "poe_class": "Class 3",
            "poe_current": "68.96",
            "poe_enable": True,
            "poe_good": True,
            "poe_mode": "auto",
            "poe_power": "3.68",
            "poe_voltage": "53.40",
            "port_idx": 8,
            "port_poe": True,
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "rx_broadcast": 125,
            "rx_bytes": 542355491,
            "rx_bytes-r": 39,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 49261,
            "rx_packets": 1065798,
            "satisfaction": 100,
            "speed": 100,
            "speed_caps": 1048623,
            "stp_pathcost": 200000,
            "stp_state": "forwarding",
            "tx_broadcast": 2542145,
            "tx_bytes": 1923949844,
            "tx_bytes-r": 679,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 7804784,
            "tx_packets": 10760304,
            "up": True,
        },
        {
            "aggregated_by": False,
            "autoneg": True,
            "bytes-r": 0,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": False,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [],
            "masked": False,
            "media": "GE",
            "name": "Port 9",
            "op_mode": "switch",
            "poe_caps": 7,
            "poe_class": "Unknown",
            "poe_current": "0.00",
            "poe_enable": False,
            "poe_good": False,
            "poe_mode": "auto",
            "poe_power": "0.00",
            "poe_voltage": "0.00",
            "port_idx": 9,
            "port_poe": True,
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "rx_broadcast": 0,
            "rx_bytes": 0,
            "rx_bytes-r": 0,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 0,
            "satisfaction": 100,
            "speed": 0,
            "speed_caps": 1048623,
            "stp_pathcost": 0,
            "stp_state": "disabled",
            "tx_broadcast": 0,
            "tx_bytes": 0,
            "tx_bytes-r": 0,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 0,
            "tx_packets": 0,
            "up": False,
        },
        {
            "aggregated_by": False,
            "autoneg": True,
            "bytes-r": 0,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": False,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [],
            "masked": False,
            "media": "GE",
            "name": "Port 10",
            "op_mode": "switch",
            "poe_caps": 7,
            "poe_class": "Unknown",
            "poe_current": "0.00",
            "poe_enable": False,
            "poe_good": False,
            "poe_mode": "auto",
            "poe_power": "0.00",
            "poe_voltage": "0.00",
            "port_idx": 10,
            "port_poe": True,
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "rx_broadcast": 0,
            "rx_bytes": 0,
            "rx_bytes-r": 0,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 0,
            "satisfaction": 100,
            "speed": 0,
            "speed_caps": 1048623,
            "stp_pathcost": 0,
            "stp_state": "disabled",
            "tx_broadcast": 0,
            "tx_bytes": 0,
            "tx_bytes-r": 0,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 0,
            "tx_packets": 0,
            "up": False,
        },
        {
            "aggregated_by": False,
            "autoneg": True,
            "bytes-r": 0,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": False,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [],
            "masked": False,
            "media": "GE",
            "name": "Port 11",
            "op_mode": "switch",
            "poe_caps": 7,
            "poe_class": "Unknown",
            "poe_current": "0.00",
            "poe_enable": False,
            "poe_good": False,
            "poe_mode": "auto",
            "poe_power": "0.00",
            "poe_voltage": "0.00",
            "port_idx": 11,
            "port_poe": True,
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "rx_broadcast": 0,
            "rx_bytes": 0,
            "rx_bytes-r": 0,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 0,
            "satisfaction": 100,
            "speed": 0,
            "speed_caps": 1048623,
            "stp_pathcost": 0,
            "stp_state": "disabled",
            "tx_broadcast": 0,
            "tx_bytes": 0,
            "tx_bytes-r": 0,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 0,
            "tx_packets": 0,
            "up": False,
        },
        {
            "aggregated_by": False,
            "autoneg": True,
            "bytes-r": 0,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": False,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [],
            "masked": False,
            "media": "GE",
            "name": "Port 12",
            "op_mode": "switch",
            "poe_caps": 7,
            "poe_class": "Unknown",
            "poe_current": "0.00",
            "poe_enable": False,
            "poe_good": False,
            "poe_mode": "auto",
            "poe_power": "0.00",
            "poe_voltage": "0.00",
            "port_idx": 12,
            "port_poe": True,
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "rx_broadcast": 0,
            "rx_bytes": 0,
            "rx_bytes-r": 0,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 0,
            "satisfaction": 100,
            "speed": 0,
            "speed_caps": 1048623,
            "stp_pathcost": 0,
            "stp_state": "disabled",
            "tx_broadcast": 0,
            "tx_bytes": 0,
            "tx_bytes-r": 0,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 0,
            "tx_packets": 0,
            "up": False,
        },
        {
            "aggregated_by": False,
            "autoneg": True,
            "bytes-r": 0,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": False,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [],
            "masked": False,
            "media": "GE",
            "name": "Port 13",
            "op_mode": "switch",
            "poe_caps": 7,
            "poe_class": "Unknown",
            "poe_current": "0.00",
            "poe_enable": False,
            "poe_good": False,
            "poe_mode": "auto",
            "poe_power": "0.00",
            "poe_voltage": "0.00",
            "port_idx": 13,
            "port_poe": True,
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "rx_broadcast": 0,
            "rx_bytes": 0,
            "rx_bytes-r": 0,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 0,
            "satisfaction": 100,
            "speed": 0,
            "speed_caps": 1048623,
            "stp_pathcost": 0,
            "stp_state": "disabled",
            "tx_broadcast": 0,
            "tx_bytes": 0,
            "tx_bytes-r": 0,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 0,
            "tx_packets": 0,
            "up": False,
        },
        {
            "aggregated_by": False,
            "autoneg": True,
            "bytes-r": 0,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": False,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [],
            "masked": False,
            "media": "GE",
            "name": "Port 14",
            "op_mode": "switch",
            "poe_caps": 7,
            "poe_class": "Unknown",
            "poe_current": "0.00",
            "poe_enable": False,
            "poe_good": False,
            "poe_mode": "auto",
            "poe_power": "0.00",
            "poe_voltage": "0.00",
            "port_idx": 14,
            "port_poe": True,
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "rx_broadcast": 0,
            "rx_bytes": 0,
            "rx_bytes-r": 0,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 0,
            "satisfaction": 100,
            "speed": 0,
            "speed_caps": 1048623,
            "stp_pathcost": 0,
            "stp_state": "disabled",
            "tx_broadcast": 0,
            "tx_bytes": 0,
            "tx_bytes-r": 0,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 0,
            "tx_packets": 0,
            "up": False,
        },
        {
            "aggregated_by": False,
            "autoneg": True,
            "bytes-r": 0,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": False,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [],
            "masked": False,
            "media": "GE",
            "name": "Port 15",
            "op_mode": "switch",
            "poe_caps": 7,
            "poe_class": "Unknown",
            "poe_current": "0.00",
            "poe_enable": False,
            "poe_good": False,
            "poe_mode": "auto",
            "poe_power": "0.00",
            "poe_voltage": "0.00",
            "port_idx": 15,
            "port_poe": True,
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "rx_broadcast": 0,
            "rx_bytes": 0,
            "rx_bytes-r": 0,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 0,
            "satisfaction": 100,
            "speed": 0,
            "speed_caps": 1048623,
            "stp_pathcost": 0,
            "stp_state": "disabled",
            "tx_broadcast": 0,
            "tx_bytes": 0,
            "tx_bytes-r": 0,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 0,
            "tx_packets": 0,
            "up": False,
        },
        {
            "aggregated_by": False,
            "autoneg": True,
            "bytes-r": 719,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": True,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [],
            "masked": False,
            "media": "GE",
            "name": "Port 16",
            "op_mode": "switch",
            "poe_caps": 7,
            "poe_class": "Class 4",
            "poe_current": "47.24",
            "poe_enable": True,
            "poe_good": True,
            "poe_mode": "auto",
            "poe_power": "2.52",
            "poe_voltage": "53.40",
            "port_idx": 16,
            "port_poe": True,
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "rx_broadcast": 118,
            "rx_bytes": 266497885,
            "rx_bytes-r": 39,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 49191,
            "rx_packets": 668010,
            "satisfaction": 100,
            "speed": 100,
            "speed_caps": 1048623,
            "stp_pathcost": 200000,
            "stp_state": "forwarding",
            "tx_broadcast": 2542151,
            "tx_bytes": 1895646361,
            "tx_bytes-r": 680,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 7804854,
            "tx_packets": 10458934,
            "up": True,
        },
        {
            "aggregated_by": False,
            "autoneg": True,
            "bytes-r": 0,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": False,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [],
            "masked": False,
            "media": "SFP",
            "name": "SFP 1",
            "op_mode": "switch",
            "poe_caps": 0,
            "port_idx": 17,
            "port_poe": False,
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "rx_broadcast": 0,
            "rx_bytes": 0,
            "rx_bytes-r": 0,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 0,
            "satisfaction": 100,
            "sfp_found": False,
            "speed": 0,
            "speed_caps": 1048608,
            "stp_pathcost": 0,
            "stp_state": "disabled",
            "tx_broadcast": 0,
            "tx_bytes": 0,
            "tx_bytes-r": 0,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 0,
            "tx_packets": 0,
            "up": False,
        },
        {
            "aggregated_by": False,
            "autoneg": True,
            "bytes-r": 0,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": False,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [],
            "masked": False,
            "media": "SFP",
            "name": "SFP 2",
            "op_mode": "switch",
            "poe_caps": 0,
            "port_idx": 18,
            "port_poe": False,
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "rx_broadcast": 0,
            "rx_bytes": 0,
            "rx_bytes-r": 0,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 0,
            "satisfaction": 100,
            "sfp_found": False,
            "speed": 0,
            "speed_caps": 1048608,
            "stp_pathcost": 0,
            "stp_state": "disabled",
            "tx_broadcast": 0,
            "tx_bytes": 0,
            "tx_bytes-r": 0,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 0,
            "tx_packets": 0,
            "up": False,
        },
    ],
    "prev_non_busy_state": 1,
    "required_version": "3.3.13",
    "rx_bytes": 1832127075,
    "satisfaction": 100,
    "serial": "FCECDA112233",
    "site_id": "5a32aa4ee4b0412345678910",
    "ssh_session_table": [],
    "start_connected_millis": 1587859259119,
    "start_disconnected_millis": 1587859249152,
    "stat": {
        "sw": {
            "bytes": 996934123.0,
            "datetime": "2020-04-26T00:00:00Z",
            "duration": 316434000.0,
            "o": "sw",
            "oid": "fc:ec:da:11:22:33",
            "port_1-rx_broadcast": 182515.0,
            "port_1-rx_bytes": 163842984.0,
            "port_1-rx_multicast": 639543.0,
            "port_1-rx_packets": 975984.0,
            "port_1-tx_broadcast": 9483.0,
            "port_1-tx_bytes": 136854988.0,
            "port_1-tx_multicast": 22235.0,
            "port_1-tx_packets": 356769.0,
            "port_16-rx_broadcast": 8.0,
            "port_16-rx_bytes": 24630367.0,
            "port_16-rx_multicast": 3936.0,
            "port_16-rx_packets": 60944.0,
            "port_16-tx_broadcast": 191990.0,
            "port_16-tx_bytes": 154033825.0,
            "port_16-tx_multicast": 647405.0,
            "port_16-tx_packets": 849103.0,
            "port_3-rx_broadcast": 14.0,
            "port_3-rx_bytes": 37970.0,
            "port_3-rx_packets": 485.0,
            "port_3-tx_broadcast": 191984.0,
            "port_3-tx_bytes": 155259350.0,
            "port_3-tx_multicast": 651340.0,
            "port_3-tx_packets": 844480.0,
            "port_4-rx_broadcast": 9.0,
            "port_4-rx_bytes": 26511461.0,
            "port_4-rx_multicast": 14479.0,
            "port_4-rx_packets": 71331.0,
            "port_4-tx_broadcast": 191989.0,
            "port_4-tx_bytes": 154000741.0,
            "port_4-tx_multicast": 647406.0,
            "port_4-tx_packets": 848948.0,
            "port_8-rx_broadcast": 8.0,
            "port_8-rx_bytes": 26279012.0,
            "port_8-rx_multicast": 3933.0,
            "port_8-rx_packets": 77466.0,
            "port_8-tx_broadcast": 191990.0,
            "port_8-tx_bytes": 155483425.0,
            "port_8-tx_multicast": 647408.0,
            "port_8-tx_packets": 862103.0,
            "rx_broadcast": 182554.0,
            "rx_bytes": 241301794.0,
            "rx_crypts": 0.0,
            "rx_dropped": 0.0,
            "rx_errors": 0.0,
            "rx_frags": 0.0,
            "rx_multicast": 661891.0,
            "rx_packets": 1186210.0,
            "site_id": "5a32aa4ee4b0412345678910",
            "sw": "fc:ec:da:11:22:33",
            "time": 1587859200000,
            "tx_broadcast": 777436.0,
            "tx_bytes": 755632329.0,
            "tx_dropped": 0.0,
            "tx_errors": 0.0,
            "tx_multicast": 2615794.0,
            "tx_packets": 3761403.0,
            "tx_retries": 0.0,
        }
    },
    "state": 1,
    "stp_priority": "32768",
    "stp_version": "rstp",
    "switch_caps": {
        "feature_caps": 1022,
        "max_aggregate_sessions": 6,
        "max_mirror_sessions": 1,
    },
    "sys_error_caps": 0,
    "sys_stats": {
        "loadavg_1": "2.82",
        "loadavg_15": "2.81",
        "loadavg_5": "2.80",
        "mem_buffer": 0,
        "mem_total": 262402048,
        "mem_used": 129331200,
    },
    "syslog_key": "3456789098098769876543",
    "system-stats": {"cpu": "100.0", "mem": "49.3", "uptime": "3971865"},
    "total_max_power": 135,
    "two_phase_adopt": False,
    "tx_bytes": 2027844548,
    "type": "usw",
    "unsupported": False,
    "unsupported_reason": 0,
    "upgradable": True,
    "upgrade_state": 0,
    "upgrade_to_firmware": "4.0.80.10875",
    "uplink": {
        "full_duplex": True,
        "ip": "192.168.0.57",
        "mac": "fc:ec:da:11:22:33",
        "max_speed": 1000,
        "media": "GE",
        "name": "eth0",
        "netmask": "255.255.255.0",
        "num_port": 18,
        "port_idx": 1,
        "rx_bytes": 2027844548,
        "rx_bytes-r": 712,
        "rx_dropped": 0,
        "rx_errors": 0,
        "rx_multicast": 0,
        "rx_packets": 12170261,
        "speed": 1000,
        "tx_bytes": 1832127075,
        "tx_bytes-r": 330,
        "tx_dropped": 0,
        "tx_errors": 0,
        "tx_packets": 4364049,
        "type": "wire",
        "up": True,
        "uplink_mac": "f0:9f:11:22:33:44",
        "uplink_remote_port": 5,
    },
    "uplink_depth": 2,
    "uptime": 3971865,
    "user-num_sta": 4,
    "version": "4.0.66.10832",
    "x_aes_gcm": True,
    "x_authkey": "345678976545678",
    "x_fingerprint": "1345678765345643567543",
    "x_has_ssh_hostkey": True,
    "x_inform_authkey": "34567657878987654323456",
    "x_ssh_hostkey_fingerprint": "3456787654567898765",
}

SWITCH_8_PORT = {
    "_id": "5a7cc21ae4b068sbddb234565324134",
    "port_table": [
        {
            "port_idx": 1,
            "media": "GE",
            "port_poe": False,
            "poe_caps": 0,
            "speed_caps": 1048623,
            "op_mode": "switch",
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "autoneg": True,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": False,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [],
            "rx_broadcast": 0,
            "rx_bytes": 0,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 0,
            "satisfaction": 100,
            "speed": 0,
            "stp_pathcost": 0,
            "stp_state": "disabled",
            "tx_broadcast": 0,
            "tx_bytes": 0,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 0,
            "tx_packets": 0,
            "up": False,
            "tx_bytes-r": 0,
            "rx_bytes-r": 0,
            "bytes-r": 0,
            "name": "Port 1",
            "masked": False,
            "aggregated_by": False,
        },
        {
            "port_idx": 2,
            "media": "GE",
            "port_poe": False,
            "poe_caps": 0,
            "speed_caps": 1048623,
            "op_mode": "switch",
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "autoneg": True,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": True,
            "is_uplink": True,
            "jumbo": False,
            "lldp_table": [
                {
                    "lldp_chassis_id": "78:8A:20:44:33:22:11",
                    "lldp_port_id": "eth1",
                    "lldp_system_name": "USG",
                }
            ],
            "rx_broadcast": 44064,
            "rx_bytes": 1109019728759,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 138783,
            "rx_packets": 808013990,
            "satisfaction": 100,
            "speed": 1000,
            "stp_pathcost": 20000,
            "stp_state": "forwarding",
            "tx_broadcast": 2498252,
            "tx_bytes": 100334873692,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 7847706,
            "tx_packets": 356816368,
            "up": True,
            "tx_bytes-r": 3480,
            "rx_bytes-r": 240953,
            "bytes-r": 244434,
            "name": "Port 2",
            "masked": False,
            "aggregated_by": False,
        },
        {
            "port_idx": 3,
            "media": "GE",
            "port_poe": False,
            "poe_caps": 0,
            "speed_caps": 1048623,
            "op_mode": "switch",
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "autoneg": True,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": False,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [],
            "rx_broadcast": 0,
            "rx_bytes": 0,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 0,
            "satisfaction": 100,
            "speed": 0,
            "stp_pathcost": 0,
            "stp_state": "disabled",
            "tx_broadcast": 0,
            "tx_bytes": 0,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 0,
            "tx_packets": 0,
            "up": False,
            "tx_bytes-r": 0,
            "rx_bytes-r": 0,
            "bytes-r": 0,
            "name": "Port 3",
            "masked": False,
            "aggregated_by": False,
        },
        {
            "port_idx": 4,
            "media": "GE",
            "port_poe": False,
            "poe_caps": 0,
            "speed_caps": 1048623,
            "op_mode": "switch",
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "autoneg": True,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": True,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [],
            "rx_broadcast": 17,
            "rx_bytes": 9242748,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 136169,
            "satisfaction": 100,
            "speed": 100,
            "stp_pathcost": 200000,
            "stp_state": "forwarding",
            "tx_broadcast": 2542342,
            "tx_bytes": 1919704579,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 7854446,
            "tx_packets": 10540945,
            "up": True,
            "tx_bytes-r": 383,
            "rx_bytes-r": 5,
            "bytes-r": 388,
            "name": "Port 4",
            "masked": False,
            "aggregated_by": False,
        },
        {
            "port_idx": 5,
            "media": "GE",
            "port_poe": False,
            "poe_caps": 0,
            "speed_caps": 1048623,
            "op_mode": "switch",
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "autoneg": True,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": True,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [
                {
                    "lldp_chassis_id": "FC:EC:DA:33:22:44",
                    "lldp_port_id": "0/1",
                    "lldp_system_name": "Switch16",
                }
            ],
            "rx_broadcast": 129026,
            "rx_bytes": 435751727043,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 411610,
            "rx_packets": 457317083,
            "satisfaction": 100,
            "speed": 1000,
            "stp_pathcost": 20000,
            "stp_state": "forwarding",
            "tx_broadcast": 2413331,
            "tx_bytes": 429589071593,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 7573771,
            "tx_packets": 370316574,
            "up": True,
            "tx_bytes-r": 914,
            "rx_bytes-r": 867,
            "bytes-r": 1781,
            "poe_mode": "auto",
            "name": "Port 5",
            "masked": False,
            "aggregated_by": False,
        },
        {
            "port_idx": 6,
            "media": "GE",
            "port_poe": False,
            "poe_caps": 0,
            "speed_caps": 1048623,
            "op_mode": "switch",
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "autoneg": True,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": True,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [
                {
                    "lldp_chassis_id": "80:2A:A8:55:44:33",
                    "lldp_port_id": "80:2A:A8:55:44:33",
                    "lldp_system_name": "UAPACPRO",
                }
            ],
            "rx_broadcast": 218412,
            "rx_bytes": 53516789416,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 2935589,
            "rx_packets": 333052376,
            "satisfaction": 90,
            "speed": 1000,
            "stp_pathcost": 20000,
            "stp_state": "forwarding",
            "tx_broadcast": 2323945,
            "tx_bytes": 2275838496776,
            "tx_dropped": 2665,
            "tx_errors": 0,
            "tx_multicast": 5051186,
            "tx_packets": 1574259392,
            "up": True,
            "tx_bytes-r": 240232,
            "rx_bytes-r": 4113,
            "bytes-r": 244345,
            "name": "Port 6",
            "masked": False,
            "aggregated_by": False,
        },
        {
            "port_idx": 7,
            "media": "GE",
            "port_poe": False,
            "poe_caps": 0,
            "speed_caps": 1048623,
            "op_mode": "switch",
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "autoneg": True,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": True,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [],
            "rx_broadcast": 2031756,
            "rx_bytes": 1602876591571,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 2646968,
            "rx_packets": 1117936736,
            "satisfaction": 100,
            "speed": 1000,
            "stp_pathcost": 20000,
            "stp_state": "forwarding",
            "tx_broadcast": 510499,
            "tx_bytes": 400026198993,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 5207435,
            "tx_packets": 440118452,
            "up": True,
            "tx_bytes-r": 2895,
            "rx_bytes-r": 613,
            "bytes-r": 3508,
            "name": "Port 7",
            "masked": False,
            "aggregated_by": False,
        },
        {
            "port_idx": 8,
            "media": "GE",
            "port_poe": True,
            "poe_caps": 8,
            "speed_caps": 1048623,
            "op_mode": "switch",
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "poe_mode": "off",
            "autoneg": True,
            "dot1x_mode": "unknown",
            "dot1x_status": "disabled",
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": False,
            "is_uplink": False,
            "jumbo": False,
            "lldp_table": [],
            "poe_enable": False,
            "poe_voltage": "48.00",
            "rx_broadcast": 0,
            "rx_bytes": 0,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 0,
            "satisfaction": 100,
            "speed": 0,
            "stp_pathcost": 0,
            "stp_state": "disabled",
            "tx_broadcast": 0,
            "tx_bytes": 0,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 0,
            "tx_packets": 0,
            "up": False,
            "tx_bytes-r": 0,
            "rx_bytes-r": 0,
            "bytes-r": 0,
            "name": "Port 8",
            "masked": False,
            "aggregated_by": False,
        },
    ],
    "stp_priority": "32768",
    "license_state": "registered",
    "port_overrides": [
        {
            "port_idx": 5,
            "portconf_id": "5a32aa4ee4babd4452422ddd22222",
            "poe_mode": "auto",
        }
    ],
    "type": "usw",
    "inform_ip": "192.168.0.5",
    "cfgversion": "123131b3x1d2x454xx",
    "board_rev": 10,
    "mac": "f0:9f:11:22:33:44",
    "inform_url": "http://192.168.0.7:8080/inform",
    "ethernet_table": [
        {"mac": "f0:9f:11:22:33:44", "num_port": 8, "name": "eth0"},
        {"mac": "f0:9f:11:22:33:4a", "name": "srv0"},
    ],
    "config_network": {"type": "dhcp", "ip": "192.168.0.8"},
    "flowctrl_enabled": False,
    "dot1x_portctrl_enabled": False,
    "led_override": "on",
    "model": "US8",
    "outdoor_mode_override": "default",
    "has_fan": False,
    "ip": "192.168.0.8",
    "x_authkey": "345678976545678",
    "jumboframe_enabled": False,
    "x_ssh_hostkey_fingerprint": "3456787654567898765",
    "version": "4.0.66.10832",
    "has_temperature": False,
    "switch_caps": {
        "feature_caps": 1022,
        "max_mirror_sessions": 1,
        "max_aggregate_sessions": 4,
    },
    "stp_version": "rstp",
    "serial": "F09F11223344",
    "site_id": "5a32aa4ee4b0412345678910",
    "name": "Switch 8",
    "fw_caps": 21683749,
    "adopted": True,
    "unsupported": False,
    "unsupported_reason": 0,
    "x_aes_gcm": True,
    "two_phase_adopt": False,
    "required_version": "3.7.16",
    "hw_caps": 0,
    "sys_error_caps": 0,
    "satisfaction": 98,
    "syslog_key": "3456789098098769876543",
    "kernel_version": "3.6.5",
    "architecture": "armv7l",
    "hash_id": "32432423f4323s",
    "gateway_mac": "192.168.0.1",
    "manufacturer_id": 4,
    "internet": True,
    "device_id": "235678987654345678",
    "state": 1,
    "start_disconnected_millis": 1587859249151,
    "upgrade_state": 0,
    "x_inform_authkey": "34567657878987654323456",
    "last_seen": 1588175735,
    "upgradable": True,
    "adoptable_when_upgraded": False,
    "upgrade_to_firmware": "4.0.80.10875",
    "known_cfgversion": "23434545676787654",
    "uptime": 3971894,
    "_uptime": 3971894,
    "locating": False,
    "start_connected_millis": 1587859250668,
    "prev_non_busy_state": 1,
    "connect_request_ip": "192.168.0.8",
    "connect_request_port": "49349",
    "sys_stats": {
        "loadavg_1": "1.12",
        "loadavg_15": "1.45",
        "loadavg_5": "1.31",
        "mem_buffer": 0,
        "mem_total": 262402048,
        "mem_used": 128737280,
    },
    "system-stats": {"cpu": "56.3", "mem": "49.1", "uptime": "3971894"},
    "ssh_session_table": [],
    "overheating": False,
    "power_source": "262144",
    "power_source_voltage": "48.00",
    "total_max_power": 0,
    "downlink_table": [
        {
            "port_idx": 5,
            "speed": 1000,
            "full_duplex": True,
            "mac": "fc:ec:da:11:22:33",
        },
        {
            "port_idx": 6,
            "speed": 1000,
            "full_duplex": True,
            "mac": "80:2a:a8:00:01:02",
        },
    ],
    "uplink": {
        "full_duplex": True,
        "ip": "192.168.0.8",
        "mac": "f0:9f:11:22:33:44",
        "name": "eth0",
        "netmask": "255.255.255.0",
        "num_port": 8,
        "rx_bytes": 1109019728759,
        "rx_dropped": 0,
        "rx_errors": 0,
        "rx_multicast": 0,
        "rx_packets": 808013990,
        "speed": 1000,
        "tx_bytes": 100334873692,
        "tx_dropped": 0,
        "tx_errors": 0,
        "tx_packets": 356816368,
        "up": True,
        "port_idx": 2,
        "media": "GE",
        "max_speed": 1000,
        "uplink_mac": "78:8a:20:33:44:55",
        "type": "wire",
        "tx_bytes-r": 3480,
        "rx_bytes-r": 240953,
    },
    "last_uplink": {"uplink_mac": "78:8a:20:33:44:55"},
    "uplink_depth": 1,
    "dhcp_server_table": [],
    "next_interval": 23,
    "next_heartbeat_at": 1588175768,
    "considered_lost_at": 1588175834,
    "stat": {
        "sw": {
            "site_id": "5a32aa4ee4b0412345678910",
            "o": "sw",
            "oid": "f0:9f:11:22:33:44",
            "sw": "f0:9f:11:22:33:44",
            "time": 1587859200000,
            "datetime": "2020-04-26T00:00:00Z",
            "rx_packets": 216932291.0,
            "rx_bytes": 260804385433.0,
            "rx_errors": 0.0,
            "rx_dropped": 0.0,
            "rx_crypts": 0.0,
            "rx_frags": 0.0,
            "tx_packets": 219814204.0,
            "tx_bytes": 261334371357.0,
            "tx_errors": 0.0,
            "tx_dropped": 202.0,
            "tx_retries": 0.0,
            "rx_multicast": 514345.0,
            "rx_broadcast": 182526.0,
            "tx_multicast": 2774756.0,
            "tx_broadcast": 777579.0,
            "bytes": 522138756790.0,
            "duration": 316469000.0,
            "port_2-rx_packets": 56426757.0,
            "port_2-rx_bytes": 76911368375.0,
            "port_2-tx_packets": 24859744.0,
            "port_2-tx_bytes": 6099269315.0,
            "port_2-rx_multicast": 11056.0,
            "port_2-tx_multicast": 650992.0,
            "port_2-tx_broadcast": 188293.0,
            "port_4-rx_packets": 18703.0,
            "port_4-rx_bytes": 1255789.0,
            "port_4-tx_packets": 862886.0,
            "port_4-tx_bytes": 156439725.0,
            "port_4-tx_multicast": 651520.0,
            "port_4-tx_broadcast": 192021.0,
            "port_5-rx_packets": 14642662.0,
            "port_5-rx_bytes": 1916386586.0,
            "port_5-tx_packets": 27718236.0,
            "port_5-tx_bytes": 36477482238.0,
            "port_5-rx_multicast": 33021.0,
            "port_5-rx_broadcast": 10231.0,
            "port_5-tx_multicast": 628931.0,
            "port_5-tx_broadcast": 181790.0,
            "port_6-rx_packets": 26449642.0,
            "port_6-rx_bytes": 3988926804.0,
            "port_6-tx_packets": 148081715.0,
            "port_6-tx_bytes": 216628215977.0,
            "port_6-rx_multicast": 258385.0,
            "port_6-tx_multicast": 403675.0,
            "port_6-tx_broadcast": 172072.0,
            "port_7-rx_packets": 119394527.0,
            "port_7-rx_bytes": 177986447879.0,
            "port_7-tx_packets": 18291623.0,
            "port_7-tx_bytes": 1972964102.0,
            "port_7-rx_multicast": 211883.0,
            "port_7-rx_broadcast": 148618.0,
            "port_7-tx_multicast": 439638.0,
            "port_7-tx_broadcast": 43403.0,
            "port_6-rx_broadcast": 19949.0,
            "port_2-rx_broadcast": 3728.0,
            "port_6-tx_dropped": 202.0,
        }
    },
    "tx_bytes": 1109019728759,
    "rx_bytes": 100334873692,
    "bytes": 1209354602451,
    "num_sta": 4,
    "user-num_sta": 4,
    "guest-num_sta": 0,
    "x_has_ssh_hostkey": True,
}

SWITCH_FLEX_MINI_5_PORT = {
    "_id": "5f47a419c753120123456789",
    "_uptime": 9273422,
    "adopt_ip": "198.168.0.9",
    "adopt_url": "http://192.168.0.1:8080/inform",
    "adoptable_when_upgraded": False,
    "adopted": True,
    "anomalies": -1,
    "anon_id": "dbf040c6-0000-aaaa-bbbb-012345678910a",
    "board_rev": 12,
    "bytes": 0,
    "cfgversion": "96376fe9d11ae1ac",
    "config_network": {"ip": "198.168.0.9", "type": "dhcp"},
    "connect_request_ip": "198.168.0.9",
    "connect_request_port": "60216",
    "connected_at": 1634732311,
    "connection_network_name": "LAN",
    "default": False,
    "device_id": "5f47a419c753120123456789",
    "dhcp_server_table": [],
    "discovered_via": "l2",
    "displayable_version": "1.8.4",
    "dot1x_portctrl_enabled": False,
    "downlink_table": [],
    "ethernet_table": [{"mac": "74:ac:b9:a1:01:01", "name": "eth0", "num_port": 5}],
    "flowctrl_enabled": False,
    "fw_caps": 0,
    "guest-num_sta": 0,
    "has_fan": False,
    "has_temperature": False,
    "hw_caps": 0,
    "inform_ip": "192.168.0.1",
    "inform_url": "http://192.168.0.1:8080/inform",
    "ip": "198.168.0.9",
    "jumboframe_enabled": False,
    "known_cfgversion": "96376fe9d11ae1ac",
    "last_seen": 1635577067,
    "last_uplink": {
        "port_idx": 1,
        "type": "wire",
        "uplink_mac": "fc:ec:00:11:22:33",
        "uplink_remote_port": 13,
    },
    "lcm_brightness_override": False,
    "lcm_idle_timeout_override": False,
    "lcm_tracker_enabled": False,
    "led_override": "on",
    "led_override_color": "#0000ff",
    "led_override_color_brightness": 100,
    "license_state": "registered",
    "lldp_table": [
        {
            "chassis_id": "fc:ec:00:11:22:33",
            "is_wired": True,
            "local_port_idx": 1,
            "local_port_name": "eth0",
            "port_id": "Port ",
        }
    ],
    "locating": False,
    "mac": "74:ac:b9:a1:01:01",
    "manufacturer_id": 2,
    "model": "USMINI",
    "model_in_eol": False,
    "model_in_lts": False,
    "model_incompatible": False,
    "name": "UniFi Switch Flex Mini",
    "next_interval": 34,
    "num_sta": 0,
    "outdoor_mode_override": "default",
    "overheating": False,
    "port_table": [
        {
            "aggregated_by": False,
            "autoneg": True,
            "bytes-r": 577,
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": True,
            "is_uplink": True,
            "jumbo": False,
            "masked": False,
            "media": "GE",
            "name": "Port 1",
            "op_mode": "switch",
            "port_idx": 1,
            "port_poe": False,
            "portconf_id": "5f3edd2aba4cc806a19f2db2",
            "rx_broadcast": 6679204,
            "rx_bytes": 6147696151,
            "rx_bytes-r": 452,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 20240009,
            "rx_packets": 30183544,
            "speed": 1000,
            "speed_caps": 1048623,
            "tx_broadcast": 3397,
            "tx_bytes": 1243754733,
            "tx_bytes-r": 124,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 310278,
            "tx_packets": 3836158,
            "up": True,
        },
        {
            "aggregated_by": False,
            "autoneg": True,
            "bytes-r": 0,
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": False,
            "is_uplink": False,
            "jumbo": False,
            "masked": False,
            "media": "GE",
            "name": "Port 2",
            "op_mode": "switch",
            "port_idx": 2,
            "port_poe": False,
            "portconf_id": "5f3edd2aba4cc806a19f2db2",
            "rx_broadcast": 0,
            "rx_bytes": 0,
            "rx_bytes-r": 0,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 0,
            "speed": 0,
            "speed_caps": 1048623,
            "tx_broadcast": 0,
            "tx_bytes": 0,
            "tx_bytes-r": 0,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 0,
            "tx_packets": 0,
            "up": False,
        },
        {
            "aggregated_by": False,
            "autoneg": True,
            "bytes-r": 0,
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": False,
            "is_uplink": False,
            "jumbo": False,
            "masked": False,
            "media": "GE",
            "name": "Port 3",
            "op_mode": "switch",
            "port_idx": 3,
            "port_poe": False,
            "portconf_id": "5f3edd2aba4cc806a19f2db2",
            "rx_broadcast": 0,
            "rx_bytes": 0,
            "rx_bytes-r": 0,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 0,
            "speed": 0,
            "speed_caps": 1048623,
            "tx_broadcast": 0,
            "tx_bytes": 0,
            "tx_bytes-r": 0,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 0,
            "tx_packets": 0,
            "up": False,
        },
        {
            "aggregated_by": False,
            "autoneg": True,
            "bytes-r": 0,
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": False,
            "is_uplink": False,
            "jumbo": False,
            "masked": False,
            "media": "GE",
            "name": "Port 4",
            "op_mode": "switch",
            "port_idx": 4,
            "port_poe": False,
            "portconf_id": "5f3edd2aba4cc806a19f2db2",
            "rx_broadcast": 0,
            "rx_bytes": 0,
            "rx_bytes-r": 0,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 0,
            "speed": 0,
            "speed_caps": 1048623,
            "tx_broadcast": 0,
            "tx_bytes": 0,
            "tx_bytes-r": 0,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 0,
            "tx_packets": 0,
            "up": False,
        },
        {
            "aggregated_by": False,
            "autoneg": True,
            "bytes-r": 0,
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": False,
            "is_uplink": False,
            "jumbo": False,
            "masked": False,
            "media": "GE",
            "name": "Port 5",
            "op_mode": "switch",
            "port_idx": 5,
            "port_poe": False,
            "portconf_id": "5f3edd2aba4cc806a19f2db2",
            "rx_broadcast": 0,
            "rx_bytes": 0,
            "rx_bytes-r": 0,
            "rx_dropped": 0,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 0,
            "speed": 0,
            "speed_caps": 1048623,
            "tx_broadcast": 0,
            "tx_bytes": 0,
            "tx_bytes-r": 0,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 0,
            "tx_packets": 0,
            "up": False,
        },
    ],
    "power_source_ctrl_enabled": False,
    "provisioned_at": 1610008100,
    "required_version": "1.7.3",
    "rollupgrade": False,
    "rx_bytes": 0,
    "satisfaction": -1,
    "serial": "74ACB9A10101",
    "site_id": "5a32aa4ee4b0412345678910",
    "start_connected_millis": 1634732311256,
    "start_disconnected_millis": 1634732296240,
    "startup_timestamp": 1626303645,
    "stat": {
        "sw": {
            "bytes": 648398923.0,
            "datetime": "2021-10-20T12:15:00Z",
            "duration": 844723000.0,
            "o": "sw",
            "oid": "74:ac:b9:a1:01:01",
            "port_1-rx_broadcast": 565601.0,
            "port_1-rx_bytes": 535337644.0,
            "port_1-rx_multicast": 1790802.0,
            "port_1-rx_packets": 2652630.0,
            "port_1-tx_broadcast": 335.0,
            "port_1-tx_bytes": 113061279.0,
            "port_1-tx_multicast": 28157.0,
            "port_1-tx_packets": 348590.0,
            "rx_broadcast": 565601.0,
            "rx_bytes": 535337644.0,
            "rx_crypts": 0.0,
            "rx_dropped": 0.0,
            "rx_errors": 0.0,
            "rx_frags": 0.0,
            "rx_multicast": 1790802.0,
            "rx_packets": 2652630.0,
            "site_id": "5a32aa4ee4b0412345678910",
            "sw": "74:ac:b9:a1:01:01",
            "time": 1634732100000,
            "tx_broadcast": 335.0,
            "tx_bytes": 113061279.0,
            "tx_dropped": 0.0,
            "tx_errors": 0.0,
            "tx_multicast": 28157.0,
            "tx_packets": 348590.0,
            "tx_retries": 0.0,
        }
    },
    "state": 1,
    "stp_priority": "32768",
    "stp_version": "rstp",
    "switch_caps": {
        "feature_caps": 44,
        "max_aggregate_sessions": 0,
        "max_mirror_sessions": 1,
        "vlan_caps": 2,
    },
    "sys_error_caps": 0,
    "sys_stats": {"mem_total": 163840, "mem_used": 131940},
    "syslog_key": "3456789098098769876543",
    "system-stats": {},
    "two_phase_adopt": False,
    "tx_bytes": 0,
    "type": "usw",
    "unsupported": False,
    "unsupported_reason": 0,
    "upgradable": False,
    "uplink": {
        "full_duplex": True,
        "ip": "198.168.0.9",
        "mac": "74:ac:b9:a1:01:01",
        "max_speed": 1000,
        "media": "GE",
        "name": "eth0",
        "netmask": "255.255.255.0",
        "num_port": 5,
        "port_idx": 1,
        "rx_bytes": 0,
        "rx_bytes-r": 0,
        "rx_dropped": 0,
        "rx_errors": 0,
        "rx_packets": 0,
        "speed": 1000,
        "tx_bytes": 0,
        "tx_bytes-r": 0,
        "tx_dropped": 0,
        "tx_errors": 0,
        "tx_packets": 0,
        "type": "wire",
        "up": True,
        "uplink_mac": "fc:ec:00:11:22:33",
        "uplink_remote_port": 13,
    },
    "uplink_depth": 2,
    "uptime": 9273422,
    "user-num_sta": 0,
    "version": "1.8.4.674",
    "x_aes_gcm": True,
    "x_authkey": "345678976545678",
    "x_has_ssh_hostkey": False,
}

PLUG_UP1 = {
    "_id": "600c8356942a6ade50707b56",
    "ip": "192.168.0.189",
    "mac": "fc:ec:da:76:4f:5f",
    "model": "UP1",
    "model_in_lts": False,
    "model_in_eol": False,
    "type": "uap",
    "version": "2.2.1.511",
    "adopted": True,
    "site_id": "545eb1f0e4b0205d14c4e548",
    "x_authkey": "345678976545678",
    "cfgversion": "4c62f1e663783447",
    "syslog_key": "41c4bcefcbc842d6eefb05b8fd9b78faa1841d10a09cebb170ce3e2f474b43b3",
    "config_network": {"type": "dhcp"},
    "setup_id": "a8730d36-8fdd-44f9-8678-1e89676f36c1",
    "x_vwirekey": "2dabb7e23b048c88b60123456789",
    "vwire_table": [],
    "dot1x_portctrl_enabled": False,
    "outlet_overrides": [],
    "outlet_enabled": True,
    "license_state": "registered",
    "x_aes_gcm": True,
    "inform_url": "http://192.168.0.5:8080/inform",
    "inform_ip": "192.168.0.5",
    "required_version": "2.1.3",
    "anon_id": "d2744a31-1c26-92fe-423d-6b9ba204abc7",
    "board_rev": 2,
    "manufacturer_id": 72,
    "model_incompatible": False,
    "antenna_table": [],
    "radio_table": [],
    "scan_radio_table": [],
    "ethernet_table": [],
    "port_table": [],
    "switch_caps": {},
    "has_speaker": False,
    "has_eth1": False,
    "fw_caps": 0,
    "hw_caps": 2562,
    "wifi_caps": 0,
    "sys_error_caps": 0,
    "has_fan": False,
    "has_temperature": False,
    "country_code": 10752,
    "outlet_table": [
        {
            "index": 1,
            "has_relay": True,
            "has_metering": False,
            "relay_state": False,
            "name": "Outlet 1",
        }
    ],
    "element_ap_serial": "44:d9:e7:90:f4:24",
    "connected_at": 1641678609,
    "provisioned_at": 1642054077,
    "led_override": "on",
    "led_override_color": "#0000ff",
    "led_override_color_brightness": 100,
    "outdoor_mode_override": "default",
    "lcm_brightness_override": False,
    "lcm_idle_timeout_override": False,
    "name": "Plug",
    "unsupported": False,
    "unsupported_reason": 0,
    "two_phase_adopt": False,
    "serial": "FCECDA764F5F",
    "lcm_tracker_enabled": False,
    "wlangroup_id_ng": "545eb1f0e4b0205d14c4e555",
    "supports_fingerprint_ml": False,
    "last_uplink": {
        "uplink_mac": "78:45:58:87:93:16",
        "uplink_device_name": "U6-Pro",
        "type": "wireless",
    },
    "device_id": "600c8356942a6ade50707b56",
    "uplink": {
        "uplink_mac": "78:45:58:87:93:16",
        "uplink_device_name": "U6-Pro",
        "type": "wireless",
        "up": True,
        "ap_mac": "78:45:58:87:93:16",
        "tx_rate": 54000,
        "rx_rate": 72200,
        "rssi": 60,
        "is_11ax": False,
        "is_11ac": False,
        "is_11n": True,
        "is_11b": False,
        "radio": "ng",
        "essid": "Network Name",
        "channel": 11,
        "tx_packets": 1586746,
        "rx_packets": 362176,
        "tx_bytes": 397773,
        "rx_bytes": 24423980,
        "tx_bytes-r": 0,
        "rx_bytes-r": 45,
        "uplink_source": "legacy",
    },
    "state": 1,
    "start_disconnected_millis": 1641679166349,
    "last_seen": 1642055273,
    "next_interval": 40,
    "known_cfgversion": "4c62f1e663783447",
    "start_connected_millis": 1641679166355,
    "upgradable": False,
    "adoptable_when_upgraded": False,
    "rollupgrade": False,
    "uptime": 376083,
    "_uptime": 376083,
    "locating": False,
    "connect_request_ip": "192.168.0.189",
    "connect_request_port": "49155",
    "sys_stats": {"mem_total": 98304, "mem_used": 87736},
    "system-stats": {},
    "lldp_table": [],
    "displayable_version": "2.2.1",
    "connection_network_name": "LAN",
    "startup_timestamp": 1641679190,
    "scanning": False,
    "spectrum_scanning": False,
    "meshv3_peer_mac": "",
    "element_peer_mac": "",
    "satisfaction": 100,
    "uplink_bssid": "78:45:58:87:93:17",
    "hide_ch_width": "none",
    "isolated": False,
    "radio_table_stats": [],
    "port_stats": [],
    "vap_table": [],
    "downlink_table": [],
    "vwire_vap_table": [],
    "bytes-d": 0,
    "tx_bytes-d": 0,
    "rx_bytes-d": 0,
    "bytes-r": 0,
    "element_uplink_ap_mac": "78:45:58:87:93:16",
    "prev_non_busy_state": 1,
    "stat": {
        "ap": {
            "site_id": "5a32aa4ee4b0412345678910",
            "o": "ap",
            "oid": "fc:ec:da:76:4f:5f",
            "ap": "fc:ec:da:76:4f:5f",
            "time": 1641678600000,
            "datetime": "2022-01-08T21:50:00Z",
            "user-rx_packets": 0.0,
            "guest-rx_packets": 0.0,
            "rx_packets": 0.0,
            "user-rx_bytes": 0.0,
            "guest-rx_bytes": 0.0,
            "rx_bytes": 0.0,
            "user-rx_errors": 0.0,
            "guest-rx_errors": 0.0,
            "rx_errors": 0.0,
            "user-rx_dropped": 0.0,
            "guest-rx_dropped": 0.0,
            "rx_dropped": 0.0,
            "user-rx_crypts": 0.0,
            "guest-rx_crypts": 0.0,
            "rx_crypts": 0.0,
            "user-rx_frags": 0.0,
            "guest-rx_frags": 0.0,
            "rx_frags": 0.0,
            "user-tx_packets": 0.0,
            "guest-tx_packets": 0.0,
            "tx_packets": 0.0,
            "user-tx_bytes": 0.0,
            "guest-tx_bytes": 0.0,
            "tx_bytes": 0.0,
            "user-tx_errors": 0.0,
            "guest-tx_errors": 0.0,
            "tx_errors": 0.0,
            "user-tx_dropped": 0.0,
            "guest-tx_dropped": 0.0,
            "tx_dropped": 0.0,
            "user-tx_retries": 0.0,
            "guest-tx_retries": 0.0,
            "tx_retries": 0.0,
            "user-mac_filter_rejections": 0.0,
            "guest-mac_filter_rejections": 0.0,
            "mac_filter_rejections": 0.0,
            "user-wifi_tx_attempts": 0.0,
            "guest-wifi_tx_attempts": 0.0,
            "wifi_tx_attempts": 0.0,
            "user-wifi_tx_dropped": 0.0,
            "guest-wifi_tx_dropped": 0.0,
            "wifi_tx_dropped": 0.0,
            "bytes": 0.0,
            "duration": 376663000.0,
        }
    },
    "tx_bytes": 0,
    "rx_bytes": 0,
    "bytes": 0,
    "vwireEnabled": True,
    "uplink_table": [],
    "num_sta": 0,
    "user-num_sta": 0,
    "user-wlan-num_sta": 0,
    "guest-num_sta": 0,
    "guest-wlan-num_sta": 0,
    "x_has_ssh_hostkey": False,
}

STRIP_UP6 = {
    "_id": "61eb1a75942a6a859b45d2bc",
    "ip": "192.168.0.138",
    "mac": "78:45:58:fc:16:7d",
    "model": "UP6",
    "model_in_lts": False,
    "model_in_eol": False,
    "type": "uap",
    "version": "2.2.1.511",
    "adopted": True,
    "site_id": "545eb1f0e4b0205d14c4e548",
    "x_authkey": "345678976545678345678976545678",
    "cfgversion": "eb5b492ed3d18e55",
    "syslog_key": "5cb5af74e36fb2a68e973d5ca5d3893afea1f974808eb35da27506da6ef8d9d1",
    "config_network": {"type": "dhcp"},
    "setup_id": "8d43a13f-5277-47da-9a05-1aabddac8bfa",
    "x_vwirekey": "2dabb7e23b048c88b60123456789234",
    "vwire_table": [],
    "dot1x_portctrl_enabled": False,
    "outlet_overrides": [
        {"index": 1, "name": "Outlet 1", "cycle_enabled": False, "relay_state": False},
        {"index": 2, "name": "Outlet 2", "cycle_enabled": False, "relay_state": False},
        {"index": 3, "name": "Outlet 3", "cycle_enabled": False, "relay_state": True},
        {"index": 4, "name": "Outlet 4", "cycle_enabled": True, "relay_state": True},
        {"index": 5, "name": "Outlet 5", "cycle_enabled": False, "relay_state": False},
        {"index": 6, "name": "Outlet 6", "cycle_enabled": False, "relay_state": False},
        {
            "index": 7,
            "name": "USB Outlets",
            "cycle_enabled": False,
            "relay_state": False,
        },
    ],
    "outlet_enabled": True,
    "license_state": "registered",
    "x_aes_gcm": True,
    "inform_url": "http://192.168.0.5:8080/inform",
    "inform_ip": "192.168.0.5",
    "required_version": "2.1.3",
    "board_rev": 5,
    "manufacturer_id": 4,
    "model_incompatible": False,
    "antenna_table": [],
    "radio_table": [],
    "scan_radio_table": [],
    "ethernet_table": [],
    "port_table": [],
    "switch_caps": {},
    "has_speaker": False,
    "has_eth1": False,
    "fw_caps": 0,
    "hw_caps": 128,
    "wifi_caps": 0,
    "sys_error_caps": 0,
    "has_fan": False,
    "has_temperature": False,
    "country_code": 10752,
    "outlet_table": [
        {
            "index": 1,
            "has_relay": True,
            "has_metering": False,
            "relay_state": False,
            "cycle_enabled": False,
            "name": "Outlet 1",
        },
        {
            "index": 2,
            "has_relay": True,
            "has_metering": False,
            "relay_state": False,
            "cycle_enabled": False,
            "name": "Outlet 2",
        },
        {
            "index": 3,
            "has_relay": True,
            "has_metering": False,
            "relay_state": True,
            "cycle_enabled": False,
            "name": "Outlet 3",
        },
        {
            "index": 4,
            "has_relay": True,
            "has_metering": False,
            "relay_state": True,
            "cycle_enabled": True,
            "name": "Outlet 4",
        },
        {
            "index": 5,
            "has_relay": True,
            "has_metering": False,
            "relay_state": False,
            "cycle_enabled": False,
            "name": "Outlet 5",
        },
        {
            "index": 6,
            "has_relay": True,
            "has_metering": False,
            "relay_state": False,
            "cycle_enabled": False,
            "name": "Outlet 6",
        },
        {
            "index": 7,
            "has_relay": True,
            "has_metering": False,
            "relay_state": False,
            "cycle_enabled": False,
            "name": "USB Outlets",
        },
    ],
    "element_ap_serial": "24:5a:4c:6b:f7:b3",
    "supports_fingerprint_ml": False,
    "connected_at": 1642797721,
    "provisioned_at": 1642800149,
    "last_uplink": {
        "uplink_mac": "78:45:58:87:93:16",
        "uplink_device_name": "U6-Pro",
        "type": "wireless",
    },
    "device_id": "61eb1a75942a6a859b45d2bc",
    "uplink": {
        "uplink_mac": "78:45:58:87:93:16",
        "uplink_device_name": "U6-Pro",
        "type": "wireless",
        "up": True,
        "ap_mac": "78:45:58:87:93:16",
        "tx_rate": 54000,
        "rx_rate": 72200,
        "rssi": 81,
        "is_11ax": False,
        "is_11ac": False,
        "is_11n": True,
        "is_11b": False,
        "radio": "ng",
        "essid": "Network Name",
        "channel": 11,
        "tx_packets": 10696,
        "rx_packets": 4800,
        "tx_bytes": 5085,
        "rx_bytes": 357084,
        "tx_bytes-r": 1,
        "rx_bytes-r": 75,
        "uplink_source": "legacy",
    },
    "state": 1,
    "start_disconnected_millis": 1642797908442,
    "unsupported": False,
    "unsupported_reason": 0,
    "two_phase_adopt": False,
    "serial": "784558fc167d",
    "anon_id": "6fd68fe8-98d5-26e5-3c0e-a62a8606d927",
    "last_seen": 1642800247,
    "next_interval": 41,
    "known_cfgversion": "eb5b492ed3d18e55",
    "start_connected_millis": 1642797908463,
    "upgradable": False,
    "adoptable_when_upgraded": False,
    "rollupgrade": False,
    "uptime": 2370,
    "_uptime": 2370,
    "locating": False,
    "connect_request_ip": "192.168.0.138",
    "connect_request_port": "49155",
    "sys_stats": {"mem_total": 98304, "mem_used": 88056},
    "system-stats": {},
    "lldp_table": [],
    "displayable_version": "2.2.1",
    "connection_network_name": "LAN",
    "startup_timestamp": 1642797877,
    "scanning": False,
    "spectrum_scanning": False,
    "meshv3_peer_mac": "",
    "element_peer_mac": "",
    "satisfaction": 100,
    "uplink_bssid": "78:45:58:87:93:28",
    "hide_ch_width": "none",
    "isolated": False,
    "radio_table_stats": [],
    "port_stats": [],
    "vap_table": [],
    "downlink_table": [],
    "vwire_vap_table": [],
    "bytes-d": 0,
    "tx_bytes-d": 0,
    "rx_bytes-d": 0,
    "bytes-r": 0,
    "element_uplink_ap_mac": "78:45:58:87:93:27",
    "prev_non_busy_state": 1,
    "stat": {
        "ap": {
            "site_id": "545eb1f0e4b0205d14c4e548",
            "o": "ap",
            "oid": "78:45:58:fc:16:7d",
            "ap": "78:45:58:fc:16:7d",
            "time": 1642797600000,
            "datetime": "2022-01-21T20:40:00Z",
            "user-rx_packets": 0.0,
            "guest-rx_packets": 0.0,
            "rx_packets": 0.0,
            "user-rx_bytes": 0.0,
            "guest-rx_bytes": 0.0,
            "rx_bytes": 0.0,
            "user-rx_errors": 0.0,
            "guest-rx_errors": 0.0,
            "rx_errors": 0.0,
            "user-rx_dropped": 0.0,
            "guest-rx_dropped": 0.0,
            "rx_dropped": 0.0,
            "user-rx_crypts": 0.0,
            "guest-rx_crypts": 0.0,
            "rx_crypts": 0.0,
            "user-rx_frags": 0.0,
            "guest-rx_frags": 0.0,
            "rx_frags": 0.0,
            "user-tx_packets": 0.0,
            "guest-tx_packets": 0.0,
            "tx_packets": 0.0,
            "user-tx_bytes": 0.0,
            "guest-tx_bytes": 0.0,
            "tx_bytes": 0.0,
            "user-tx_errors": 0.0,
            "guest-tx_errors": 0.0,
            "tx_errors": 0.0,
            "user-tx_dropped": 0.0,
            "guest-tx_dropped": 0.0,
            "tx_dropped": 0.0,
            "user-tx_retries": 0.0,
            "guest-tx_retries": 0.0,
            "tx_retries": 0.0,
            "user-mac_filter_rejections": 0.0,
            "guest-mac_filter_rejections": 0.0,
            "mac_filter_rejections": 0.0,
            "user-wifi_tx_attempts": 0.0,
            "guest-wifi_tx_attempts": 0.0,
            "wifi_tx_attempts": 0.0,
            "user-wifi_tx_dropped": 0.0,
            "guest-wifi_tx_dropped": 0.0,
            "wifi_tx_dropped": 0.0,
            "bytes": 0.0,
            "duration": 2525000.0,
        }
    },
    "tx_bytes": 0,
    "rx_bytes": 0,
    "bytes": 0,
    "vwireEnabled": True,
    "uplink_table": [],
    "num_sta": 0,
    "user-num_sta": 0,
    "user-wlan-num_sta": 0,
    "guest-num_sta": 0,
    "guest-wlan-num_sta": 0,
    "x_has_ssh_hostkey": False,
}

PDU_PRO = {
    "_id": "61e4a1e60bbb2d53aeb430ea",
    "_uptime": 1347471,
    "adoptable_when_upgraded": False,
    "adopted": True,
    "anomalies": -1,
    "anon_id": "**REDACTED**",
    "architecture": "mips",
    "board_rev": 1,
    "bytes": 738792,
    "cfgversion": "66d4fb7eda710676",
    "config_network": {"type": "dhcp", "ip": "192.168.1.66"},
    "connect_request_ip": "192.168.1.66",
    "connect_request_port": "36934",
    "connected_at": 1643657816,
    "connection_network_name": "Default LAN",
    "device_id": "61e4a1e60bbb2d53aeb430ea",
    "dhcp_server_table": [],
    "disconnection_reason": (
        "MISSED_INFORM, last_seen '1643657061', "
        "considered_lost '1643657117', state: 1"
    ),
    "displayable_version": "5.76.7",
    "dot1x_portctrl_enabled": False,
    "downlink_table": [],
    "ethernet_table": [{"mac": "00:00:00:00:00:84", "num_port": 1, "name": "eth0"}],
    "flowctrl_enabled": False,
    "fw_caps": 1732968229,
    "gateway_mac": "**REDACTED**",
    "guest-num_sta": 0,
    "has_fan": False,
    "has_temperature": False,
    "hash_id": "26efd73319270782",
    "hw_caps": 136,
    "inform_ip": "192.168.1.1",
    "inform_url": "http://192.168.1.1:8080/inform",
    "internet": True,
    "ip": "192.168.1.66",
    "jumboframe_enabled": False,
    "kernel_version": "4.14.115",
    "known_cfgversion": "66d4fb7eda710676",
    "last_seen": 1643721168,
    "last_uplink": {
        "uplink_mac": "00:00:00:00:00:83",
        "uplink_device_name": "Server Cabinet Switch",
        "uplink_remote_port": 1,
        "port_idx": 1,
        "type": "wire",
    },
    "lcm_brightness": 80,
    "lcm_night_mode_begins": "22:00",
    "lcm_night_mode_enabled": True,
    "lcm_night_mode_ends": "08:00",
    "license_state": "registered",
    "lldp_table": [
        {
            "chassis_id": "00:00:00:00:00:83",
            "chassis_id_subtype": "mac",
            "is_wired": True,
            "local_port_idx": 1,
            "local_port_name": "eth0",
            "port_id": "local Port 1",
        }
    ],
    "locating": False,
    "mac": "00:00:00:00:00:84",
    "manufacturer_id": 4,
    "min_inform_interval_seconds": 10,
    "model": "USPPDUP",
    "model_in_eol": False,
    "model_in_lts": False,
    "model_incompatible": False,
    "name": "Main Server Cabinet PDU",
    "next_interval": 56,
    "num_sta": 0,
    "outlet_ac_power_budget": "1875.000",
    "outlet_ac_power_consumption": "307.741",
    "outlet_enabled": True,
    "outlet_overrides": [
        {
            "index": 1,
            "name": "USB Outlet 1",
            "cycle_enabled": False,
            "relay_state": False,
        },
        {
            "index": 2,
            "name": "USB Outlet 2",
            "cycle_enabled": False,
            "relay_state": False,
        },
        {
            "index": 3,
            "name": "USB Outlet 3",
            "cycle_enabled": False,
            "relay_state": False,
        },
        {
            "index": 4,
            "name": "USB Outlet 4",
            "cycle_enabled": False,
            "relay_state": False,
        },
        {"index": 5, "name": "Console", "relay_state": True},
        {"index": 6, "name": "UDM Pro", "relay_state": True},
        {"index": 7, "name": "Unraid", "relay_state": True},
        {"index": 8, "relay_state": True},
        {"index": 9, "relay_state": True},
        {"index": 10, "relay_state": True},
        {"index": 11, "relay_state": True},
        {"index": 12, "relay_state": True},
        {"index": 13, "relay_state": True},
        {"index": 14, "relay_state": True},
        {"index": 15, "relay_state": True},
        {"index": 16, "name": "UNVR Pro", "relay_state": True},
        {"index": 17, "relay_state": True},
        {"index": 18, "name": "Home Assistant", "relay_state": True},
        {"index": 19, "name": "Server Cabinet Switch", "relay_state": True},
        {"index": 20, "name": "Rear Cabinet Lights", "relay_state": True},
    ],
    "outlet_table": [
        {
            "index": 1,
            "relay_state": True,
            "cycle_enabled": False,
            "name": "USB Outlet 1",
            "outlet_caps": 1,
        },
        {
            "index": 2,
            "relay_state": False,
            "cycle_enabled": False,
            "name": "USB Outlet 2",
            "outlet_caps": 1,
        },
        {
            "index": 3,
            "relay_state": True,
            "cycle_enabled": False,
            "name": "USB Outlet 3",
            "outlet_caps": 1,
        },
        {
            "index": 4,
            "relay_state": False,
            "cycle_enabled": False,
            "name": "USB Outlet 4",
            "outlet_caps": 1,
        },
        {
            "index": 5,
            "relay_state": True,
            "name": "Console",
            "outlet_caps": 3,
            "outlet_voltage": "118.566",
            "outlet_current": "0.061",
            "outlet_power": "3.815",
            "outlet_power_factor": "0.527",
        },
        {
            "index": 6,
            "relay_state": True,
            "name": "UDM Pro",
            "outlet_caps": 3,
            "outlet_voltage": "118.566",
            "outlet_current": "0.248",
            "outlet_power": "14.351",
            "outlet_power_factor": "0.488",
        },
        {
            "index": 7,
            "relay_state": True,
            "name": "Unraid",
            "outlet_caps": 3,
            "outlet_voltage": "118.566",
            "outlet_current": "1.454",
            "outlet_power": "169.900",
            "outlet_power_factor": "0.985",
        },
        {
            "index": 8,
            "relay_state": True,
            "outlet_caps": 3,
            "outlet_voltage": "118.566",
            "outlet_current": "0.000",
            "outlet_power": "0.000",
            "outlet_power_factor": "0.000",
            "name": "Outlet 8",
        },
        {
            "index": 9,
            "relay_state": True,
            "outlet_caps": 3,
            "outlet_voltage": "118.566",
            "outlet_current": "0.000",
            "outlet_power": "0.000",
            "outlet_power_factor": "0.000",
            "name": "Outlet 9",
        },
        {
            "index": 10,
            "relay_state": True,
            "outlet_caps": 3,
            "outlet_voltage": "118.566",
            "outlet_current": "0.000",
            "outlet_power": "0.000",
            "outlet_power_factor": "0.000",
            "name": "Outlet 10",
        },
        {
            "index": 11,
            "relay_state": False,
            "outlet_caps": 3,
            "outlet_voltage": "118.566",
            "outlet_current": "0.000",
            "outlet_power": "0.000",
            "outlet_power_factor": "0.000",
            "name": "Outlet 11",
        },
        {
            "index": 12,
            "relay_state": True,
            "outlet_caps": 3,
            "outlet_voltage": "118.566",
            "outlet_current": "0.000",
            "outlet_power": "0.000",
            "outlet_power_factor": "0.000",
            "name": "Outlet 12",
        },
        {
            "index": 13,
            "relay_state": True,
            "outlet_caps": 3,
            "outlet_voltage": "118.566",
            "outlet_current": "0.000",
            "outlet_power": "0.000",
            "outlet_power_factor": "0.000",
            "name": "Outlet 13",
        },
        {
            "index": 14,
            "relay_state": True,
            "outlet_caps": 3,
            "outlet_voltage": "118.566",
            "outlet_current": "0.000",
            "outlet_power": "0.000",
            "outlet_power_factor": "0.000",
            "name": "Outlet 14",
        },
        {
            "index": 15,
            "relay_state": True,
            "outlet_caps": 3,
            "outlet_voltage": "118.566",
            "outlet_current": "0.127",
            "outlet_power": "9.394",
            "outlet_power_factor": "0.623",
            "name": "Outlet 15",
        },
        {
            "index": 16,
            "relay_state": True,
            "name": "UNVR Pro",
            "outlet_caps": 3,
            "outlet_voltage": "118.566",
            "outlet_current": "0.278",
            "outlet_power": "31.992",
            "outlet_power_factor": "0.970",
        },
        {
            "index": 17,
            "relay_state": True,
            "outlet_caps": 3,
            "outlet_voltage": "118.566",
            "outlet_current": "0.000",
            "outlet_power": "0.000",
            "outlet_power_factor": "0.000",
            "name": "Outlet 17",
        },
        {
            "index": 18,
            "relay_state": True,
            "name": "Home Assistant",
            "outlet_caps": 3,
            "outlet_voltage": "118.566",
            "outlet_current": "0.328",
            "outlet_power": "21.529",
            "outlet_power_factor": "0.553",
        },
        {
            "index": 19,
            "relay_state": True,
            "name": "Server Cabinet Switch",
            "outlet_caps": 3,
            "outlet_voltage": "118.566",
            "outlet_current": "0.495",
            "outlet_power": "56.760",
            "outlet_power_factor": "0.967",
        },
        {
            "index": 20,
            "relay_state": True,
            "name": "Rear Cabinet Lights",
            "outlet_caps": 3,
            "outlet_voltage": "118.566",
            "outlet_current": "0.000",
            "outlet_power": "0.000",
            "outlet_power_factor": "0.000",
        },
    ],
    "overheating": False,
    "port_table": [
        {
            "port_idx": 1,
            "media": "FE",
            "port_poe": False,
            "poe_caps": 0,
            "speed_caps": 1048591,
            "op_mode": "switch",
            "portconf_id": "5fc7fb23c3da2e039ebeea97",
            "autoneg": False,
            "enable": True,
            "flowctrl_rx": False,
            "flowctrl_tx": False,
            "full_duplex": True,
            "is_uplink": True,
            "jumbo": False,
            "mac_table": [],
            "rx_broadcast": 0,
            "rx_bytes": 538000102,
            "rx_dropped": 2,
            "rx_errors": 0,
            "rx_multicast": 0,
            "rx_packets": 3943979,
            "satisfaction": 90,
            "satisfaction_reason": 1,
            "speed": 100,
            "stp_pathcost": 0,
            "stp_state": "disabled",
            "tx_broadcast": 0,
            "tx_bytes": 114523726,
            "tx_dropped": 0,
            "tx_errors": 0,
            "tx_multicast": 0,
            "tx_packets": 670312,
            "up": True,
            "tx_bytes-r": 82,
            "rx_bytes-r": 1510,
            "bytes-r": 1592,
            "name": "Port 1",
            "masked": False,
            "aggregated_by": False,
        }
    ],
    "power_source": "0",
    "power_source_ctrl_enabled": False,
    "prev_non_busy_state": 1,
    "provisioned_at": 1643657874,
    "required_version": "5.28.0",
    "rollupgrade": False,
    "rx_bytes": 369548,
    "satisfaction": 91,
    "serial": "**REDACTED**",
    "setup_id": "5039a051-1351-40e6-8b7e-247fa2e66299",
    "site_id": "5fc7fb1fc3da2e039ebeea82",
    "ssh_session_table": [],
    "start_connected_millis": 1643657816345,
    "start_disconnected_millis": 1643657181004,
    "startup_timestamp": 1642373704,
    "stat": {
        "sw": {
            "site_id": "5fc7fb1fc3da2e039ebeea82",
            "o": "sw",
            "oid": "00:00:00:00:00:84",
            "sw": "00:00:00:00:00:84",
            "time": 1643552100000,
            "datetime": "2022-01-30T14:15:00Z",
            "rx_packets": 542382.0,
            "rx_bytes": 73171815.0,
            "rx_errors": 0.0,
            "rx_dropped": 0.0,
            "rx_crypts": 0.0,
            "rx_frags": 0.0,
            "tx_packets": 85750.0,
            "tx_bytes": 14748197.0,
            "tx_errors": 0.0,
            "tx_dropped": 0.0,
            "tx_retries": 0.0,
            "rx_multicast": 0.0,
            "rx_broadcast": 0.0,
            "tx_multicast": 0.0,
            "tx_broadcast": 0.0,
            "bytes": 87920012.0,
            "duration": 168120000.0,
            "port_1-rx_packets": 542382.0,
            "port_1-rx_bytes": 73171815.0,
            "port_1-tx_packets": 85750.0,
            "port_1-tx_bytes": 14748197.0,
        }
    },
    "state": 1,
    "stp_priority": "32768",
    "stp_version": "rstp",
    "switch_caps": {
        "feature_caps": 0,
        "max_mirror_sessions": 0,
        "max_aggregate_sessions": 0,
        "max_l3_intf": 0,
        "max_reserved_routes": 0,
        "max_static_routes": 0,
    },
    "sys_error_caps": 0,
    "sys_stats": {
        "loadavg_1": "0.08",
        "loadavg_15": "0.01",
        "loadavg_5": "0.02",
        "mem_buffer": 0,
        "mem_total": 61792256,
        "mem_used": 18235392,
    },
    "syslog_key": "96e5f444529a9525a710cc7a3cc2975d6f7376c48f62ad08f32be932eb05c2e0",
    "system-stats": {"cpu": "1.1", "mem": "29.5", "uptime": "1347471"},
    "total_max_power": 0,
    "two_phase_adopt": False,
    "tx_bytes": 369244,
    "type": "usw",
    "unsupported": False,
    "unsupported_reason": 0,
    "upgradable": False,
    "uplink": {
        "uplink_mac": "00:00:00:00:00:83",
        "uplink_device_name": "Server Cabinet Switch",
        "uplink_remote_port": 1,
        "port_idx": 1,
        "type": "wire",
        "tx_bytes": 369548,
        "rx_bytes": 369244,
        "tx_packets": 4719,
        "rx_packets": 4715,
        "tx_bytes-r": 0,
        "rx_bytes-r": 0,
        "full_duplex": True,
        "ip": "192.168.1.66",
        "mac": "00:00:00:00:00:84",
        "max_vlan": 4009,
        "name": "eth0",
        "netmask": "255.255.255.0",
        "num_port": 1,
        "rx_dropped": 2,
        "rx_errors": 0,
        "rx_multicast": 0,
        "speed": 100,
        "tx_dropped": 0,
        "tx_errors": 0,
        "up": True,
        "media": "FE",
        "max_speed": 100,
        "uplink_source": "lldp",
    },
    "uplink_depth": 1,
    "uptime": 1347471,
    "user-num_sta": 0,
    "version": "5.76.7.13442",
    "x_aes_gcm": True,
    "x_authkey": "**REDACTED**",
    "x_has_ssh_hostkey": True,
    "x_ssh_hostkey_fingerprint": "**REDACTED**",
}

DPI_APPS = [
    {
        "_id": "5f976f62e3c58f018ec7e17d",
        "apps": [],
        "blocked": True,
        "cats": ["4"],
        "enabled": True,
        "log": True,
        "site_id": "5ba29dd4e3c58f026e9d7c38",
    },
]

DPI_GROUPS = [
    {
        "_id": "5ba29dd8e3c58f026e9d7c4a",
        "attr_no_delete": True,
        "attr_hidden_id": "Default",
        "name": "Default",
        "site_id": "5ba29dd4e3c58f026e9d7c38",
    },
    {
        "_id": "5f976f4ae3c58f018ec7dff6",
        "name": "No Media",
        "site_id": "5ba29dd4e3c58f026e9d7c38",
        "dpiapp_ids": ["5f976f62e3c58f018ec7e17d"],
    },
]

VOUCHERS = [
    {
        "_id": "657e370a4543a555901865c7",
        "admin_name": "Admin",
        "code": "7470075124",
        "create_time": 1638342818,
        "duration": 5184000,
        "end_time": 1949382832,
        "for_hotspot": False,
        "note": "auto-generated",
        "qos_overwrite": False,
        "quota": 0,
        "site_id": "5a32aa4ee4b0412345678910",
        "start_time": 1638342832,
        "status": "USED_MULTIPLE",
        "status_expires": 244679302,
        "used": 2,
    },
    {
        "_id": "61facea3873fdb075ce28d71",
        "admin_name": "Admin",
        "code": "4470344703",
        "create_time": 1643826851,
        "duration": 480,
        "for_hotspot": False,
        "note": None,
        "qos_overwrite": True,
        "qos_rate_max_down": 5000,
        "qos_rate_max_up": 2000,
        "qos_usage_quota": 1000,
        "quota": 1,
        "site_id": "5a32aa4ee4b0412345678910",
        "status": "VALID_ONE",
        "status_expires": 0,
        "used": 0,
    },
]

WLANS = [
    {
        "_id": "012345678910111213141516",
        "bc_filter_enabled": False,
        "bc_filter_list": [],
        "dtim_mode": "default",
        "dtim_na": 1,
        "dtim_ng": 1,
        "enabled": True,
        "group_rekey": 3600,
        "mac_filter_enabled": False,
        "mac_filter_list": [],
        "mac_filter_policy": "allow",
        "minrate_na_advertising_rates": False,
        "minrate_na_beacon_rate_kbps": 6000,
        "minrate_na_data_rate_kbps": 6000,
        "minrate_na_enabled": False,
        "minrate_na_mgmt_rate_kbps": 6000,
        "minrate_ng_advertising_rates": False,
        "minrate_ng_beacon_rate_kbps": 1000,
        "minrate_ng_data_rate_kbps": 1000,
        "minrate_ng_enabled": False,
        "minrate_ng_mgmt_rate_kbps": 1000,
        "name": "SSID 1",
        "no2ghz_oui": False,
        "schedule": [],
        "security": "wpapsk",
        "site_id": "5a32aa4ee4b0412345678910",
        "usergroup_id": "012345678910111213141518",
        "wep_idx": 1,
        "wlangroup_id": "012345678910111213141519",
        "wpa_enc": "ccmp",
        "wpa_mode": "wpa2",
        "x_iapp_key": "01234567891011121314151617181920",
        "x_passphrase": "password in clear text",
    },
    {
        "_id": "123456789101112161415160",
        "bc_filter_enabled": True,
        "bc_filter_list": [],
        "dtim_mode": "default",
        "dtim_na": 1,
        "dtim_ng": 1,
        "enabled": False,
        "group_rekey": 3600,
        "is_guest": True,
        "mac_filter_enabled": False,
        "mac_filter_list": [],
        "mac_filter_policy": "allow",
        "minrate_na_advertising_rates": False,
        "minrate_na_beacon_rate_kbps": 6000,
        "minrate_na_data_rate_kbps": 6000,
        "minrate_na_enabled": False,
        "minrate_na_mgmt_rate_kbps": 6000,
        "minrate_ng_advertising_rates": False,
        "minrate_ng_beacon_rate_kbps": 1000,
        "minrate_ng_cck_rates_enabled": True,
        "minrate_ng_data_rate_kbps": 1000,
        "minrate_ng_enabled": False,
        "minrate_ng_mgmt_rate_kbps": 1000,
        "name": "SSID 2",
        "schedule": [],
        "security": "wpapsk",
        "site_id": "5a32aa4ee4b0412345678910",
        "usergroup_id": "123456789101112161415162",
        "wep_idx": 1,
        "wlangroup_id": "123456789101112161415163",
        "wpa_enc": "ccmp",
        "wpa_mode": "wpa2",
        "x_iapp_key": "12345678910111216141516171819204",
        "x_passphrase": "password in clear text",
    },
]

WIRED_CLIENT = {
    "_id": "5a32b0c9e4b047ede36a85cd",
    "_is_guest_by_usw": False,
    "_is_guest_by_ugw": False,
    "_last_seen_by_ugw": 1642574376,
    "_last_seen_by_usw": 1642574376,
    "_uptime_by_ugw": 1527337,
    "_uptime_by_usw": 1527337,
    "anomalies": -1,
    "assoc_time": 1642487042,
    "authorized": True,
    "dev_cat": 7,
    "dev_family": 8147,
    "dev_id": 36970,
    "dev_id_override": 2149,
    "dev_vendor": 29813,
    "device_name": "Network Camera",
    "disconnect_timestamp": 1642487052,
    "eagerly_discovered": True,
    "fingerprint_engine_version": "",
    "fingerprint_override": True,
    "fingerprint_source": 2,
    "first_seen": 1598100273,
    "fw_version": "",
    "gw_mac": GATEWAY_USG3["mac"],
    "hostname": "camera-acccde123456",
    "hostname_source": "ubios",
    "ip": "192.168.0.2",
    "is_guest": False,
    "is_wired": True,
    "last_seen": 1642574376,
    "latest_assoc_time": 1642487042,
    "mac": "ac:cc:de:12:34:56",
    "name": "",
    "network": "LAN",
    "network_id": "5a32aa4ee4b047ede36a85a8",
    "noted": True,
    "oui": "Manu",
    "qos_policy_applied": True,
    "satisfaction": 100,
    "score": 63,
    "site_id": "5a32aa4ee4b0412345678910",
    "sw_depth": 0,
    "sw_mac": SWITCH_16_PORT_POE["mac"],
    "sw_port": 3,
    "tx_retries": 0,
    "uptime": 87334,
    "user_id": "5a32b0c9e4b047ede36a85cc",
    "usergroup_id": "",
    "wifi_tx_attempts": 0,
    "wired_rate_mbps": 1000,
    "wired-tx_bytes": 0,
    "wired-rx_bytes": 0,
    "wired-tx_packets": 0,
    "wired-rx_packets": 0,
    "wired-tx_bytes-r": 0,
    "wired-rx_bytes-r": 0,
}

WIRELESS_CLIENT = {
    "_id": "5a32b0c9e4b047ede36a85cc",
    "_is_guest_by_uap": False,
    "_is_guest_by_ugw": False,
    "_is_guest_by_usw": False,
    "_last_seen_by_uap": 1587765360,
    "_last_seen_by_ugw": 1587765372,
    "_last_seen_by_usw": 1587763868,
    "_uptime_by_uap": 11904,
    "_uptime_by_ugw": 18,
    "_uptime_by_usw": 318,
    "anomalies": 0,
    "ap_mac": ACCESS_POINT_AC_PRO["mac"],
    "assoc_time": 1587753456,
    "authorized": True,
    "blocked": False,
    "bssid": ACCESS_POINT_AC_PRO["mac"],
    "bytes-r": 809,
    "ccq": 333,
    "channel": 44,
    "dev_cat": 6,
    "dev_family": 3,
    "dev_id": 247,
    "dev_id_override": 4,
    "dev_vendor": 11,
    "device_name": "Discovery device name",
    "dhcpend_time": 2030,
    "essid": "SSID",
    "fingerprint_override": True,
    "first_seen": 1513271497,
    "fixed_ip": "192.168.0.1",
    "gw_mac": GATEWAY_USG3["mac"],
    "hostname": "client",
    "idletime": 1,
    "ip": "192.168.0.1",
    "is_11r": False,
    "is_guest": False,
    "is_wired": False,
    "last_seen": 1587765360,
    "latest_assoc_time": 1587765354,
    "mac": "00:00:00:00:00:01",
    "name": "Client 1",
    "network": "LAN",
    "network_id": "5a32aa4ee4b047ede36a85a8",
    "noise": -106,
    "noted": True,
    "os_class": 16,
    "os_name": 25,
    "oui": "Apple",
    "powersave_enabled": False,
    "qos_policy_applied": True,
    "radio": "na",
    "radio_name": "wifi1",
    "radio_proto": "ac",
    "rssi": 35,
    "rx_bytes": 12867114,
    "rx_bytes-r": 326,
    "rx_packets": 54198,
    "rx_rate": 400000,
    "satisfaction": 100,
    "signal": -61,
    "site_id": "5a32aa4ee4b0412345678910",
    "sw_depth": -1,
    "sw_mac": SWITCH_16_PORT_POE["mac"],
    "sw_port": 1,
    "tx_bytes": 52852089,
    "tx_bytes-r": 483,
    "tx_packets": 66615,
    "tx_power": 34,
    "tx_rate": 216000,
    "tx_retries": 9542,
    "uptime": 11904,
    "use_fixedip": False,
    "user_id": "5a32b0c9e4b047ede36a85cc",
    "usergroup_id": "",
    "vlan": 0,
    "wifi_tx_attempts": 56140,
}

MESSAGE_WIRELESS_CLIENT_REMOVED = {
    "meta": {"rc": "ok", "message": "user:delete"},
    "data": [
        {
            "_id": "5cdb099be4b01dd218123456",
            "first_seen": WIRELESS_CLIENT["first_seen"],
            "is_guest": WIRELESS_CLIENT["is_guest"],
            "is_wired": WIRELESS_CLIENT["is_wired"],
            "last_seen": WIRELESS_CLIENT["last_seen"] + 10,
            "mac": WIRELESS_CLIENT["mac"],
            "oui": WIRELESS_CLIENT["oui"],
            "site_id": WIRELESS_CLIENT["essid"],
        }
    ],
}

EVENT_WIRELESS_CLIENT_CONNECTED = {
    "meta": {"rc": "ok", "message": "events"},
    "data": [
        {
            "_id": "5ea331fa30c49e00f90ddc1a",
            "ap": WIRELESS_CLIENT["ap_mac"],
            "channel": WIRELESS_CLIENT["channel"],
            "datetime": "2020-04-24T18:37:36Z",
            "hostname": WIRELESS_CLIENT["hostname"],
            "key": "EVT_WU_Connected",
            "msg": (
                f'User[{WIRELESS_CLIENT["mac"]}] has connected '
                f'to AP[{WIRELESS_CLIENT["ap_mac"]}] with SSID '
                f'"{WIRELESS_CLIENT["essid"]}" on "channel '
                f'{WIRELESS_CLIENT["channel"]}({WIRELESS_CLIENT["radio"]})"'
            ),
            "radio": WIRELESS_CLIENT["radio"],
            "site_id": WIRELESS_CLIENT["site_id"],
            "ssid": WIRELESS_CLIENT["essid"],
            "subsystem": "wlan",
            "time": 1587753456179,
            "user": WIRELESS_CLIENT["mac"],
        }
    ],
}

EVENT_WIRELESS_CLIENT_DISCONNECTED = {
    "meta": {"rc": "ok", "message": "events"},
    "data": [
        {
            "_id": "5ea32ff730c49e00f90dca1a",
            "ap": WIRELESS_CLIENT["ap_mac"],
            "bytes": 459039,
            "datetime": "2020-04-24T18:28:47Z",
            "duration": 467,
            "hostname": WIRELESS_CLIENT["hostname"],
            "key": "EVT_WU_Disconnected",
            "msg": (
                f'User[{WIRELESS_CLIENT["mac"]}] disconnected from '
                f'"{WIRELESS_CLIENT["essid"]}" (7m 47s connected, 448.28K bytes, '
                f'last AP[{WIRELESS_CLIENT["ap_mac"]}])'
            ),
            "site_id": WIRELESS_CLIENT["site_id"],
            "ssid": WIRELESS_CLIENT["essid"],
            "subsystem": "wlan",
            "time": 1587752927000,
            "user": WIRELESS_CLIENT["mac"],
        }
    ],
}

EVENT_WIRELESS_CLIENT_WIRED_CONNECTED = {
    "meta": {"rc": "ok", "message": "events"},
    "data": [
        {
            "_id": "5ea3304330c49e00f90dcc35",
            "datetime": "2020-04-24T18:30:22Z",
            "key": "EVT_LU_Connected",
            "msg": f'User{[WIRELESS_CLIENT["mac"]]} has connected to LAN',
            "network": "LAN",
            "site_id": WIRELESS_CLIENT["site_id"],
            "subsystem": "lan",
            "time": 1587753022473,
            "user": WIRELESS_CLIENT["mac"],
        }
    ],
}

EVENT_WIRELESS_CLIENT_WIRED_DISCONNECTED = {
    "meta": {"rc": "ok", "message": "events"},
    "data": [
        {
            "_id": "5ea3318a30c49e00f90dd8c4",
            "bytes": 0,
            "datetime": "2020-04-24T18:30:27Z",
            "duration": 5,
            "hostname": WIRELESS_CLIENT["hostname"],
            "key": "EVT_LU_Disconnected",
            "msg": (
                f'User{[WIRELESS_CLIENT["mac"]]} disconnected from "LAN" '
                "(5s connected, 0.00 bytes)"
            ),
            "network": "LAN",
            "site_id": WIRELESS_CLIENT["site_id"],
            "subsystem": "lan",
            "time": 1587753027000,
            "user": WIRELESS_CLIENT["mac"],
        }
    ],
}

EVENT_SWITCH_16_CONNECTED = {
    "meta": {"rc": "ok", "message": "events"},
    "data": [
        {
            "_id": "5eae82572ab79c00f9d39b38",
            "datetime": "2020-05-03T08:35:35Z",
            "key": "EVT_SW_Connected",
            "msg": f'Switch[{SWITCH_16_PORT_POE["mac"]}] was connected',
            "site_id": SWITCH_16_PORT_POE["site_id"],
            "subsystem": "lan",
            "sw": SWITCH_16_PORT_POE["mac"],
            "sw_name": SWITCH_16_PORT_POE["name"],
            "time": 1588494935241,
        }
    ],
}

EVENT_SWITCH_16_RESTARTED_UNKOWN = {
    "meta": {"rc": "ok", "message": "events"},
    "data": [
        {
            "_id": "5ea9e37030c49e010363ee0b",
            "datetime": "2020-04-29T20:27:24Z",
            "key": "EVT_SW_RestartedUnknown",
            "msg": f'Switch[{SWITCH_16_PORT_POE["mac"]}] was restarted',
            "site_id": SWITCH_16_PORT_POE["site_id"],
            "subsystem": "lan",
            "sw": SWITCH_16_PORT_POE["mac"],
            "sw_name": SWITCH_16_PORT_POE["name"],
            "time": 1588192044198,
        }
    ],
}

EVENT_SWITCH_16_LOST_CONTACT = {
    "meta": {"rc": "ok", "message": "events"},
    "data": [
        {
            "_id": "5eae7fe02ab79c00f9d38960",
            "datetime": "2020-05-03T08:25:04Z",
            "key": "EVT_SW_Lost_Contact",
            "msg": f'Switch[{SWITCH_16_PORT_POE["mac"]}] was disconnected',
            "site_id": SWITCH_16_PORT_POE["site_id"],
            "subsystem": "lan",
            "sw": SWITCH_16_PORT_POE["mac"],
            "sw_name": SWITCH_16_PORT_POE["name"],
            "time": 1588494304030,
        }
    ],
}

EVENT_SWITCH_16_UPGRADED = {
    "meta": {"rc": "ok", "message": "events"},
    "data": [
        {
            "_id": "5eae7fe02ab79c00f9d38960",
            "datetime": "2020-05-09T20:06:37Z",
            "key": "EVT_SW_Upgraded",
            "msg": (
                f'Switch[{SWITCH_16_PORT_POE["mac"]}] was upgraded from '
                '"4.0.66.10832" to "4.3.13.11253"'
            ),
            "site_id": SWITCH_16_PORT_POE["site_id"],
            "subsystem": "lan",
            "sw": SWITCH_16_PORT_POE["mac"],
            "sw_name": SWITCH_16_PORT_POE["name"],
            "time": 1589054797635,
            "version_from": "4.0.66.10832",
            "version_to": "4.3.13.11253",
        }
    ],
}

PORT_FORWARDING = {
    "meta": {"rc": "ok"},
    "data": [
        {
            "_id": "5a32aa4ee4b0412345678911",
            "dst_port": "12345",
            "enabled": True,
            "fwd_port": "23456",
            "fwd": "10.0.0.2",
            "name": "New port forward",
            "pfwd_interface": "wan",
            "proto": "tcp_udp",
            "site_id": "5a32aa4ee4b0412345678910",
            "src": "any",
        }
    ],
}

SYSTEM_INFORMATION = {
    "anonymous_controller_id": "24f81231-a456-4c32-abcd-f5612345385f",
    "autobackup": False,
    "build": "atag_7.4.162_21057",
    "console_display_version": "3.1.15",
    "data_retention_days": 90,
    "data_retention_time_in_hours_for_5minutes_scale": 24,
    "data_retention_time_in_hours_for_daily_scale": 2160,
    "data_retention_time_in_hours_for_hourly_scale": 720,
    "data_retention_time_in_hours_for_monthly_scale": 8760,
    "data_retention_time_in_hours_for_others": 2160,
    "debug_device": "warn",
    "debug_mgmt": "warn",
    "debug_sdn": "warn",
    "debug_setting_preference": "auto",
    "debug_system": "warn",
    "default_site_device_auth_password_alert": False,
    "facebook_wifi_registered": False,
    "has_webrtc_support": True,
    "hostname": "UDMP",
    "https_port": 8443,
    "image_maps_use_google_engine": False,
    "inform_port": 8080,
    "ip_addrs": ["1.2.3.4"],
    "is_cloud_console": False,
    "live_chat": "super-only",
    "name": "UDMP",
    "override_inform_host": False,
    "portal_http_port": 8880,
    "previous_version": "7.4.156",
    "radius_disconnect_running": False,
    "sso_app_id": "90wa123b0Xg456yYl789M5x12390SabczyFbyo8v",
    "sso_app_sec": (
        "abcdefyPBsqYLsPX9LP123456789E6wV8cX6C6iIlRnLT4bvuuabcde1234q24TnR"
        "3nMW37mrNaOT0Z6SEapGo0123456789abcde8Mew0xWK7ozecSJm5VS87654321"
    ),
    "store_enabled": "super-only",
    "timezone": "Europe/Stockholm",
    "ubnt_device_type": "UDMPRO",
    "udm_version": "3.0.20.9281",
    "unifi_go_enabled": False,
    "unsupported_device_count": 0,
    "unsupported_device_list": [],
    "update_available": False,
    "update_downloaded": False,
    "uptime": 1196290,
    "version": "7.4.162",
}

TRAFFIC_RULES = [
    {
        "_id": "6452cd9b859d5b11aa002ea1",
        "action": "BLOCK",
        "app_category_ids": [],
        "app_ids": [],
        "bandwidth_limit": {
            "download_limit_kbps": 1024,
            "enabled": False,
            "upload_limit_kbps": 1024,
        },
        "description": "Test 1",
        "domains": [],
        "enabled": True,
        "ip_addresses": [],
        "ip_ranges": [],
        "matching_target": "INTERNET",
        "network_ids": [],
        "regions": [],
        "schedule": {
            "date_end": "2023-05-10",
            "date_start": "2023-05-03",
            "mode": "ALWAYS",
            "repeat_on_days": [],
            "time_all_day": False,
            "time_range_end": "12:00",
            "time_range_start": "09:00",
        },
        "target_devices": [{"client_mac": WIRELESS_CLIENT["mac"], "type": "CLIENT"}],
    },
    {
        "_id": "64628771859d5b11aa050792",
        "action": "BLOCK",
        "app_category_ids": [],
        "app_ids": [],
        "bandwidth_limit": {
            "download_limit_kbps": 1024,
            "enabled": False,
            "upload_limit_kbps": 1024,
        },
        "description": "Test 2",
        "domains": [],
        "enabled": False,
        "ip_addresses": [
            {
                "ip_or_subnet": WIRED_CLIENT["ip"],
                "ip_version": "v4",
                "port_ranges": [{"port_start": 35, "port_stop": 100}],
                "ports": [],
            }
        ],
        "ip_ranges": [
            {"ip_start": "192.168.0.1", "ip_stop": "192.168.0.10", "ip_version": "v4"}
        ],
        "matching_target": "IP",
        "network_ids": [],
        "regions": [],
        "schedule": {
            "date_end": "2023-05-22",
            "date_start": "2023-05-15",
            "mode": "CUSTOM",
            "repeat_on_days": ["mon", "thu"],
            "time_all_day": False,
            "time_range_end": "12:00",
            "time_range_start": "09:00",
        },
        "target_devices": [
            {"network_id": WIRELESS_CLIENT["network_id"], "type": "NETWORK"}
        ],
    },
]

TRAFFIC_ROUTES = [
    {
        "_id": "6468ecd4c1dd1932ad2f801c",
        "description": "Test domain rule",
        "domains": [
            {"domain": "example.com", "port_ranges": [], "ports": []},
        ],
        "enabled": True,
        "ip_addresses": [],
        "ip_ranges": [],
        "matching_target": "DOMAIN",
        "network_id": "5a32aa4ee4b047ede36a85a8",
        "next_hop": "",
        "regions": [],
        "target_devices": [
            {"network_id": WIRELESS_CLIENT["network_id"], "type": "NETWORK"},
        ],
    },
    {
        "_id": "655565af1e1c2754a39388a4",
        "description": "Test all internet rule",
        "domains": [],
        "enabled": False,
        "ip_addresses": [],
        "ip_ranges": [],
        "matching_target": "INTERNET",
        "network_id": "5a32aa4ee4b047ede36a85a8",
        "next_hop": "",
        "regions": [],
        "target_devices": [
            {"network_id": WIRELESS_CLIENT["network_id"], "type": "NETWORK"}
        ],
    },
    {
        "_id": "655566f91e1c2754a393892c",
        "description": "Test IP rule",
        "domains": [],
        "enabled": False,
        "ip_addresses": [
            {
                "ip_or_subnet": "1.1.1.1",
                "ip_version": "v4",
                "port_ranges": [],
                "ports": [],
            },
        ],
        "ip_ranges": [],
        "matching_target": "IP",
        "network_id": "5a32aa4ee4b047ede36a85a8",
        "next_hop": "",
        "regions": [],
        "target_devices": [
            {"network_id": WIRELESS_CLIENT["network_id"], "type": "NETWORK"}
        ],
    },
]
