/***************************************************************************
 * 
 * All modifications in this file to the original code are
 * (C) Copyright 1992, ..., 2000 the "DOSEMU-Development-Team".
 *
 * for details see file COPYING in the DOSEMU distribution
 *
 *
 *  SIMX86 a Intel 80x86 cpu emulator
 *  Copyright (C) 1997,2000 Alberto Vignani, FIAT Research Center
 *				a.vignani@crf.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additional copyright notes:
 *
 * 1. The kernel-level vm86 handling was taken out of the Linux kernel
 *  (linux/arch/i386/kernel/vm86.c). This code originaly was written by
 *  Linus Torvalds with later enhancements by Lutz Molgedey and Hans Lermen.
 *
 ***************************************************************************/

#include "emu86.h"
#include "codegen.h"

/////////////////////////////////////////////////////////////////////////////

unsigned char byrev[256] = {
	0x00,0x80,0x40,0xc0,0x20,0xa0,0x60,0xe0,
	0x10,0x90,0x50,0xd0,0x30,0xb0,0x70,0xf0,
	0x08,0x88,0x48,0xc8,0x28,0xa8,0x68,0xe8,
	0x18,0x98,0x58,0xd8,0x38,0xb8,0x78,0xf8,
	0x04,0x84,0x44,0xc4,0x24,0xa4,0x64,0xe4,
	0x14,0x94,0x54,0xd4,0x34,0xb4,0x74,0xf4,
	0x0c,0x8c,0x4c,0xcc,0x2c,0xac,0x6c,0xec,
	0x1c,0x9c,0x5c,0xdc,0x3c,0xbc,0x7c,0xfc,
	0x02,0x82,0x42,0xc2,0x22,0xa2,0x62,0xe2,
	0x12,0x92,0x52,0xd2,0x32,0xb2,0x72,0xf2,
	0x0a,0x8a,0x4a,0xca,0x2a,0xaa,0x6a,0xea,
	0x1a,0x9a,0x5a,0xda,0x3a,0xba,0x7a,0xfa,
	0x06,0x86,0x46,0xc6,0x26,0xa6,0x66,0xe6,
	0x16,0x96,0x56,0xd6,0x36,0xb6,0x76,0xf6,
	0x0e,0x8e,0x4e,0xce,0x2e,0xae,0x6e,0xee,
	0x1e,0x9e,0x5e,0xde,0x3e,0xbe,0x7e,0xfe,
	0x01,0x81,0x41,0xc1,0x21,0xa1,0x61,0xe1,
	0x11,0x91,0x51,0xd1,0x31,0xb1,0x71,0xf1,
	0x09,0x89,0x49,0xc9,0x29,0xa9,0x69,0xe9,
	0x19,0x99,0x59,0xd9,0x39,0xb9,0x79,0xf9,
	0x05,0x85,0x45,0xc5,0x25,0xa5,0x65,0xe5,
	0x15,0x95,0x55,0xd5,0x35,0xb5,0x75,0xf5,
	0x0d,0x8d,0x4d,0xcd,0x2d,0xad,0x6d,0xed,
	0x1d,0x9d,0x5d,0xdd,0x3d,0xbd,0x7d,0xfd,
	0x03,0x83,0x43,0xc3,0x23,0xa3,0x63,0xe3,
	0x13,0x93,0x53,0xd3,0x33,0xb3,0x73,0xf3,
	0x0b,0x8b,0x4b,0xcb,0x2b,0xab,0x6b,0xeb,
	0x1b,0x9b,0x5b,0xdb,0x3b,0xbb,0x7b,0xfb,
	0x07,0x87,0x47,0xc7,0x27,0xa7,0x67,0xe7,
	0x17,0x97,0x57,0xd7,0x37,0xb7,0x77,0xf7,
	0x0f,0x8f,0x4f,0xcf,0x2f,0xaf,0x6f,0xef,
	0x1f,0x9f,0x5f,0xdf,0x3f,0xbf,0x7f,0xff
};

/////////////////////////////////////////////////////////////////////////////

/* table of opcodes which cannot start a sequence, i.e. opcodes
 * which are always compiled(0) or interpreted(!=0) */

char InterOps[256] =
{
	0,	// ADDbfrm		0x00
	0,	// ADDwfrm		0x01
	0,	// ADDbtrm		0x02
	0,	// ADDwtrm		0x03
	0,	// ADDbia		0x04
	0,	// ADDwia		0x05
	0,	// PUSHes		0x06
	2,	// POPes		0x07
	0,	// ORbfrm		0x08
	0,	// ORwfrm		0x09
	0,	// ORbtrm		0x0a
	0,	// ORwtrm		0x0b
	0,	// ORbi			0x0c
	0,	// ORwi			0x0d
	0,	// PUSHcs		0x0e
	2,	// TwoByteESC		0x0f
	0,	// ADCbfrm		0x10
	0,	// ADCwfrm		0x11
	0,	// ADCbtrm		0x12
	0,	// ADCwtrm		0x13
	0,	// ADCbi		0x14
	0,	// ADCwi		0x15
	0,	// PUSHss		0x16
	2,	// POPss		0x17
	0,	// SBBbfrm		0x18
	0,	// SBBwfrm		0x19
	0,	// SBBbtrm		0x1a
	0,	// SBBwtrm		0x1b
	0,	// SBBbi		0x1c
	0,	// SBBwi		0x1d
	0,	// PUSHds		0x1e
	2,	// POPds		0x1f
	0,	// ANDbfrm		0x20
	0,	// ANDwfrm		0x21
	0,	// ANDbtrm		0x22
	0,	// ANDwtrm		0x23
	0,	// ANDbi		0x24
	0,	// ANDwi		0x25
	4,	// SEGes		0x26
	0,	// DAA			0x27
	0,	// SUBbfrm		0x28
	0,	// SUBwfrm		0x29
	0,	// SUBbtrm		0x2a
	0,	// SUBwtrm		0x2b
	0,	// SUBbi		0x2c
	0,	// SUBwi		0x2d
	4,	// SEGcs		0x2e
	0,	// DAS			0x2f
	0,	// XORbfrm		0x30
	0,	// XORwfrm		0x31
	0,	// XORbtrm		0x32
	0,	// XORwtrm		0x33
	0,	// XORbi		0x34
	0,	// XORwi		0x35
	4,	// SEGss		0x36
	0,	// AAA			0x37
	0,	// CMPbfrm		0x38
	0,	// CMPwfrm		0x39
	0,	// CMPbtrm		0x3a
	0,	// CMPwtrm		0x3b
	0,	// CMPbi		0x3c
	0,	// CMPwi		0x3d
	4,	// SEGds		0x3e
	0,	// AAS			0x3f
	0,	// INCax		0x40
	0,	// INCcx		0x41
	0,	// INCdx		0x42
	0,	// INCbx		0x43
	0,	// INCsp		0x44
	0,	// INCbp		0x45
	0,	// INCsi		0x46
	0,	// INCdi		0x47
	0,	// DECax		0x48
	0,	// DECcx		0x49
	0,	// DECdx		0x4a
	0,	// DECbx		0x4b
	0,	// DECsp		0x4c
	0,	// DECbp		0x4d
	0,	// DECsi		0x4e
	0,	// DECdi		0x4f
	0,	// PUSHax		0x50
	0,	// PUSHcx		0x51
	0,	// PUSHdx		0x52
	0,	// PUSHbx		0x53
	0,	// PUSHsp		0x54
	0,	// PUSHbp		0x55
	0,	// PUSHsi		0x56
	0,	// PUSHdi		0x57
	0,	// POPax		0x58
	0,	// POPcx		0x59
	0,	// POPdx		0x5a
	0,	// POPbx		0x5b
	0,	// POPsp		0x5c
	0,	// POPbp		0x5d
	0,	// POPsi		0x5e
	0,	// POPdi		0x5f
	0,	// PUSHA		0x60
	0,	// POPA			0x61
	-1,	// BOUND		0x62
	-1,	// ARPL			0x63
	4,	// SEGfs		0x64
	4,	// SEGgs		0x65
	4,	// OPERoverride		0x66
	4,	// ADDRoverride		0x67
	0,	// PUSHwi		0x68
	0,	// IMULwrm		0x69 
	0,	// PUSHbi		0x6a
	0,	// IMULbrm		0x6b
	1,	// INSb			0x6c
	1,	// INSw			0x6d
	1,	// OUTSb		0x6e
	1,	// OUTSw		0x6f
	2,	// JO			0x70
	2,	// JNO			0x71
	2,	// JB_JNAE		0x72
	2,	// JNB_JAE		0x73
	2,	// JE_JZ		0x74
	2,	// JNE_JNZ		0x75
	2,	// JBE_JNA		0x76
	2,	// JNBE_JA		0x77
	2,	// JS			0x78
	2,	// JNS			0x79
	2,	// JP_JPE		0x7a
	2,	// JNP_JPO		0x7b
	2,	// JL_JNGE		0x7c
	2,	// JNL_JGE		0x7d
	2,	// JLE_JNG		0x7e
	2,	// JNLE_JG		0x7f
	0,	// IMMEDbrm		0x80
	0,	// IMMEDwrm		0x81
	0,	// IMMEDbrm2		0x82
	0,	// IMMEDisrm		0x83
	0,	// TESTbrm		0x84
	0,	// TESTwrm		0x85
	0,	// XCHGbrm		0x86
	0,	// XCHGwrm		0x87
	0,	// MOVbfrm		0x88
	0,	// MOVwfrm		0x89
	0,	// MOVbtrm		0x8a
	0,	// MOVwtrm		0x8b
	0,	// MOVsrtrm		0x8c
	0,	// LEA			0x8d
	2,	// MOVsrfrm		0x8e
	0,	// POPrm		0x8f
	1,	// NOP			0x90
	0,	// XCHGcx		0x91
	0,	// XCHGdx		0x92
	0,	// XCHGbx		0x93
	0,	// XCHGsp		0x94
	0,	// XCHGbp		0x95
	0,	// XCHGsi		0x96
	0,	// XCHGdi		0x97
	0,	// CBW			0x98
	0,	// CWD			0x99
	1,	// CALLl		0x9a
	1,	// WAIT			0x9b
	1,	// PUSHF		0x9c
	1,	// POPF			0x9d
	0,	// SAHF			0x9e
	0,	// LAHF			0x9f
	0,	// MOVmal		0xa0
	0,	// MOVmax		0xa1
	0,	// MOValm		0xa2
	0,	// MOVaxm		0xa3
	0,	// MOVSb		0xa4
	0,	// MOVSw		0xa5
	0,	// CMPSb		0xa6
	0,	// CMPSw		0xa7
	0,	// TESTbi		0xa8
	0,	// TESTwi		0xa9
	0,	// STOSb		0xaa
	0,	// STOSw		0xab
	0,	// LODSb		0xac
	0,	// LODSw		0xad
	0,	// SCASb		0xae
	0,	// SCASw		0xaf
	0,	// MOVial		0xb0
	0,	// MOVicl		0xb1
	0,	// MOVidl		0xb2
	0,	// MOVibl		0xb3
	0,	// MOViah		0xb4
	0,	// MOVich		0xb5
	0,	// MOVidh		0xb6
	0,	// MOVibh		0xb7
	0,	// MOViax		0xb8
	0,	// MOVicx		0xb9
	0,	// MOVidx		0xba
	0,	// MOVibx		0xbb
	0,	// MOVisp		0xbc
	0,	// MOVibp		0xbd
	0,	// MOVisi		0xbe
	0,	// MOVidi		0xbf
	0,	// SHIFTbi		0xc0
	0,	// SHIFTwi		0xc1 
	1,	// RETisp		0xc2
	1,	// RET			0xc3
	2,	// LES			0xc4
	2,	// LDS			0xc5
	0,	// MOVbirm		0xc6
	0,	// MOVwirm		0xc7
	1,	// ENTER		0xc8
	1,	// LEAVE		0xc9 
	1,	// RETlisp		0xca
	1,	// RETl			0xcb
	1,	// INT3			0xcc
	1,	// INT			0xcd
	1,	// INTO			0xce
	1,	// IRET			0xcf
	0,	// SHIFTb		0xd0
	0,	// SHIFTw		0xd1
	0,	// SHIFTbv		0xd2
	0,	// SHIFTwv		0xd3
	0,	// AAM			0xd4
	0,	// AAD			0xd5
	-1,	// RESERVED1		0xd6
	0,	// XLAT			0xd7
	2,	// ESC0			0xd8
	2,	// ESC1			0xd9
	2,	// ESC2			0xda
	2,	// ESC3			0xdb
	2,	// ESC4			0xdc
	2,	// ESC5			0xdd
	2,	// ESC6			0xde
	2,	// ESC7			0xdf
	2,	// LOOPNZ_LOOPNE	0xe0
	2,	// LOOPZ_LOOPE		0xe1
	2,	// LOOP			0xe2
	2,	// JCXZ			0xe3
	1,	// INb			0xe4
	1,	// INw			0xe5
	1,	// OUTb			0xe6
	1,	// OUTw			0xe7
	1,	// CALLd		0xe8
	1,	// JMPd			0xe9
	1,	// JMPld		0xea
	2,	// JMPsid		0xeb
	1,	// INvb			0xec
	1,	// INvw			0xed
	1,	// OUTvb		0xee
	1,	// OUTvw		0xef
	-1,	// LOCK			0xf0
	-1,	// BARTS_OP		0xf1
	0,	// REPNE		0xf2
	0,	// REP			0xf3
	1,	// HLT			0xf4
	0,	// CMC			0xf5
	0,	// GRP1brm 		0xf6
	0,	// GRP1wrm 		0xf7
	0,	// CLC			0xf8
	0,	// STC			0xf9
	1,	// CLI			0xfa
	1,	// STI			0xfb
	0,	// CLD			0xfc
	0,	// STD			0xfd
	0,	// GRP2brm		0xfe
	2,	// GRP2wrm		0xff
};

