/* gentlex.h - declarations for file generated by gentlex */
/*
	Copyright Carnegie Mellon University 1992 - All rights reserved
	$Disclaimer: This software is part of version 6.1 of the 
 * Andrew User Interface System and is 
 * the property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * the individual named in ./config/allsys.h.  
 * This source code is not to be redistributed.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/

#ifndef _GENTLEX_H_
#define _GENTLEX_H_

#ifndef TRUE
#define boolean int
#define TRUE 1
#define FALSE 0
#endif

/* when subscripting by a char, use UNSIGN since some systems 
	will use a negative value for characters above 0x7F */
#define UNSIGN(c) ((c) & 0xFF)

/* macro to interrogate charset values.
	if parm->b is a Charset value, we can ask 
	whether the bit corresponding to character c is set by saying
		tlex_BITISSET(parm->b, c)
*/
typedef struct charsettype {
	char *vector;
	char mask;
}    Charset;
#define tlex_BITISSET(bs, c) ((((bs).vector)[UNSIGN(c)]) & ((bs).mask))


/* the following may appear in the action or thongact array */
#define tlex_ACTTHONG 0x100
	/* start thong table search at thongtbl[action&(~tlex_ACTTHONG)] */
#define tlex_ACTSCAN 0x200
	/* call recognizer described in rectbl[action&(~tlex_ACTSCAN)] */
#define tlex_ACTRESWD 0x400
	/* recognize the reserved word token action&(~tlex_ACTRESWD) */
#define tlex_ACTEOF 0x800
	/* end of file */

/* indices in internal table of the predefined recognizers 
  these values are of use in writing lexical analyzers, not client code */
 /* there is a table of names for these values in tlex/output.c */
#define tlex_ERROR 1
#define tlex_WHITESPACE 2
#define tlex_COMMENT 3
#define tlex_TOKEN 4
#define tlex_ID 5
#define tlex_NUMBER 6
#define tlex_STRING 7

/* an action value usually resolves into an index into tab->rectbl
	this provides a Recparm struct which specifies a recognizer,
	either predefined or user-defined, and provides parameters.
	the recognizer is called with two arguments:
		a pointer to the tlex
		a pointer to the Recparm struct
	the recognizer returns TRUE if it has found a token
	and FALSE if scanning is to resume
	arguments to recognizers and handlers are: tlex, parm
*/

/* the following Recparm declarations are used by the builtin recognizers 
	in the lexical analyzer.  They are not used in client code.  */

struct tlex_Recparm {
	short tokennumber;
	int recognizerindex;	/* tlex_TOKEN */
	int (*handler)();
	boolean SaveText;
};
struct tlex_NumberRecparm {
	short tokennumber;
	int recognizerindex;	/* tlex_NUMBER */
	int (*handler)();
	boolean IsInt;
	long intval;
	double realval;
};
struct tlex_IDRecparm {
	short tokennumber;
	int recognizerindex;	/* tlex_ID */
	int (*handler)();
	boolean SaveText;
	Charset continueset;
};
struct tlex_WhitespaceRecparm {
	short tokennumber;
	int recognizerindex;	/* tlex_WHITESPACE */
	int (*handler)();
	boolean SaveText;
	Charset continueset;
};
struct tlex_CommentRecparm {
	short tokennumber;
	int recognizerindex;	/* tlex_COMMENT */
	int (*handler)();
	boolean SaveText;
	char *endseq;
};
struct tlex_StringRecparm {
	short tokennumber;
	int recognizerindex;	/* tlex_STRING */
	int (*handler)();
	boolean SaveText;
	char *endseq;
	char *escapechar;
	char *badchar;
};
struct tlex_ErrorRecparm {
	short tokennumber;
	int recognizerindex;	/* tlex_ERROR */
	int (*handler)();
	char *msg;
};


struct tlex_tables {
	struct tlex_Recparm **rectbl;
			/* array describing possible actions */
	short *action;	/* action for each initial character
			if value has tlex_ACTTHONG set,
				consult thongtbl using low bits as index
			if value has tlex_ACTSCAN bit set,
				call recognizer via rectbl
			otherwise treat as a standalone token
				with value as token number */
	int hichar;	/* action has elements for 0...hichar */
	int defaultaction;	/* action for characters above hichar */
	struct tlex_Recparm *reservedwordparm;
				/* points to a recparm struct for
				handling reserved words */
	char **thongtbl;	/* points to sorted array of thong strings
				If there are thongs beginning with the letter x,
				there is a one character entry for x as the
				first of the thongs for that letter.
				The last entry is followed by a zero length string. */
	char *thongsame;	/* thongsame[i] has as its value the number of
				leading characters which are the same between
				thongtbl[i-1] and thongtbl[i] */
	short *thongact;	/* array of action values for thongs */
	struct tlex_Recparm *global;	/* points to the global struct */
	struct tlex_ErrorRecparm *ErrorHandler; 
		/* ErrorHandler->handler is called by tlex_Error.
		If not specified, a dummy is created by gentlex;
		the dummy just prints the message.
		Clients should call tlex_Error instead of this handler. */
};

/* these values can be returned by C code handlers for token classes 
	in the .tlx file
   the value of a variable of type 'action' can also be returned
*/
#define tlex_ACCEPT (-1)
#define tlex_IGNORE (-2)

#endif
