/* ********************************************************************** *\
 *         Copyright IBM Corporation 1988,1991 - All Rights Reserved      *
 *        For full copyright information see:'andrew/config/COPYRITE'     *
\* ********************************************************************** */

/*
	$Disclaimer: This software is part of version 6.1 of the 
 * Andrew User Interface System and is 
 * the property of IBM, Carnegie Mellon University, 
 * and the other copyright holders.  The source 
 * code of this version is for the sole use of 
 * the individual named in ./config/allsys.h.  
 * This source code is not to be redistributed.  
 * Binary object code compiled or derived from 
 * these sources is not to be distributed to non-
 * members.  Members may have additional 
 * distribution rights granted by prior written 
 * permission of Carnegie Mellon University.
 * 
 * IBM, CARNEGIE MELLON UNIVERSITY, 
 * AND THE OTHER COPYRIGHT HOLDERS
 *  DISCLAIM ALL WARRANTIES WITH 
 * REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANT-
 * ABILITY AND FITNESS. IN 
 * NO EVENT SHALL  IBM, CARNEGIE 
 * MELLON UNIVERSITY, OR ANY OTHER 
 * COPYRIGHT HOLDER BE LIABLE FOR 
 * ANY SPECIAL, INDIRECT OR CONSE-
 * QUENTIAL DAMAGES OR ANY DAMAGES 
 * WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT 
 * OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *  $
*/


#include <cmerror.h>

/* Could have just as easily used TRUE and FALSE for these. */
#define cmenu_Inactive                  0
#define cmenu_Active                    1

#define cmenu_DisallowDuplicates        8
#define cmenu_CreatePane                2
#define cmenu_DeleteEmptyPanes          4

#define cmenu_NoBackground              0
#define cmenu_BackgroundPixel           1
#define cmenu_BackgroundPixmap          2
#define cmenu_NoSaveUnder               3

#ifdef _STDC_
extern struct cmenu *cmenu_Create(Display *display, Window parent,
                         char *defaultEnvironment, void (*freeFunction)());
extern cmenu_Destroy(struct cmenu *menu);
extern int cmenu_AddPane(struct cmenu *menu, char *paneTitle,
                         int panePriority, int flags);
extern int cmenu_DeletePane(struct cmenu *menu, char *paneTitle, int priority);
extern int cmenu_AddSelection(struct cmenu *menu, char *paneTitle,
               int panePriority, char *selectionLabel, int selectionPriority,
               long selectionData, int flags, char *keys);
extern int cmenu_DeleteSelection(struct cmenu *menu, char *paneTitle,
               int panePriority, char *slectionLabel, int selectionPriority,
               int flags);
extern int cmenu_Activate(struct cmenu *menu, XButtonEvent *menuEvent,
               long *data, int backgroundType, long backgroundValue);
#else /* _STDC_ */
extern struct cmenu *cmenu_Create();
extern int cmenu_AddPane();
extern int cmenu_AddSelection();
extern int cmenu_DeletePane();
extern int cmenu_DeleteSelection();
#endif /* _STDC_ */
