/****************************************************************************
 * This module is mostly all new
 * by Rob Nation (nation@rocket.sanders.lockheed.com)
 * A little of it is borrowed from ctwm.
 * Copyright 1993 Robert Nation. No restrictions are placed on this code,
 * as long as the copyright notice is preserved
 ****************************************************************************/
/***********************************************************************
 *
 * fvwm icon code
 *
 ***********************************************************************/

#include "configuration.h"

#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#ifdef XPM
#include "xpm.h"
#endif /* XPM */
#include "fvwm.h"
#include "menus.h"
#include "misc.h"
#include "parse.h"
#include "screen.h"
#ifdef SHAPE
#include <X11/extensions/shape.h>
#endif /* SHAPE */


void GrabIconButtons(FvwmWindow *, Window);
void GrabIconKeys(FvwmWindow *, Window);
MyFont *IconFont;

/****************************************************************************
 *
 * Creates an icon window as needed
 *
 ****************************************************************************/
void CreateIconWindow(FvwmWindow *tmp_win, int def_x, int def_y)
{
#ifndef NO_ICONS
  int final_x, final_y;
  unsigned long valuemask;		/* mask for create windows */
  XSetWindowAttributes attributes;	/* attributes for create windows */

  tmp_win->flags |= ICON_OURS;
  tmp_win->flags &= ~XPM_FLAG;
  tmp_win->flags &= ~PIXMAP_OURS;
  tmp_win->flags &= ~SHAPED_ICON;
  tmp_win->icon_pixmap_w = None;
  tmp_win->iconPixmap = None;
  tmp_win->iconDepth = 0;
  
  if(Scr.flags & SuppressIcons)
    return;

  /* First, see if it was specified in the .fvwmrc */
  tmp_win->icon_p_height = 0;
  tmp_win->icon_p_width = 0;

  /* First, check for a monochrome bitmap */
  if(tmp_win->icon_bitmap_file != NULL)
    GetBitmapFile(tmp_win);

  /* Next, check for a color pixmap */
  if((tmp_win->icon_bitmap_file != NULL)&&
     (tmp_win->icon_p_height == 0)&&(tmp_win->icon_p_width == 0))
    GetXPMFile(tmp_win);

  /* Next, See if the app supplies its own icon window */
  if((tmp_win->icon_p_height == 0)&&(tmp_win->icon_p_width == 0)&&
     (tmp_win->wmhints) && (tmp_win->wmhints->flags & IconWindowHint))
    GetIconWindow(tmp_win);

  /* Finally, try to get icon bitmap from the application */
  if((tmp_win->icon_p_height == 0)&&(tmp_win->icon_p_width == 0)&&
	  (tmp_win->wmhints)&&(tmp_win->wmhints->flags & IconPixmapHint))
    GetIconBitmap(tmp_win);

  /* figure out the icon window size */
  tmp_win->icon_t_width = XTextWidth(IconFont->font,tmp_win->icon_name, 
				     strlen(tmp_win->icon_name));
  if((tmp_win->flags & ICON_OURS)&&(tmp_win->icon_p_height >0))
    {
      tmp_win->icon_p_width += 4;
      tmp_win->icon_p_height +=4;
    }

  if(tmp_win->icon_p_width == 0)
    tmp_win->icon_p_width = tmp_win->icon_t_width+6;
  tmp_win->icon_w_width = tmp_win->icon_p_width;

  tmp_win->icon_w_height = ICON_HEIGHT;

  final_x = def_x;
  final_y = def_y;
  if(final_x <0)
    final_x = 0;
  if(final_y <0)
    final_y = 0;
  
  if(final_x + tmp_win->icon_w_width >=Scr.MyDisplayWidth)
    final_x = Scr.MyDisplayWidth - tmp_win->icon_w_width-1;
  if(final_y + tmp_win->icon_w_height >=Scr.MyDisplayHeight)
    final_y = Scr.MyDisplayHeight - tmp_win->icon_w_height-1;

  tmp_win->icon_x_loc = final_x;
  tmp_win->icon_xl_loc = final_x;
  tmp_win->icon_y_loc = final_y;

  /* clip to fit on screen */
  attributes.background_pixel = Scr.StdColors.back;
  valuemask =  CWBorderPixel | CWCursor | CWEventMask | CWBackPixel;
  attributes.border_pixel = Scr.StdColors.fore;
  attributes.cursor = Scr.FvwmCursors[DEFAULT];
  attributes.event_mask = (ButtonPressMask | ButtonReleaseMask | VisibilityChangeMask |
			   ExposureMask | KeyPressMask|EnterWindowMask |
			   FocusChangeMask | LeaveWindowMask);
  tmp_win->icon_w = 
    XCreateWindow(dpy, Scr.Root, final_x, final_y+tmp_win->icon_p_height,
		  tmp_win->icon_w_width, tmp_win->icon_w_height,0,
		  CopyFromParent, 
		  CopyFromParent,CopyFromParent,valuemask,&attributes);

  if((tmp_win->flags & ICON_OURS)&&(tmp_win->icon_p_width>0)&&
     (tmp_win->icon_p_height>0))
    {
      tmp_win->icon_pixmap_w = 
	XCreateWindow(dpy, Scr.Root, final_x, final_y, tmp_win->icon_p_width,
		      tmp_win->icon_p_height, 0, CopyFromParent,
		      CopyFromParent,CopyFromParent,valuemask,&attributes);
    }
  else
    {
      valuemask = CWEventMask;
      XChangeWindowAttributes(dpy,tmp_win->icon_pixmap_w,
			      valuemask,&attributes);
    }


#ifdef XPM
#ifdef SHAPE
  if (tmp_win->flags & SHAPED_ICON)
    {
      XShapeCombineMask(dpy, tmp_win->icon_pixmap_w, ShapeBounding,2, 2,
			tmp_win->icon_maskPixmap, ShapeSet);
    }
#endif
#endif

  XSaveContext(dpy, tmp_win->icon_w, FvwmContext, (caddr_t)tmp_win);
  if(tmp_win->icon_pixmap_w != None)
    XSaveContext(dpy, tmp_win->icon_pixmap_w, FvwmContext, (caddr_t)tmp_win);
  XDefineCursor(dpy, tmp_win->icon_w, Scr.FvwmCursors[DEFAULT]);
  XDefineCursor(dpy, tmp_win->icon_pixmap_w, Scr.FvwmCursors[DEFAULT]);
  GrabIconButtons(tmp_win,tmp_win->icon_w);
  GrabIconKeys(tmp_win,tmp_win->icon_w);
  if(tmp_win->icon_pixmap_w)
    {
      GrabIconButtons(tmp_win,tmp_win->icon_pixmap_w);
      GrabIconKeys(tmp_win,tmp_win->icon_pixmap_w);
    }
  return;
#endif
}

/****************************************************************************
 *
 * Draws the icon window
 *
 ****************************************************************************/
void DrawIconWindow(FvwmWindow *Tmp_win)
{
#ifndef NO_ICONS
  GC Shadow, Relief;
  Pixel TextColor,BackColor;
  int x ;

  if(Scr.flags & SuppressIcons)
    return;

  flush_expose (Tmp_win->icon_w);
  if(Tmp_win->icon_pixmap_w != None)
    flush_expose (Tmp_win->icon_pixmap_w);

  if(Scr.Hilite == Tmp_win)
    {
      if(Scr.d_depth < 2)
	Relief = Scr.HiShadowGC;
      else
	Relief = Scr.HiReliefGC;
      Shadow = Scr.HiShadowGC;
      XSetWindowBackground(dpy,Tmp_win->icon_w,Scr.HiColors.back);
      if((Tmp_win->flags & ICON_OURS)&&(Tmp_win->icon_pixmap_w != None))
	XSetWindowBackground(dpy,Tmp_win->icon_pixmap_w,Scr.HiColors.back);
      /* resize the icon name window */
      Tmp_win->icon_w_width = Tmp_win->icon_t_width+6;
      if(Tmp_win->icon_w_width < Tmp_win->icon_p_width)
	Tmp_win->icon_w_width = Tmp_win->icon_p_width;
      Tmp_win->icon_xl_loc = Tmp_win->icon_x_loc - 
	(Tmp_win->icon_w_width - Tmp_win->icon_p_width)/2;
      TextColor = Scr.HiColors.fore;
      BackColor = Scr.HiColors.back;
    }
  else
    {
#ifndef NO_MORE_COLORS
      if(Tmp_win->flags & STICKY)
	{
	  if(Scr.d_depth < 2)
	    Relief = Scr.StickyShadowGC;
	  else
	    Relief = Scr.StickyReliefGC;
	  Shadow = Scr.StickyShadowGC;
	  XSetWindowBackground(dpy,Tmp_win->icon_w,Scr.StickyColors.back);
	  if((Tmp_win->flags & ICON_OURS)&&(Tmp_win->icon_pixmap_w != None))
	    XSetWindowBackground(dpy,Tmp_win->icon_pixmap_w,
				 Scr.StickyColors.back);
	  TextColor = Scr.StickyColors.fore;
	  BackColor = Scr.StickyColors.back;

	}
      else
#endif
	{
	  if(Scr.d_depth < 2)
	    Relief = Scr.StdShadowGC;
	  else
	    Relief = Scr.StdReliefGC;
	  Shadow = Scr.StdShadowGC;
	  XSetWindowBackground(dpy,Tmp_win->icon_w,Scr.StdColors.back);
	  if((Tmp_win->flags & ICON_OURS)&&(Tmp_win->icon_pixmap_w != None))
	    XSetWindowBackground(dpy,Tmp_win->icon_pixmap_w,
				 Scr.StdColors.back);
	  /* resize the icon name window */
	  Tmp_win->icon_w_width = Tmp_win->icon_p_width;
	  Tmp_win->icon_xl_loc = Tmp_win->icon_x_loc;
	  TextColor = Scr.StdColors.fore;
	  BackColor = Scr.StdColors.back;
	}
      /* resize the icon name window */
      Tmp_win->icon_w_width = Tmp_win->icon_p_width;
      Tmp_win->icon_xl_loc = Tmp_win->icon_x_loc;
	  
    }
  /* write the icon label */
  NewFontAndColor(IconFont->font->fid,TextColor,BackColor);

  XMoveWindow(dpy,Tmp_win->icon_pixmap_w,Tmp_win->icon_x_loc,
	      Tmp_win->icon_y_loc);
  XMoveResizeWindow(dpy, Tmp_win->icon_w, Tmp_win->icon_xl_loc,
		    Tmp_win->icon_y_loc+Tmp_win->icon_p_height,
		    Tmp_win->icon_w_width,ICON_HEIGHT);
  
  XClearWindow(dpy,Tmp_win->icon_w);

  if((Tmp_win->iconPixmap != None)&&(!(Tmp_win->flags & SHAPED_ICON)))
    RelieveWindow(Tmp_win->icon_pixmap_w,0,0,Tmp_win->icon_p_width,
 		  Tmp_win->icon_p_height, Relief,Shadow, FULL_HILITE);  

  /* need to locate the icon pixmap */
  if(Tmp_win->iconPixmap != None)
    {
      if(Tmp_win->iconDepth == Scr.d_depth)
	{
	  XCopyArea(dpy,Tmp_win->iconPixmap,Tmp_win->icon_pixmap_w,Scr.FontGC,
		    0,0,Tmp_win->icon_p_width-4, Tmp_win->icon_p_height-4,2,2);
	}
      else
	XCopyPlane(dpy,Tmp_win->iconPixmap,Tmp_win->icon_pixmap_w,Scr.FontGC,0,
		   0,Tmp_win->icon_p_width-4, Tmp_win->icon_p_height-4,2,2,1);  
    }      

  /* text position */
  x = (Tmp_win->icon_w_width - Tmp_win->icon_t_width)/2;
  if(x<3)x=3;
  
  XDrawString (dpy, Tmp_win->icon_w, Scr.FontGC, x,
	       Tmp_win->icon_w_height-IconFont->height+IconFont->y-3,
	       Tmp_win->icon_name, strlen(Tmp_win->icon_name));
  RelieveWindow(Tmp_win->icon_w,0,0,Tmp_win->icon_w_width,	
 		ICON_HEIGHT,Relief,Shadow, FULL_HILITE);
#endif  
}

/***********************************************************************
 *
 *  Procedure:
 *	RedoIconName - procedure to re-position the icon window and name
 *
 ************************************************************************/
void RedoIconName(FvwmWindow *Tmp_win)
{
#ifndef NO_PAGER
  if(Scr.PagerFont.height > 0)
    {
      XClearWindow(dpy,Tmp_win->pager_view);
      RedrawPager();
    }
#endif

#ifndef NO_ICONS
  if(Scr.flags & SuppressIcons)
    return;

  if (Tmp_win->icon_w == (int)NULL)
    return;
  
  Tmp_win->icon_t_width = XTextWidth(IconFont->font,Tmp_win->icon_name, 
				     strlen(Tmp_win->icon_name));
  /* clear the icon window, and trigger a re-draw via an expose event */
  if (Tmp_win->flags & ICONIFIED)
    XClearArea(dpy, Tmp_win->icon_w, 0, 0, 0, 0, True);
#endif
  return;
}



  
/***********************************************************************
 *
 *  Procedure:
 *	AutoPlace - Find a home for an icon
 *
 ************************************************************************/
void AutoPlace(FvwmWindow *t)
{
#ifndef NO_ICONS
  int test_x=0, test_y=0,tw,th,tx,ty,i,temp_h,temp_w;
  int base_x, base_y;
  int width,height;
  FvwmWindow *test_window;
  Bool loc_ok;
  int real_x=10, real_y=10;

  /* New! Put icon in same page as the center of the window */
  base_x=((t->frame_x+Scr.Vx+(t->frame_width>>1))/Scr.MyDisplayWidth)*
    Scr.MyDisplayWidth - Scr.Vx;
  base_y=((t->frame_y+Scr.Vy+(t->frame_height>>1))/Scr.MyDisplayHeight)*
    Scr.MyDisplayHeight - Scr.Vy;
  if(t->flags & ICON_MOVED)
    {
      /* just make sure the icon is on this screen */
      t->icon_x_loc = t->icon_x_loc % Scr.MyDisplayWidth + base_x;
      t->icon_y_loc = t->icon_y_loc % Scr.MyDisplayHeight + base_y;
      if(t->icon_x_loc < 0)
	t->icon_x_loc += Scr.MyDisplayWidth;
      if(t->icon_y_loc < 0)
	t->icon_y_loc += Scr.MyDisplayHeight;

    }
  else if (t->wmhints && t->wmhints->flags & IconPositionHint)
    {
      t->icon_x_loc = t->wmhints->icon_x;
      t->icon_y_loc = t->wmhints->icon_y;
    }
  else
    {
      width = t->icon_p_width;
      height = t->icon_w_height + t->icon_p_height;
      loc_ok = False;  
      
      /* check all boxes in order */
      i=0;
      while((i<Scr.NumBoxes)&&(!loc_ok))
	{
	  /* In each IconBox, start at the upper left, travel right, then
	   * down */
	  test_y = Scr.IconBoxes[i][1]+base_y;
	  
	  temp_h = height;
	  temp_w = width;
	  
	  /* OK second try at this.
	   * If the window is taller than the icon box, ignore the icon height
	   * when figuring where to put it. Same goes for the width */
	  /* This should permit reasonably graceful handling of big icons. */
	  if(width >= (Scr.IconBoxes[i][2] - Scr.IconBoxes[i][0]))
	    temp_w = 0;
	  if(height >= (Scr.IconBoxes[i][3] - Scr.IconBoxes[i][1]))
	    temp_h = 0;
	  
	  while(((test_y + temp_h) < (Scr.IconBoxes[i][3]+base_y))&&(!loc_ok))
	    {

	      test_x = Scr.IconBoxes[i][0]+base_x;
	      while(((test_x + temp_w) < (Scr.IconBoxes[i][2]+base_x))&&
		    (!loc_ok))
		{
		  real_x = test_x;
		  real_y = test_y;
		  
		  if(test_x + width > (Scr.MyDisplayWidth-2+base_x))
		    real_x = Scr.MyDisplayWidth - width -2 + base_x;
		  if(test_y + height > (Scr.MyDisplayHeight-2+base_y))
		    real_y = Scr.MyDisplayHeight - height -2+base_y;
		  if(test_x <base_x)
		    real_x = base_x;
		  if(test_y < base_y)
		    real_y = base_y;
		  loc_ok = True;
		  test_window = Scr.FvwmRoot.next;
		  while((test_window != (FvwmWindow *)0)&&(loc_ok == True))
		    {
		      if(test_window->Desk == Scr.CurrentDesk)
			{
			  if((test_window->flags&ICONIFIED)&&
			     (test_window->icon_w)&&
			     (test_window != t))
			    {
			      tw=test_window->icon_p_width;
			      th=test_window->icon_p_height+
				test_window->icon_w_height;
			      tx = test_window->icon_x_loc;
			      ty = test_window->icon_y_loc;
			  
			      if((tx<(real_x+width+3))&&((tx+tw+3) > real_x)&&
				 (ty<(real_y+height+3))&&((ty+th + 3)>real_y))
				{
				  loc_ok = False;
				}
			    }
			  if(Scr.flags & StubbornIconPlacement)
			    {
			      if(!(test_window->flags&ICONIFIED)&&
				 (test_window!=t))
				{
				  tw=test_window->frame_width;
				  th=test_window->frame_height;
				  tx = test_window->frame_x;
				  ty = test_window->frame_y;
			  
				  if((tx < (real_x+width+3))&&
				     ((tx+tw+3)>real_x)&&
				     (ty < (real_y+height+3))&&
				     ((ty+th+3)>real_y))
				    {
				      loc_ok = False;
				    }
				}
			    }
			}
		      test_window = test_window->next;
		    }
		  test_x +=3;
		}
	      test_y +=3;
	    }
	  i++;
	}
      if(loc_ok == False)
	return;
      t->icon_x_loc = real_x;
      t->icon_y_loc = real_y;
    }

  if(t->icon_pixmap_w)
    XMoveWindow(dpy,t->icon_pixmap_w,t->icon_x_loc, t->icon_y_loc);

  t->icon_w_width = t->icon_p_width;
  t->icon_xl_loc = t->icon_x_loc;

  XMoveResizeWindow(dpy, t->icon_w, t->icon_xl_loc,
		    t->icon_y_loc+t->icon_p_height, 
		    t->icon_w_width,ICON_HEIGHT);
#endif
}

/***********************************************************************
 *
 *  Procedure:
 *	GrabIconButtons - grab needed buttons for the icon window
 *
 *  Inputs:
 *	tmp_win - the fvwm window structure to use
 *
 ***********************************************************************/
void GrabIconButtons(FvwmWindow *tmp_win, Window w)
{
#ifndef NO_ICONS
  MouseButton *MouseEntry;

  MouseEntry = Scr.MouseButtonRoot;
  while(MouseEntry != (MouseButton *)0)
    {
      if((MouseEntry->func != (int)0)&&(MouseEntry->Context & C_ICON))
	{
	  if(MouseEntry->Button >0)
	    XGrabButton(dpy, MouseEntry->Button, MouseEntry->Modifier, w, 
			True, ButtonPressMask | ButtonReleaseMask,
			GrabModeAsync, GrabModeAsync, None, 
			Scr.FvwmCursors[DEFAULT]);
	  else
	    {
	      XGrabButton(dpy, 1, MouseEntry->Modifier, w,
			  True, ButtonPressMask | ButtonReleaseMask,
			  GrabModeAsync, GrabModeAsync, None, 
			  Scr.FvwmCursors[DEFAULT]);
	      XGrabButton(dpy, 2, MouseEntry->Modifier, w,
			  True, ButtonPressMask | ButtonReleaseMask,
			  GrabModeAsync, GrabModeAsync, None, 
			  Scr.FvwmCursors[DEFAULT]);
	      XGrabButton(dpy, 3, MouseEntry->Modifier, w,
			  True, ButtonPressMask | ButtonReleaseMask,
			  GrabModeAsync, GrabModeAsync, None, 
			  Scr.FvwmCursors[DEFAULT]);
	    }
	}
      
      MouseEntry = MouseEntry->NextButton;
    }
  return;
#endif
}



/***********************************************************************
 *
 *  Procedure:
 *	GrabIconKeys - grab needed keys for the icon window
 *
 *  Inputs:
 *	tmp_win - the fvwm window structure to use
 *
 ***********************************************************************/
void GrabIconKeys(FvwmWindow *tmp_win,Window w)
{
#ifndef NO_ICONS
  FuncKey *tmp;
  for (tmp = Scr.FuncKeyRoot.next; tmp != NULL; tmp = tmp->next)
    {
      if (tmp->cont & C_ICON)
	XGrabKey(dpy, tmp->keycode, tmp->mods, w, True,
		 GrabModeAsync, GrabModeAsync);
    }
  return;
#endif /* NO_ICONS*/
}


/****************************************************************************
 *
 * Find the specified icon file somewhere along the given path.
 *
 * There is a possible race condition here:  We check the file and later
 * do something with it.  By then, the file might not be accessible.
 * Oh well.
 *
 ****************************************************************************/
char *findIconFile(char *icon, char *pathlist, int type)
{
  char *path;
  char *dir_end;
  int l1,l2;

  if(icon != NULL)
    l1 = strlen(icon);
  else 
    l1 = 0;

  if(pathlist != NULL)
    l2 = strlen(pathlist);
  else
    l2 = 0;

  path = safemalloc(l1 + l2 + 5);
  *path = '\0';
  if (*icon == '/') 
    {
      /* No search if icon begins with a slash */
      strcpy(path, icon);
      return path;
    }
     
  if ((pathlist == NULL) || (*pathlist == '\0')) 
    {
      /* No search if pathlist is empty */
      strcpy(path, icon);
      return path;
    }
 
  /* Search each element of the pathlist for the icon file */
  while ((pathlist)&&(*pathlist))
    { 
      dir_end = strchr(pathlist, ':');
      if (dir_end != NULL)
	{
	  strncpy(path, pathlist, dir_end - pathlist);
	  path[dir_end - pathlist] = 0;
	}
      else 
	strcpy(path, pathlist);

      strcat(path, "/");
      strcat(path, icon);
      if (access(path, type) == 0) 
	return path;

      /* Point to next element of the path */
      if(dir_end == NULL)
	pathlist = NULL;
      else
	pathlist = dir_end + 1;
    }
  /* Hmm, couldn't find the file.  Return NULL */
  free(path);
  return NULL;
}
 

/****************************************************************************
 *
 * Looks for a monochrome icon bitmap file
 *
 ****************************************************************************/
void GetBitmapFile(FvwmWindow *tmp_win)
{
#ifndef NO_ICONS
  char *path = NULL;
  unsigned int HotX,HotY;
  extern char *IconPath;

  path = findIconFile(tmp_win->icon_bitmap_file, IconPath,R_OK);

  if(path == NULL)return;
  if(XReadBitmapFile (dpy, Scr.Root,path,&tmp_win->icon_p_width, 
		      &tmp_win->icon_p_height, &tmp_win->iconPixmap,
		      &HotX, &HotY) != BitmapSuccess)
    {
      tmp_win->icon_p_width = 0;
      tmp_win->icon_p_height = 0;
    }
    
  free(path);
#endif
}

/****************************************************************************
 *
 * Looks for a color XPM icon file
 *
 ****************************************************************************/
void GetXPMFile(FvwmWindow *tmp_win)
{
#ifndef NO_ICONS
#ifdef XPM
  XWindowAttributes root_attr;
  XpmAttributes xpm_attributes;
  extern char *PixmapPath;
  char *path = NULL;

  path = findIconFile(tmp_win->icon_bitmap_file, PixmapPath,R_OK);
  if(path == NULL)return;  

  XGetWindowAttributes(dpy,Scr.Root,&root_attr);
  xpm_attributes.colormap = root_attr.colormap;
  xpm_attributes.closeness = 40000; /* Allow for "similar" colors */
  xpm_attributes.valuemask = XpmSize | XpmReturnPixels | XpmColormap | XpmCloseness;

  if(XpmReadFileToPixmap(dpy, Scr.Root, path,
			 &tmp_win->iconPixmap, 
			 &tmp_win->icon_maskPixmap, 
			 &xpm_attributes) == XpmSuccess) 
    { 
      tmp_win->icon_p_width = xpm_attributes.width;
      tmp_win->icon_p_height = xpm_attributes.height;
      tmp_win->flags |= XPM_FLAG;
      tmp_win->flags |= PIXMAP_OURS;
      tmp_win->iconDepth = Scr.d_depth;
#ifdef SHAPE
      if (tmp_win->icon_maskPixmap)
	tmp_win->flags |= SHAPED_ICON;
#endif
    } 
  free(path);
#endif /* XPM */
#endif
}

/****************************************************************************
 *
 * Looks for an application supplied icon window
 *
 ****************************************************************************/
void GetIconWindow(FvwmWindow *tmp_win)
{
#ifndef NO_ICONS
  /* We are guaranteed that wmhints is non-null when calling this
   * routine */
  if(XGetGeometry(dpy,   tmp_win->wmhints->icon_window, &JunkRoot, 
		  &JunkX, &JunkY,(unsigned int *)&tmp_win->icon_p_width, 
		  (unsigned int *)&tmp_win->icon_p_height, 
		  &JunkBW, &JunkDepth)==0)
    {
      fprintf(stderr,"Help! Bad Icon Window!\n");
    }
  tmp_win->icon_p_width += JunkBW<<1;
  tmp_win->icon_p_height += JunkBW<<1;
  /*
   * Now make the new window the icon window for this window,
   * and set it up to work as such (select for key presses
   * and button presses/releases, set up the contexts for it,
   * and define the cursor for it).
   */
  tmp_win->icon_pixmap_w = tmp_win->wmhints->icon_window;
#ifdef SHAPE
  if (tmp_win->wmhints->flags & IconMaskHint)
    {
      tmp_win->flags |= SHAPED_ICON;
      tmp_win->icon_maskPixmap = tmp_win->wmhints->icon_mask;
    }
#endif
  /* Make sure that the window is a child of the root window ! */
  /* Olwais screws this up, maybe others do too! */
  XReparentWindow(dpy, tmp_win->icon_pixmap_w, Scr.Root, 0,0);
  tmp_win->flags &= ~ICON_OURS;
#endif /*NO_ICONS*/
}


/****************************************************************************
 *
 * Looks for an application supplied bitmap or pixmap
 *
 ****************************************************************************/
void GetIconBitmap(FvwmWindow *tmp_win)
{
#ifndef NO_ICONS
  /* We are guaranteed that wmhints is non-null when calling this
   * routine */
  XGetGeometry(dpy, tmp_win->wmhints->icon_pixmap, &JunkRoot, &JunkX, &JunkY,
	       (unsigned int *)&tmp_win->icon_p_width, 
	       (unsigned int *)&tmp_win->icon_p_height, &JunkBW, &JunkDepth);
  tmp_win->iconPixmap = tmp_win->wmhints->icon_pixmap;
  tmp_win->iconDepth = JunkDepth;
#ifdef SHAPE
  if (tmp_win->wmhints->flags & IconMaskHint)
    {
      tmp_win->flags |= SHAPED_ICON;
      tmp_win->icon_maskPixmap = tmp_win->wmhints->icon_mask;
    }
#endif
#endif
}
