/*
 *  binfile.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "ObjProArith/hrdarth.h"
#include "ObjProGen/errcode.h" 

class TargetNode ;

class BinaryFile {
protected:
	const char * file_name ;
	TargetNode * node ;
	enum data_word_type {mach_type=0,int8_type=1,int16_type=2,int32_type=3,
		float_type=4, double_type=5}  data_type ;

	char * delete_file_name ;
	char * exp_file_name ;
	int file ;
	ErrCode the_file_state ;
	int open_flag ;
	double double_read();
	void * direct_read();
	int no_conversion_mach ;
	int no_conversion_bin_mach ;
	double x_val_ptr ;
	char * val_ptr ;

	int bytes_per_word ;

public:
	BinaryFile(const char * file_name, TargetNode * node,int type);
	virtual ~BinaryFile();
	ErrCode file_state() const {return the_file_state;}
	int is_open() const {return open_flag;}
	const char * name() {return file_name;}
};

class BinaryInputFile : public BinaryFile {
	int32 skip ;
	ErrCode read_to_val_ptr();
	double case_read(const char * routine);
public:
	BinaryInputFile(const char * file_name, TargetNode * node,int type,
		int skip = 0);
	virtual ~BinaryInputFile();
	ErrCode open(int force_error=0);
	IntegerMachWord read_integer();
	MachWord read();
};

class BinaryOutputFile : public BinaryFile {
public:
	BinaryOutputFile(const char * file_name, TargetNode * node,int type);
	virtual ~BinaryOutputFile();
	ErrCode open(int force_error=0);
	void write_integer(IntegerMachWord w);
	void write(MachWord w);
};


