/*
 *  outfile.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "ObjProArith/hrdarth.h"
#include "ObjProDSP/portable.h"
#include "ObjProDSPcom/datfile.h"
#include "ObjProGen/errcode.h"
class OutputNode ;

class OutputFile {
	int TheFile ;
	const char * FileName ;
	OutputNode * TheNode ;
	int16 Channels ;
	int32 BlockSizeInWords ;
	int32 BlockSizeInBytes ;
	int HighestChannelToWrite ;
	int NextChannelToWrite ;
	long FirstDataSample ;
	long * LastWriteBlock ;
	long * SeekLastWordUpdate ;
	int16 * LastWriteWord ;
	int32 * ElementSize ;
	int16 WordSize ;
	MachWord ** Buffers ;
	MachWord * ZeroBuf ;
	int CreatedOk:1 ;
	int InDestructor:1 ;
	int FileInit:1 ;
	int initial_reset:1 ;
	char * delete_file_name ;
	char * exp_file_name ;

	int IsInDestructor() {return InDestructor;}
	int DoWrite(const void * Data, int Size, int BinaryFlag=0) ;
	int IncrementalWrite(const void * Data, int Size, int BinaryFlag=0) ;
	int PacketWrite(enum DataFileElements type,
		const void * Data, int Size) ;
	int UpdateChannel(int Channel) ;
	int DoFileInit() ;
	void WriteError();
	int WriteChannelHeader(int Channel);
	int CheckSeek(long DidSeek) ;
	int StringWrite(const char * TheString, int Length) ;
	ErrCode flush();
public:
	OutputFile(OutputNode * node, const char * Name);
	~OutputFile();
	int Write(MachWord Val, int Channel);
	int Write(BinMachWord Val, int Channel) ;
	int Write(MachWord * Ptr, int Size, int Channel);
	int Write(BinMachWord * Ptr, int Size, int Channel);
	int CreateOk() {return CreatedOk;}
	int32 LastWordIndex(int Channel) ;
	const char * GetFileName() {return FileName;}
	ErrCode Reset();
	ErrCode open(int inc_flag=0);
};

