/*
 *  integ.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef INTEG_DOT_H
#define INTEG_DOT_H
#define __DSP_PP_TARGET_CODE__

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProDSPcom/tarnod.h"
class Integrate: public TargetNode {
#line 43 "../integ.usr"
 
	int32 NumberOfOverflows ;
	double * Sums ;
	double total_samples;
	int NumberOutputSums ;
	int InitialOutput ; 
	int ArraySize ;
	int NextOut ;
	int32 ElementSize ;
	int first_index_used ;
	int last_index_used ;
	int32 need_new_index ;
	int size ;
	int skip_data ;
	void update_size();
	void ctor();
	void dtor();
	ErrCode kernel(int32 k);
#line 39 "/usrb/dist/ftp/opd-0.1/src/include/ObjProDSPtar/ObjProUsr/integ.h"
	int32  IntegrationSize_1;
	int32  OutputStep_2;
	double  Scale_3;
public:
	Integrate (const char * Name, int32 IntegrationSize, int32 OutputStep, 
		double Scale,
		DfNodeInLink* in_links, DfNodeOutLink* out_links,
		int ** exec_seq,  NodeExecuteType exec_type,
		int delay);
	virtual ~Integrate();
	int32 GetIntegrationSize() const {return IntegrationSize_1;}
	int32 GetOutputStep() const {return OutputStep_2;}
	double GetScale() const {return Scale_3;}
	virtual ErrCode DoNode(int32);
	void SetScale(double  Scale) { Scale_3 = Scale; parameter_changed(); }
};

extern Integrate * IntegrateDef;


#endif /* #ifdef INTEG_DOT_H */
