/*
 *  textrans.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef TEXTRANS_DOT_H
#define TEXTRANS_DOT_H

#include "ObjProGen/texutil.h"

struct TeXMathTranslation {
	char C ;
	const char * Translation ;
} ;

class TeXTranslate {
	const TeXMathTranslation * TeXMathTrans ;
	int CheckMacroTail ;
	char * Buffer ;
	int Size ;

	int BufferCount ;

	void ExpandBuffer();
	int RequireTranslate(const char * Text) ;
	int InList(char Check, const char * TheList);
	int IsSpecial(char Check) const {return IsTeXSpecial(Check);}
	int IsEscapable(char Check) const {return IsTeXEscapable(Check);}
	void ClearBuffer() {BufferCount = 0 ;}
	void AppendChar(char C);
	void Append(const char * str);
	const char * IsTeXMathTranslatable(char C);
public:
	TeXTranslate();
	const char * DoTeXTranslate(const char * Fragment) ;
	void ClearCheckTail() {CheckMacroTail=0;}
};

extern TeXTranslate TranslateToTeX ;

#endif /* #ifdef TEXTRANS_DOT_H */
