/*
 *  typout.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "typout.h"
#include <strstream.h>
#ifndef OVERFLOW
#include <complex.h>
#endif

#ifndef TI_C30
const TypeBufSize = 128 ;
static char TypeBuf[TypeBufSize]; 

#define CONVERT_TO_STRING(x)		\
	ostrstream Temp(TypeBuf,TypeBufSize-1);	\
	for (int i = 0 ; i < TypeBufSize;i++) TypeBuf[i] = '\0' ;			\
	Temp <<  x ;			\
	return TypeBuf 				\


const char * TypeToString(MachWord x)
{
	CONVERT_TO_STRING(x) ;
}

const char * TypeToString(AccMachWord x)
{
	CONVERT_TO_STRING(x) ;
}

const char * TypeToString(CxMachWord& x)
{
	complex z((double) MachReal(x),(double) MachImag(x)) ;
	CONVERT_TO_STRING(z) ;
}

const char * TypeToString(CxAccMachWord& x)
{
	complex z((double) MachReal(x),(double) MachImag(x)) ;
	CONVERT_TO_STRING(z) ;
}

const char * TypeToString(int16 x)
{
	CONVERT_TO_STRING(x) ;
}

const char * TypeToString(int32 x)
{
	CONVERT_TO_STRING(x) ;
}

const char * TypeToString(double x)
{
	CONVERT_TO_STRING(x) ;
}

const char * TypeToString(class complex& x)
{
	CONVERT_TO_STRING(x) ;
}

#endif
