/*
 *  net.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/net.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
static EntityList * NetworkNodeList = 0 ;
static InteractiveEntity * IntEntNetwork ;
void NetworkNodesInit();
Network::Network (const char * Name):
	ProcessNet(Name)
,
	do_not_redisplay(0)
{
	if (!NetworkNodeList) NetworkNodesInit() ;
	NetworkNodeList->Append(MakeDeclaredEntity(this, IntEntNetwork)) ;
	InitArithType(TheArithType);
	NewMenuItem("Network",GetName());
} // end constructor

Network::~Network()
{
	TheMenuServer->DeleteMenuItem("Network",GetName());
	NetworkNodeList->Delete(GetName()) ;
} // end destructor

int Network::CheckSafeDelete()
{
	int Safe_Check_Return = ProcessNet::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

const char * Network::EmitState(OutTokens& Out)
{
#line 656 "../net.usr"
  
	return ProcessNet::DoStateEmit(Out);
#line 54 "../net.C"
} // end state emit

Network * NetworkDef;

static UserEntity * MakeNetwork(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith = (ArithType::ArithCapabilities) TheArithType) ;
int Network::CppList(OutTokens& Out, CppListCmds Cmd)
{
	return IntEntNetwork->CppList(Out,Cmd,this);
}

void Network::Describe(OutTokens& Out, ListEntity Option)
{
	switch(Option) {
case ListSingleEntity:
		Out.NewLine();
		MakeNetwork(Out,EntityReqDescribeFull,*IntEntNetwork,TheArithType);
		Out.NewLine();
		Out.NextFillOut("There are no parameters for the constructor of this class.");
		Out.NewLine();
		break;
case ListEntityMembers:
		Out.NextOut(GetName());
		break;
case ListGlobalClasses:
case ListEntityClasses:
		break ;
case ListSetParameterValues:
		break;
	}
} // end  list entity switch

static ValueType * GraphDisplay(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("Member function");
		Out.NextQuoteOut("GraphDisplay");
		Out.NextFillOut("displays network topology.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		((Network * )This)->GraphDisplay(
		);		}
	}
	return 0;
}

static ValueType * Execute(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("Member function");
		Out.NextQuoteOut("Execute");
		Out.NextFillOut("executes this network.");
		Out.NextFillOut("It causes the first node in the network");
		Out.NextFillOut("to produce a specified number");
		Out.NextFillOut("of input blocks. Each node is executed for as many iterations");
		Out.NextFillOut("as possible given the available input data and output buffer");
		Out.NextFillOut("space. Execution halts when no node generates any new samples");
		Out.NextFillOut("after a complete pass throughout the network.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{		int32 InputSamples =
			Param->GetIntParameterValue("InputSamples");

		((Network * )This)->Execute(
		InputSamples);		}
	}
	return 0;
}

static ValueType * Raise(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextQuoteOut("Raise");
		Out.NextFillOut("will cause a window displaying this network to be raised");
		Out.NextFillOut("to the top level over any overlapping windows.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		((Network * )This)->Raise(
		);		}
	}
	return 0;
}

static ValueType * ReplaceNode(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextQuoteOut("ReplaceNode");
		Out.NextFillOut("will substitute node");
		Out.NextQuoteOut("Replacement");
		Out.NextFillOut("for node");
		Out.NextQuoteOut("ToReplace");
		Out.NextFillOut("in the network. The nodes must have the same number of input and");
		Out.NextFillOut("output channels and be compatible in all other respects. If an");
		Out.NextFillOut("error occurs the original node will remain in the network.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{		Node&ToReplace =
			(Node& )*(Node *)Param->GetEntityParameterValue("ToReplace");
		Node&Replacement =
			(Node& )*(Node *)Param->GetEntityParameterValue("Replacement");

		((Network * )This)->ReplaceNode(
		ToReplace, Replacement);		}
	}
	return 0;
}

static ValueType * MakeTarget(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("Member function");
		Out.NextQuoteOut("MakeTarget");
		Out.NextFillOut("will create source and executable");
		Out.NextFillOut("code for this network for a supported target.");
		Out.NextFillOut("See the description of parameter");
		Out.NextQuoteOut("Target");
		Out.NextFillOut("for a list of");
		Out.NextFillOut("the available targets. See parameter");
		Out.NextQuoteOut("Directory");
		Out.NextFillOut("for a description");
		Out.NextFillOut("of the files created.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{		const char * Target =
			Param->GetStringParameterValue("Target");
		int16 Create =
			Param->GetIntParameterValue("Create");
		const char * Directory =
			Param->GetStringParameterValue("Directory");

		((Network * )This)->MakeTarget(
		Target, Create, Directory);		}
	}
	return 0;
}

static ValueType * MakeValidate(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("Member function");
		Out.NextQuoteOut("MakeValidate");
		Out.NextFillOut("first replaces each display output");
		Out.NextFillOut("node in this network (such as plotting or listing nodes)");
		Out.NextFillOut("with an");
		Out.NextFillOut("`OutputNode'");
		Out.NextFillOutConcat(". This network is then saved to directory");
		Out.NextQuoteOut("DirName");
		Out.NextFillOutConcat(". Next the same nodes are replaced with a");
		Out.NextFillOut("`CompareDisk'");
		Out.NextFillOut("node. This new network is written to the same directory under");
		Out.NextFillOut("a different name. The first network saved state will include a");
		Out.NextFillOut("statement to");
		Out.NextFillOut("execute for");
		Out.NextQuoteOut("ExecuteCount");
		Out.NextFillOut("+");
		Out.NextQuoteOut("ExtraCountCreator");
		Out.NextFillOut("blocks of input.");
		Out.NextFillOut("The second network will execute for");
		Out.NextQuoteOut("ExecuteCount");
		Out.NextFillOut("blocks.");
		Out.NextFillOut("These networks");
		Out.NextFillOut("are used to generate baseline regression test data and");
		Out.NextFillOut("to run tests against this data.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{		const char * DirName =
			Param->GetStringParameterValue("DirName");
		int32 ExecuteCount =
			Param->GetIntParameterValue("ExecuteCount");
		int32 ExtraCountCreator =
			Param->GetIntParameterValue("ExtraCountCreator");
		int32 MaxReport =
			Param->GetIntParameterValue("MaxReport");
		double Tolerance =
			Param->GetFloatParameterValue("Tolerance");
		const char * errorFile =
			Param->GetStringParameterValue("errorFile");

		((Network * )This)->MakeValidate(
		DirName, ExecuteCount, ExtraCountCreator, MaxReport, Tolerance, errorFile);		}
	}
	return 0;
}

static ValueType * TargetValidate(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("Member function");
		Out.NextQuoteOut("TargetValidate");
		Out.NextFillOut("first replaces each display output");
		Out.NextFillOut("node in this network (such as plotting or listing nodes)");
		Out.NextFillOut("with an");
		Out.NextFillOut("`OutputNode'");
		Out.NextFillOutConcat(". This network is then used to generate");
		Out.NextFillOut("a target system in directory");
		Out.NextQuoteOut("DirName");
		Out.NextFillOutConcat("/create'. Next the");
		Out.NextFillOut("same nodes are replaced with a");
		Out.NextFillOut("`CompareDisk'");
		Out.NextFillOut("node. The code for this network is written to the directory");
		Out.NextQuoteOut("DirName");
		Out.NextFillOutConcat("/test.");
		Out.NextFillOut("Shell scripts will be written to directory");
		Out.NextQuoteOut("DirName");
		Out.NextFillOut("to execute");
		Out.NextFillOut("the networks for");
		Out.NextQuoteOut("ExecuteCount");
		Out.NextFillOut("blocks");
		Out.NextFillOut("(test network) and (");
		Out.NextFillOutConcat("ExecuteCount");
		Out.NextFillOut("+");
		Out.NextQuoteOut("ExtraCountCreator");
		Out.NextFillOutConcat(")");
		Out.NextFillOut("blocks (test data creation network).");
		Out.NextQuoteOut("DirName");
		Out.NextFillOut("will contain");
		Out.NextFillOut("all test data and error files and network state descriptions.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{		const char * Target =
			Param->GetStringParameterValue("Target");
		int16 Create =
			Param->GetIntParameterValue("Create");
		const char * DirName =
			Param->GetStringParameterValue("DirName");
		int32 ExecuteCount =
			Param->GetIntParameterValue("ExecuteCount");
		int32 ExtraCountCreator =
			Param->GetIntParameterValue("ExtraCountCreator");
		int32 MaxReport =
			Param->GetIntParameterValue("MaxReport");
		double Tolerance =
			Param->GetFloatParameterValue("Tolerance");
		const char * ErrorFile =
			Param->GetStringParameterValue("ErrorFile");

		((Network * )This)->TargetValidate(
		Target, Create, DirName, ExecuteCount, ExtraCountCreator, MaxReport, Tolerance, ErrorFile);		}
	}
	return 0;
}

static ValueType * SetTimingExact(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("If the timing analysis cannot resolve a network it may still");
		Out.NextFillOut("execute correctly. If");
		Out.NextQuoteOut("Exact");
		Out.NextFillOut("is one no attempt will be made to");
		Out.NextFillOut("execute the network. Instead an error will be generated. This is");
		Out.NextFillOut("usually set for for validation tests to make sure that timing");
		Out.NextFillOut("analysis errors are not overlooked.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{		int16 Exact =
			Param->GetIntParameterValue("Exact");

		((Network * )This)->SetTimingExact(
		Exact);		}
	}
	return 0;
}

static ValueType * ReplaceWithOutput(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("Member function");
		Out.NextQuoteOut("ReplaceWithOutput");
		Out.NextFillOut("replaces all plot and listing");
		Out.NextFillOut("nodes with a new output node with a name derived from the");
		Out.NextFillOut("node it is replacing. The file name is the same as the node name.");
		Out.NextFillOut("This is used to create regression tests.");
		Out.NextFillOut("First");
		Out.NextQuoteOut("ReplaceWithOutput");
		Out.NextFillOut("creates a network to generate test data. Then");
		Out.NextQuoteOut("ReplaceWithCompare");
		Out.NextFillOut("creates a network for running a regression");
		Out.NextFillOut("test against the data. All three networks should be saved in");
		Out.NextFillOut("separate state files.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		((Network * )This)->ReplaceWithOutput(
		);		}
	}
	return 0;
}

static ValueType * ReplaceWithCompare(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("Member function");
		Out.NextQuoteOut("ReplaceWithCompare");
		Out.NextFillOut("replaces each");
		Out.NextFillOut("`OutputNode'");
		Out.NextFillOut("in a network with a");
		Out.NextFillOut("`CompareDisk'");
		Out.NextFillOut("node. If an");
		Out.NextFillOut("`OutputNode'");
		Out.NextFillOut("has more than one input channel the operation will fail.");
		Out.NextFillOut("This is useful in converting a network used to generate");
		Out.NextFillOut("a regression test case to a network for running the");
		Out.NextFillOut("regression test. The new node name is created from");
		Out.NextFillOut("the node replaced. The file name is the output file");
		Out.NextFillOut("written by the node being replaced. The other parameters are set");
		Out.NextFillOut("to be the same as the corresponding parameters of this");
		Out.NextFillOut("function.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{		int32 MaxReport =
			Param->GetIntParameterValue("MaxReport");
		double Tolerance =
			Param->GetFloatParameterValue("Tolerance");
		const char * ErrorFile =
			Param->GetStringParameterValue("ErrorFile");

		((Network * )This)->ReplaceWithCompare(
		MaxReport, Tolerance, ErrorFile);		}
	}
	return 0;
}

static ValueType * Add_Op(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("The `+' operator appends its right operand (a signal");
		Out.NextFillOut("generation node)");
		Out.NextQuoteOut("TheNode");
		Out.NextFillOut("to its left operand (a data flow");
		Out.NextQuoteOut("Network");
		Out.NextFillOutConcat(").");
		Out.NewLine();

	break ;
case EntityReqCall:
		{		SignalStr&TheNode =
			(SignalStr& )*(SignalStr *)Param->GetEntityParameterValue("TheNode");

		ValueType * ValueTypeReturn = new ValueType(DecEnt,(UserEntity *)&((Network * )This)->operator+(
		TheNode));
		return ValueTypeReturn;
		}
	}
	return 0;
}

static ValueType * RightShift_Op(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("The `>>' operator appends its right operand (a processing");
		Out.NextFillOut("or signal generation node)");
		Out.NextQuoteOut("TheNode");
		Out.NextFillOut("to its left operand (a");
		Out.NextFillOut("`DataFlow'");
		Out.NextFillOut("Network).");
		Out.NewLine();

	break ;
case EntityReqCall:
		{		Node&TheNode =
			(Node& )*(Node *)Param->GetEntityParameterValue("TheNode");

		ValueType * ValueTypeReturn = new ValueType(DecEnt,(UserEntity *)&((Network * )This)->operator>>(
		TheNode));
		return ValueTypeReturn;
		}
	}
	return 0;
}

static ValueType * GraphDisplayWindow(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("Member function");
		Out.NextQuoteOut("GraphDisplay");
		Out.NextFillOut("displays the network topology.");
		Out.NextFillOut("In a window of up to");
		Out.NextQuoteOut("Width");
		Out.NextFillOut("x");
		Out.NextQuoteOut("Height");
		Out.NextFillOut("pixels.  The window");
		Out.NextFillOut("may start out smaller and grow larger as nodes are added");
		Out.NextFillOut("to it but it will not exceed these dimensions. (If needed");
		Out.NextFillOut("a vertical scrollbar will be added to the window.)");
		Out.NewLine();

	break ;
case EntityReqCall:
		{		int16 Width =
			Param->GetIntParameterValue("Width");
		int16 Height =
			Param->GetIntParameterValue("Height");

		((Network * )This)->GraphDisplayWindow(
		Width, Height);		}
	}
	return 0;
}

static ValueType * DisplayNames(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("Member function");
		Out.NextQuoteOut("DisplayNames");
		Out.NextFillOut("displays the names of the controller");
		Out.NextFillOut("and buffer descriptor for this node in the help window.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		((Network * )This)->DisplayNames(
		);		}
	}
	return 0;
}

static ValueType * SetBufferDescriptor(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextQuoteOut("SetBufferDescriptor");
		Out.NextFillOut("assigns descriptor");
		Out.NextQuoteOut("Descriptor");
		Out.NextFillOut("to this");
		Out.NextFillOut("network. The network need not be complete. No buffers are allocated.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{		BufferDescript&Descriptor =
			(BufferDescript& )*(BufferDescript *)Param->GetEntityParameterValue("Descriptor");

		((Network * )This)->SetBufferDescriptor(
		Descriptor);		}
	}
	return 0;
}

static ValueType * AssociateNode(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextQuoteOut("AssociateNode");
		Out.NextFillOut("associates node");
		Out.NextQuoteOut("TheNode");
		Out.NextFillOut("with this network. It does");
		Out.NextFillOut("not link the node into the network. Its only effect is to have the node");
		Out.NextFillOut("displayed in the window in which the network appears.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{		Node&TheNode =
			(Node& )*(Node *)Param->GetEntityParameterValue("TheNode");

		((Network * )This)->AssociateNode(
		TheNode);		}
	}
	return 0;
}

static ValueType * Link(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("In building a data flow topology network the connection operator");
		Out.NextFillOut("`>>' always links the output of the last node accessed (from");
		Out.NextFillOut("the network to the left of `>>') to the node on the right side of");
		Out.NextFillOut("`>>'. For simple linear networks this is adequate. For nodes");
		Out.NextFillOut("with more than one output");
		Out.NextFillOut("one must specify when to use channels other than 0 using");
		Out.NextQuoteOut("Link");
		Out.NextFillOutConcat(".");
		Out.NextQuoteOut("Link");
		Out.NextFillOut("causes the next link from the network to begin at the");
		Out.NextFillOut("specified");
		Out.NextQuoteOut("TheNode");
		Out.NextFillOut("and");
		Out.NextQuoteOut("OutChannel");
		Out.NextFillOutConcat(".");
		Out.NewLine();

	break ;
case EntityReqCall:
		{		Node&TheNode =
			(Node& )*(Node *)Param->GetEntityParameterValue("TheNode");
		int16 OutChannel =
			Param->GetIntParameterValue("OutChannel");

		ValueType * ValueTypeReturn = new ValueType(DecEnt,(UserEntity *)&((Network * )This)->Link(
		TheNode, OutChannel));
		return ValueTypeReturn;
		}
	}
	return 0;
}

static ValueType * SelfLink(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextQuoteOut("SelfLink");
		Out.NextFillOut("establishes a feedback link in a data flow");
		Out.NextFillOut("network. Input parameters include the source node and its output channel");
		Out.NextFillOut("and the destination node and its input channel.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{		Node&NodeOut =
			(Node& )*(Node *)Param->GetEntityParameterValue("NodeOut");
		Node&NodeIn =
			(Node& )*(Node *)Param->GetEntityParameterValue("NodeIn");
		int16 ChannelOut =
			Param->GetIntParameterValue("ChannelOut");
		int16 ChannelIn =
			Param->GetIntParameterValue("ChannelIn");

		ValueType * ValueTypeReturn = new ValueType(DecEnt,(UserEntity *)&((Network * )This)->SelfLink(
		NodeOut, NodeIn, ChannelOut, ChannelIn));
		return ValueTypeReturn;
		}
	}
	return 0;
}

static ValueType * AssignBuffers(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("Member function");
		Out.NextQuoteOut("AssignBuffers");
		Out.NextFillOut("buffers to a complete network.");
		Out.NextFillOut("Buffers will not be assigned if the network is not complete.");
		Out.NextQuoteOut("Descriptor");
		Out.NextFillOut("determines the buffer characteristics.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{		BufferDescript&Descriptor =
			(BufferDescript& )*(BufferDescript *)Param->GetEntityParameterValue("Descriptor");

		((Network * )This)->AssignBuffers(
		Descriptor);		}
	}
	return 0;
}

static ValueType * GetBufferDescriptor(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("Member function");
		Out.NextQuoteOut("GetBufferDescriptor");
		Out.NextFillOut("returns the buffer descriptor");
		Out.NextFillOut("associated with this network.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		ValueType * ValueTypeReturn = new ValueType(DecEnt,(UserEntity *)&((Network * )This)->GetBufferDescriptor(
		));
		return ValueTypeReturn;
		}
	}
	return 0;
}

static ValueType * ClearBuffers(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("You can not change the topology of a network while buffers are");
		Out.NextFillOut("assigned. Member function");
		Out.NextQuoteOut("ClearBuffers");
		Out.NextFillOut("removes all buffers");
		Out.NextFillOut("so that the network can be edited or different buffers assigned.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		((Network * )This)->ClearBuffers(
		);		}
	}
	return 0;
}

static ValueType * GetNetController(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("Member function");
		Out.NextQuoteOut("GetNetController");
		Out.NextFillOut("returns the network controller");
		Out.NextFillOut("associated with this network.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		ValueType * ValueTypeReturn = new ValueType(DecEnt,(UserEntity *)&((Network * )This)->GetNetController(
		));
		return ValueTypeReturn;
		}
	}
	return 0;
}

static ValueType * ClearNetwork(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("Member function");
		Out.NextQuoteOut("ClearNetwork");
		Out.NextFillOut("removes all links in the network");
		Out.NextFillOut("being controlled. The nodes freed in this way can then be used");
		Out.NextFillOut("in a different network.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		((Network * )This)->ClearNetwork(
		);		}
	}
	return 0;
}

void NetworkNodesInit()
{
	if (NetworkNodeList)  return ;

	static StringParam NetworkNameParam =
		{"Network", MakeNewEntityName, 0, LegalEntityName};

	static OneParameter NetworkParArray[] = {
		{"Name", 0, "node name", 0, 0, &NetworkNameParam},
		{0}
	};

	static OneParameter GraphDisplayNetworkList[] = {
		{0}
	};
	UserParameters * GraphDisplayMemberParam = new UserParameters
		(GraphDisplayNetworkList);

	Procedure * MemberProcGraphDisplay = new Procedure("GraphDisplay", GraphDisplay,
		GraphDisplayMemberParam, "void", 0, "display network topology");
	static IntParam NetworkExecuteInputSamplesParam = {
		 128, 0,  0,  1, 0, 2147483647};
	static OneParameter ExecuteNetworkList[] = {
		{"InputSamples", 0, "input samples to process"
			, &NetworkExecuteInputSamplesParam},
		{0}
	};
	UserParameters * ExecuteMemberParam = new UserParameters
		(ExecuteNetworkList);

	Procedure * MemberProcExecute = new Procedure("Execute", Execute,
		ExecuteMemberParam, "void", 0, "execute network generating the specified number of samples");
	static OneParameter RaiseNetworkList[] = {
		{0}
	};
	UserParameters * RaiseMemberParam = new UserParameters
		(RaiseNetworkList);

	Procedure * MemberProcRaise = new Procedure("Raise", Raise,
		RaiseMemberParam, "void", 0, "raise a window containing this network display");
	static EntityParam NetworkReplaceNodeToReplaceParam = {
		0, "Node&", 0, 0, DefaultNotLegal};
	static EntityParam NetworkReplaceNodeReplacementParam = {
		0, "Node&", 0, 0, DefaultNotLegal};
	static OneParameter ReplaceNodeNetworkList[] = {
		{"ToReplace", 0, "node to replace"
			, 0, 0, 0, &NetworkReplaceNodeToReplaceParam},
		{"Replacement", 0, "node to replace"
			, 0, 0, 0, &NetworkReplaceNodeReplacementParam},
		{0}
	};
	UserParameters * ReplaceNodeMemberParam = new UserParameters
		(ReplaceNodeNetworkList);

	Procedure * MemberProcReplaceNode = new Procedure("ReplaceNode", ReplaceNode,
		ReplaceNodeMemberParam, "void", 0, "replace a single node in a network");
	static StringParam NetworkMakeTargetTargetParam = {
		 "generic_cpp", 0, 0};
	static IntParam NetworkMakeTargetCreateParam = {
		 1, 0,  0,  0,  0,  1};
	static StringParam NetworkMakeTargetDirectoryParam = {
		 0, 0, 0};
	static OneParameter MakeTargetNetworkList[] = {
		{"Target", 0, "target processor"
			, 0, 0, &NetworkMakeTargetTargetParam, 0, 0, 1},
		{"Create", 0, "create executable flag"
			, &NetworkMakeTargetCreateParam, 0, 0, 0, 0, 1},
		{"Directory", 0, "directory of created files"
			, 0, 0, &NetworkMakeTargetDirectoryParam, 0, 0, 1},
		{0}
	};
	UserParameters * MakeTargetMemberParam = new UserParameters
		(MakeTargetNetworkList);

	Procedure * MemberProcMakeTarget = new Procedure("MakeTarget", MakeTarget,
		MakeTargetMemberParam, "void", 0, "create target processor code for this network");
	static StringParam NetworkMakeValidateDirNameParam = {
		 0, 0, 0};
	static IntParam NetworkMakeValidateExecuteCountParam = {
		 8192, 0,  0,  1, 0, 2147483647};
	static IntParam NetworkMakeValidateExtraCountCreatorParam = {
		 2048, 0,  0,  1, 0, 2147483647};
	static IntParam NetworkMakeValidateMaxReportParam = {
		 1000, 0,  0,  1, 0, 2147483647};
	static FloatParam NetworkMakeValidateToleranceParam = {
		 0.0, 0,  0,  0.0, 0, 1e+100};
	static StringParam NetworkMakeValidateerrorFileParam = {
		 0, 0, 0};
	static OneParameter MakeValidateNetworkList[] = {
		{"DirName", 0, "directory to place validation files"
			, 0, 0, &NetworkMakeValidateDirNameParam, 0, 0, 1},
		{"ExecuteCount", 0, "number of inputs to execute for"
			, &NetworkMakeValidateExecuteCountParam, 0, 0, 0, 0, 1},
		{"ExtraCountCreator", 0, "number of additional inputs to create data"
			, &NetworkMakeValidateExtraCountCreatorParam, 0, 0, 0, 0, 1},
		{"MaxReport", 0, "maximum number of errors to report"
			, &NetworkMakeValidateMaxReportParam, 0, 0, 0, 0, 1},
		{"Tolerance", 0, "absolute value of minimum difference for an error"
			, 0, &NetworkMakeValidateToleranceParam, 0, 0, 0, 1},
		{"errorFile", 0, "if set errors will be written to this file"
			, 0, 0, &NetworkMakeValidateerrorFileParam, 0, 0, 1},
		{0}
	};
	UserParameters * MakeValidateMemberParam = new UserParameters
		(MakeValidateNetworkList);

	Procedure * MemberProcMakeValidate = new Procedure("MakeValidate", MakeValidate,
		MakeValidateMemberParam, "void", 0, "create a validation test case from this network");
	static StringParam NetworkTargetValidateTargetParam = {
		 "generic_cpp", 0, 0};
	static IntParam NetworkTargetValidateCreateParam = {
		 0, 0,  0,  0,  0,  1};
	static StringParam NetworkTargetValidateDirNameParam = {
		 0, 0, 0};
	static IntParam NetworkTargetValidateExecuteCountParam = {
		 8192, 0,  0,  1, 0, 2147483647};
	static IntParam NetworkTargetValidateExtraCountCreatorParam = {
		 2048, 0,  0,  1, 0, 2147483647};
	static IntParam NetworkTargetValidateMaxReportParam = {
		 1000, 0,  0,  1, 0, 2147483647};
	static FloatParam NetworkTargetValidateToleranceParam = {
		 0.0, 0,  0,  0.0, 0, 1e+100};
	static StringParam NetworkTargetValidateErrorFileParam = {
		 0, 0, 0};
	static OneParameter TargetValidateNetworkList[] = {
		{"Target", 0, "target processor"
			, 0, 0, &NetworkTargetValidateTargetParam, 0, 0, 1},
		{"Create", 0, "create executable flag"
			, &NetworkTargetValidateCreateParam, 0, 0, 0, 0, 1},
		{"DirName", 0, "directories to place validation files"
			, 0, 0, &NetworkTargetValidateDirNameParam, 0, 0, 1},
		{"ExecuteCount", 0, "number of inputs to execute for"
			, &NetworkTargetValidateExecuteCountParam, 0, 0, 0, 0, 1},
		{"ExtraCountCreator", 0, "number of additional inputs to create data"
			, &NetworkTargetValidateExtraCountCreatorParam, 0, 0, 0, 0, 1},
		{"MaxReport", 0, "maximum number of errors to report"
			, &NetworkTargetValidateMaxReportParam, 0, 0, 0, 0, 1},
		{"Tolerance", 0, "absolute value of minimum difference for an error"
			, 0, &NetworkTargetValidateToleranceParam, 0, 0, 0, 1},
		{"ErrorFile", 0, "if set errors will be written to this file"
			, 0, 0, &NetworkTargetValidateErrorFileParam, 0, 0, 1},
		{0}
	};
	UserParameters * TargetValidateMemberParam = new UserParameters
		(TargetValidateNetworkList);

	Procedure * MemberProcTargetValidate = new Procedure("TargetValidate", TargetValidate,
		TargetValidateMemberParam, "void", 0, "create a target validation test case from this network");
	static IntParam NetworkSetTimingExactExactParam = {
		 0, 0,  0,  0,  0,  1};
	static OneParameter SetTimingExactNetworkList[] = {
		{"Exact", 0, "timing constraints loose(0) or exact(1)"
			, &NetworkSetTimingExactExactParam},
		{0}
	};
	UserParameters * SetTimingExactMemberParam = new UserParameters
		(SetTimingExactNetworkList);

	Procedure * MemberProcSetTimingExact = new Procedure("SetTimingExact", SetTimingExact,
		SetTimingExactMemberParam, "void", 0, "set exact or loose timing constraints");
	static OneParameter ReplaceWithOutputNetworkList[] = {
		{0}
	};
	UserParameters * ReplaceWithOutputMemberParam = new UserParameters
		(ReplaceWithOutputNetworkList);

	Procedure * MemberProcReplaceWithOutput = new Procedure("ReplaceWithOutput", ReplaceWithOutput,
		ReplaceWithOutputMemberParam, "void", 0, "replaces plot and listing nodes with an `OutputNode'");
	static IntParam NetworkReplaceWithCompareMaxReportParam = {
		 1000, 0,  0,  1, 0, 2147483647};
	static FloatParam NetworkReplaceWithCompareToleranceParam = {
		 0.0, 0,  0,  0.0, 0, 1e+100};
	static StringParam NetworkReplaceWithCompareErrorFileParam = {
		 0, 0, 0};
	static OneParameter ReplaceWithCompareNetworkList[] = {
		{"MaxReport", 0, "maximum number of errors to report"
			, &NetworkReplaceWithCompareMaxReportParam, 0, 0, 0, 0, 1},
		{"Tolerance", 0, "absolute value of minimum difference for an error"
			, 0, &NetworkReplaceWithCompareToleranceParam, 0, 0, 0, 1},
		{"ErrorFile", 0, "if set errors will be written to this file"
			, 0, 0, &NetworkReplaceWithCompareErrorFileParam, 0, 0, 1},
		{0}
	};
	UserParameters * ReplaceWithCompareMemberParam = new UserParameters
		(ReplaceWithCompareNetworkList);

	Procedure * MemberProcReplaceWithCompare = new Procedure("ReplaceWithCompare", ReplaceWithCompare,
		ReplaceWithCompareMemberParam, "void", 0, "replace each `OutputNode' with a `Compare' node");
	static EntityParam NetworkAdd_OpTheNodeParam = {
		 "CosDef", "SignalStr&", 0, 0};
	static OneParameter Add_OpNetworkList[] = {
		{"TheNode", 0, "node to append to"
			, 0, 0, 0, &NetworkAdd_OpTheNodeParam},
		{0}
	};
	UserParameters * Add_OpMemberParam = new UserParameters
		(Add_OpNetworkList);

	Procedure * MemberProcAdd_Op = new Procedure("operator+", Add_Op,
		Add_OpMemberParam, "Network&", 0, "the `+' operator adds a thread to a `Network");
	static EntityParam NetworkRightShift_OpTheNodeParam = {
		 "GainDef", "Node&", 0, 0};
	static OneParameter RightShift_OpNetworkList[] = {
		{"TheNode", 0, "node to append to"
			, 0, 0, 0, &NetworkRightShift_OpTheNodeParam},
		{0}
	};
	UserParameters * RightShift_OpMemberParam = new UserParameters
		(RightShift_OpNetworkList);

	Procedure * MemberProcRightShift_Op = new Procedure("operator>>", RightShift_Op,
		RightShift_OpMemberParam, "Network&", 0, "operator>> appends a node to a network");
	static IntParam NetworkGraphDisplayWindowWidthParam = {
		 550, 0,  0,  150,  0,  2048};
	static IntParam NetworkGraphDisplayWindowHeightParam = {
		 700, 0,  0,  150,  0,  2048};
	static OneParameter GraphDisplayWindowNetworkList[] = {
		{"Width", 0, "maximum width in pixels of display"
			, &NetworkGraphDisplayWindowWidthParam},
		{"Height", 0, "maximum height in pixels of display"
			, &NetworkGraphDisplayWindowHeightParam},
		{0}
	};
	UserParameters * GraphDisplayWindowMemberParam = new UserParameters
		(GraphDisplayWindowNetworkList);

	Procedure * MemberProcGraphDisplayWindow = new Procedure("GraphDisplayWindow", GraphDisplayWindow,
		GraphDisplayWindowMemberParam, "void", 0, "display network topology in a specified window size");
	static OneParameter DisplayNamesNetworkList[] = {
		{0}
	};
	UserParameters * DisplayNamesMemberParam = new UserParameters
		(DisplayNamesNetworkList);

	Procedure * MemberProcDisplayNames = new Procedure("DisplayNames", DisplayNames,
		DisplayNamesMemberParam, "void", 0, "display the name of the controller and buffer descriptor");
	static EntityParam NetworkSetBufferDescriptorDescriptorParam = {
		 "CircBufDesDef", "BufferDescript&", 0, 0};
	static OneParameter SetBufferDescriptorNetworkList[] = {
		{"Descriptor", 0, "buffer characteristics"
			, 0, 0, 0, &NetworkSetBufferDescriptorDescriptorParam},
		{0}
	};
	UserParameters * SetBufferDescriptorMemberParam = new UserParameters
		(SetBufferDescriptorNetworkList);

	Procedure * MemberProcSetBufferDescriptor = new Procedure("SetBufferDescriptor", SetBufferDescriptor,
		SetBufferDescriptorMemberParam, "void", 0, "assign a buffer descriptor to this network");
	static EntityParam NetworkAssociateNodeTheNodeParam = {
		0, "Node&", 0, 0, DefaultNotLegal};
	static OneParameter AssociateNodeNetworkList[] = {
		{"TheNode", 0, "node to associate with this network"
			, 0, 0, 0, &NetworkAssociateNodeTheNodeParam},
		{0}
	};
	UserParameters * AssociateNodeMemberParam = new UserParameters
		(AssociateNodeNetworkList);

	Procedure * MemberProcAssociateNode = new Procedure("AssociateNode", AssociateNode,
		AssociateNodeMemberParam, "void", 0, "put this node in this networks display window");
	static EntityParam NetworkLinkTheNodeParam = {
		0, "Node&", 0, 0, GetFreeNodeOut};
	static IntParam NetworkLinkOutChannelParam = {
		 0, 0,  0,  0, 0, 32767};
	static OneParameter LinkNetworkList[] = {
		{"TheNode", 0, "processing or signal generator to link to"
			, 0, 0, 0, &NetworkLinkTheNodeParam},
		{"OutChannel", 0, "output channel of selected node to link to"
			, &NetworkLinkOutChannelParam, 0, 0, 0, 0, 1},
		{0}
	};
	UserParameters * LinkMemberParam = new UserParameters
		(LinkNetworkList);

	Procedure * MemberProcLink = new Procedure("Link", Link,
		LinkMemberParam, "Network&", 0, "make next link in network from specified node and channel");
	static EntityParam NetworkSelfLinkNodeOutParam = {
		0, "Node&", 0, 0, GetFreeNodeOut};
	static EntityParam NetworkSelfLinkNodeInParam = {
		0, "Node&", 0, 0, GetFreeNodeIn};
	static IntParam NetworkSelfLinkChannelOutParam = {
		 0, 0,  0,  0, 0, 32767};
	static IntParam NetworkSelfLinkChannelInParam = {
		 1, 0,  0,  0, 0, 32767};
	static OneParameter SelfLinkNetworkList[] = {
		{"NodeOut", 0, "node to link from"
			, 0, 0, 0, &NetworkSelfLinkNodeOutParam},
		{"NodeIn", 0, "node to link to"
			, 0, 0, 0, &NetworkSelfLinkNodeInParam},
		{"ChannelOut", 0, "output channel of output node to link from"
			, &NetworkSelfLinkChannelOutParam, 0, 0, 0, 0, 1},
		{"ChannelIn", 0, "input channel to link to"
			, &NetworkSelfLinkChannelInParam, 0, 0, 0, 0, 1},
		{0}
	};
	UserParameters * SelfLinkMemberParam = new UserParameters
		(SelfLinkNetworkList);

	Procedure * MemberProcSelfLink = new Procedure("SelfLink", SelfLink,
		SelfLinkMemberParam, "Network&", 0, "establish a feedback link in a data flow network");
	static EntityParam NetworkAssignBuffersDescriptorParam = {
		 "CircBufDesDef", "BufferDescript&", 0, 0};
	static OneParameter AssignBuffersNetworkList[] = {
		{"Descriptor", 0, "specify buffer characteristics"
			, 0, 0, 0, &NetworkAssignBuffersDescriptorParam},
		{0}
	};
	UserParameters * AssignBuffersMemberParam = new UserParameters
		(AssignBuffersNetworkList);

	Procedure * MemberProcAssignBuffers = new Procedure("AssignBuffers", AssignBuffers,
		AssignBuffersMemberParam, "void", 0, "assign buffers to a completely defined network");
	static OneParameter GetBufferDescriptorNetworkList[] = {
		{0}
	};
	UserParameters * GetBufferDescriptorMemberParam = new UserParameters
		(GetBufferDescriptorNetworkList);

	Procedure * MemberProcGetBufferDescriptor = new Procedure("GetBufferDescriptor", GetBufferDescriptor,
		GetBufferDescriptorMemberParam, "BufferDescript&", 0, "get the buffer descriptor associated with this network");
	static OneParameter ClearBuffersNetworkList[] = {
		{0}
	};
	UserParameters * ClearBuffersMemberParam = new UserParameters
		(ClearBuffersNetworkList);

	Procedure * MemberProcClearBuffers = new Procedure("ClearBuffers", ClearBuffers,
		ClearBuffersMemberParam, "void", 0, "remove all buffers from network");
	static OneParameter GetNetControllerNetworkList[] = {
		{0}
	};
	UserParameters * GetNetControllerMemberParam = new UserParameters
		(GetNetControllerNetworkList);

	Procedure * MemberProcGetNetController = new Procedure("GetNetController", GetNetController,
		GetNetControllerMemberParam, "NetControl&", 0, "get the network controller associated with this network");
	static OneParameter ClearNetworkNetworkList[] = {
		{0}
	};
	UserParameters * ClearNetworkMemberParam = new UserParameters
		(ClearNetworkNetworkList);

	Procedure * MemberProcClearNetwork = new Procedure("ClearNetwork", ClearNetwork,
		ClearNetworkMemberParam, "void", 0, "delete all network links");
static ValueType * NetworkMembers[24] ;
	int ii = 0 ;
	NetworkMembers[ii++] = new ValueType(DecProcedure, MemberProcGraphDisplay) ;
	NetworkMembers[ii++] = new ValueType(DecProcedure, MemberProcExecute) ;
	NetworkMembers[ii++] = new ValueType(DecProcedure, MemberProcRaise) ;
	NetworkMembers[ii++] = new ValueType(DecProcedure, MemberProcReplaceNode) ;
	NetworkMembers[ii++] = new ValueType(DecProcedure, MemberProcMakeTarget) ;
	NetworkMembers[ii++] = new ValueType(DecProcedure, MemberProcMakeValidate) ;
	NetworkMembers[ii++] = new ValueType(DecProcedure, MemberProcTargetValidate) ;
	NetworkMembers[ii++] = new ValueType(DecProcedure, MemberProcSetTimingExact) ;
	NetworkMembers[ii++] = new ValueType(DecProcedure, MemberProcReplaceWithOutput) ;
	NetworkMembers[ii++] = new ValueType(DecProcedure, MemberProcReplaceWithCompare) ;
	NetworkMembers[ii++] = new ValueType(DecProcedure, MemberProcAdd_Op) ;
	NetworkMembers[ii++] = new ValueType(DecProcedure, MemberProcRightShift_Op) ;
	NetworkMembers[ii++] = new ValueType(DecProcedure, MemberProcGraphDisplayWindow) ;
	NetworkMembers[ii++] = new ValueType(DecProcedure, MemberProcDisplayNames) ;
	NetworkMembers[ii++] = new ValueType(DecProcedure, MemberProcSetBufferDescriptor) ;
	NetworkMembers[ii++] = new ValueType(DecProcedure, MemberProcAssociateNode) ;
	NetworkMembers[ii++] = new ValueType(DecProcedure, MemberProcLink) ;
	NetworkMembers[ii++] = new ValueType(DecProcedure, MemberProcSelfLink) ;
	NetworkMembers[ii++] = new ValueType(DecProcedure, MemberProcAssignBuffers) ;
	NetworkMembers[ii++] = new ValueType(DecProcedure, MemberProcGetBufferDescriptor) ;
	NetworkMembers[ii++] = new ValueType(DecProcedure, MemberProcClearBuffers) ;
	NetworkMembers[ii++] = new ValueType(DecProcedure, MemberProcGetNetController) ;
	NetworkMembers[ii++] = new ValueType(DecProcedure, MemberProcClearNetwork) ;
	NetworkMembers[ii++] = 0 ;
	NetworkNodeList = new EntityList;
	IntEntNetwork = new InteractiveEntity("Network", NetworkNodeList,
		MakeNetwork, InteractiveScheduler, "net.h",
		NetworkMembers, "ProcessNet");
	IntEntNetwork->SetParameters(new UserParameters(NetworkParArray));
	TheNodes->Append(IntEntNetwork);
} // end initalization

static UserEntity * MakeNetwork(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith)
{
	switch(Request) {
case EntityReqDescribe:

case EntityReqDescribeFull:
		Out.NextQuoteOut("Network");
		Out.NextFillOut("is the class that allows you to combine");
		Out.NextFillOut("nodes to form a DSP process. Member functions allow you");
		Out.NextFillOut("to add threads (`operator+') and add nodes (`operator>>').");
		Out.NextFillOut("It is easiest to use these functions by editing a network");
		Out.NextFillOut("graphically. There are other member functions for editing");
		Out.NextFillOut("and manipulating networks. Most of these can also be called");
		Out.NextFillOut("by graphically editing a network. Member function");
		Out.NextQuoteOut("Execute");
		Out.NextFillOut("executes a network for a specified number of input blocks.");
		Out.NextFillOut("It can only be accesses from the menu data base.");
		Out.NewLine();
		break;

case EntityReqCreate:
	{
		const char * Name = IntNode.GetStringParameterValue("Name");
		return new Network(Name);

	}
	}
	return 0;
}

static InitObj LocalInit(NetworkNodesInit, "Network", "ProcessNet");

