/*
 *  tarbuf.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "netlnk.h"

void TargetNode::WriteCxWord (CxMachWord Data, int OutChannel)
{
	if (!CkOut(OutChannel,"WriteCxWord") ) return;
	OutLinks[OutChannel].WriteCxWord(Data) ;
}

CxMachWord TargetNode::ReadCxWord ( int InChannel)
{
	if (!CkIn(InChannel,"WriteCxWord")) return 0;
	return InLinks[InChannel].ReadCxWord() ;
}

int TargetNode::GetContiguousSpace (int OutChannel) const
{
	if (!CkOut(OutChannel,"GetContiguousSpace")) return 0;
	return OutLinks[OutChannel].GetContiguousSpace() ;
}

int TargetNode::GetSpace (int OutChannel) const
{
	if (!CkOut(OutChannel,"GetSpace")) return 0;
	return OutLinks[OutChannel].GetSpace() ;
}

void TargetNode::WriteBinary (BinMachWord Data, int OutChannel)
{
	if (!CkOut(OutChannel,"WriteBinary")) return;
	OutLinks[OutChannel].WriteBinary(Data) ;
}

void TargetNode::WriteWord (MachWord Data, int OutChannel)
{
	if (!CkOut(OutChannel,"WriteWord")) return;
	OutLinks[OutChannel].WriteWord(Data) ;
}

int TargetNode::GetContiguousAvailableData ( int InChannel) const
{
	if (!CkIn(InChannel,"GetContiguousAvailableData")) return 0;
	return InLinks[InChannel].GetContiguousAvailableData() ;
}

int TargetNode::GetAvailableData ( int InChannel) const
{
	if (!CkIn(InChannel,"GetAvailableData")) return 0;
	return InLinks[InChannel].GetAvailableData() ;
}

BinMachWord TargetNode::ReadBinary ( int InChannel)
{
	if (!CkIn(InChannel,"ReadBinary")) return (int16) 0;
	return InLinks[InChannel].ReadBinary() ;
}

MachWord TargetNode::ReadWord ( int InChannel)
{
	if (!CkIn(InChannel,"ReadWord")) return (int16) 0;
	return InLinks[InChannel].ReadWord() ;
}

void TargetNode::UpdateRead(int32 Size, int chan)
					// Add Size words to read pointer
{
	if(!CkIn(chan,"UpdateRead")) return ;
	InLinks[chan].UpdateRead(Size) ;
}

void TargetNode::UpdateWrite(int32 Size, int chan)
					// Add Size words to write pointer
{
	if(!CkOut(chan,"UpdateWrite")) return;
	OutLinks[chan].UpdateWrite(Size) ;
}

const MachWord * TargetNode::GetReadPtr(int chan) const
{
	if (!CkIn(chan,"GetReadPtr")) return 0;
	return InLinks[chan].GetReadPtr() ;
}

MachWord * TargetNode::GetWritePtr(int chan)  const
{
	if(!CkOut(chan,"GetWritePtr")) return 0;
	return OutLinks[chan].GetWritePtr() ;
}

const MachWord * TargetNode::GetReadBase(int chan) const
{
	if(!CkIn(chan,"GetReadBase")) return 0;
	return InLinks[chan].GetReadBase() ;
}

const MachWord * TargetNode::GetReadEnd(int chan) const
{
	if(!CkIn(chan,"GetReadEnd")) return 0;
	return InLinks[chan].GetReadEnd() ;
}

MachWord * TargetNode::GetWriteBase(int chan) const
{
	if(!CkOut(chan,"GetWriteBase")) return 0;
	return OutLinks[chan].GetWriteBase() ;
}

MachWord * TargetNode::GetWriteEnd(int chan) const
{
	if(!CkOut(chan,"GetWriteEnd")) return 0;
	return OutLinks[chan].GetWriteEnd() ;
}

