/*
 *  dylist.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <complex.h>
#include <stream.h>
#include "ObjProArith/hrdarth.h"
#include "ObjProComGui/cgidbg.h"
#include "ObjProDSPcom/disphnd.h"
#include "ObjProGui/sigintfc.h"
#include "ObjProGui/dyntextd.h"
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/dylist.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
static EntityList * ListingNodeList = 0 ;
static InteractiveEntity * IntEntListing ;
void ListingNodesInit();
Listing::Listing (const char * Name, int16 Hex, const char * Caption):
	DisplayNodeStr(Name, 1, 1, 
	 new StreamStr(SizeVariable , SizeVariable , ArithType::ArithCapabilityAny), TimingTypeLinear)
,
	Hex_1(Hex),
	Caption_2(Caption)
{
	if (!ListingNodeList) ListingNodesInit() ;
	ListingNodeList->Append(MakeDeclaredEntity(this, IntEntListing)) ;
	InitArithType(TheArithType);
	NewMenuItem("Listing",GetName());
#line 67 "../dylist.usr"
 
#ifdef INTERACTIVE
	set_delete_if_unlinked();
#endif
	ConstructorKernel();
#line 49 "../dylist.C"
} // end constructor

ErrCode Listing::EmitStaticCtorParameters(OutTokens& Out)
{
	ostream& Outs = *(Out.GetStream());
	Outs << ",\n\tListingStaticInitinteger_read_flag_" << GetName() << "";
	return OK;
}

ErrCode Listing::EmitStaticInit(OutTokens& Out)
{
	ostream& Outs = *(Out.GetStream());
	Outs << "static int ListingStaticInitinteger_read_flag_" << GetName() << " = ";	
	OutStringStaticValue(Outs,"int", &(integer_read_flag)) ;

	Outs << ";\n";
	return OK;
}

Listing::~Listing()
{
	TheMenuServer->DeleteMenuItem("Listing",GetName());
	ListingNodeList->Delete(GetName()) ;
#line 74 "../dylist.usr"
 
#line 75 "../dylist.C"
} // end destructor

int Listing::CheckSafeDelete()
{
	int Safe_Check_Return = DfNode::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

double Listing::TimeFirst( DfNodeInLink * , DfNodeOutLink * )
{
#line 96 "../dylist.usr"
	return 0.0;
	// timing is irrelevant for a node with no output channels
#line 90 "../dylist.C"
} // end timing code

Listing * ListingDef;

ErrCode Listing::DoNode(int32 k)
{
#line 100 "../dylist.usr"
 
	return Kernel(k);
#line 100 "../dylist.C"
} // end kernel code

static UserEntity * MakeListing(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith = (ArithType::ArithCapabilities) TheArithType) ;
int Listing::CppList(OutTokens& Out, CppListCmds Cmd)
{
	return IntEntListing->CppList(Out,Cmd,this);
}

void Listing::Describe(OutTokens& Out, ListEntity Option)
{
	switch(Option) {
case ListSingleEntity:
		Out.NewLine();
		MakeListing(Out,EntityReqDescribeFull,*IntEntListing,TheArithType);
		Out.NewLine();
		Out.NextQuoteOut("Hex");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetHex()));
		Out.NextFillOut(")");
		Out.NextFillOutConcat(", when set, displays  data in hexadecimal format.");
		Out.NextFillOut("If a value will not fit in a 32 bit integer it");
		Out.NextFillOut("is hard limited.");
		Out.NextQuoteOut("Caption");
		Out.NextQuoteOut(GetCaption());
		Out.NextFillOut("specifies a caption that will appear at the");
		Out.NextFillOut("head of the listing. If no caption is specified");
		Out.NextFillOut("(default 0) then the node name will be used. The");
		Out.NextFillOut("caption cannot contain blanks. Use underscore instead.");
		Out.NewLine();
		break;
case ListEntityMembers:
		Out.NextOut(GetName());
		break;
case ListGlobalClasses:
case ListEntityClasses:
		break ;
case ListSetParameterValues:
		IntEntListing->GetOneParameter("Hex")->
			IntP->CurrentValue = Hex_1;
		IntEntListing->GetOneParameter("Caption")->
			StringP->CurrentValue = Caption_2;
		break;
	}
} // end  list entity switch

static ValueType * SetHex(OutTokens&,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
	break ;
case EntityReqDescribeFull:
	break ;
case EntityReqCall:
		{		// Call procedure
				int16 Hex =
			Param->GetIntParameterValue("Hex");
		((Listing *) This)->SetHex(Hex);
		return 0 ;
	}
	}
	return 0;
}

void ListingNodesInit()
{
	if (ListingNodeList)  return ;

	static StringParam ListingNameParam =
		{"Listing", MakeNewEntityName, 0, LegalEntityName};
	static IntParam ListingHexParam = {
		 0, 0,  0,  0,  0,  1};
	static StringParam ListingCaptionParam = {
		 0, 0, 0};

	static OneParameter ListingParArray[] = {
		{"Name", 0, "node name", 0, 0, &ListingNameParam},
		{"Hex", 0, 
			"option(1) to output data in hex format",
			&ListingHexParam},
		{"Caption", 0, 
			"list caption",
			0, 0, &ListingCaptionParam},
		{0}
	};

	static OneParameter SetHexListingList[] = {
		{"Hex", 0, "option(1) to output data in hex format",
			 &ListingHexParam},
			{0}
	};
	UserParameters * SetHexMemberParam = new UserParameters
		(SetHexListingList);

	Procedure * SetMemberProcHex = new Procedure("SetHex", SetHex,
		 SetHexMemberParam, "void");
static ValueType * ListingMembers[2] ;
	int ii = 0 ;
	ListingMembers[ii++] = new ValueType(DecProcedure, SetMemberProcHex) ;
	ListingMembers[ii++] = 0 ;
	ListingNodeList = new EntityList;
	IntEntListing = new InteractiveEntity("Listing", ListingNodeList,
		MakeListing, InteractiveDisplay, "dylist.h",
		ListingMembers, "DisplayNodeStr");
	IntEntListing->SetParameters(new UserParameters(ListingParArray));
	TheNodes->Append(IntEntListing);
} // end initalization

static UserEntity * MakeListing(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith)
{
	switch(Request) {
case EntityReqDescribe:

case EntityReqDescribeFull:
		Out.NextQuoteOut("Listing");
		Out.NextFillOut("displays its input data streams.");
		Out.NextFillOut("The");
		Out.NextFillOut("`ElementSize'");
		Out.NextFillOut("words in each sample are enclosed");
		Out.NextFillOut("in parenthesis and separated by commas. Each sample is");
		Out.NextFillOut("given an index of one to three levels. These are the");
		Out.NextFillOut("element within a block, the block index and the channel index.");
		Out.NextFillOut("If the time flag is set then the time of each sample is listed.");
		Out.NextFillOut("If");
		Out.NextQuoteOut("Hex");
		Out.NextFillOut("is set the data is displayed in hexadecimal format and");
		Out.NextFillOut("hard limited if it cannot fit in a 32 bit integer.");
		Out.NextQuoteOut("Caption");
		Out.NextFillOut("is a label the listing window.");
		Out.NewLine();
		break;

case EntityReqCreate:
	{
		const char * Name = IntNode.GetStringParameterValue("Name");
		int16 Hex =
			IntNode.GetIntParameterValue("Hex");
		const char * Caption =
			IntNode.GetStringParameterValue("Caption");
		return new Listing(Name, Hex, Caption);

	}
	}
	return 0;
}

static InitObj LocalInit(ListingNodesInit, "Listing", "DisplayNodeStr");

