/*
 *  outndx.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "outnode.h"
#include "noderep.h"
#include "network.h"
#include "dfnode.h"
#include "cgidbg.h"
#include "compare.h"
#include "yacintfc.h"
#include "dspe_app.h"
#include "mkstr.h"
#include "ObjProGui/intfc.h"


DfNode * OutputNode::target_replacement(const char * target)
{
    if (strcmp(target,NodeReplacement::validate_compare_replace)) return 0 ;
	if (In > 1) return 0 ;
	const char * node_name = DspApplication::force_to_legal_name_del(
		Concatenate("Compare_",GetName()));
	const char * err_file = Concatenate(
		DspApplication::compare_disk_error_file(),"_node_",GetName());
	return new CompareDisk(node_name,GetFileName(),
		DspApplication::compare_disk_max_report(),
		DspApplication::compare_disk_tolerance(),err_file);
}

