/*
 *  integ.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <complex.h>
#include <signal.h>
#include "ObjProDSP/portable.h"
#include "ObjProComGui/usercom.h"
#include "ObjProArith/hrdarth.h"
#include "ObjProArithGen/arthfnc.h"
#include "ObjProComGui/cgidbg.h"
#include "ObjProArithGen/artherr.h"
#include "ObjProDSPint/netlnk.h"
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/integ.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
static EntityList * IntegrateNodeList = 0 ;
static InteractiveEntity * IntEntIntegrate ;
void IntegrateNodesInit();
Integrate::Integrate (const char * Name, int32 IntegrationSize, int32 OutputStep, 
		double Scale):
	ProcessNodeStr(Name, 1, 1, new StreamStr(StreamNotSet), 
	new StreamStr(StreamNotSet), 0, OutputStep, 1, IntegrationSize ? IntegrationSize - 1 : 0, 0, 
	TimingTypeLinear)
,
	IntegrationSize_1(IntegrationSize),
	OutputStep_2(OutputStep),
	Scale_3(Scale)
{
	if (!IntegrateNodeList) IntegrateNodesInit() ;
	IntegrateNodeList->Append(MakeDeclaredEntity(this, IntEntIntegrate)) ;
	InitArithType(TheArithType);
	NewMenuItem("Integrate",GetName());
#line 63 "../integ.usr"
 
	ctor();
#line 51 "../integ.C"
} // end constructor

Integrate::~Integrate()
{
	TheMenuServer->DeleteMenuItem("Integrate",GetName());
	IntegrateNodeList->Delete(GetName()) ;
#line 67 "../integ.usr"
 
	dtor();
#line 61 "../integ.C"
} // end destructor

int Integrate::CheckSafeDelete()
{
	int Safe_Check_Return = UserEntity::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

Integrate * IntegrateDef;

ErrCode Integrate::DoNode(int32 k)
{
#line 88 "../integ.usr"
 
	return kernel(k);
#line 78 "../integ.C"
} // end kernel code

static UserEntity * MakeIntegrate(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith = (ArithType::ArithCapabilities) TheArithType) ;
int Integrate::CppList(OutTokens& Out, CppListCmds Cmd)
{
	return IntEntIntegrate->CppList(Out,Cmd,this);
}

void Integrate::Describe(OutTokens& Out, ListEntity Option)
{
	switch(Option) {
case ListSingleEntity:
		Out.NewLine();
		MakeIntegrate(Out,EntityReqDescribeFull,*IntEntIntegrate,TheArithType);
		Out.NewLine();
		Out.NextQuoteOut("IntegrationSize");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetIntegrationSize()));
		Out.NextFillOut(")");
		Out.NextFillOut("is the number of samples to sum.");
		Out.NextFillOut("An output is generated for every");
		Out.NextQuoteOut("OutputStep");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetOutputStep()));
		Out.NextFillOut(")");
		Out.NextFillOut("inputs.");
		Out.NextFillOut("The number of buffers that must be maintained");
		Out.NextFillOut("is");
		Out.NextQuoteOut("IntegrationSize");
		Out.NextFillOut("/");
		Out.NextQuoteOut("OutputStep");
		Out.NextFillOutConcat(".");
		Out.NextQuoteOut("Scale");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetScale()));
		Out.NextFillOut(")");
		Out.NextFillOut("multiplies each output sample.");
		Out.NextFillOut("The intermediate arithmetic is done in double floating point");
		Out.NextFillOut("point.");
		Out.NextQuoteOut("Scale");
		Out.NextFillOut("is applied to the final output");
		Out.NextFillOut("point before it is converted to MachWord.");
		Out.NewLine();
		break;
case ListEntityMembers:
		Out.NextOut(GetName());
		break;
case ListGlobalClasses:
case ListEntityClasses:
		break ;
case ListSetParameterValues:
		IntEntIntegrate->GetOneParameter("IntegrationSize")->
			IntP->CurrentValue = IntegrationSize_1;
		IntEntIntegrate->GetOneParameter("OutputStep")->
			IntP->CurrentValue = OutputStep_2;
		IntEntIntegrate->GetOneParameter("Scale")->
			FloatP->CurrentValue = Scale_3;
		break;
	}
} // end  list entity switch

static ValueType * SetScale(OutTokens&,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
	break ;
case EntityReqDescribeFull:
	break ;
case EntityReqCall:
		{		// Call procedure
				double Scale =
			Param->GetFloatParameterValue("Scale");
		((Integrate *) This)->SetScale(Scale);
		return 0 ;
	}
	}
	return 0;
}

void IntegrateNodesInit()
{
	if (IntegrateNodeList)  return ;

	static StringParam IntegrateNameParam =
		{"Integrate", MakeNewEntityName, 0, LegalEntityName};
	static IntParam IntegrateIntegrationSizeParam = {
		 1, 0,  0,  0, 0, 2147483647};
	static IntParam IntegrateOutputStepParam = {
		 1, 0,  0,  1, 0, 2147483647};
	static FloatParam IntegrateScaleParam = {
		 1.0, 0, 0, -1e+100, 0, 1e+100};

	static OneParameter IntegrateParArray[] = {
		{"Name", 0, "node name", 0, 0, &IntegrateNameParam},
		{"IntegrationSize", 0, 
			"Number of samples to sum",
			&IntegrateIntegrationSizeParam},
		{"OutputStep", 0, 
			"number of input samples for one output",
			&IntegrateOutputStepParam, 0, 0, 0, 0, 1},
		{"Scale", 0, 
			"output is scaled by this factor",
			0, &IntegrateScaleParam, 0, 0, 0, 1},
		{0}
	};

	static OneParameter SetScaleIntegrateList[] = {
		{"Scale", 0, "output is scaled by this factor",
			 0, &IntegrateScaleParam, 0, 0, 0, 1},
			{0}
	};
	UserParameters * SetScaleMemberParam = new UserParameters
		(SetScaleIntegrateList);

	Procedure * SetMemberProcScale = new Procedure("SetScale", SetScale,
		 SetScaleMemberParam, "void");
static ValueType * IntegrateMembers[2] ;
	int ii = 0 ;
	IntegrateMembers[ii++] = new ValueType(DecProcedure, SetMemberProcScale) ;
	IntegrateMembers[ii++] = 0 ;
	IntegrateNodeList = new EntityList;
	IntEntIntegrate = new InteractiveEntity("Integrate", IntegrateNodeList,
		MakeIntegrate, InteractiveNode, "integ.h",
		IntegrateMembers, "ProcessNodeStr");
	IntEntIntegrate->SetParameters(new UserParameters(IntegrateParArray));
	TheNodes->Append(IntEntIntegrate);
} // end initalization

static UserEntity * MakeIntegrate(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith)
{
	switch(Request) {
case EntityReqDescribe:

case EntityReqDescribeFull:
		Out.NextQuoteOut("Integrate");
		Out.NextFillOut("sums");
		Out.NextQuoteOut("IntegrationSize");
		Out.NextFillOut("consecutive samples and");
		Out.NextFillOut("outputs this sum for every");
		Out.NextQuoteOut("OutputStep");
		Out.NextFillOut("input samples.");
		Out.NextFillOut("In effect it is a Fir filter with all the coefficients equal");
		Out.NextFillOut("to 1.");
		Out.NextFillOut("If");
		Out.NextQuoteOut("IntegrationSize");
		Out.NextFillOut("is 0 then the sum is continuous and");
		Out.NextFillOut("the output is normalized by the number of samples. The");
		Out.NextFillOut("summation is done in double floating point. The output");
		Out.NextFillOut("is scaled by");
		Out.NextQuoteOut("Scale");
		Out.NextFillOut("before being converted to `MachWord'.");
		Out.NewLine();
		break;

case EntityReqCreate:
	{
		const char * Name = IntNode.GetStringParameterValue("Name");
		int32 IntegrationSize =
			IntNode.GetIntParameterValue("IntegrationSize");
		int32 OutputStep =
			IntNode.GetIntParameterValue("OutputStep");
		double Scale =
			IntNode.GetFloatParameterValue("Scale");
		return new Integrate(Name, IntegrationSize, OutputStep, Scale);

	}
	}
	return 0;
}

static InitObj LocalInit(IntegrateNodesInit, "Integrate", "ProcessNodeStr");

