/*
 *  import.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <stream.h>
#include <string.h>
#include <fcntl.h>
#include <libc.h>
#include "ObjProComGui/cgidbg.h"
#include "ObjProDSP/sysconst.h"
#include "ObjProGui/yacintfc.h"
#include "ObjProGen/mkstr.h"
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/import.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
static EntityList * ImportDataNodeList = 0 ;
static InteractiveEntity * IntEntImportData ;
void ImportDataNodesInit();
ImportData::ImportData (const char * Name, const char * FileName, const char * Format, 
		int16 Fields, int16 RepeatFlag, int32 * SkipFields, 
		int32 SkipFields_Length, int32 * SkipColumns, 
		int32 SkipColumns_Length):
	Signal(Name, 1, 1, 1, 1, TimingTypeLinear, 
	(ArithType::ArithCapabilities)((Format[strlen(Format) - 1] == 'X' || Format[strlen(Format) - 1] == 'x') ? (TheArithType == ArithType::ArithInt16 ? TheArithType : ArithType::ArithInt32) : TheArithType))
,
	FileName_1(FileName),
	Format_2(Format),
	Fields_3(Fields),
	RepeatFlag_4(RepeatFlag),
	SkipFields_5(SkipFields),
	SkipFields_Length_6(SkipFields_Length),
	SkipColumns_7(SkipColumns),
	SkipColumns_Length_8(SkipColumns_Length)
{
	if (!ImportDataNodeList) ImportDataNodesInit() ;
	ImportDataNodeList->Append(MakeDeclaredEntity(this, IntEntImportData)) ;
	InitArithType(TheArithType);
	NewMenuItem("ImportData",GetName());
#line 156 "../import.usr"
 
	ctor();
#line 56 "../import.C"
} // end constructor

ImportData::~ImportData()
{
	TheMenuServer->DeleteMenuItem("ImportData",GetName());
	ImportDataNodeList->Delete(GetName()) ;
#line 160 "../import.usr"
 
	dtor();
#line 66 "../import.C"
} // end destructor

int ImportData::CheckSafeDelete()
{
	int Safe_Check_Return = DfNode::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

ImportData * ImportDataDef;

ErrCode ImportData::DoNode(int32 k)
{
#line 179 "../import.usr"
 
	return kernel(k);
#line 83 "../import.C"
} // end kernel code

static UserEntity * MakeImportData(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith = (ArithType::ArithCapabilities) TheArithType) ;
int ImportData::CppList(OutTokens& Out, CppListCmds Cmd)
{
	return IntEntImportData->CppList(Out,Cmd,this);
}

void ImportData::Describe(OutTokens& Out, ListEntity Option)
{
	switch(Option) {
case ListSingleEntity:
		Out.NewLine();
		MakeImportData(Out,EntityReqDescribeFull,*IntEntImportData,TheArithType);
		Out.NewLine();
		Out.NextQuoteOut("FileName");
		Out.NextQuoteOut(GetFileName());
		Out.NextFillOut("specifies the name of the disk file");
		Out.NextFillOut("to be read. If no file name is specified (default 0)");
		Out.NextFillOut("you will be prompted for a file name when execution starts.");
		Out.NextQuoteOut("Format");
		Out.NextQuoteOut(GetFormat());
		Out.NextFillOut("specifies the format to use in reading data.");
		Out.NextFillOut("Any standard `C' input format can be used.");
		Out.NextFillOut("The default, `%d' for integer decimal data,");
		Out.NextFillOut("for octal data. If the format string ends in `X' or `x'");
		Out.NextFillOut("integer data is written to the output stream on a floating point");
		Out.NextFillOut("simulator. If the last character is an `s' and the format");
		Out.NextFillOut("is a floating point format the data will be normalized");
		Out.NextFillOut("on the 16 bit integer simulator, i. e. .5 will be converted");
		Out.NextFillOut("to 16384 or half of full scale.");
		Out.NextFillOut("If the last two characters of the format string");
		Out.NextFillOut("are an underscore (_) and any other character they will be deleted");
		Out.NextFillOut("from the format. You can use this to control the type");
		Out.NextFillOut("of output or scaling independent of the format for reading data.");
		Out.NextFillOut("The type of format is determined by looking for the first occurrence");
		Out.NextFillOut("of `%' ad then the first occurrence of one the letters `x',");
		Out.NextFillOut("`d', `o' ,`f' or `e' after that. Floating point format");
		Out.NextFillOut("characters must be preceded by a `l' and others must not.");
		Out.NextFillOut("The letter can be in either");
		Out.NextFillOut("upper or lower case. If the format is not recognized");
		Out.NextFillOut("and error will be generated. `x' and `o' formats will read");
		Out.NextFillOut("data as unsigned 32 bit integers. `d' will it as signed 32");
		Out.NextFillOut("bit integers. `e' and 'f' will read it as a double floating point");
		Out.NextFillOut("value. Overflows will be reported as warnings.");
		Out.NextQuoteOut("Fields");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetFields()));
		Out.NextFillOut(")");
		Out.NextFillOut("specifies the number of data fields on each line.");
		Out.NextFillOut("If set to 0 then all data fields that are found on a line");
		Out.NextFillOut("will be read (up to a maximum line width of 1024 characters.)");
		Out.NextFillOut("A data field is any contiguous string");
		Out.NextFillOut("of legal digits separated by white space (blank, tab,");
		Out.NextFillOut("the beginning of a line or the end of a line)");
		Out.NextFillOut("from other data fields or other information on the line.");
		Out.NextFillOut("Decimal and octal fields can start with a `+' or `-'.");
		Out.NextFillOut("Hexadecimal fields may start with an optional `0x' or");
		Out.NextFillOut("`0X' provided the");
		Out.NextQuoteOut("Format");
		Out.NextFillOut("string is `%x' or `%X'.");
		Out.NextFillOut("The value");
		Out.NextQuoteOut("Fields");
		Out.NextFillOut("is an upper limit on the fields on a");
		Out.NextFillOut("line. There may be fewer fields on a line and even");
		Out.NextFillOut("lines with no valid numeric fields.");
		Out.NextFillOut("Setting");
		Out.NextQuoteOut("RepeatFlag");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetRepeatFlag()));
		Out.NextFillOut(")");
		Out.NextFillOut("causes the file to be read at");
		Out.NextFillOut("the beginning once the end of file is encountered.");
		Out.NextFillOut("If the file is short it will only be read once and");
		Out.NextFillOut("the data will be retained in memory.");
		Out.NextQuoteOut("SkipFields");
		Out.NextFillOut("is a list of fields (in increasing order) to skip.");
		Out.NextFillOut("Fields start at 1. If all values are 0");
		Out.NextFillOut("no fields are skipped.");
		Out.NextQuoteOut("SkipColumns");
		Out.NextFillOut("is a list of pairs of column numbers in increasing order.");
		Out.NextFillOut("All data in columns starting at the first column number in the");
		Out.NextFillOut("pair and ending at the next column number after the second");
		Out.NextFillOut("element in the pair will be ignored. Thus");
		Out.NextFillOut("the list");
		Out.NextFillOut("{");
		Out.NextFillOutConcat("20, 24, 30, 32");
		Out.NextFillOutConcat("}");
		Out.NextFillOut("would cause the five columns");
		Out.NextFillOut("20 through 24 and the three columns 30 through 32 to");
		Out.NextFillOut("be skipped. If there are an odd number of entries");
		Out.NextFillOut("all columns at or following the last entry");
		Out.NextFillOut("will be skipped. Columns start at 1. If only values of 0");
		Out.NextFillOut("are entered no columns will be skipped.");
		Out.NewLine();
		break;
case ListEntityMembers:
		Out.NextOut(GetName());
		break;
case ListGlobalClasses:
case ListEntityClasses:
		break ;
case ListSetParameterValues:
		IntEntImportData->GetOneParameter("FileName")->
			StringP->CurrentValue = FileName_1;
		IntEntImportData->GetOneParameter("Format")->
			StringP->CurrentValue = Format_2;
		IntEntImportData->GetOneParameter("Fields")->
			IntP->CurrentValue = Fields_3;
		IntEntImportData->GetOneParameter("RepeatFlag")->
			IntP->CurrentValue = RepeatFlag_4;
		IntEntImportData->GetOneParameter("SkipFields")->
			ArrayP->CurrentValue = 
		(new ArrayData)->SetArrayData(SkipFields_Length_6, DecInt, SkipFields_5);
		IntEntImportData->GetOneParameter("SkipColumns")->
			ArrayP->CurrentValue = 
		(new ArrayData)->SetArrayData(SkipColumns_Length_8, DecInt, SkipColumns_7);
		break;
	}
} // end  list entity switch

int32 TheDataForImportDataSkipFieldsDefaultArray[] = {

		0
	};

	static ArrayData ImportDataSkipFieldsDefaultArray = { 1, DecInt,
		(void *) TheDataForImportDataSkipFieldsDefaultArray};

int32 TheDataForImportDataSkipColumnsDefaultArray[] = {

		0
	};

	static ArrayData ImportDataSkipColumnsDefaultArray = { 1, DecInt,
		(void *) TheDataForImportDataSkipColumnsDefaultArray};

static int ImportData_Format_CheckLegalThis_Func(CheckAction TheAction,
	OneParameter * TheParam, const OneParameter **,OutTokens *)
{
#line 82 "../import.usr"
  return ImportData::check_format(TheAction, TheParam);
#line 228 "../import.C"

}

static DoCheckFunc ImportData_Format_CheckLegalThis = {ImportData_Format_CheckLegalThis_Func,  0};

static int ImportData_SkipFields_CheckLegalThis_Func(CheckAction TheAction,
	OneParameter * TheParam, const OneParameter **,OutTokens *)
{
#line 113 "../import.usr"
  return ImportData::is_increasing(TheAction,TheParam);
#line 239 "../import.C"

}

static DoCheckFunc ImportData_SkipFields_CheckLegalThis = {ImportData_SkipFields_CheckLegalThis_Func,  0};

static int ImportData_SkipColumns_CheckLegalThis_Func(CheckAction TheAction,
	OneParameter * TheParam, const OneParameter **,OutTokens *)
{
#line 127 "../import.usr"
  return ImportData::is_increasing(TheAction,TheParam);
#line 250 "../import.C"

}

static DoCheckFunc ImportData_SkipColumns_CheckLegalThis = {ImportData_SkipColumns_CheckLegalThis_Func,  0};

void ImportDataNodesInit()
{
	if (ImportDataNodeList)  return ;

	static StringParam ImportDataNameParam =
		{"ImportData", MakeNewEntityName, 0, LegalEntityName};
	static StringParam ImportDataFileNameParam = {
		 0, 0, 0};
	static StringParam ImportDataFormatParam = {
		 "%d", 0, 0};
	static IntParam ImportDataFieldsParam = {
		 1, 0,  0,  0,  0,  1024};
	static IntParam ImportDataRepeatFlagParam = {
		 0, 0,  0,  0,  0,  1};
	static int32 ImportDataSkipFieldsLowerArrayBound =
		0 ;

	static int32 ImportDataSkipFieldsUpperArrayBound =
		1024 ;

	static ArrayParam ImportDataSkipFieldsParam = {
		DecInt, &ImportDataSkipFieldsDefaultArray,
		0, 0, (void *) &ImportDataSkipFieldsLowerArrayBound, 0,
		(void *) &ImportDataSkipFieldsUpperArrayBound, 1, 1024};
	static int32 ImportDataSkipColumnsLowerArrayBound =
		0 ;

	static int32 ImportDataSkipColumnsUpperArrayBound =
		1024 ;

	static ArrayParam ImportDataSkipColumnsParam = {
		DecInt, &ImportDataSkipColumnsDefaultArray,
		0, 0, (void *) &ImportDataSkipColumnsLowerArrayBound, 0,
		(void *) &ImportDataSkipColumnsUpperArrayBound, 1, 1024};

	static OneParameter ImportDataParArray[] = {
		{"Name", 0, "node name", 0, 0, &ImportDataNameParam},
		{"FileName", 0, 
			"name of ascii file to read",
			0, 0, &ImportDataFileNameParam},
		{"Format", &ImportData_Format_CheckLegalThis, 
			"`C' format to read data values",
			0, 0, &ImportDataFormatParam, 0, 0, 1},
		{"Fields", 0, 
			"number of data fields on each line",
			&ImportDataFieldsParam, 0, 0, 0, 0, 1},
		{"RepeatFlag", 0, 
			"flag to read the file repeatedly",
			&ImportDataRepeatFlagParam, 0, 0, 0, 0, 1},
		{"SkipFields", &ImportData_SkipFields_CheckLegalThis, 
			"list of fields to skip (enter single 0 to skip none)",
			0, 0, 0, 0,
			&ImportDataSkipFieldsParam, 1},

		{"SkipColumns", &ImportData_SkipColumns_CheckLegalThis, 
			"list of pairs of columns to skip (enter single 0 to skip none",
			0, 0, 0, 0,
			&ImportDataSkipColumnsParam, 1},

		{0}
	};

	ImportDataNodeList = new EntityList;
	IntEntImportData = new InteractiveEntity("ImportData", ImportDataNodeList,
		MakeImportData, InteractiveNode, "import.h",
		0, "Signal");
	IntEntImportData->SetParameters(new UserParameters(ImportDataParArray));
	TheNodes->Append(IntEntImportData);
} // end initalization

static UserEntity * MakeImportData(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith)
{
	switch(Request) {
case EntityReqDescribe:

case EntityReqDescribeFull:
		Out.NextQuoteOut("ImportData");
		Out.NextFillOut("reads ascii data in a variety of formats.");
		Out.NextFillOut("Selected columns can be");
		Out.NextFillOut("be ignored. Each line is broken into");
		Out.NextFillOut("fields. A field is a string that has a numeric value.");
		Out.NextFillOut("These fields are separated by any characters");
		Out.NextFillOut("that do not have an embedded numeric value. Selected fields can");
		Out.NextFillOut("be ignored.");
		Out.NewLine();
		break;

case EntityReqCreate:
	{
		const char * Name = IntNode.GetStringParameterValue("Name");
		const char * FileName =
			IntNode.GetStringParameterValue("FileName");
		const char * Format =
			IntNode.GetStringParameterValue("Format");
		int16 Fields =
			IntNode.GetIntParameterValue("Fields");
		int16 RepeatFlag =
			IntNode.GetIntParameterValue("RepeatFlag");
		int32 * SkipFields =
			(int32 *  ) IntNode.GetArrayParameterValue("SkipFields");
		int32 SkipFields_Length =
			IntNode.GetLengthArrayParameterValue("SkipFields");
		int32 * SkipColumns =
			(int32 *  ) IntNode.GetArrayParameterValue("SkipColumns");
		int32 SkipColumns_Length =
			IntNode.GetLengthArrayParameterValue("SkipColumns");
		return new ImportData(Name, FileName, Format, Fields, RepeatFlag, SkipFields, SkipFields_Length, SkipColumns, SkipColumns_Length);

	}
	}
	return 0;
}

static InitObj LocalInit(ImportDataNodesInit, "ImportData", "Signal");

