/*
 *  intfccomd.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "intfccomd.h"
#include "cgidbg.h"
#include "newaloc.h"
#include "yacintfc.h"

DspInterfaceController InterfaceControl ;

void InterfaceController::ActionServer(int Id, DoCallBackAction Action,
	int RemSize, const char * Data)
{
/*
 *	LogOut << "InterfaceController::ActionServer(" << Id << ", "
 *		<< Action << ", " << RemSize << "," << (Data ? Data : "NULL")
 *		<< ")\n" ;
 */
	switch (Action) {
case ParseReadFileAction:
		int OverwriteFlag;
		int FlagSize = sizeof(OverwriteFlag);
		if (RemSize <= FlagSize)
			DbgError("InterfaceController::ActionServer",
			"too small");
		MoveNBytes((char *) &OverwriteFlag, Data, FlagSize);
		State.ReadFile(Data+FlagSize,OverwriteFlag,Id);
		break ;
case ReadyForInitReadState:
default:
		DbgError("InterfaceController::ActionServer","bad action");
	}
}

void InterfaceController::ReturnServer(int Id, ReturnCallBackAction Action,
	int RemSize, const char * Data)
{
/*
 *	LogOut << "InterfaceController::ReturnServer(" << Id << ", "
 *		<< Action << ", " << RemSize << "," << (Data ? Data : "NULL")
 *		<< ")\n" ;
 */
	switch (Action) {
case InitReadFinished:
		ReturnCallBack DoCall = TheCallBacks->GetCallBack(Id);
		if (!DoCall) DbgError("InterfaceController::ReturnServer",
			"bad id");
		int Temp;
		if (RemSize != sizeof(int)) DbgError(
			"InterfaceController::ReturnServer", "bad size");
		MoveNBytes((char *) &Temp,Data,RemSize);
		DoCall(Action);
		break ;
case ParseReadFileReturn:
default:
		DbgError("InterfaceController::ReturnServer","bad action");
	}
}

void InterfaceController::ActionNoReturnServer(DoActionNoCallBack Action,
	int RemSize, const char * Data)
{
	switch (Action) {
case DoActionSetSaveFileName:
		State.SaveInit(Data);
		return ;
default:
		DbgError("InterfaceController::ActionNoReturnServer",
			"bad case");
	}
}


