/*
 *  spellfil.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <ctype.h>
#include <string.h>
#include <fstream.h>
#include "debug.h"
#include "spellfil.h"
#include "files.h"

static ostream * SpellFile = 0;
static int CharPosition = 0 ;

int IsWhiteSpace(const char * Text)
{
	for (const char * Ch = Text; *Ch ; Ch++) if (!isspace(*Ch)) return 0;
	return 1 ;
}

static void OpenSpellFile()
{
	if (!SpellFileName[0]) DbgError("OpenSpellFile", "no file name");
	// SpellFile = OpenFile(SpellFileName);
	SpellFile = new ofstream(SpellFileName);
}

void AddToSpellFile(const char * String)
{
	static int EndedInSpace = 1 ;
	if (!String) return ;
	if (!*String) return ;
	if (IsWhiteSpace(String)) return ;
	if (!SpellFile) OpenSpellFile();
	while (*String) {
		if (!isascii(*String)) {
			String++;
			continue;
		}
		if (isalpha(*String)) break ;
		String++;
	}
	int Length = strlen(String) ;
	if (!Length) return ;
	if (CharPosition + Length > 75) {
		*SpellFile << "\n" ;
		CharPosition = 0 ;
		EndedInSpace = 1;
	}
	if (!EndedInSpace) if (!isspace(*String)) {
		*SpellFile << " " ;
		CharPosition++ ;
	}
	*SpellFile << String ;
	CharPosition += Length ;
	EndedInSpace = isspace(String[Length-1]);
}


void CloseSpellFile()
{
	if (!SpellFile) return ;
	*SpellFile << "\n" ;
	delete SpellFile;
	SpellFile = 0 ;
}
