/*
 *  dlist.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <iostream.h>
#include "portable.h"
#include "dlist.h"
#include "errcode.h"

ErrCode DoubleList::Insert(Entity a)
{
	if (Last) {
		Last->Next = new DoubleLink(a,Last,Last->Next) ;
		Last->Next->Previous = Last->Next ;	
	} else {
		Last = new DoubleLink(a,0,0);
		Last->Next = Last ;
		Last->Previous = Last ;
	}
	return OK;
}

ErrCode DoubleList::Append(Entity a)
{
	if (Last) {
		Last = Last->Next = new DoubleLink(a,Last,Last->Next) ;
		Last->Next->Previous = Last ;
	} else {
		Last = new DoubleLink(a,0,0);
		Last->Next = Last ;
		Last->Previous = Last ;
	}
	return OK;
}

Entity DoubleList::Pop()
{
	if (Last == 0) return 0 ;
	DoubleLink * OldLast = Last ;
	Entity Ret = OldLast->Entry ;
	Last = Last->Previous ;
	if (Last == OldLast) Last = 0 ;
	else {
		Last->Next = OldLast->Next ;
		(Last->Next)->Previous = Last ;
	}
	delete OldLast ;
	return Ret ;
}

Entity DoubleList::Get()
{
	if (Last == 0) return 0;
	DoubleLink * First = Last->Next ;
	Entity Return = First->Entry ;
	if (First == Last) Last = 0;
	else {
		Last->Next = First->Next ;
		(First->Next)->Previous = Last ;
	}
	delete First ;
	return Return ;
}

void DoubleList::Clear()
{
	DoubleLink * link = Last ;
	if (!link) return ;
	do {
		DoubleLink * l = link ;
		link = link->Next ;
		delete l ;
	} while (link!= Last) ;
	Last = 0 ;
}

int DoubleList::Size()
{
	DoubleListIterator Iter(*this);
	int Sz = 0;
	while (Iter.Next()) Sz++;
	return Sz;
}

ErrCode DoubleList::RemoveEntry (Entity Entry)
{
	DoubleListIterator Iter(*this);
	DoubleLink * Prev = Last ;
	Entity Ent;
	while(Ent = Iter.Next()) if (Ent == Entry) {
		DoubleLink * Save = Prev->Next ;
		Prev->Next = Iter.CurrentEntry->Next ;
		if (Save == Last) Last = Prev->Next ;
		if (Save == Last) Last = 0;
		delete Save ;
		return OK ;
	} else Prev = Prev->Next ;
	return Warning ;
}
		


Entity DoubleListIterator::Next()
{
	DoubleLink * Link ;
	if (!CurrentList) return 0;
	if (!CurrentList->Last) return 0;
	if ( !CurrentEntry )
		Link = CurrentEntry = CurrentList->Last->Next ;
			// Last->Next is First in list
	else {
		CurrentEntry = CurrentEntry->Next ;
		Link = (CurrentEntry == CurrentList->Last->Next) ?
			0 : CurrentEntry ;
	}
	return Link ? Link->Entry : 0 ;
}

void DoubleList::LinkDump() const
{
	cout << "last = " << (void *) Last << "," ;
	Last->Dump();
}

void DoubleLink::Dump() const
{
	cout << "this = " << (void *) this << ", prev = " << (void *) Previous
		<< ", next = " << (void *) Next << "\n" ;
}

Entity DoubleListIterator::Previous()
{
	// cout << "CurrentEntry: " ;
	// CurrentEntry->Dump();
	// cout << "CurrentList: " ;
	// CurrentList->LinkDump();
	DoubleLink * Link ;
	if (!CurrentList) return 0;
	if (!CurrentList->Last) return 0;
	if (CurrentEntry == CurrentList->Last->Next) return 0 ;
	if ( !CurrentEntry) Link = CurrentEntry = CurrentList->Last ;
	else {
		Link = CurrentEntry->Previous ;
		CurrentEntry = Link ;
	}
	// cout << "CurrentEntry: " ;
	// CurrentEntry->Dump();
	return Link ? Link->Entry : 0 ;
}



