/*
 *  outfilnm.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <string.h>
#include <iostream.h>
#include <stdlib.h>
#include "outfilnm.h"

const char * MakeOutFileName(const char * InputFile)
{
	const char * Start = InputFile ;
	const char * LastDot = InputFile+strlen(InputFile) ;
	for (const char * Ptr = InputFile; *Ptr; Ptr++) {
		if (*Ptr == '/') Start = Ptr+1;
		if (*Ptr == '.') LastDot = Ptr ;
	}
	int Length = LastDot-Start;
	if (Length < 1) {
		cerr << "Bad input file name `" << InputFile << "'.\n" ;
		exit(1);
	}
	char * Ret = new char[Length+1];
	strncpy(Ret,Start,Length);
	Ret[Length] = '\0' ;
	return Ret ;
}


