/*
 *  cgidbg.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "ObjProComGui/cgidbg.h"
#include "ObjProGen/mkstr.h"
#include <strstream.h>
#include <libc.h>
typedef void (*new_handler_t)();
extern new_handler_t __new_handler;
extern "C" void default_new_handler();
extern "C" new_handler_t set_new_handler(new_handler_t);


void ExitOneWayOrAnother()
{
	exit(1);
}

static void OutOfMemory()
{
	DbgError("No more memory","JOB TERMINATED");
}
	
void SetNewHandler()
{
	set_new_handler(OutOfMemory);
}

void SystemErrorMessage(int LastLineFeed, char **ret)
{
    const char * message_is = "The system error message is:\n" ;
    const char * err_number = "error number: " ;
    const char * not_in = " which is not in the system error table" ;
    if (ret) {
        char * to_delete = 0 ;
        const char * sys_msg = 0 ;
        if (errno < sys_nerr) {
            const buf_size = 32 ;
            char buf[buf_size] ;
            ostrstream num(buf,buf_size);
            num << errno ;
            sys_msg = to_delete = Concatenate(err_number,buf,not_in);
        } sys_msg = sys_errlist[errno] ;
        *ret  = Concatenate(message_is,sys_msg,".");
        delete to_delete ;
        return ;
    }
    cerr << message_is ;
    if (errno < sys_nerr) *Output << sys_errlist[errno] ;
    else cerr  << err_number << errno << not_in ;
    cerr << "." ;
}


