/*
 *  debug.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <iostream.h>
#include <signal.h>
/* #include <unistd.h> */
#include <unistd.h>
#include <libc.h>
#include "ObjProGen/debug.h"

#ifndef TI_C30
void DebugCode(int code)
{
#ifndef NO_OSFCN
	cerr << "Error code " << code << "\n" ;
	cerr.flush();
	kill (getpid(),SIGQUIT);
#else
	exit(1);
#endif
}

void DbgError(const char * Routine,const char *ErrorType, const char* Class)
{
#ifndef NO_OSFCN
	cerr << "Error " << ErrorType << "  from `" ;
	if (Class)  cerr << Class <<  "::" ;
	cerr <<	Routine  << "'.\n" ;
	cerr.flush();
	kill (getpid(),SIGQUIT);
#else
	exit(1);
#endif
}
#endif

