/*
 *  dsp_app.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef DSP_APP_DOT_H
#define DSP_APP_DOT_H

#include <InterViews/coord.h>
#include <InterViews/glyph.h>
#include "usriotyp.h"

#include "arthtyp.h"
#include "textdefs.h"
#include "portable.h"

class RootMenuView ;
class ivCanvas ;
class ivDisplay ;
class ivColor ;
class ivFont ;
class ivGlyph ;
class ivBrush ;
class GuiDynamicTextControl;
class ivStyle ;
class ivWidgetKit ;
class ivLayoutKit ;
class ivWindow ;
class DspProcessState ;
class NetworkDisplayManager ;
class HelpControl ;
class Menu ;
class MenuViewList ;
class MenuViewLine ;
class StringList ;
class DspProcessState ;
class ShiftTable ;
class TextWindowView ;
class StackMenuList;
class ConstStringList;

class DspApplication {
	static int spacer_l;
public:
	static RootMenuView * root_window() ;
	static ivWindow * menu_window() ;
	static const char * spacer();
	static int spacer_length() ;
	static int size_of(ArithType::ArithTypes);
	static double convert_to_double(const char * value,ArithType::ArithTypes);
	static ivCanvas* canvas() ;
	static ivDisplay * display() ;
	static void disable_remote_com();
	static void enable_remote_com();
	static void set_root_window(RootMenuView& w);
	static void network_display(int id,int size,const char *data);
	static void network_edit(int id,int size,const char *data);
	static NetworkDisplayManager * network_manager();
	static const ivColor * rosy_brown();
	static const ivColor * cyan();
	static const ivColor * white();
	static const ivColor * black();
	static const ivFont * font();
	static const ivFont * tty_font();
	static void dimensions(ivGlyph * g, ivCoord& x, ivCoord&y);
	static ivCoord x_req(ivGlyph *g);
	static ivCoord y_req(ivGlyph *g);
	static const ivBrush * brush();
	static const char * int_string(int v);
	static void dynamic_text(OutputType type,const char *str,OutputType nxt);
	static GuiDynamicTextControl * dynamic_text_controller() ;
	static HelpControl * help_control() ;
	static ivStyle& style() ;
	static ivWidgetKit& kit();
	static const ivLayoutKit& layout();
	static char * open_file(int& the_file_id) ;
	static char * make_file_name() ;
	static const char * temp_file_directory() ;
	static void remove_control(char *str) ;
	static DspProcessState * state();
	static void child_id(int c);
	static int child_id();
	static void flush_help_info();
	static void write_help_info();
	static int execute_menu_command(const char* cmd,ConstStringList* lst,
		Menu* menu=0);
	static int execute_menu_command(const char* cmd, const char ** const lst);
	static int execute_menu_command(Menu * constraint, const char * cmd,
		const char * h1=0,
		const char * h2 =0, const char * h3 = 0, const char * h4=0,
		const char * h5 =0, const char * h6 = 0, const char * h7=0);
	static int execute_menu_command(const char * cmd, const char * h1=0,
		const char * h2 =0, const char * h3 = 0, const char * h4=0,
		const char * h5 =0, const char * h6 = 0, const char * h7=0);
	static MenuViewList & menu_manager();
	static void prompt(StringList& msg, SuspendedRead client,
		const char * def_val=0, void * obj=0, ivWindow * win = 0);
	static void prompt(const char *msg, SuspendedRead client,
		const char * def_val=0, void * obj=0, ivWindow * win = 0);
	static uint32 xk_alias(uint32 c);
	static const char * xk_name_of_char(uint32 c);
	static void display_help_file(const char * name) ;
	static void record_action(ivGlyphIndex index, const char * selected,
		const char * win, const char * comment=0);
	static void record_prompt(const char * str);
	static void record_menu_text(const char * str);
	static void record_dpp_text(const char * str);
	static void record_on(const char * file_name=0);
	static void record_off();
	static void record_close();
	static void record_mouse(uint32 action, const char * selected,
		const char *window);
	static void record_key(uint32 action, const char * selected,
		const char *window);

	static void information(const char * msg,ivWindow *win, int force=0);
	static void information(StringList & strings, ivWindow *win, int force=0);
	static const char * get_file_name(const char * prompt, const char * def=0,
		const char * pattern=0,ivWindow * win=0);

	static int set_prompt_response(const char * resp);
	static void action_read_on();
	static void action_read_off();
	static int action_read_line();
	static int cond_check_packet_read();
	static int check_packet_read();
	static DspProcessState * dsp_state() ;
	static int is_busy() ;
	static int event_check();
	static int check_processing();
	static void check_wait_for_dsp();
	static void set_wait_for_dsp();
	static void wait_for_dsp();
	static const char * record_file_name() ;
	static void process_help_strings();
	static void command_record_state();
	static int user_input_allowed(int warn = 1);
	static ShiftTable& shift_table() ;
	static void cpp_scroll(const char * str);
	static void menu_scroll(const char * str);
	static void read_plot();
	static void check_rebuild();
	static const char * main_window_prefix;
	static const char * info_window ;
	static TextWindowView * help_display() ;
	static void set_waiting_on_dsp();
	static void clear_waiting_on_dsp();
	static int waiting_on_dsp();
	static void new_cursor();
	static void do_menu_command(const char * str);
	static int nan_count() ;
	static int infinity_count();
	static void plot_err_display();
	static void warn_info_window(ivCoord X_dim, ivCoord Y_dim,
        const char ** str) ;
	static void create_default(const char * cmd);
	static void create_instance(const char * cmd);
	static void record_menu_state(StackMenuList& list,MenuViewLine& line);
	static void record_menu_state(const char ** const state);
	static int prompt_active();
	static void prompt_active(int set_to);
};

#endif /* #ifdef DSP_APP_DOT_H */
