/*
 *  examp.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <libc.h>
#include "examp.h"
#include "cgidbg.h"
#include "mkstr.h"
#include "dynmen.h"
#include "help.h"
#include "helpdir.h"
#include "dirfil.h"
#include "dsp_app.h"
#include "xdrv.h"
// #include "diskmgr.h"
// #include "winmgr.h"
#include "dynmnu.h"
#include "environ.h"
// #include "winpres.h"
// #include "textwin.h"

ExamplesDspPP * TheExamples = 0 ;
DirectoriesDspPP * TheDirectories = 0 ;
// char * HelpFileDirectory = 0 ;

static const char * GetRootDirectory()
{
	const char * RootName = "OPD_ROOT" ;
	const char * Root =  Environment::get(RootName);
	if (!Root) DbgError(
		"GetRootDirectory enviornment variable not set", RootName);
	return Root ;
}

static const char * GetExamplesDirectory(const char * Dir)
{
	const char * Return = AddSubDirectory(Dir,"examp");
	if (!Return) DbgError("GetExamplesDirectory","bad strings");
	return Return ;
}

static const char * GetHelpDirectory(const char * Dir)
{
	const char * Return = AddSubDirectory(Dir,"help");
	if (!Return) DbgError("GetHelpDirectory","bad strings");
	return Return ;
}

static const char * ExampleSuffix = ".xml" ;
static const char * HelpSuffix = ".hlp" ;

DirectoriesDspPP::DirectoriesDspPP():
	Root(GetRootDirectory()),
	Examples(GetExamplesDirectory(Root)),
	HelpFiles(GetHelpDirectory(Root)),
	Home( Environment::get("HOME"))
{
	HelpFileDirectory = Concatenate(HelpFiles,"/++++|++++|+++",HelpSuffix);
}

ExamplesDspPP::ExamplesDspPP()
{
	if (!TheDirectories) DbgError("ExamplesDspPP::ctor", "no dirs");
	// open examples directory
	ExamineDirectory& TheExamples =
		* new ExamineDirectory(TheDirectories->Examples, ExampleSuffix);
	// make examples menu
	const char * OneFile ;
	while (OneFile = TheExamples.NextFile()) {
		// LogOut << "Adding example " << OneFile << "\n" ;
		char * FileName = RemoveDirectory(OneFile);
		char * ItemName = RemoveSuffix(OneFile,ExampleSuffix);
		delete FileName ;
		TheDynamicMenuServer.DoCommand(MenuServerNewMenuItem,
			"ExampleMenu", ItemName);
		delete ItemName ;
	}
}

void ExamplesDspPP::DescribeExample(const char * Examp) const 
{
	// LogOut << "ExamplesDspPP::DescribeExample(" << Examp << ")\n" ;
	// HelpDo.DisplayHelpFile(Examp);
	DspApplication::root_window()->display_help_file(Examp);
}

void ExamplesDspPP::ExecuteExample(const char * Examp, const char * Over) const 
{
	char * FileName = Concatenate(TheDirectories->Examples,
		"/",Examp,ExampleSuffix);
	// TheWindowsManager->ReadState(FileName,!strcmp(Over,"over"));
	DspApplication::root_window()->read_state(!strcmp(Over,"over"),FileName);
	delete FileName ;
}

void ExamplesDspPP::ReadExample(const char * Examp) const 
{
	const char * FileName = Concatenate(TheDirectories->Examples,
		"/",Examp,ExampleSuffix);
	int Lines ;
/*
 *	TextWindow * Cpp = TheWindowsManager->GetCppWindow() ;
 *	TextWindowPreserve * Pres = Cpp->GetPreserve();
 *	int32 Curr = Pres->GetCurrentAddress();
 *	Pres->GoToAddress(Curr - Lines + 1);
 *	if (Cpp->IsVisible()) Cpp->Home();
 *	TheDiskManager.DoAppendFile(FileName, Cpp, Lines);
 *	if (HelpDo.All()) *Output + OutputHelp << "Appended " << Lines <<
 *		" lines of example `" <<  Examp <<
 *		"' to the DSP++ statement window.\n";
 */
}

