/*
 *  helpwin.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef HELPWIN_DOT_H
#define HELPWIN_DOT_H
#include <InterViews/monoglyph.h>

#include <InterViews/coord.h>
#include <OS/enter-scope.h>
#include <InterViews/enter-scope.h>
#include "com_input.h"
#include "slist.h"


class InputFile ;
class WidgetKit ;
class LayoutKit ;
class Adjustable ;
class Composition ;
class ScrollBox ;
class String ;
class TopLevelWindow ;
class PolyGlyph ;
class Style ;
class Font ;

class DocumentView : public DspInputHandler {
	static Glyph* glyph_char[256];
	int deletable ;
	char ** current_strings ;
	char ** temp_strings ;
	int current_string_size ;
	int temp_size ;
	ivCoord X_dim ;

	void check_size(int size);
	void update_strings();
public:
    DocumentView(WidgetKit&, const LayoutKit&, Style *, ivCoord x,
		const Font * f=0);
    virtual ~DocumentView();
	virtual void draw(Canvas*, const Allocation&) const ;
    virtual Adjustable* adjustable() const;
	void replace_page(const char ** strings);
	void replace_page(StringList& strings);
	void replace_file(InputFile * file);
	virtual void keystroke(const Event&);
	char ** window_contents() const {return current_strings;}
private:
    Composition* page_;
    ScrollBox* box_;
    Glyph* begin_par_;
    Glyph* end_par_;
    Glyph* begin_line_;
    Glyph* end_line_;
    Glyph* word_space_;
    Glyph* interline_;
    Glyph* vfil_glue_;

    void add(const String&);
    void add_par(const String&);

	void make_page(long length);
	void add_page();
};

class TextWindowView {
	DocumentView * the_view ;
	PolyGlyph * the_glyph ;
	Coord X_dim ;
	Coord Y_dim ;
	const char ** last_strings ;
	void replace_page_start();
	void replace_page_end();
public:
	TextWindowView(Coord x, Coord y, const char **) ;
	DocumentView * view() const {return the_view;}
	PolyGlyph * glyph() const {return the_glyph;}
	void replace_page(const char ** strings);
	void replace_page(StringList& strings);
	char ** window_contents() const {return the_view->window_contents();}
};

class TextWindowKit {
public:
	static TopLevelWindow * document_view(const char * file,
		const char * win_name=0, const Font * f =0);
	static TextWindowView * document_window(Coord X_dim, Coord Y_dim,
		const char ** str) ;
	static void warn_info_window(Coord X_dim, Coord Y_dim,
		const char ** str) ;

};

#include <InterViews/leave-scope.h>
#include <OS/leave-scope.h>

#endif /* #ifdef HELPWIN_DOT_H */
