/*
 *  textdefs.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef TEXTDEFS_DOT_H
#define TEXTDEFS_DOT_H
#include "usriotyp.h"
enum Justification {JustifyCenter, JustifyLeft,JustifyRight} ;


enum TextWindowWrite {TextOk, TextLineAboutToWrap, TextLineWrap,
	TextWindowAboutToScroll,TextWindowScroll, TextNoWrapInsert} ;

extern const double Rnd  ;

typedef void (*SuspendedRead)(const char *, InputType, void *) ;

class CaptureRead {
	SuspendedRead to_call ;
	SuspendedRead do_capture(SuspendedRead);
public:
	CaptureRead():to_call(0){}
	void set_suspend(SuspendedRead rd) {to_call = rd; }
	void read(const char *, InputType, void *);
	static CaptureRead& capture_read();
	static SuspendedRead capture(SuspendedRead);
};


#endif /* #ifdef TEXTDEFS_DOT_H */
