/*
 *  rd_scr.y from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
%{
#include <stream.h>
#include <string.h>
#include "portable.h"
#include "cgidbg.h"
#include "cgidbg.h"
#include "playback.h"
#include "restcnt.h"
#ifdef SCO_NO_ALLOCA
#include <malloc.h>
#define alloca malloc
#endif

static void yyerror(const char* s1, const char* s2 = 0,const char* s3 = 0,
	const char* s4 = 0, const char* s5=0)
{
	ManagedKeyboards::manager()->yyerror(s1,s2,s3,s4,s5);
}

extern int yylex();
%}
%union {
	int32 reserved ;
	int32 integer ;
	char * string ;
	} 

%token <string> STRING
%token <integer> INTEGER 
%token <reserved> KEY ACTION MOUSE PROMPT MENU DPP MENU_STATE
%token NEWLINE

%type <reserved> ActionType
%%

Statement : ActionDescription newline |

	PromptDescription newline |

	TextEntry newline |

	MenuState newline |

	newline |

	error newline

newline : NEWLINE			{YYACCEPT;}

ActionDescription : ActionType INTEGER STRING STRING
				{ManagedKeyboards::manager()->action($1,$2,$3,$4);}


PromptDescription : PROMPT STRING 
		{ManagedKeyboards::manager()->prompt(restore_control((char *)$2));}

ActionType : KEY | ACTION | MOUSE

TextEntry : MenuEntry | DppEntry 

MenuEntry : MENU STRING  {ManagedKeyboards::manager()->menu_text($2);}

DppEntry : DPP STRING {ManagedKeyboards::manager()->dpp_text($2);}

MenuState : MENU_STATE 
		{ManagedKeyboards::manager()->start_menu_state();}

	 | MenuState STRING {ManagedKeyboards::manager()->add_to_menu_state($2);}

