/*
 *  mkstr.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef MKSTR_DOT_H
#define MKSTR_DOT_H
char * Concatenate(const char * s1, const char * s2=0,
	const char * s3 = 0, const char * s4 = 0,
	const char * s5 = 0, const char * s6 = 0) ;

inline char * NewCopyString(const char * s) {return Concatenate (s);}

const char * FindSuffix(const char * Name, const char * Suffix) ;
const char * FindBase(const char * Name, const char * Base);
const char * FindLastDot(const char * Name) ;
char * RemoveSuffix(const char * Base, const char * Suffix) ;
char * AddSuffix(const char * Base, const char * Suffix) ;
char * ForceSuffix(const char * Base, const char * Suffix) ;
char * RemoveDirectory(const char * Name);
char * RemoveLowestDirectory(const char * Name);
char * ReplaceDirectory(const char * DirName, const char * OriginalName) ;
char * FindDirectory(const char * OriginalName);
char * AddSubDirectory(const char * Base, const char * SubDirectory);
char * GetLowestDirectory(const char * name);
const char * StringAfterLastSlash(const char * name);
int EmptyString(const char * String) ;

char * top_version_name(const char * name);

int is_version_name(const char * name);

#endif /* #ifdef MKSTR_DOT_H */
