/*
 *  opf.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <fstream.h>
#include <stdlib.h>
#include "domknode.h"
#include "opf.h"

const char * ObjProGen = "ObjProGen" ;
const char * ObjProDSP = "ObjProDSP" ;
const char * ObjProArith = "ObjProArith" ;
const char * ObjProCom = "ObjProDSPcom" ;
const char * ObjProGui = "ObjProGui" ;
const char * ObjProUsr = "ObjProUsr" ;
const char * ObjProIntUsr = "ObjProDSPint" ;
const char * ObjProTarUsr = "ObjProDSPTar" ;
const char * ObjProNet = "ObjProNet" ;
const char * OpdRoot = 0 ;

void EmitHeaderIncludes(ostream& Str, int DfNodeFlag)
{
	Str << "\n#include \"" << ObjProDSP << "/portable.h\"\n" ;
	Str << "#include \"" << ObjProDSP << "/entenm.h\"\n" ;
	Str << "#include \"" << ObjProGen << "/debug.h\"\n" ;
	if (DfNodeFlag) Str << "#include \"" << ObjProNet << "/dfnode.h\"\n" ;

}

void EmitBodyIncludes(ostream& Str)
{
	Str << "#include \"" << ObjProGen << "/outtok.h\"\n" ;
	Str << "#include \"" << ObjProGui << "/intfc.h\"\n" ; // MUST MOVE
	Str << "#include \"" << ObjProGui << "/remmen.h\"\n" ; // MUST MOVE
	Str << "#include \"" << ObjProGui << "/user.h\"\n" ;	// MUST MOVE
	Str << "#include \"" << ObjProGui << "/dynmnu.h\"\n" ;  // menuserver
	Str << "#include \"" << ObjProArith << "/typout.h\"\n" ;
	Str << "#include \"" << ObjProGui << "/array.h\"\n" ;
	Str << "#include \"" << ObjProGui << "/interinit.h\"\n" ;
	Str << "#include \"" << ObjProGen << "/stattyp.h\"\n" ;
}

ostream& OpenFile(const char * Name, const char * type)
{
	ofstream& Return = *(new ofstream(Name)) ;
	if (!Return.good()) {
		cerr << "Cannot create " << type << " file `" << Name
			<< "'.\n" ;
		exit(1);
	}
	return Return ;
}

