/*
 *	lockdata.c
 *	For objects you can unlock and lock.
 *	eg. doors, boxes, etc;
 */
#include "lock_logic.h"

private int	is_unlocked;

void set_is_unlocked(int i)
{
	is_unlocked = i;
}

int query_is_unlocked()
{
	return is_unlocked;
}

/*
 *	unlock
 *	return 0 or 1 for "was already unlocked", "was locked, is now unlocked"
 */
int unlock()
{
	if (!is_unlocked) {
		is_unlocked = 1;
		return LOCKLOGIC_LOCK_UNLOCKS;
	};
	return LOCKLOGIC_LOCK_ALREADY_UNLOCKED;
}

/*
 *	lock
 *	return 0 or 1 for "was already locked", "was unlocked, is now locked"
 */
int lock()
{
	if (is_unlocked) {
		is_unlocked = 0;
		return LOCKLOGIC_LOCK_LOCKS;
	};
	return LOCKLOGIC_LOCK_ALREADY_LOCKED;
}

/*
 *	toggle
 *	return new state of is_unlocked
 */
int toggle()
{
	if (is_unlocked) {
		is_unlocked = 0;
	}
	else {
		is_unlocked = 1;
	};
	return query_is_unlocked();
}
