/* rob.c */
/* $Id: rob.c,v 1.3 1993/01/30 03:38:43 nils Exp $ */

#include "copyright.h"
#include <ctype.h>

/* rob and kill */

#include "db.h"
#include "config.h"
#include "interface.h"
#include "match.h"
#include "externs.h"
#ifdef INCLUDE_ROB
void do_rob(player,what)
     dbref player;
 char *what;
{
  dbref thing;
  
  if ( Guest(db[player].owner) )  {
    notify(player, "Guests don't use money!");
    return;
  }
  
  init_match(player, what, TYPE_PLAYER);
  match_neighbor();
  match_me();
  if(power(player, TYPE_HONWIZ)) {
    match_absolute();
    match_player();
  }
  thing = match_result();
  
  if ( Guest(db[thing].owner) )  {
    notify(player, "You can't rob guests.");
    return;
  }
  
  switch(thing) {
  case NOTHING:
    notify(player, "Rob whom?");
    break;
  case AMBIGUOUS:
    notify(player, "I don't know who you mean!");
    break;
  default:
    if(Typeof(thing) != TYPE_PLAYER) {
      notify(player, "Sorry, you can only rob other players.");
    } else if(Pennies(thing) < 1) {
      notify(player,tprintf( "%s has no credits.", db[thing].name));
      notify(thing,    
	     tprintf(
		     "%s tried to rob you, but you have no credits to take.",
		     db[player].name));
    } else if(could_doit(player, thing, A_LOCK)) {
      /* steal a penny */
      giveto(player,1);
      giveto(thing,-1);
      notify(player, "You stole a Credit.");
      notify(thing,
	     tprintf( "%s stole one of your Credits!", db[player].name));
      did_it(player,thing,A_SUCC,NULL,A_OSUCC,NULL,A_ASUCC);
    }
    else 
      did_it(player,thing,A_FAIL,"Your conscience tells you not to.",
	     A_OFAIL,NULL,A_AFAIL);
    break;
  }
}
#endif
#ifdef ILL_MIN_COST
void do_kill(player,what,cost)
     dbref player;
 char *what;
     int cost;
{
  dbref victim;
  char buf[BUFFER_LEN+100];
  char buf1[BUFFER_LEN+100];
  
  if ( Guest(db[player].owner) )  {
    notify(player, "Guests can't kill!");
    return;
  }
  
  init_match(player, what, TYPE_PLAYER);
  match_neighbor();
  match_me();
  match_here();
  if(power(player, POW_REMOTE)) {
    match_player();
    match_absolute();
  }
  victim = match_result();
  
  switch(victim) {
  case NOTHING:
    notify(player, "I don't see that player here.");
    break;
  case AMBIGUOUS:
    notify(player, "I don't know who you mean!");
    break;
  default:
    if ( Guest(db[victim].owner) )
      notify(player, "Guests are immune to being killed.");
    if((Typeof(victim) != TYPE_PLAYER) && (Typeof(victim)!=TYPE_THING))
      notify(player, "Sorry, you can only kill other players.");
    else if (((db[db[victim].location].flags & HAVEN) &&
	      !power(player, POW_MODIFY)) ||
	     (controls(victim,db[victim].location, POW_MODIFY) &&
	      !controls(player,db[victim].location, POW_MODIFY))){
      notify(player, "Sorry.");
    } else {
      /* go for it */
      /* set cost */
      if(cost < KILL_MIN_COST) cost = KILL_MIN_COST;
      
      /* see if it works */
      if(!payfor(player, cost)) {
	notify(player, "You don't have enough Credits.");
      } else if((random() % KILL_BASE_COST) < cost
		&& !power(victim, POW_SLAY)) {
	/* you killed him */
	sprintf(buf, "You killed %s!", db[victim].name);
	sprintf(buf1,"killed %s!",db[victim].name);
	if (Typeof(victim)==TYPE_THING)
	  do_halt(victim,"");
	did_it(player,victim,A_KILL,buf,A_OKILL,buf1,A_AKILL);
	
	/* notify victim */
	sprintf(buf, "%s killed you!", db[player].name);
	notify(victim, buf);
	
	/* maybe pay off the bonus */
	if(Pennies(db[victim].owner) < MAX_PENNIES) {
	  sprintf(buf, "Your insurance policy pays %d Credits.",
		  KILL_BONUS);
	  notify(victim, buf);
	  giveto(db[victim].owner,KILL_BONUS);
	} else {
	  notify(victim, "Your insurance policy has been revoked.");
	}
	
	/* send him home */
	safe_tel(victim,HOME);
	/* if victim is object also dequeue all commands */
      } else {
	/* notify player and victim only */
	notify(player, "Your murder attempt failed.");
	sprintf(buf, "%s tried to kill you!", db[player].name);
	notify(victim, buf);
      }
      break;
    }
  }
}
#endif
void do_slay(player,what)
     dbref player;
 char *what;
{
  dbref victim;
  char buf[BUFFER_LEN+100];
  char buf1[BUFFER_LEN+100];
  
  if ( ! power(player, POW_SLAY)) {
    notify(player, "You do not have such power.");
    return; 
  }
  
  init_match(player, what, TYPE_PLAYER);
  match_neighbor();
  match_me();
  match_here();
  if(power(player, POW_REMOTE)) {
    match_player();
    match_absolute();
  }
  victim = match_result();
  
  switch(victim) {
  case NOTHING:
    notify(player, "I don't see that player here.");
    break;
  case AMBIGUOUS:
    notify(player, "I don't know who you mean!");
    break;
  default:
    if((Typeof(victim) != TYPE_PLAYER) && (Typeof(victim)!=TYPE_THING)) {
      notify(player, "Sorry, you can only kill other players.");
      /*    } else if (!controls(player,victim)){*/
    } else if (Level(player)<Levnm(victim)) {
      notify(player, "Sorry.");
    } else {
      /* go for it */
      /* you killed him */
      sprintf(buf, "You killed %s!", db[victim].name);
      sprintf(buf1,"killed %s!",db[victim].name);
      if (Typeof(victim)==TYPE_THING)
	do_halt(victim,"");
      did_it(player,victim,A_KILL,buf,A_OKILL,buf1,A_AKILL);
      
      /* notify victim */
      sprintf(buf, "%s killed you!", db[player].name);
      notify(victim, buf);
      
      
      /* send him home */
      safe_tel(victim,HOME);
    }
    break;
  }
}
void do_giveto(player,who,amnt)
     dbref player;
     char *who;
     char *amnt;
{
  int amount;
  dbref recipt;

  if(!power(player,POW_MEMBER)) {
    notify(player,"Silly, you can't give out money!");
    return;
  }
  init_match(player,who,TYPE_PLAYER);
  match_player();
  match_absolute();
  match_neighbor();
  recipt=noisy_match_result();
  if(recipt==NOTHING) {
    return;
  }
  amount=atoi(amnt);
  if(amount<1) {
    notify(player,"You can only @giveto positive amounts.");
    return;
  }
  if(!payfor(player,amount)) {
    notify(player,"You can't pay for that much1");
    return;
  }
  giveto(recipt,amount);
  notify(player,"Given.");
}

void do_give(player,recipient,amnt)
     dbref player;
     char *recipient;
     char *amnt;
{
  dbref who;               
  int amount;
  char buf[BUFFER_LEN];
  char *s;
  
  if ( Guest(db[player].owner) )  {
    notify(player, "Sorry, guests can't do that!");
    return;
  }
  
  /* check recipient */
  init_match(player, recipient, TYPE_PLAYER);
  match_neighbor();
  match_me();
  if(power(player, POW_REMOTE)) {
    match_player();
    match_absolute();
  }
  
  switch(who = match_result()) 
    {
    case NOTHING:
      notify(player, "Give to whom?");
      return;
    case AMBIGUOUS:
      notify(player, "I don't know who you mean!");
      return;
    }
  
  /* make sure amount is all digits */
  for(s=amnt;*s && ((isdigit(*s)) || (*s=='-'));s++);
  /* must be giving object */
  if (*s)
    {
      dbref thing;
      
      init_match(player, amnt, TYPE_THING);
      match_possession();
      match_me();
      switch(thing = match_result())
	{
        case NOTHING:
	  notify(player, "You don't have that!");
	  return;
        case AMBIGUOUS:
	  notify(player, "I don't know which you mean!");
	  return;
        default:     
	  if (((Typeof(thing)==TYPE_THING) || (Typeof(thing)==TYPE_PLAYER)) &&
	      (((db[who].flags & ENTER_OK) && could_doit(player,thing,A_LOCK))
		|| controls(player,who, POW_TELEPORT)))
	    {  
	      moveto(thing,who);
	      notify(who,
		     tprintf("%s gave you %s.",db[player].name,db[thing].name));
	      notify(player,"Given.");
	      notify(thing,tprintf("%s gave you to %s.",db[player].name,
				   db[who].name));
	    }
	  else
	    notify(player,"Permission denied.");
	}
      return;
    }
  amount=atoi(amnt);
  /* do amount consistency check */
  if(amount < 0 && !power(player, POW_STEAL)) {
    notify(player, "Try using the \"rob\" command.");
    return;
  } else if(amount == 0) {
    notify(player, "You must specify a positive number of Credits.");
    return;
  }  
  
  if(!power(player, POW_STEAL)) {
    if(Pennies(who) + amount > MAX_PENNIES) {
      notify(player, "That player doesn't need that many Credits!");
      return;
    }
  }
  
  /* try to do the give */
  if(!payfor(player, amount)) {
    notify(player, "You don't have that many Credits to give!");
  } else {
    /* objects work differently */
    if (Typeof(who)==TYPE_THING)
      {
	int cost;
	if (amount<(cost=atoi(atr_get(who,A_COST))))
	  {
            notify(player,"Feeling poor today?");
            giveto(player,amount);
            return;
	  }
	if (cost<0)
	  return;
	if((amount-cost) > 0 ) {
          sprintf(buf,"You get %d in change.",amount-cost);
	}
	else {
	  sprintf(buf,"You paid %d credits.",amount);
	}
	notify(player,buf);
	giveto(player,amount-cost);
	giveto(who,cost);
	did_it(player,who,A_PAY,NULL,A_OPAY,NULL,A_APAY);
	return;
      }       
    else
      {
	/* he can do it */
	notify(player,
	       tprintf( "You give %d Credits to %s.",
		       amount,
		       db[who].name));
	if(Typeof(who) == TYPE_PLAYER) {
	  notify(who,
		 tprintf( "%s gives you %d Credits.",
			 db[player].name,
			 amount));
	}
	giveto(who,amount);  
	did_it(player,who,A_PAY,NULL,A_OPAY,NULL,A_APAY);
      }
  }
}
