! ----------------------------------------------------------------------------
!  VERBLIB:  A library of standard verb routines which run the universe...
!
!  Supplied for use with Inform 5
!
!  The actions provided are:
!
!    Quit, Restart, Restore, Verify, Save, ScriptOn, ScriptOff,
!    Inv, Take, Drop, Remove, PutOn, Insert, Transfer, Empty,
!    Enter, Exit, Go, Look, Examine, Give,
!    Unlock, Lock, SwitchOn, SwitchOff, Open, Close, Disrobe, Wear, Eat;
!
!  and routines for verbs which by default only print a suitable reply:
!
!    Yes, No, Burn, Pray, Wake, WakeOther [person],
!    Kiss, Think, Smell, Listen, Taste, Touch, TouchThing, Dig,
!    Cut, Jump [jump on the spot], JumpOver, Tie, Drink,
!    Fill, Sorry, Strong [swear word], Mild [swear word], Attack, Swim,
!    Swing [something], Blow, Rub, Set, SetTo, WaveHands [ie, just "wave"],
!    Wave [something], Pull, Push, PushDir [push something in a direction],
!    Turn, Squeeze, LookUnder [look underneath something], Search,
!    ThrowAt, Answer, Buy, Ask, Sing, Climb, Wait, Sleep, Consult
!
!  and the useful routines DescribeObj, which describes an object with
!  its possessions, PlayerTo, which moves the player to a new place,
!  MovePlayer, which moves the player in a given direction and looks.
! ----------------------------------------------------------------------------
!  The SACK_OBJECT, look-modes, defaults added
!  Wear now checks to see if you're already wearing something
!  Redrafted in new-style Inform syntax and tidied up - 8/1/94
!  Fixed a bug noticed by Michael Baum for multiple supported objects - 23/2
!  Added calling pre/postroutines of containers into which things are put,
!    supporters onto which things are put, and from which things are removed,
!    at suggestion of Robin Watts - 14/4
!  Set to added - 15/4
!  Consult added - 23/4
!  Give extended by Gareth Rees - 5/5
!  Support for floating objects - 17/5
! ----------------------------------------------------------------------------

System_file;

Default MAX_CARRIED  100;
Default MAX_SCORE    0;
Default NUMBER_TASKS 1;
Default OBJECT_SCORE 4;
Default ROOM_SCORE   5;
Default SACK_OBJECT  0;   
Default AMUSING_PROVIDED 1;
Default TASKS_PROVIDED   1;

#IFNDEF task_scores;
Global task_scores initial 0;
#ENDIF;

[ ScoreSub;
  if (deadflag==0)
       print "You have so far scored ";
  else print "In that game you scored ";

  print score, " out of a possible ", MAX_SCORE, ", in ", turns, " turns";

  PrintRank();
];

Global task_done data NUMBER_TASKS;

[ Achieved num;
  if (task_done->num==0)
  {   task_done->num=1; score=score+task_scores->num;
  }
];

[ PANum m n;
  print "  ";
  n=m;
  if (n<0)    { n=-m; n=n*10; }
  if (n<10)   { print "   "; jump panuml; }
  if (n<100)  { print "  "; jump panuml; }
  if (n<1000) { print " "; }
.panuml;
  print m, " ";
];

[ FullScoreSub i;
  ScoreSub();
  if (score==0 || TASKS_PROVIDED==1) rfalse;
  new_line;
  if (deadflag==0) print "The score is ";
  else             print "The score was ";
  print "made up as follows:^^";

  for (i=0:i<NUMBER_TASKS:i++)
      if (task_done->i==1)
      {   PANum(task_scores->i);
          PrintTaskName(i);
      }
  
  if (things_score~=0)
  {   PANum(things_score);
      print "finding sundry items^";
  }
  if (places_score~=0)
  {   PANum(places_score);
      print "visiting various places^";
  }
  new_line; PANum(score); print "total (out of ", MAX_SCORE, ")^";
];

[ YesOrNo i;
  for (::)
  {   read buffer parse;
      i=parse-->1;
      if (i=='yes' or #n$y) rtrue;
      if (i=='no' or #n$n) rfalse;
      print "Please answer yes or no.> ";
  }
];

[ QuitSub;
  print "Are you sure you want to quit? ";
  if (YesOrNo()~=0) quit;
];

[ RestartSub;
  print "Are you sure you want to restart? ";
  if (YesOrNo()~=0) { restart; "Failed."; }
];

[ RestoreSub;
  restore Rmaybe;
  "Restore failed.";
  .RMaybe; print "Ok.^";
];

[ SaveSub;
  save Smaybe;
  "Save failed.";
  .Smaybe; print "Ok.^";
];

[ VerifySub;
  verify Vmaybe;
  jump Vwrong;
  .Vmaybe; "The game file has verified as intact.";
  .Vwrong;
  "The game file did not verify properly, and may be corrupted \
             (unless you are running it on a primitive interpreter which \
             does not properly implement the VERIFY code).";
];

[ ScriptOnSub;
  if (transcript_mode==1) "Transcripting is already on.";
  transcript_mode=1;
  0-->8 = (0-->8)|1;
  print "Start of a transcript of^";
  Banner();
];

[ ScriptOffSub;
  if (transcript_mode==0) "Transcripting is already off.";
  print "^End of transcript.^";
  transcript_mode=0;
  0-->8 = (0-->8)&$fffe;
];

[ MoveFloatingObjects place i k l address top;
  top=#largest_object-256;
  for (i=1: i<=top: i++)
  {   address=i.&found_in;
      if (i hasnt absent && address~=0 && i.found_in~=0)
      {   k=i.#found_in;
          #IFV3;
          for (l=0: l<k: l++)
              if (place==address->l) move i to place;
          #ENDIF;
          #IFV5;
          for (l=0: l<k/2: l++)
              if (place==address-->l) move i to place;
          #ENDIF;
      }
  }
];

[ InvSub;
  if (child(player)==0) "You are carrying nothing.";
  print "You are carrying:^";
  Inventory(player);
  AfterRoutines();
];

[ Inventory obj n o2;
  o2=1;
  if (n~=0)
  {   spaces 2*n;
      o2=DescribeObj(obj,0); new_line;
  }
  if (o2==0) rtrue;

  objectloop(o2 in obj) Inventory(o2,n+1);
];

[ TakeSub;
  if (RTakeSub(location)~=0) rtrue;
  if (AfterRoutines()==1) rtrue;
  notheld_mode=onotheld_mode;
  if (notheld_mode==0) print "Taken.^";
];

[ RTakeSub fromobj i j k postonobj;
  if (noun==player) "As the bishop said to the actress.";

  if (noun has animate)
  {   print "I don't suppose "; DefArt(noun);
      " would care for that.";
  }

  i=parent(noun);
  if (i==player) "You already have that.";

  if (i has container || i has supporter)
  {   postonobj=i;
      k=action; action=##LetGo;
      if (RunRoutines(i,before)~=0) { action=k; rtrue; }
      action=k;
  }

  while (i~=fromobj)
  {   if (i hasnt container && i hasnt supporter)
          "That isn't available.";
      if (i has container && i hasnt open)
      {   print "Unfortunately "; DefArt(i); " isn't open."; }
      i=parent(i);
      if (i==player) i=fromobj;
  }
  if (noun has scenery)  "That's hardly portable.";
  if (noun has static)   "Fixed in place.";

  k=0; objectloop (j in player) if (j hasnt worn) k++;

  if (k >= MAX_CARRIED)
  {   if (SACK_OBJECT~=0)
      {   if (parent(SACK_OBJECT)~=player)
              "You're carrying too many things already.";
          j=0;
          objectloop (k in player) 
              if (k~=SACK_OBJECT && k hasnt worn && k hasnt light) j=k;

          if (j~=0)
          {   print "(putting "; DefArt(j); print " into ";
              DefArt(SACK_OBJECT); print " to make room)^";
              move j to SACK_OBJECT;
          }
          else "You're carrying too many things already.";
      }
      else "You're carrying too many things already.";
  }
  move noun to player;
  if (noun hasnt moved)
  {   give noun moved;
      if (noun has scored)
      {   score=score+OBJECT_SCORE;
          things_score=things_score+OBJECT_SCORE;
      }
  }

  if (postonobj~=0)
  {   k=action; action=##LetGo;
      if (RunRoutines(postonobj,after)~=0) { action=k; rtrue; }
      action=k;
  }
  rfalse;
];

[ DropSub i;
  i=parent(noun);
  if (i==location)
      "Already on the floor.";
  if (i~=player)
      "You haven't got that.";
  if (noun has worn)
  {   print "(First taking "; DefArt(noun); print " off)^"; give noun ~worn; }

  move noun to parent(player);
  if (AfterRoutines()==1) rtrue;
  print "Dropped.^";
];

[ RemoveSub i;

  i=parent(noun);
  if (i has container && i hasnt open) "Alas, it is closed.";
  if (i~=second) "But it isn't there now.";
  if (second has worn) "You'll need to take it off first.";
  if (RTakeSub(second)~=0) rtrue;
  action=##Take;   if (AfterRoutines()==1) rtrue;
  action=##Remove; if (AfterRoutines()==1) rtrue;

  print "Removed.^";
];

[ PutOnSub;
  if (second==d_obj) { <Drop noun>; rfalse; }
  if (parent(noun)~=player)
      "You need to be holding it before you can put it onto \
          something else.";

  if (second>1)
  {   action=##Receive;
      if (RunRoutines(second,before)~=0) { action=##PutOn; rtrue; }
      action=##PutOn;
  }

  if (second hasnt supporter)
  {   print "Putting things on "; DefArt(second);
      " would achieve nothing.";
  }
  if (parent(second)==player) "You lack the dexterity.";
  if (noun has worn)
  {   print "(first taking it off)^"; give noun ~worn; }
  if (children(second)>=prop(second,capacity))
  {   print "There is no more room on "; DefArt(second); ".";
  }
  move noun to second;

  if (AfterRoutines()==1) rtrue;

  if (second>1)
  {   action=##Receive;
      if (RunRoutines(second,after)~=0) { action=##PutOn; rtrue; }
      action=##PutOn;
  }

  if (multiflag==1) "Done.";
  print "You put the "; print_obj noun; print " on "; DefArt(second);
  ".";
];

[ InsertSub;
  if (second==d_obj ) <<Drop noun>>;
  if (parent(noun)~=player)
     "You need to be holding it before you can put it into \
          something else.";

  if (second>1)
  {   action=##Receive;
      if (RunRoutines(second,before)~=0) { action=##Insert; rtrue; }
      action=##Insert;
  }

  if (second hasnt container) "That can't contain things.";
  if (second hasnt open)      "Alas, it is closed.";
  if (second has worn)        "You'll need to take it off first.";
  if (noun has worn) { print "(first taking it off)^"; give noun ~worn; }

  if (children(second)>=prop(second,capacity))
  {   print "There is no more room in "; DefArt(second); "."; }

  move noun to second;

  if (AfterRoutines()==1) rtrue;

  if (second>1)
  {   action=##Receive;
      if (RunRoutines(second,after)~=0) { action=##Insert; rtrue; }
      action=##Insert;
  }

  if (multiflag==1) "Done.";
  print "You put "; DefArt(noun); print " into "; DefArt(second); ".";
];

[ TransferSub i a;
  a=##Drop;
  if (second has container) a=##Insert;
  else
      if (second has supporter) a=##PutOn;

  i=parent(noun);
  if (i~=player)
  {   while (i~=0)
      {   if (i hasnt open) "That isn't in your possession.";
          i=parent(i);
          if (i==player) jump Segue;
      }
      "First pick that up.";
  }
  .Segue; move noun to player;
  Process(noun,second,a); rfalse;
];

[ EmptySub;
  second=d_obj; EmptyTSub();
];

[ EmptyTSub i j;
  if (noun hasnt container)
  {   CDefArt(noun); " can't contain things."; }
  if (noun hasnt open)
  {   CDefArt(noun); " is closed."; }
  if (second~=d_obj)
  {   if (second hasnt container)
      {   CDefArt(second); " can't contain things."; }
      if (second hasnt open) { CDefArt(second); " is closed."; }
  }
  i=child(noun);
  if (i==0) { DefArt(noun); " is empty already."; }
  while (i~=0)
  {   j=sibling(i);
      print object i, ": ";
      <Transfer i second>;
      i=j;
  }
];

[ EnterSub i;
  if (noun has door) <<Go noun>>;
  i=parent(player);
  if (i~=location)
  {   print "But you're already in "; DefArt(i); "."; }
  if (noun hasnt enterable) "A surreal idea.";
  i=parent(noun);
  if (i==compass) <<Go noun>>;
  if (i~=location) "You can only get into something on the floor.";
  move player to noun;
  print "You get into "; DefArt(noun); print ".^";
  Locale(noun);
];

[ ExitSub;
  if (parent(player)==location)
  {   if (location.out_to~=0) <<Go out_obj>>;
      "But you're aren't in anything at the moment.";
  }
  move player to location;
  print "You are on your own two feet again.^"; LookSub(1); AfterRoutines();
];

[ VagueGoSub;
  "You'll have to say which compass direction to go in.";
];

[ GoInSub;
  <Go in_obj>; rtrue;
];

[ GoSub i j df movewith thedir;

  movewith=0;
  i=parent(player);
  if ((location~=thedark && i~=location)
      || (location==thedark && i~=real_location))
  {   j=location; location=real_location;
      if (RunRoutines(i,before)~=0)
      {   movewith=i; i=parent(i); location=j; jump gotroom; }
      location=j;
      print "You'll have to get out of "; DefArt(i);
      " first.";
  }
  .gotroom;
  thedir=noun.door_dir;
  if ((thedir-#code_offset)>=0) thedir=RunRoutines(noun,door_dir);
  
  j=i.thedir;

  if (j>#largest_object)
  {   if ((j-#strings_offset)>=0)
      {   print_paddr j; new_line; rfalse; }
      j=RunRoutines(i,thedir);
      if (j==1) rtrue;
  }

  if (j==0)
  {   print_paddr i.cantgo; new_line; rfalse; }

  if (j has door)
  {   if (j has concealed) "You can't go that way.";
      if (j hasnt open)
      {   if (noun==u_obj)
          {   print "You are unable to climb "; Defart(j); "."; }
          if (noun==d_obj)
          {   print "You are unable to descend "; Defart(j); "."; }
          print "You can't, since "; Defart(j); " is in the way.";
      }
      if ((j.door_to-#code_offset)>=0) j=RunRoutines(j,door_to);
      else j=j.door_to;
      if (j==0)
      {   print "You can't, since "; Defart(j); " leads nowhere."; }
  }
  if (movewith==0) move player to j; else move movewith to j;

  df=OffersLight(j);
  if (df~=0) { location=j; lightflag=1; }
  else
  {   if (location==thedark) DarkToDark();
      real_location=j;
      location=thedark; lightflag=0;
  }
  if (LAfterRoutines()==1) rtrue;
  LookSub(1);
];

[ SayWhatsOn descon o i k;
  print "^On "; DefArt(descon);
  k=children(descon);
  if (children(descon)==1) print " is "; else print " are ";
  i=0;
  objectloop (o in descon)
  {   i++; 
      DescribeObj(o,1);
      if (i==k-1)  print " and ";
      if (i<k-1) print ", ";
  }
  print ".^";
];

[ Locale descin o k j flag i;

  k=0;
  objectloop (o in descin)
      if (o hasnt concealed)
      {  if (o hasnt scenery)
         {   give o workflag; inc k;
             if (o hasnt moved || o.describe~=$ffff)
             {   if (o.describe~=$ffff && RunRoutines(o,describe)~=0)
                 {   flag=1;
                     give o ~workflag; dec k;
                 }    
                 else
                 {   j=o.initpos;
                     if ((o has door && o hasnt open)
                          || (o has switchable && o hasnt on) ) j=o.closedpos;
                     if (j~=0)
                     {   new_line; print_paddr j; new_line;
                         flag=1;
                         give o ~workflag; dec k;
                         if (o has supporter && child(o)~=0) SayWhatsOn(o);
                     }
                 }
             }
         }
         else
             if (o has supporter && child(o)~=0) SayWhatsOn(o);
      }

  if (k==0) return;
  new_line;
  if (descin~=location) { print "In "; DefArt(descin); print " you"; }
  if (descin==location) print "You";
  print " can ";
  if (flag==1) print "also ";
  print "see ";
  i=0;
  objectloop (o in descin)
      if (o has workflag)
      {  i++;
         DescribeObj(o,1);
         if (i==k-1) print " and ";
         if (i< k-1) print ", ";
      }
  if (descin~=location) print ".^";
  if (descin==location) print " here.^";
];

[ LMode1Sub;
  lookmode=1; print_paddr #Story;
  " is now in its normal ~brief~ printing mode, which gives \
              long descriptions of \
              places never before visited and short descriptions otherwise.";
];

[ LMode2Sub;
  lookmode=2; print_paddr #Story;
  " is now in its ~verbose~ mode, which always gives long \
              descriptions of locations (even if you've been there before).";
];

[ LMode3Sub;
  lookmode=3; print_paddr #Story;
  " is now in its ~superbrief~ mode, which always gives short \
              descriptions of locations (even if you haven't been there \
              before).";
];

[ LookSub weary i descin j;
  descin=location;
  if (descin~=lastdesc)
  {   if (RunRoutines(descin,initpos)~=0) NewRoom();
      MoveFloatingObjects(location);
  }
  new_line;
#IFV5; style bold; #ENDIF;
  print object location;
#IFV5; style roman; #ENDIF;

  i=parent(player);
  if (location~=thedark && i~=location)
  {   print " (in "; DefArt(i); print ")"; descin=i; }
  new_line;

  if ((weary~=1) || (lookmode==2) || (location hasnt visited))
  {   if (location.describe~=$ffff) RunRoutines(location,describe);
      else
      {   j=location.description;
          if ((j-#strings_offset)>0)
          {   print_paddr j; new_line; } 
          else
              RunRoutines(location,description);
      }
  }

  if (location hasnt visited)
  {   give location visited;
      if (location has scored)
      {   score=score+ROOM_SCORE;
          places_score=places_score+ROOM_SCORE;
      }
  }

  if (descin~=location) Locale(location);
  Locale(descin);

  LookRoutine();
  action=##Look;
  if (LAfterRoutines()==1) rtrue;
];

[ ExamineSub i;
  if (location==thedark)
      "Darkness, noun.  An absence of light to see by.";
  if (noun==player)
      "As good-looking as ever.";
  if (noun has autosearch) { SearchSub(); rfalse; }
  i=noun.description;
  if (i==0)
  {   if (noun has container) { SearchSub(); rfalse; }
      print "You see nothing special about "; Defart(noun); ".";
  }
  if ((i-#strings_offset)>0)
  {   print_paddr i; new_line; }
  else
      RunRoutines(noun,description);
  if (noun has switchable)
  {   print "It is currently switched ";
      if (noun has on) print "on.^"; else print "off.^";
  }
  if (AfterRoutines()==1) rtrue;
];

[ DescribeObj o listmode p i k rval;

  if (listmode~=2) Indefart(o); else Defart(o);

  if (o has light) print " (providing light)";
  if (o has worn)  print " (being worn)";
  if (o has container)
  {   if (listmode~=2) print " (which is "; else print ", which is ";
      if (o hasnt open)
      {   print "closed";
          if (o hasnt transparent) jump Cdone;
      }
      if (o has open) print "open";
      if (listmode==0) { rval=1; jump Cdone; }
      k=children(o);
      if (k==0)
      {   print " but empty";
          jump Cdone;
      }
      print " and contains ";
      i=0;
      objectloop (p in o)
      {   i++; DescribeObj(p,1);
          if (i==k-1) print " and ";
          if (i< k-1) print ", ";
      }
      .Cdone;
      if (listmode~=2) print ")";
  }
  if (o has supporter)
  {   p=child(o);
      if (p~=0)
      {   if (listmode~=2)
              print " (on which ";
          else
              print ", on top of which ";
          if (listmode==0) { rval=1; jump Sdone; }
          k=children(o); i=0;
          if (k==1) print "is "; else print "are ";
          objectloop (p in o)
          {   i++;
              DescribeObj(p,1);
              if (i==k-1) print " and ";
              if (i< k-1) print ", ";
          }
          .SDone;
          if (listmode~=2) print ")";
      }
  }
  return rval;
];

[ GiveSub;
  if (parent(noun)~=player)
  {   print "You aren't holding "; DefArt(noun); "."; }
  if (second==player) { print "You juggle "; DefArt(noun);
      " for a while, but don't achieve much."; }
  if (RunLife(second,##Give)~=0) rfalse;
  CDefArt(second); " doesn't seem interested.";
];

[ GiveRSub; <Give second noun>; ];

[ UnlockSub;
  if (noun hasnt lockable) "I can't see how to unlock that.";
  if (noun hasnt locked)   "It is in fact unlocked now.";
  if (noun.with_key~=second) "That doesn't seem to fit the lock.";
  give noun ~locked;
  if (AfterRoutines()==1) rtrue;
  print "You unlock "; DefArt(noun); ".";
];

[ LockSub;
  if (noun hasnt lockable) "I can't see how to lock that.";
  if (noun has locked)     "It is in fact locked now.";
  if (noun has open)       "First you'll have to close it.";
  if (noun.with_key~=second) "That doesn't seem to fit the lock.";
  give noun locked;
  if (AfterRoutines()==1) rtrue;
  print "You lock "; DefArt(noun); ".";
];

[ SwitchonSub;
  if (noun hasnt switchable)
      "That's not something you can switch.";
  if (noun has on) "It's already on.";
  give noun on;
  if (AfterRoutines()==1) rtrue;
  print "You switch "; DefArt(noun); " on.";
];

[ SwitchoffSub;
  if (noun hasnt switchable)
      "That's not something you can switch.";
  if (noun hasnt on) "It's already off.";
  give noun ~on;
  if (AfterRoutines()==1) rtrue;
  print "You switch "; DefArt(noun); " off.";
];

[ OpenSub;
  if (noun hasnt openable) "That's not something you can open.";
  if (noun has locked)     "It seems to be locked.";
  if (noun has open)       "It's already open.";
  give noun open;
  if (AfterRoutines()==1) rtrue;
  print "You open "; DefArt(noun); ".";
];

[ CloseSub;
  if (noun hasnt openable) "That's not something you can close.";
  if (noun hasnt open)     "It's already closed.";
  give noun ~open;
  if (AfterRoutines()==1) rtrue;
  print "You close "; DefArt(noun); ".";
];

[ DisrobeSub;
  if (noun hasnt worn) "You're not wearing that.";
  give noun ~worn;
  if (AfterRoutines()==1) rtrue;
  print "You take off "; DefArt(noun); print ".^";
];

[ WearSub;
  if (noun hasnt clothing)  "You can't wear that!";
  if (parent(noun)~=player) "You're not holding that!";
  if (noun has worn)        "You're already wearing that!";
  give noun worn;
  if (AfterRoutines()==1) rtrue;
  print "You put on "; DefArt(noun); print ".^";
];

[ EatSub;
  if (noun hasnt edible)    "No, it's plainly inedible.";
  remove noun;
  if (AfterRoutines()==1) rtrue;
  print "You eat "; DefArt(noun); ".  Not bad.";
];

[ YesSub;
  "That was a rhetorical question.";
];

[ NoSub;
  "That was a rhetorical question.";
];

[ BurnSub;
  "In this game, arson is (usually) forbidden.";
];

[ PraySub;
  "Spooky!  For a moment there, a deep voice seemed \
             to say ~you're on your own~.";
];

[ WakeSub;
  "The dreadful truth is, this is not a dream.";
];

[ WakeOtherSub;
  "That seems unnecessary.";
];

[ KissSub;
  if (RunLife(noun,##Kiss)~=0) rfalse;
  "Keep your mind on the game.";
];

[ ThinkSub;
  "What a good idea.";
];

[ SmellSub;
  "You smell nothing unexpected.";
];

[ ListenSub;
  "You hear nothing unexpected.";
];

[ TasteSub;
  "You taste nothing unexpected.";
];

[ TouchSub;
  "You feel nothing unexpected.";
];

[ TouchThingSub;
  if (noun has animate) "Keep your hands to yourself!";
  "You feel nothing unexpected.";
];

[ DigSub;
  "The ground is unsuitable for digging here.";
];

[ CutSub;
  "In this game, cutting things up is never helpful.";
];

[ JumpSub;
  "You jump on the spot, fruitlessly.";
];

[ JumpOverSub;
  "You would achieve nothing by this.";
];

[ TieSub;
  "You would achieve nothing by this.";
];

[ DrinkSub;
  "There's nothing suitable to drink here.";
];

[ FillSub;
  "But there's no water here to carry.";
];

[ SorrySub;
  "Oh, don't apologise.";
];

[ StrongSub;
  "Disgraceful!  Once upon a time adventurers had moral standards.";
];

[ MildSub;
  "Quite.";
];

[ AttackSub;
  if (noun has animate && RunLife(noun,##Attack)~=0) rfalse;
  "Violence isn't the answer, you know.";
];

[ SwimSub;
  "There's not enough water to swim in.";
];

[ SwingSub;
  "There's nothing sensible to swing here.";
];

[ BlowSub;
  "You can't usefully blow that.";
];

[ RubSub;
  "You achieve nothing by this.";
];

[ SetSub;
  "No, you can't set that.";
];

[ SetToSub;
  "No, you can't set that to anything.";
];

[ WaveHandsSub;
  "You wave, feeling foolish.";
];

[ WaveSub;
  if (parent(noun)~=player) "But you aren't holding that.";
  print "You look ridiculous waving "; DefArt(noun); ".";
];

[ PullSub;
  if (noun has static)   "It is fixed in place.";
  if (noun has scenery)  "You are unable to.";
  "Nothing obvious happens.";
];

[ PushSub;
  if (noun has static)   "It is fixed in place.";
  if (noun has scenery)  "You are unable to.";
  "Nothing obvious happens.";
];

[ AllowPushDir i;
  if (parent(second)~=compass) "That's not a direction.";
  if (second==u_obj or d_obj)  "Not that way you can't.";
  AfterRoutines();
  i=noun; <Go second>; move i to location;
];

[ PushDirSub;          
  "Is that the best you can think of?";
];

[ TurnSub;
  if (noun has static)  "It is fixed in place.";
  if (noun has scenery) "You are unable to.";
  "Nothing obvious happens.";
];

[ SqueezeSub;
  if (noun has animate) "Keep your hands to yourself.";
  "You achieve nothing by this.";
];

[ LookUnderSub;
  "You find nothing of interest.";
];

[ SearchSub;
  if (noun hasnt container)
      "You find nothing of interest.";
  if (noun hasnt transparent && noun hasnt open)
      "You can't see inside, since it is closed.";
  if (AfterRoutines()==1) rtrue;
  print "You peer at "; DescribeObj(noun,2); ".";
];

[ ThrowAtSub;
  if (second hasnt animate) "Futile.";
  if (RunLife(second,##ThrowAt)~=0) rfalse;
  "You lack the nerve when it comes to the crucial moment.";
];

[ AnswerSub;
  if (RunLife(second,##Answer)~=0) rfalse;
  "No reply.";
];  

[ BuySub;
  "Nothing is on sale.";
];

[ AskSub;
  if (RunLife(noun,##Ask)~=0) rfalse;
  "No reply.";
];  

[ SingSub;
  if (random(2)==1) print "Your yodelling ";
  else print "Your singing ";
  "is atrocious, if you say so yourself.";
];

[ ClimbSub;
  "I don't think much is to be achieved by that.";
];  

[ WaitSub;
  if (LAfterRoutines()==1) rtrue;
  "Time passes.";
];  

[ SleepSub;
  "You must have slept yourself out.  \
             You certainly aren't drowsy now.";
];

[ ConsultSub;
  print "There's nothing to be discovered";
  if (noun==0) ".";
  print " by consulting "; DefArt(noun); ".";
];

[ PlayerTo newplace flag;
  move player to newplace; location=newplace;
  real_location=location;
  AdjustLight(1);
  if (flag==0) <Look>;
];

[ MovePlayer direc; <Go direc>; <Look>; ];
