// Copyright 1994 Brad Pitzel
//
// Feel free to use/distribute/modify as long as credit/copyrights for myself 
// are included.

// This is a class to simply the job of maintaining a fixed 
// frames-per-second animation rate in the program.
// Search for "Timer::" in sasteroids.c to see how its used.

#ifndef __Timer__
#define __Timer__

#include <sys/time.h>
#include <unistd.h>


// used to get fixed animation rates on different
// speed computers
class Timer {
    public:
    
    	// set frame rate to 'f' frames per second
    	static void setFrameRate( int f );
    	
    	// call once before entering animation loops
    	static void init();
    
    	// pause required amount of time to get proper frame rate
    	// returns the amount of time passed since last sync() or
    	// init() call in usec.
    	static long sync();

    private:
    	static timeval	lastClk, newClk;
	static long	fTime;

    	static int frameRate;
    };


// set frame rate to 'f' frames per second
inline void Timer::setFrameRate( int f ) 
	{ 
	fTime = 1000000/f; 
	}
    	
// call once before entering animation loops
inline void Timer::init() 
	{ 
	gettimeofday(&lastClk,NULL); 
	}
    
// pause required amount of time to get proper frame rate
inline long Timer::sync()
    	{
    	long delta;
    	
    	gettimeofday(&newClk, NULL);
    	delta = (newClk.tv_usec - lastClk.tv_usec);
    	
    	usleep( ((fTime - delta) >? 0) <? fTime );
    	
	gettimeofday(&lastClk, NULL);
	
	return delta;
	}

#endif
