------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                    A D A . S T R I N G S . F I X E D                     --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.4 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------


with Ada.Strings.Maps;
with Ada.Strings.Search;

package Ada.Strings.Fixed is
pragma Pure (Ada.Strings.Fixed);

   Blank : constant Character := ' ';
   Pad   : constant Character := ' ';

   --------------------------------------------------------------
   -- Copy Procedure for Strings of Possibly Different Lengths --
   --------------------------------------------------------------

   procedure Move (Source  : in  String;
                   Target  : out String;
                   Drop    : in  Truncation := Error;
                   Justify : in  Alignment  := Left;
                   Pad     : in  Character  := Fixed.Pad);

   ------------------------
   -- Search Subprograms --
   ------------------------

   --  Note: in this implementation, these search subprograms are in a
   --  separate package Ada.Strings.Search. The declarations are thus
   --  replaced by renamings of these routines (which is perfectly valid
   --  since it is semantically undetectable that we have renamings here
   --  rather than "real" subprogram declarations).

   function Index (Source   : in String;
                   Pattern  : in String;
                   Going    : in Direction := Forward;
                   Mapping  : in Maps.Character_Mapping
                                := Maps.Identity)
     return Natural
     renames Ada.Strings.Search.Index;


   function Index (Source : in String;
                   Set    : in Maps.Character_Set;
                   Test   : in Membership := Inside;
                   Going  : in Direction  := Forward)
     return Natural
     renames Ada.Strings.Search.Index;


   function Index_Non_Blank (Source : in String;
                             Going  : in Direction := Forward)
     return Natural
     renames Ada.Strings.Search.Index_Non_Blank;

   function Count (Source   : in String;
                   Pattern  : in String;
                   Mapping  : in Maps.Character_Mapping
                                 := Maps.Identity)
     return Natural
     renames Ada.Strings.Search.Count;

   function Count (Source   : in String;
                   Set      : in Maps.Character_Set)
     return Natural
     renames Ada.Strings.Search.Count;

   procedure Find_Token (Source : in String;
                         Set    : in Maps.Character_Set;
                         Test   : in Membership;
                         First  : out Positive;
                         Last   : out Natural)
     renames Ada.Strings.Search.Find_Token;

   ------------------------------------
   -- String Translation Subprograms --
   ------------------------------------

   function Translate (Source  : in String;
                       Mapping : in Maps.Character_Mapping)
      return String;

   procedure Translate (Source  : in out String;
                        Mapping : in Maps.Character_Mapping);

   ---------------------------------------
   -- String Transformation Subprograms --
   ---------------------------------------

   function Replace_Slice
      (Source   : in String;
       Low      : in Positive;
       High     : in Natural;
       By       : in String)
      return String;

   procedure Replace_Slice
      (Source   : in out String;
       Low      : in Positive;
       High     : in Natural;
       By       : in String;
       Drop     : in Truncation := Error;
       Justify  : in Alignment  := Left;
       Pad      : in Character  := Fixed.Pad);


   function Insert (Source   : in String;
                    Before   : in Positive;
                    New_Item : in String)
      return String;

   procedure Insert (Source   : in out String;
                     Before   : in Positive;
                     New_Item : in String;
                     Drop     : in Truncation := Error);


   function Overwrite (Source   : in String;
                       Position : in Positive;
                       New_Item : in String)
      return String;

   procedure Overwrite (Source   : in out String;
                        Position : in Positive;
                        New_Item : in String;
                        Drop     : in Truncation := Right);


   function Delete (Source  : in String;
                    From    : in Positive;
                    Through : in Natural)
      return String;

   procedure Delete (Source  : in out String;
                     From    : in Positive;
                     Through : in Natural;
                     Justify : in Alignment := Left;
                     Pad     : in Character := Fixed.Pad);

   ---------------------------------
   -- String Selector Subprograms --
   ---------------------------------

   function Trim
      (Source : in String)
      return String;

   function Trim
      (Source : in String;
       Left   : in Maps.Character_Set;
       Right  : in Maps.Character_Set)
      return String;

   procedure Trim
      (Source  : in out String;
       Left    : in Maps.Character_Set;
       Right   : in Maps.Character_Set;
       Justify : in Alignment := Ada.Strings.Left;
       Pad     : in Character := Fixed.Pad);


   function Head (Source : in String;
                  Count  : in Natural;
                  Pad    : in Character := Fixed.Pad)
      return String;

   function Tail (Source : in String;
                  Count  : in Natural;
                  Pad    : in Character := Fixed.Pad)
      return String;

   ----------------------------------
   -- String Constructor Functions --
   ----------------------------------

   function "*" (Left  : in Natural;
                 Right : in Character) return String;

   function "*" (Left  : in Natural;
                 Right : in String) return String;

end Ada.Strings.Fixed;
