------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                     A D A . S T R I N G S . M A P S                      --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.12 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------


package Ada.Strings.Maps is
pragma Preelaborate (Maps);

   --------------------------------
   -- Character Set Declarations --
   --------------------------------

   --  Representation for a set of character values:

   type Character_Set is private;

   Null_Set : constant Character_Set;

   type Character_Range is
     record
        Low  : Character;
        High : Character;
     end record;
   --  Represents Character range Low .. High

   type Character_Ranges is array (Positive range <>) of Character_Range;

   subtype Character_Sequence is String;
   --  Alternative representation for a set of character values

   ---------------------------
   -- Constructors for Sets --
   ---------------------------

   function To_Set    (Ranges : in Character_Ranges) return Character_Set;
   function To_Set    (Span   : in Character_Range)  return Character_Set;
   function To_Ranges (Set    : in Character_Set)    return Character_Ranges;

   ----------------------------------
   -- Operations on Character Sets --
   ----------------------------------

   function "="   (Left, Right : Character_Set) return Boolean;

   function "not" (Right       : Character_Set) return Character_Set;
   function "and" (Left, Right : Character_Set) return Character_Set;
   function "or"  (Left, Right : Character_Set) return Character_Set;
   function "xor" (Left, Right : Character_Set) return Character_Set;

   pragma Import (Intrinsic, "=");
   pragma Import (Intrinsic, "not");
   pragma Import (Intrinsic, "and");
   pragma Import (Intrinsic, "or");
   pragma Import (Intrinsic, "xor");

   function "-"   (Left, Right : Character_Set) return Character_Set;

   function Is_In
     (Element : Character;
      Set     : Character_Set)
      return    Boolean;

   function Is_Subset
     (Elements : Character_Set;
      Set      : Character_Set)
      return     Boolean;

   function "<="
     (Left  : Character_Set;
      Right : Character_Set)
      return  Boolean
   renames Is_Subset;


   function To_Set (Sequence  : Character_Sequence) return Character_Set;
   function To_Set (Singleton : Character)          return Character_Set;

   function To_Sequence (Set : Character_Set) return Character_Sequence;

   ------------------------------------
   -- Character Mapping Declarations --
   ------------------------------------

   type Character_Mapping is private;
   --  Representation for a character to character mapping:

   function Value
     (Map     : in Character_Mapping;
      Element : in Character)
      return    Character;

   Identity : constant Character_Mapping;

   ----------------------------
   -- Operations on Mappings --
   ----------------------------

   function To_Mapping
     (From, To : in Character_Sequence)
      return     Character_Mapping;

   function To_Domain
     (Map  : in Character_Mapping)
      return Character_Sequence;

   function To_Range
     (Map  : in Character_Mapping)
      return Character_Sequence;

   type Character_Mapping_Function is
      access function (From : in Character) return Character;

   ------------------
   -- Private Part --
   ------------------

private
   pragma Inline (Is_In);
   pragma Inline (Value);
   use Ascii;

   type Character_Set is array (Character) of Boolean;
   pragma Pack (Character_Set);

   Null_Set : constant Character_Set := (others => False);

   type Character_Mapping is array (Character) of Character;
   pragma Pack (Character_Mapping);

   Identity : constant Character_Mapping :=
     NUL & SOH & STX & ETX & EOT & ENQ & ACK & BEL & BS  & HT  & LF  &
     VT  & FF  & CR  & SO  & SI  & DLE & DC1 & DC2 & DC3 & DC4 & SYN &
     ETB & CAN & EM  & SUB & ESC & FS & GS & RS & US &

     " !""#$%&'()*+,-./0123456789:;<=>?@" &
     "ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`"   &
     "abcdefghijklmnopqrstuvwxyz{|}~"     &

     DEL &
     Character'Val (128) & Character'Val (129) & Character'Val (130) &
     Character'Val (131) & Character'Val (132) & Character'Val (133) &
     Character'Val (134) & Character'Val (135) & Character'Val (136) &
     Character'Val (137) & Character'Val (138) & Character'Val (139) &
     Character'Val (140) & Character'Val (141) & Character'Val (142) &
     Character'Val (143) & Character'Val (144) & Character'Val (145) &
     Character'Val (146) & Character'Val (147) & Character'Val (148) &
     Character'Val (149) & Character'Val (150) & Character'Val (151) &
     Character'Val (152) & Character'Val (153) & Character'Val (154) &
     Character'Val (155) & Character'Val (156) & Character'Val (157) &
     Character'Val (158) & Character'Val (159) & Character'Val (160) &
     Character'Val (161) & Character'Val (162) & Character'Val (163) &
     Character'Val (164) & Character'Val (165) & Character'Val (166) &
     Character'Val (167) & Character'Val (168) & Character'Val (169) &
     Character'Val (170) & Character'Val (171) & Character'Val (172) &
     Character'Val (173) & Character'Val (174) & Character'Val (175) &
     Character'Val (176) & Character'Val (177) & Character'Val (178) &
     Character'Val (179) & Character'Val (180) & Character'Val (181) &
     Character'Val (182) & Character'Val (183) & Character'Val (184) &
     Character'Val (185) & Character'Val (186) & Character'Val (187) &
     Character'Val (188) & Character'Val (189) & Character'Val (190) &
     Character'Val (191) & Character'Val (192) & Character'Val (193) &
     Character'Val (194) & Character'Val (195) & Character'Val (196) &
     Character'Val (197) & Character'Val (198) & Character'Val (199) &
     Character'Val (200) & Character'Val (201) & Character'Val (202) &
     Character'Val (203) & Character'Val (204) & Character'Val (205) &
     Character'Val (206) & Character'Val (207) & Character'Val (208) &
     Character'Val (209) & Character'Val (210) & Character'Val (211) &
     Character'Val (212) & Character'Val (213) & Character'Val (214) &
     Character'Val (215) & Character'Val (216) & Character'Val (217) &
     Character'Val (218) & Character'Val (219) & Character'Val (220) &
     Character'Val (221) & Character'Val (222) & Character'Val (223) &
     Character'Val (224) & Character'Val (225) & Character'Val (226) &
     Character'Val (227) & Character'Val (228) & Character'Val (229) &
     Character'Val (230) & Character'Val (231) & Character'Val (232) &
     Character'Val (233) & Character'Val (234) & Character'Val (235) &
     Character'Val (236) & Character'Val (237) & Character'Val (238) &
     Character'Val (239) & Character'Val (240) & Character'Val (241) &
     Character'Val (242) & Character'Val (243) & Character'Val (244) &
     Character'Val (245) & Character'Val (246) & Character'Val (247) &
     Character'Val (248) & Character'Val (249) & Character'Val (250) &
     Character'Val (251) & Character'Val (252) & Character'Val (253) &
     Character'Val (254) & Character'Val (255);

end Ada.Strings.Maps;
