------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--              S Y S T E M . N O R M A L I Z E _ S T R I N G               --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.2 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

procedure System.Normalize_String (S : in out String; F, L : out Natural) is
begin
   F := S'First;
   L := S'Last;

   --  Scan for leading spaces

   while F <= L and then S (F) = ' ' loop
      F := F + 1;
   end loop;

   --  Check for case when the string contained no characters

   if F > L then
      raise Constraint_Error;
   end if;

   --  Scan for trailing spaces

   while S (L) = ' ' loop
      L := L - 1;
   end loop;

   if S (F) /= ''' then

      --  Upper case any lower case characters.
      --  This needs to be expanded to handle Latin-1 upper half ???

      for J in F .. L loop
         if S (J) in 'a' .. 'z' then
            S (J) := Character'Val (Character'Pos (S (J)) - 32);
         end if;
      end loop;
   end if;

end System.Normalize_String;
