#include <stdio.h>
#include <string.h>
#include <time.h>
#include "xutil.h"
#include "lutil.h"
#include "ftn.h"
#include "ftnmsg.h"
#include "rfcmsg.h"
#include "config.h"
#include "bwrite.h"

#define MAXMSGSIZE 8192
#define MSGTYPE 2

extern int newsmode;
extern char *version;

extern int stricmp(char *,char *);
extern int strincmp(char *,char *,int);
extern char *bgets(char *,int,FILE *);
extern long sequencer(void);

int needputrfc(msg)
rfcmsg *msg;
{
	/* 0-junk, 1-kludge, 2-pass */

	if (!stricmp(msg->key,"X-UUCP-From")) return 0;
	if (!stricmp(msg->key,"X-Body-Start")) return 0;
	if (!strincmp(msg->key,"X-FTN-",6)) return 0;
	if (!stricmp(msg->key,"Xref")) return 0;
	if (!stricmp(msg->key,"Return-Receipt-To")) return 1;
	if (!stricmp(msg->key,"Received")) return newsmode?0:2;
	if (!stricmp(msg->key,"From")) return 2;
	if (!stricmp(msg->key,"To")) return newsmode?0:2;
	if (!stricmp(msg->key,"Reply-To")) return 2;
	if (!stricmp(msg->key,"Mailer")) return 0;
	if (!stricmp(msg->key,"X-Mailer")) return 0;
	if (!stricmp(msg->key,"Newsreader")) return 0;
	if (!stricmp(msg->key,"X-Newsreader")) return 0;
	if (!stricmp(msg->key,"Date")) return 0;
	if (!stricmp(msg->key,"Subject")) 
	{
		if (strlen(msg->val) > MAXSUBJ) return 2;
		else return 0;
	}
	if (!stricmp(msg->key,"Organization")) 
	{
		if (strlen(msg->val) > MAXORIGIN) return 1;
		else return 0;
	}
	if (!stricmp(msg->key,"Comment-To")) return 0;
	if (!stricmp(msg->key,"X-Comment-To")) return 0;
	if (!stricmp(msg->key,"Keywords")) return 2;
	if (!stricmp(msg->key,"Summary")) return 2;
	/*if (!stricmp(msg->key,"")) return ;*/
	return 1;
}

extern char *months[];
static char *weekday[] = {
"Sun","Mon","Tue","Wed","Thu","Fri","Sat"
};

char *viadate(void)
{
	static char buf[64];
	time_t t;
	struct tm *ptm;

	time(&t);
	ptm=localtime(&t);
	sprintf(buf,"%s %s %d %d at %02d:%02d",
		weekday[ptm->tm_wday],months[ptm->tm_mon],
		ptm->tm_mday,ptm->tm_year+1900,ptm->tm_hour,ptm->tm_min);
	return buf;
}

int putmessage(msg,fmsg,fp,pkt)
rfcmsg *msg;
ftnmsg *fmsg;
FILE *fp,*pkt;
{
	char buf[BUFSIZ],*p;
	rfcmsg *tmp;
	int rfcheaders;
	int needsplit,datasize;

	debug(9,"putmessage from %s",ascfnode(fmsg->from,0x7f));
	debug(9,"putmessage   to %s",ascfnode(fmsg->to,0x7f));
	debug(9,"putmessage subj %s",fmsg->subj);
	debug(9,"putmessage flags %04x",fmsg->flags);
	debug(9,"putmessage msgid %s",fmsg->msgid);
	debug(9,"putmessage reply %s",fmsg->reply);
	debug(9,"putmessage pid %s",fmsg->pid);
	debug(9,"putmessage date %s",fmsg->date);

	needsplit=0;
	do
	{
		datasize=14;

		iwrite(MSGTYPE,         pkt);
		iwrite(fmsg->from->node,pkt);
		iwrite(fmsg->to->node,  pkt);
		iwrite(fmsg->from->net, pkt);
		iwrite(fmsg->to->net,   pkt);
		iwrite(fmsg->flags,     pkt);
		iwrite(0,               pkt);
		awrite(fmsg->date,      pkt);
		awrite(fmsg->to->name,  pkt);
		awrite(fmsg->from->name,pkt);
		awrite(fmsg->subj,      pkt);

		if (fmsg->area) fprintf(pkt,"AREA:%s\r",fmsg->area);

		if (!newsmode)
		{
			if (fmsg->to->point)
				fprintf(pkt,"\1TOPT: %u\r",fmsg->to->point);
			if (fmsg->from->point)
				fprintf(pkt,"\1FMPT: %u\r",fmsg->from->point);
			fprintf(pkt,"\1INTL: %u:%u/%u %u:%u/%u\r",
				fmsg->to->zone,
				fmsg->to->net,
				fmsg->to->node,
				fmsg->from->zone,
				fmsg->from->net,
				fmsg->from->node
				);
		}
		if ((!needsplit) && fmsg->msgid) 
			fprintf(pkt,"\1MSGID: %s\r",fmsg->msgid);
		else
			fprintf(pkt,"\1MSGID: %s %08lx \r",
				ascfnode(whoami->addr,0x1f),
				sequencer());
		if (fmsg->reply) fprintf(pkt,"\1REPLY: %s\r",fmsg->reply);
		if (fmsg->pid) fprintf(pkt,"\1PID: %s\r",fmsg->pid);

		for (tmp=msg;tmp;tmp=tmp->next) 
		if (!strncmp(tmp->key,"X-FTN-",6) &&
		    stricmp(tmp->key,"X-FTN-AREA") &&
		    stricmp(tmp->key,"X-FTN-SEEN-BY") &&
		    stricmp(tmp->key,"X-FTN-PATH") &&
		    stricmp(tmp->key,"X-FTN-Via"))
		{
			datasize += strlen(tmp->key)+strlen(tmp->val);
			fprintf(pkt,"\1%s:",tmp->key+6);
			kwrite(tmp->val,pkt);
		}

		rfcheaders=0;
		for (tmp=msg;tmp;tmp=tmp->next) if (needputrfc(tmp) == 1)
		{
			rfcheaders++;
			datasize += strlen(tmp->key)+strlen(tmp->val);
			fprintf(pkt,"\1RFC-%s:",tmp->key);
			kwrite(tmp->val,pkt);
		}
		for (tmp=msg;tmp;tmp=tmp->next) if (needputrfc(tmp) == 2)
		{
			rfcheaders++;
			datasize += strlen(tmp->key)+strlen(tmp->val);
			fprintf(pkt,"%s:",tmp->key);
			cwrite(tmp->val,pkt);
		}
		if (rfcheaders) cwrite("\n",pkt);

		if (needsplit)
		{
			fprintf(pkt," * Continuation of a splitted message *\r\r");
			needsplit=0;
		}
		else if (p=hdr("X-Body-Start",msg)) 
		{
			datasize += strlen(p);
			cwrite(p,pkt);
		}
		while (!(needsplit=(datasize > MAXMSGSIZE)) &&
			(bgets(buf,sizeof(buf)-1,fp)))
		{
			debug(9,"putmessage body %s",buf);
			datasize += strlen(buf);
			cwrite(buf,pkt);
		}
		if (needsplit)
			fprintf(pkt,"\r * Message split, to be continued *\r");
			
		if (newsmode)
		{
			fprintf(pkt,"\r--- IFmail v.%s\r",version);
			fprintf(pkt," * Origin: %s (%s)\r",
				fmsg->origin ? fmsg->origin : "Unknown",
				ascfnode(whoami->addr,0x1f));

			if (hdr("X-FTN-SEEN-BY",msg))
			{
				for (tmp=msg;tmp;tmp=tmp->next) 
				if (!stricmp(tmp->key,"X-FTN-SEEN-BY"))
				{
				datasize += strlen(tmp->key)+strlen(tmp->val);
					fprintf(pkt,"SEEN-BY:");
					kwrite(tmp->val,pkt);
				}
			}
			else
			{
				fprintf(pkt,"SEEN-BY: %s\r",
					ascfnode(whoami->addr,0x06));
			}

			if (hdr("X-FTN-PATH",msg))
			{
				for (tmp=msg;tmp;tmp=tmp->next) 
				if (!stricmp(tmp->key,"X-FTN-PATH"))
				{
				datasize += strlen(tmp->key)+strlen(tmp->val);
					fprintf(pkt,"\1PATH:");
					kwrite(tmp->val,pkt);
				}
			}
			else
			{
				fprintf(pkt,"\1PATH: %s\r",
					ascfnode(whoami->addr,0x06));
			}
		}
		else
		{
			for (tmp=msg;tmp;tmp=tmp->next) 
			if (!stricmp(tmp->key,"X-FTN-Via"))
			{
			datasize += strlen(tmp->key)+strlen(tmp->val);
				fprintf(pkt,"\1Via");
				kwrite(tmp->val,pkt);
			}
			fprintf(pkt,"\1Via IFmail %s, %s (%s)\r",
				ascfnode(whoami->addr,0x1f),
				viadate(),version);
		}
		awrite("",pkt); /* trailing zero byte */
	}
	while (needsplit);

	debug(7,"putmessage exiting...");
	return 0;
}
