#include <stdio.h>
#include <time.h>
#include <sys/types.h>
#include <sys/timeb.h>

char *wdays[]={"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};
char *months[]={"Jan","Feb","Mar","Apr","May","Jun",
		"Jul","Aug","Sep","Oct","Nov","Dec"};

extern char getopt();
char *rfcdate(now)
time_t now;
{
	static char buf[40];
	struct tm ptm;
	char sign;
	int hr,min;
	long offset;

	if (!now) time(&now);
	ptm=*localtime(&now);

#ifdef SCO
	offset=ptm.tm_tzadj;
#elif linux
	offset=timezone-daylight*3600L; /* Nasty, but no normal way */
#elif POSIX
	offset=ptm.tm_gmtoff;
#else
	if (daylight) offset=altzone;
	else offset=timezone;
#endif

	if (offset < 0)
	{
		sign='+';
		offset=-offset;
	}
	else sign='-';
	hr=offset/3600L;
	min=(offset/60L)%60L;

	sprintf(buf,"%s, %02d %s %02d %02d:%02d:%02d %c%02d%02d (%s)",
		wdays[ptm.tm_wday],ptm.tm_mday,months[ptm.tm_mon],
		ptm.tm_year%100,ptm.tm_hour,ptm.tm_min,ptm.tm_sec,
		sign,hr,min,
#ifdef SCO
		ptm.tm_name
#else
		tzname[daylight]
#endif
);
	return(buf);
}
