/*************************************************************************/
/*                  VChat interactive IP-level chat system               */
/*-----------------------------------------------------------------------*/
/*  (c) '93/'94 by Andreas S. Wetzel (mickey@deadline.panic.bln.sub.org  */
/*                 All rights reserverd.                                 */ 
/*-----------------------------------------------------------------------*/
/* See the file COPYRIGHT in the top level directory of VChat for        */
/* copyright notices and further disclaimers.                            */ 
/*************************************************************************/

#include "../config.h"
#include "../global.h"
#include <stdio.h>
#include <termios.h>
#include <sys/ioctl.h>
#include "proto.h"

void tty_param(int action)
{
	static struct termios termbuf;

	if(action == SAVE) tcgetattr(0, &termbuf);
	if(action == RESTORE) tcsetattr(0, TCSAFLUSH, &termbuf);
}
 
void tty_mode(int md)   
{
	struct termios term;

	tcgetattr(0, &term);

	term.c_iflag = (IXON | IXANY);
	term.c_oflag = (OPOST | ONLCR);
	term.c_lflag = ISIG;
	term.c_cc[VMIN] = (char) md;
	term.c_cc[VTIME] = 10;

	tcsetattr(0, TCSAFLUSH, &term);  
}
