/* do_database.c */

/* 
 * do_database() - called when conference database search is executed
 */

#include "database.h"

void
do_database(w,event,params,num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
    Arg args[20];
    char line[MAXLINE];
    char searchline[MAXLINE];
    register int i;
	String s;
	String toDateStr, fromDateStr, LocationStr;
        char fromDate[12];
        char toDate[12];

    if (databaseSocket) {
        return;
    }

    XtVaSetValues(databaseDisplayText, XtNstring, "", NULL);

    XtSetArg(args[0], XtNstring, &s);
    XtGetValues(enterText, args, 1);

        fromDate[0] = '\0';
        toDate[0] = '\0';
	XtVaGetValues(fromText, XtNstring, &fromDateStr, NULL);
	XtVaGetValues(toText, XtNstring, &toDateStr, NULL);
        XtVaGetValues(locationText, XtNstring, &LocationStr, NULL);
        if (fromDateStr && strlen(fromDateStr) && (!toDateStr ||
                                                  !strlen(toDateStr)))
            toDateStr = "Jan 1 2025";
        if (toDateStr && strlen(toDateStr) && (!fromDateStr ||
                                               !strlen(fromDateStr)))
            fromDateStr = "Jan 1 1970";
        if (fromDateStr && toDateStr && strlen(fromDateStr) && 
            strlen(toDateStr))
            if ((parse_date(fromDateStr,fromDate) == -1) ||
                (parse_date(toDateStr,toDate) == -1) ) {
             set_status("invalid date mmm dd yyyy (example - Jan 1 1993)", RED);
              return;
            }
            XtVaSetValues(fromText, XtNstring, fromDate, NULL);
            XtVaSetValues(toText, XtNstring, toDate, NULL);

    if (!strlen(s)) {
		s = (String)NULL;
		databaseValue[0] = '\0';
        if (strlen(fromDate) && strlen(toDate)) {
	    strcpy(line, "looking for any conference between dates...");
	    set_status(line, YELLOW);
        }
        else if (strlen(LocationStr)) {
		sprintf(line, "looking up %s...", LocationStr);
		set_status(line, YELLOW);
        }
    } else {
		strcpy(databaseValue, s);
		sprintf(line, "looking up %s...", databaseValue);
		set_status(line, YELLOW);
	}

    strcpy(TMP, tmpnam(NULL));

        searchline[0] = '\0';
        if (databaseValue && strlen(databaseValue) &&
            (search_mask[SEARCH][TITLE] || search_mask[SEARCH][DESCRIPTION])) {
            sprintf(line,"\tbegin\t");
            if (search_mask[SEARCH][TITLE])
                strcat(line,"title\t");
            if (search_mask[SEARCH][DESCRIPTION])
                strcat(line,"description\t");
            strcat(line,"end\t");
            strcat(line,databaseValue);
            strcat(searchline,line); 
        }
        if (LocationStr && strlen(LocationStr)) {
            sprintf(line,
                    "\tbegin\tlocation\tend\t%s",LocationStr);
            strcat(searchline,line);
        }
	if (strlen(fromDate) && strlen(toDate))
		sprintf(line, "start_date\tend_date\t%s\t%s", fromDate, toDate);
	else
		line[0] = '\0';

	databaseSocket = GetByConditions(DBNAME, RELATION, 

		/* fields returned */
		"title\tstart_date\tend_date\tlocation",

                /* dates to search */
                line,

		/* keyword search list */
		searchline);


    if (databaseSocket) {
        databaseInput = XtAppAddInput(XtWidgetToApplicationContext(w),
            databaseSocket,
            (XtPointer) XtInputReadMask, 
            databaseIncoming, (XtPointer)databaseSocket);

        set_cursor(CURSOR_BUSY, 0);
        set_cursor(CURSOR_BUSY, enterText);
        set_cursor(CURSOR_BUSY, fromText);
        set_cursor(CURSOR_BUSY, locationText);
        set_cursor(CURSOR_BUSY, toText);
        set_cursor(CURSOR_BUSY, databaseDisplayText);
        grey_the_button(cancelButton, True);
        grey_the_bar(False);
    } else {
        set_status("had a problem contacting the server", RED);
    }
}

