#define I_IOCTL
#define I_SYS
#define I_GETOPT
#define I_SOCKET
#include "includes.h"
#ifdef NO_VSPRINTF
#define va_alist a1,a2,a3,a4,a5,a6,a7,a8,a9
#define va_dcl long a1,a2,a3,a4,a5,a6,a7,a8,a9;
#define vsprintf(buf,fmt,v) sprintf((buf),(fmt),a1,a2,a3,a4,a5,a6,a7,a8,a9)
#define va_list int
#define va_start(v)
#define va_end(v)
#define USE_VARARGS
#else
#ifdef USE_VARARGS
#include <varargs.h>
#else
#include <stdarg.h>
#endif
#endif
#include <string.h>
#include <sys/stat.h>

#include "client.h"
#include <signal.h>

char *term_server = "";

int lcompression = -1;		/* defaults. */
int rcompression = -1;
int priority = 0;
char com_result[200];
char *command_result;
#ifdef SHAREDIR
int share        = -1;


void set_share_mode(void){
  char *e;

  e=getenv("TERMMODE");
  if(e!=NULL){
    share=atoi(e);
    if(share<0||share>1) share=-1;
  };
  if(share == -1)
#ifndef USERSHARE
    share = (getgid() != getegid() || getuid() != geteuid());
#else
    share = (getgid() != getegid() || getuid() != geteuid()) ? 1 : -1;
#endif
};
#endif
				/* parse all the options, and then */
				/* return the first unused argument. */
int client_options(int argc, char *argv[], char *myopts, Callback callback)
{
  int c;
  char args[200];

  /* make sure we get all the args to pass to getopt */
  if (getenv("TERMSERVER"))
    term_server = getenv("TERMSERVER");


#ifdef SHAREDIR
  strcpy(args, "t:crp:S:");
#else
  strcpy(args, "t:crp:");
#endif
  strcat(args, myopts);

  while ((c = getopt(argc, argv, args))!=EOF) {
    switch(c) {
    case 't':
      term_server = optarg;	
      break;
    case 'c': /* for compressionion */
      lcompression = 1;
      rcompression = 1;
      break;
    case 'r': /* for raw, no compressionion */
      lcompression = 0;
      rcompression = 0;
      break;
    case 'p':
      priority = atoi(optarg);
      fprintf(stderr, "Changeing priority to %d\n", priority);
      break;
#ifdef SHAREDIR
    case 'S':
      share = (!strcmp(optarg,"on"));
      break;
#endif
    case '?':
      return -1;
      break;
    default:
      if ( (callback == NULL) || ( callback(c, optarg) == -1 ) )
	{
	  fprintf(stderr, "Unrecognized option %s\n", argv[optind]);
	  return -1; 
	}
      break;
    }
  }
  return optind;
}
				/* Send a command to the Term */
				/* process.*/ 
#ifdef USE_VARARGS
int send_command(sock , comm, local , fmt, va_alist)
int sock , comm, local;
char *fmt;
va_dcl {
#else
int send_command(int sock, int comm, int local, char *fmt, ...) {
#endif
  char buff[200];
  va_list v;
  int i;
#ifdef USE_VARARGS
  va_start(v);
#else
  va_start(v, fmt);
#endif
				/* A command follows.. */
  buff[0] = C_SWITCH;
				/* Is it for the local term? or the */
				/* remote term? */
  if (local)
    buff[1] = C_SWITCH - 1;
  else
    buff[1] = C_SWITCH - 2;
				/* Set the command in. */
  buff[2] = comm;
  if (fmt)
    vsprintf(buff+3, fmt, v);
  else
    buff[3] = 0;

  va_end(v);
				/* Ok. Buff holds the entire command. */
				/* Lets do the damned thing.. */
  if (write(sock, buff, strlen(buff)+1) < 0)
    return -1;
				/* If the command is C_DUMB, then no */
				/* reply will be forthcoming. */
  if ((comm == C_DUMB) || (comm == C_QUIT)) return 1;

  i = 0;
  do {
    read(sock, &com_result[i], 1);
  } while (com_result[i++]);
  command_result = &com_result[3];

  if (com_result[2] != I_OK)
    return -1;
/*  printf("command return was (%d)%s.\n", i, com_result);*/
  return 1;
}

int socket_connect_server(int S,char *server) {
  int s;
#ifdef SHAREDIR

  set_share_mode();
	/* If "share" is still undecided, I try both shared and unshared. */
  if(share==-1){
    share=1;
    s=try_connect_server(S,server);
    if(s>=0) return s;
    share=!share;
  };
#endif
  s=try_connect_server(S,server);
  if(s>=0) return s;
  return -1;
}

int connect_server(char *server) {
  int s;
#ifdef SHAREDIR

  set_share_mode();
	/* If "share" is still undecided, I try both shared and unshared. */
  if(share==-1){
    share=1;
    s=try_connect_server(-1,server);
    if(s>=0) return s;
    share=!share;
  };
#endif
  s=try_connect_server(-1,server);
  if(s>=0) return s;
  exit(1);
}

int try_connect_server(int S,char *server) {
  char path[200];
  char *home_p, *share_p;
  int s;
  
  if (!server) server = "";

  home_p = getenv( "TERMDIR" );
  if (!home_p) home_p = getenv( "HOME" );

#ifdef SHAREDIR
#ifndef USERSHARE
  share_p = getenv( "TERMSHARE" );
#endif
  if (!share_p) share_p = SHAREDIR;

#ifdef SHAREDIR
  if(share){
    sprintf(path,"%s/tmp/private", share_p);
    { 
      struct stat file_status;
      if(stat(path,&file_status)==-1) return -1;
      if(!(file_status.st_mode&S_IXUSR)
        ||!(!geteuid()||file_status.st_uid==geteuid()))
        if(!(file_status.st_mode&S_IXGRP)
          ||!(!getegid()||file_status.st_gid==getegid())) return -1;
    };
    sprintf(path,"%s/tmp/private/socket%s", share_p, server);
  }else{
#endif
    setegid(getgid());
    seteuid(getuid());
    if(!home_p) home_p = "/tmp";
    sprintf(path,"%s/.term/socket%s", home_p, server);
  };
#endif

				/* Try and connect to term. */
  s = connect_unix(S,path);
  if(s<0){
    if(term_debug>=0) fprintf(stderr,"Term: Failed to connect to socket %s\n",path);
    return -1;
  };

  if ( lcompression >=0 )
    send_command(s, C_COMPRESS, 1, "%d", lcompression);
  if ( rcompression >=0 )
    send_command(s, C_COMPRESS, 0, "%d", rcompression);

  if (priority) {
    send_command(s, C_PRIORITY, 1, "%d", priority);
    send_command(s, C_PRIORITY, 0, "%d", priority);
  }

  return s;
}

/* build_arg: build a string from char ** argv to be passed 
 * to C_EXEC family. 
 *
 * by: croutons
 *
 * Notes:
 *  returns a pointer to malloced space.
 *  takes a null pointer as the end of the array of char*.
 *  assumes null terminated strings. (for using string(3))
 *  returns NULL on error.
 *
 *  we assume '\xff' is ok for the new terminator
 */
char * build_arg( char**arg )
{
	int i, s;
	char * f;

	if ( ! arg ) return NULL;
        if ( *arg == NULL ) return NULL;

	for ( s = i = 0; NULL != arg[i]; i++) s += strlen(arg[i]);
	s += i + 2;
	if ( NULL == (f = (char *)malloc( s * sizeof(char) ) ) ) {
		return NULL;
	}
	for ( s = i = 0; NULL != arg[i]; i++ ) {	
		s += strlen(strcpy(&f[s], arg[i]));
/*		f[s++] = '\xff';  bothers Ultrix MIPS compiler */
		f[s++] = '\377';  
	}
	f[s] = '\0';
	return f;
}

