/*
**      LIBAMC.H -- Defines for Algorithmic Music Composition routines
**      psl 1/89
*/

/* SBSD (stochastic binary subdivision) defines */
#define MAXRES  64
typedef	struct  INST   {
	int     inum;           /* instrument # or key (note) # */
	int     density;        /* as a % */
	int     up;             /* up- or down- beat */
	int     res;            /* ticks per quantum */
	int     dur;            /* note duration */
	int     vel;            /* key velocity */
	int     chan;           /* MIDI channel for output */
	char    pat[MAXRES];    /* current pattern */
} INST;
typedef	struct	SBSDP	{	/* sbsd parameters */
	int	lolim, hilim;	/* low/high key numbers */
	int	scaled;		/* 0 => not scaled */
	int	scale[12];	/* booleans, starting at C */
	int	lastnote;	/* prior note, for relative motion */
	int	ninst;		/* number of instruments in use */
	INST	*inst;		/* pointer to first instr struct */
} SBSDP;
