/*
**	TONEROW -- Create a tone row
**	4/89 psl
*/

#include <stdio.h>
#include <midi.h>

#define	WHOLE		(MPU_CLOCK_PERIOD << 1)
#define	SIXTEENTH	(MPU_CLOCK_PERIOD >> 3)

int	Row[12];

main(argc, argv)
char	*argv[];
{
	u_char mbuf[4], *seq;
	int i, j, t, key, seed;
	MCMD m;

	key = 60;
	seed = 0;
	for (i = 1; i < argc; i++) {
	    if (argv[i][0] == '-') {
		switch (argv[i][1]) {
		case 'k':		/* lowest note */
		    key = name2key(&argv[i][2]);
		    break;
		case 's':		/* random number seed */
		    seed = atoi(&argv[i][2]);
		    break;
		default:
		    goto syntax;
		}
	    } else {
syntax:
		fprintf(stderr, "Usage: %s [-kKEY] [-s#]\n", argv[0]);
		fprintf(stderr, " -kKEY sets lowest pitch (C3, 0x3c, 60)\n");
		fprintf(stderr, " -s# sets the random number seed\n");
		exit(2);
	    }
	}
	if (seed)
	    srand(seed);
	else
	    srand((int) time(0));
	for (i = 12; --i >= 0; Row[i] = key + i);
	for (i = 12; --i > 0; ) {
	    j = rand() % (i + 1);
	    t = Row[i];
	    Row[i] = Row[j];
	    Row[j] = t;
	}
	m.len = 3;
	m.cmd = mbuf;
	m.cmd[0] = CH_KEY_ON;
	m.when = 0;
	for (t = 0; t < 12; t++) {
	    m.cmd[1] = Row[t];
	    m.cmd[2] = 64;
	    putmcmd(stdout, &m);
	    m.when += SIXTEENTH;
	    m.cmd[2] = 0;
	    putmcmd(stdout, &m);
	}

}
