#! /bin/perl -w
#
# add a new domain to Sun's NIS+ Nameservice
#
# Nistool is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# Nistool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with the NIS+ Server; see the file COPYING.  If
# not, write to the Free Software Foundation, Inc., 675 Mass Ave,
# Cambridge, MA 02139, USA.
#
# Version: 0.1alpha
# Author: Ralf Lehmann <ralfl@darwin.muc.de>
#

use Nisplus;
use strict;

my $DOMAIN = $ARGV[0];
my $MASTER = $ARGV[1];
my $NETPASS = $ARGV[2];
my %R;
my $RETSTR;

$| = 1;
if (!defined($DOMAIN) || !defined($MASTER)) {
	usage();
}

%R = Nisplus::check_domainname($DOMAIN);
if ($R{"RET"}) {
	print STDERR $R{"TEXT"};
	exit 1;
}

$MASTER = Nisplus::absname($MASTER);
%R = Nisplus::check_server($MASTER);
 if ($R{"RET"}) { 
        print STDERR $R{"TEXT"}; 
        exit 1; 
 } 

if (!Nisplus::is_rootdomain($DOMAIN) && !defined($NETPASS)) {
	usage_rootdomain();
	exit 1;
}



my $new_domain = Nisplus->new($DOMAIN);
$R{"RET"} = $new_domain->create_domain($MASTER, $NETPASS);
if ($RETSTR = $new_domain->get_error()){
	print STDERR "Error: $RETSTR\n";
}
close(STDERR);
exit $R{"RET"};
	

sub usage {
	print STDERR "usage: $0 domainname master\n";
	exit 1;
}

sub usage_rootdomain {
	print STDERR "usage: $0 domainname master netpassword\n";
	exit 1;
}
